/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.internal.utils;

import com.ibm.team.repository.common.util.ObfuscationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class PasswordHelper {
    public static String getClearPassword(String password) throws GeneralSecurityException {
        String clearPass = null;
        try {
            clearPass = PasswordHelper.getClearPasswordFromFile(new File(password));
        }
        catch (IOException e) {
            try {
                clearPass = PasswordHelper.internalGetPassword(password);
            }
            catch (GeneralSecurityException e1) {
                clearPass = password;
            }
            catch (IllegalArgumentException e1) {
                clearPass = password;
            }
        }
        return clearPass;
    }

    public static String getClearPasswordFromString(String password) {
        String clearPass = null;
        try {
            clearPass = PasswordHelper.internalGetPassword(password);
        }
        catch (GeneralSecurityException e1) {
            clearPass = password;
        }
        catch (IllegalArgumentException e1) {
            clearPass = password;
        }
        return clearPass;
    }

    public static String getClearPasswordFromFile(File password) throws IOException, GeneralSecurityException {
        StringBuffer fileContent = new StringBuffer();
        FileInputStream inputStream = new FileInputStream(password);
        byte[] buffer = new byte[256];
        int bytesRead = inputStream.read(buffer);
        while (bytesRead != -1) {
            fileContent.append(new String(buffer, 0, bytesRead));
            bytesRead = inputStream.read(buffer);
        }
        inputStream.close();
        return PasswordHelper.internalGetPassword(fileContent.toString());
    }

    private static String internalGetPassword(String password) throws GeneralSecurityException {
        return new String(ObfuscationHelper.decrypt((byte[])password.getBytes()));
    }
}

