/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.internal.utils;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.internal.utils.ZOS;
import com.ibm.teamz.build.ant.types.resources.BuildableResource;
import com.ibm.teamz.build.ant.types.zos.Alloc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.eclipse.osgi.util.NLS;

public class MacroExec
implements Callable<MacroExec> {
    public static final String SOURCE_DATASET = "source.dataset";
    public static final String SOURCE_MEMBER = "source.member";
    public static final String SOURCE_MEMBER_NAME = "source.member.name";
    public static final String TEMP_SOURCE_DATA_SET_NAME = "&&ANTZTEMP";
    private static final String JOB = "job";
    private static final String TEAMZ_BUILD_MACRO_PREFIX = "teamz.build.macro.";
    private static Map<String, String> LangDefToMacro;
    BuildableResource buildableResource;
    String buildMacro;
    String langDefName;
    Task parentTask;
    Exception exception;
    ZFile tempFile;

    public MacroExec(Task parentTask, BuildableResource buildableResource) {
        this.parentTask = parentTask;
        this.buildableResource = buildableResource;
        if (LangDefToMacro == null) {
            MacroExec.initializeMap(parentTask.getProject());
        }
        this.buildMacro = buildableResource.getBuildMacro();
        this.langDefName = buildableResource.getLangDefName();
        if (this.buildMacro == null) {
            if (this.langDefName == null) {
                throw new BuildException(NLS.bind((String)Messages.MODEL_NOT_DEFINED, (Object)buildableResource.getName()));
            }
            this.buildMacro = MacroExec.getBuildMacro(this.langDefName);
        }
    }

    @Override
    public MacroExec call() {
        Properties p;
        Task task = this.parentTask.getProject().createTask(this.buildMacro);
        if (task == null) {
            throw new BuildException(NLS.bind((String)Messages.TASK_NOT_CREATED, (Object)this.buildMacro));
        }
        this.log(NLS.bind((String)Messages.TASK_CREATED, (Object)this.langDefName), 4);
        try {
            p = this.getAttributes();
        }
        catch (Exception e) {
            throw new BuildException(Messages.EXCEPTIONS_DURING_PROCESSING, (Throwable)e);
        }
        if (task instanceof MacroInstance) {
            MacroInstance job = (MacroInstance)task;
            MacroDef macroDef = job.getMacroDef();
            List attributes = macroDef.getAttributes();
            for (Object o : attributes) {
                MacroDef.Attribute attribute = (MacroDef.Attribute)o;
                String key = attribute.getName();
                String defaultValue = attribute.getDefault();
                String value = p.getProperty(key);
                if (value == null && defaultValue != null) {
                    this.log(NLS.bind((String)Messages.USE_DEFAULT_ATTRIBUTE, (Object)key, (Object)defaultValue), 3);
                    value = defaultValue;
                }
                job.setDynamicAttribute(key, value);
                this.log(NLS.bind((String)Messages.SET_DYNAMIC_ATTRIBUTE, (Object)key, (Object)value), 4);
            }
            this.log(NLS.bind((String)Messages.EXECUTE_MACRO, (Object)this.langDefName), 4);
            try {
                try {
                    job.getProject().addReference(JOB, (Object)this);
                    job.execute();
                }
                catch (BuildException be) {
                    this.exception = be;
                    if (this.tempFile != null) {
                        try {
                            ZOS.close(this.tempFile);
                        }
                        catch (ZFileException e) {
                            this.exception = e;
                        }
                        this.tempFile = null;
                    }
                    Alloc.freeAll(this.parentTask);
                }
            }
            finally {
                if (this.tempFile != null) {
                    try {
                        ZOS.close(this.tempFile);
                    }
                    catch (ZFileException e) {
                        this.exception = e;
                    }
                    this.tempFile = null;
                }
                Alloc.freeAll(this.parentTask);
            }
        }
        return this;
    }

    private Properties getAttributes() throws Exception {
        String memberName;
        String member;
        Properties p = new Properties();
        String datasetName = this.buildableResource.getDatasetName();
        if (datasetName == null || datasetName.trim().length() == 0) {
            datasetName = this.allocateTemporarySourceDataSet();
        }
        if ((member = (memberName = this.buildableResource.getMemberName())) == null || member.trim().length() == 0) {
            memberName = "";
            member = "";
        } else {
            member = "(" + member + ")";
        }
        String dataSetName = this.tempFile != null ? this.buildableResource.getDatasetName() : String.valueOf(this.buildableResource.getDatasetName()) + member;
        p.setProperty(SOURCE_DATASET, dataSetName);
        p.setProperty(SOURCE_MEMBER, member);
        p.setProperty(SOURCE_MEMBER_NAME, memberName);
        return p;
    }

    private String allocateTemporarySourceDataSet() throws Exception {
        String text;
        if (ZOS.datasetExists((ProjectComponent)this.parentTask, TEMP_SOURCE_DATA_SET_NAME)) {
            ZOS.removeDataset((ProjectComponent)this.parentTask, TEMP_SOURCE_DATA_SET_NAME);
        }
        if ((text = this.buildableResource.getNestedText()) != null) {
            this.tempFile = ZOS.saveLines(this.parentTask, TEMP_SOURCE_DATA_SET_NAME, this.getLinesList(text));
            this.buildableResource.setDatasetName(TEMP_SOURCE_DATA_SET_NAME);
        }
        return TEMP_SOURCE_DATA_SET_NAME;
    }

    private List<String> getLinesList(String text) {
        String[] lines = text.split("\n");
        ArrayList<String> linesList = new ArrayList<String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            line = line.replace("\t", "    ");
            linesList.add(line);
            ++n2;
        }
        if (linesList.size() > 0 && ((String)linesList.get(linesList.size() - 1)).trim().length() == 0) {
            linesList.remove(linesList.size() - 1);
        }
        if (linesList.size() > 0 && ((String)linesList.get(0)).trim().length() == 0) {
            linesList.remove(0);
        }
        return linesList;
    }

    private static String getBuildMacro(String langDefName) {
        String macroName = null;
        if (langDefName != null) {
            macroName = LangDefToMacro.get(langDefName);
        }
        if (macroName != null) {
            return macroName;
        }
        throw new BuildException(NLS.bind((String)Messages.MACRO_NOT_FOUND, (Object)langDefName));
    }

    private static void initializeMap(Project project) {
        LangDefToMacro = new HashMap<String, String>();
        Hashtable properties = project.getProperties();
        for (String key : properties.keySet()) {
            if (!key.startsWith(TEAMZ_BUILD_MACRO_PREFIX)) continue;
            String langDef = (String)properties.get(key);
            String macro = key.substring(TEAMZ_BUILD_MACRO_PREFIX.length());
            LangDefToMacro.put(langDef, macro);
        }
    }

    public BuildableResource getBuildableResource() {
        return this.buildableResource;
    }

    public String getBuildMacro() {
        return this.buildMacro;
    }

    public String getLangDefName() {
        return this.langDefName;
    }

    public Exception getException() {
        return this.exception;
    }

    public Task getTask() {
        return this.parentTask;
    }

    public void log(String s) {
        this.log(s, 2);
    }

    public void log(String s, int msgLevel) {
        if (this.parentTask != null) {
            this.parentTask.log(s, msgLevel);
        } else {
            System.out.println(s);
        }
    }
}

