/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.zos.utils;

import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.teamz.build.ant.zos.exceptions.JzosException;
import com.ibm.teamz.build.ant.zos.nls.Messages;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

public class JzosUtility {
    public static final boolean SIMULATION_ENABLED = System.getProperty("scmee.simulate") != null;
    private static final Log LOG = LogFactory.getLog(JzosUtility.class);

    static {
        new JzosUtility();
    }

    private JzosUtility() {
    }

    public static String getDefaultHLQ() {
        return ZFile.getDefaultHLQ();
    }

    public static void executeCommand(String cmd, LoadTracing lt) throws JzosException {
        try {
            cmd = String.valueOf(cmd) + " msg(1)";
            LogUtility.logTrace(LOG, null, "JzosUtility.executeCommand: ", cmd);
            if (lt != null) {
                lt.printToLog(NLS.bind((String)Messages.JzosUtility_logging_1, (Object)cmd));
            }
            ZFile.bpxwdyn((String)cmd);
        }
        catch (RcException rce) {
            LogUtility.logTrace(LOG, (Exception)((Object)rce), cmd);
            if (lt != null) {
                lt.printToLog(NLS.bind((String)Messages.JzosUtility_logging_1, (Object)cmd));
                lt.printToLog(rce.getMessage());
            }
            throw new JzosException(cmd, rce);
        }
    }

    public static boolean dataSetAlreadyExists(String dsName, String prefix) throws JzosException {
        boolean result = true;
        String pdsName = prefix == null || prefix.trim().length() == 0 ? dsName : String.valueOf(prefix) + "." + dsName;
        String quotName = JzosUtility.getSlashSlashQuotedDSN(pdsName);
        LogUtility.logTrace(LOG, null, ">>allocPDS==DataSet: " + dsName + " pdsName: " + pdsName + " quoteName: " + quotName + "exists?");
        try {
            result = ZFile.exists((String)quotName);
        }
        catch (ZFileException zfe) {
            LogUtility.logTrace(LOG, (Exception)((Object)zfe), zfe.toString());
            throw new JzosException(zfe);
        }
        LogUtility.logTrace(LOG, null, result ? "-- exists!" : "-- doesn't exist!");
        return result;
    }

    public static String getSlashSlashQuotedDSN(String pdsName) {
        return "//'" + pdsName + "'";
    }

    public static String substituteSystemSymbols(String s) {
        String ss;
        if (!(SIMULATION_ENABLED || s == null || s.isEmpty() || s.indexOf(38) == -1 || (ss = ZUtil.substituteSystemSymbols((String)s)) == null || ss.isEmpty())) {
            return ss;
        }
        return s;
    }
}

