/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.zos.utils;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.teamz.build.ant.zos.utils.AllocInfo;
import com.ibm.teamz.build.ant.zos.utils.ILoggingInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;

public class ISPFGatewayUtil {
    private static final String OS_NAME = "os.name";
    private static final String Z_OS = "z/OS";
    private static final String TWO_AMPERSANDS = "&&";
    private static final String TWO_SLASHES = "//";
    private static final String APOSTROPHE = "'";
    public static final String SERVICE_ISPF = "ISPF";
    public static final String SERVICE_TSO = "TSO";
    public static final String SESSION_NONE = "NONE";
    public static final String SESSION_REUSE = "REUSE";
    private static final String EXTENSION_XML = ".xml";
    private static final String PREFIX_ISPFINPUT = "ispfinput";
    private static final String JAZZ_TRANSLATOR_RETURN_CODE = "JAZZ_TRANSLATOR_RETURN_CODE";
    private static final String REXX_DYFREE = "call BPXWDYN(\"free dd(%s)\")";
    private static final String REXX_EXECIO = "\"EXECIO * DISKW %1$s (STEM %1$s. FINIS)\"";
    private static final String REXX_INLINE = "%1$s.%2$d = '%3$s'";
    private static final String MSG_FAILED = "say 'allocation failed: dd=%s, rc='||rc";
    public static final String MSG_TOOLONG = "Instream data line longer than 80 characters";
    private static int DEFAULT_SIZE = 16;
    private static int MAX_CHARS = 255;
    public static int INSTREAM_CHAR_LIMIT = 80;

    public static File generateXmlFile(ILoggingInterface logIntf, File dir, String rexxScript, String tsoCommand, String service, String session, List<? extends Object> allocationCmdList) throws TransformerFactoryConfigurationError, Exception {
        return ISPFGatewayUtil.generateXmlFile(logIntf, dir, rexxScript, tsoCommand, service, session, allocationCmdList, false, false, false);
    }

    public static File generateXmlFile(ILoggingInterface logIntf, File dir, String rexxScript, String tsoCommand, String service, String session, List<? extends Object> allocationCmdList, boolean isMultiProcess, boolean isFirstOne) throws TransformerFactoryConfigurationError, Exception {
        return ISPFGatewayUtil.generateXmlFile(logIntf, dir, rexxScript, tsoCommand, service, session, allocationCmdList, isMultiProcess, isFirstOne, false);
    }

    public static File generateXmlFile(ILoggingInterface logIntf, File dir, String rexxScript, String tsoCommand, String service, String session, List<? extends Object> allocationCmdList, boolean isMultiProcess, boolean isFirstOne, boolean debug) throws TransformerFactoryConfigurationError, Exception {
        String command = String.valueOf(SERVICE_ISPF.equals(service) ? "TSO EXEC '" : "EXEC '") + ISPFGatewayUtil.saveRexxScript(logIntf, rexxScript, tsoCommand, allocationCmdList, isMultiProcess, isFirstOne, debug) + APOSTROPHE;
        File xml = File.createTempFile(PREFIX_ISPFINPUT, EXTENSION_XML, dir);
        String lines = ISPFGatewayUtil.getXmlString(service, session, command);
        logIntf.debug("ISPF Gateway Input XML file=");
        logIntf.debug(lines);
        logIntf.debug("----");
        FileOutputStream fos = new FileOutputStream(xml);
        fos.write(lines.getBytes());
        fos.flush();
        fos.close();
        return xml;
    }

    private static String saveRexxScript(ILoggingInterface logIntf, String rexxScript, String command, List<? extends Object> allocationCmdList, boolean isMultiProcess, boolean isFirstOne, boolean debug) throws Exception {
        List<String> content = ISPFGatewayUtil.getRexxContent(command, allocationCmdList, isMultiProcess, isFirstOne, debug);
        String lines = "";
        for (String line : content) {
            lines = String.valueOf(lines) + line + "\n";
        }
        logIntf.debug("isMultiProcess=" + isMultiProcess + " isFirstOne=" + isFirstOne);
        logIntf.debug("REXX script=");
        logIntf.debug(lines);
        logIntf.debug("----");
        if (Z_OS.equals(System.getProperty(OS_NAME))) {
            ISPFGatewayUtil.saveLines(logIntf, rexxScript, content);
        }
        return rexxScript;
    }

    private static String buildSingleQuotedDsName(String dsname) {
        if (dsname == null || dsname.startsWith(TWO_AMPERSANDS)) {
            return dsname;
        }
        return APOSTROPHE + dsname + APOSTROPHE;
    }

    private static ZFile saveLines(ILoggingInterface logIntf, String dsname, List<String> lines) throws Exception {
        String output = TWO_SLASHES + ISPFGatewayUtil.buildSingleQuotedDsName(dsname);
        boolean haveWritten = false;
        int tryCount = 0;
        ZFile zFileOut = null;
        while (true) {
            try {
                zFileOut = new ZFile(output, "wb,type=record,recfm=vb,lrecl=255,noseek");
                for (String line : lines) {
                    byte[] b = line.getBytes(ZUtil.getDefaultPlatformEncoding());
                    zFileOut.write(b, 0, b.length);
                    haveWritten = true;
                }
                zFileOut.flush();
                if (!dsname.startsWith(TWO_AMPERSANDS)) {
                    zFileOut.close();
                }
                return zFileOut;
            }
            catch (ZFileException e) {
                if (haveWritten || tryCount++ < 10) {
                    throw e;
                }
                logIntf.debug("Caught exception " + e.getMessage() + " while trying to write REXX script, waiting 100ms and trying again");
                Thread.sleep(100L);
                continue;
            }
            break;
        }
    }

    private static String getXmlString(String service, String session, String command) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        String s = "<?xml version=\"1.0\"?>\n<ISPF-INPUT>\n<SERVICE-REQUEST>\n<service>" + service + "</service>\n" + "<session>" + session + "</session>\n" + "<command>" + command + "</command>\n" + "</SERVICE-REQUEST>\n" + "</ISPF-INPUT>\n";
        return s;
    }

    private static List<String> splitLine(String line) {
        ArrayList<String> l = new ArrayList<String>(DEFAULT_SIZE);
        return ISPFGatewayUtil.splitLine(l, line);
    }

    private static List<String> splitLine(List<String> l, String line) {
        if (line == null) {
            return l;
        }
        if (line.length() <= MAX_CHARS - 4) {
            l.add(line);
            return l;
        }
        StringBuffer sb = new StringBuffer(line);
        boolean inString = false;
        int length = line.length();
        int counter = 0;
        int i = 0;
        while (i < length) {
            char c = sb.charAt(i);
            if (++counter == MAX_CHARS - 8) {
                String s = sb.substring(0, i);
                String s2 = sb.substring(i);
                if (inString) {
                    if (c == '\"') {
                        s = String.valueOf(s) + "\"||,";
                        s2 = s2.substring(1);
                    } else {
                        s = String.valueOf(s) + "\"||,";
                        s2 = "\"" + s2;
                    }
                } else {
                    s = String.valueOf(s) + "||,";
                }
                l.add(s);
                return ISPFGatewayUtil.splitLine(l, s2);
            }
            if (c == '\"') {
                inString = !inString;
            }
            ++i;
        }
        return l;
    }

    private static void addLine(List<String> list, String line) {
        if (line != null) {
            if (line.length() > MAX_CHARS - 4) {
                List<String> lines = ISPFGatewayUtil.splitLine(line);
                for (String aline : lines) {
                    list.add(aline);
                }
            } else {
                list.add(line);
            }
        }
    }

    private static List<String> getRexxContent(String command, List<? extends Object> allocationCmdList, boolean isMultiProcess, boolean isFirstOne, boolean debug) {
        AllocInfo s;
        ArrayList<String> l = new ArrayList<String>(DEFAULT_SIZE);
        boolean addAllocateDataSet = false;
        ISPFGatewayUtil.addLine(l, "/* REXX */");
        ISPFGatewayUtil.addLine(l, "signal on failure");
        if (debug) {
            ISPFGatewayUtil.addLine(l, "trace i");
        }
        for (Object object : allocationCmdList) {
            s = ISPFGatewayUtil.getAllocInfo(object);
            if (s.getDdName() == null) continue;
            ISPFGatewayUtil.addLine(l, String.format(REXX_DYFREE, s.getDdName()));
        }
        for (Object object : allocationCmdList) {
            s = ISPFGatewayUtil.getAllocInfo(object);
            if (s.getInstreamData() != null) {
                String dd = s.getDdName();
                ISPFGatewayUtil.addLine(l, " ");
                ISPFGatewayUtil.addLine(l, "rc = BPXWDYN(\"" + s.getNewCommand() + "\")");
                ISPFGatewayUtil.addLine(l, "if rc \\= 0 then do");
                ISPFGatewayUtil.addLine(l, "  " + String.format(MSG_FAILED, dd));
                ISPFGatewayUtil.addLine(l, "  call allocateMessage");
                ISPFGatewayUtil.addLine(l, "  call exit 24");
                ISPFGatewayUtil.addLine(l, "end");
                ISPFGatewayUtil.addLine(l, String.valueOf(dd) + ".0 = " + s.getInstreamData().length);
                int i = 0;
                while (i < s.getInstreamData().length) {
                    if (s.getInstreamData()[i].length() > INSTREAM_CHAR_LIMIT) {
                        throw new IllegalArgumentException(MSG_TOOLONG);
                    }
                    ISPFGatewayUtil.addLine(l, String.format(REXX_INLINE, dd, i + 1, s.getInstreamData()[i].replace(APOSTROPHE, "''")));
                    ++i;
                }
                ISPFGatewayUtil.addLine(l, String.format(REXX_EXECIO, dd));
                continue;
            }
            if (s.getDataSetName() == null || s.getDataSetName().startsWith(TWO_AMPERSANDS)) {
                ISPFGatewayUtil.addLine(l, " ");
                ISPFGatewayUtil.addLine(l, "rc = BPXWDYN(\"" + s.getNewCommand() + "\")");
                ISPFGatewayUtil.addLine(l, "if rc \\= 0 then do");
                ISPFGatewayUtil.addLine(l, "  " + String.format(MSG_FAILED, s.getDdName()));
                ISPFGatewayUtil.addLine(l, "  call allocateMessage");
                ISPFGatewayUtil.addLine(l, "  call exit 24");
                ISPFGatewayUtil.addLine(l, "end");
                continue;
            }
            if (s.getShrCommand() != null && s.getShrCommand().equals(s.getNewCommand())) {
                ISPFGatewayUtil.addLine(l, " ");
                ISPFGatewayUtil.addLine(l, "rc = BPXWDYN(\"" + s.getShrCommand() + "\")");
                ISPFGatewayUtil.addLine(l, "if rc \\= 0 then do");
                ISPFGatewayUtil.addLine(l, "  " + String.format(MSG_FAILED, s.getDdName()));
                ISPFGatewayUtil.addLine(l, "  call allocateMessage");
                ISPFGatewayUtil.addLine(l, "  call exit 24");
                ISPFGatewayUtil.addLine(l, "end");
                continue;
            }
            addAllocateDataSet = true;
            ISPFGatewayUtil.addLine(l, " ");
            ISPFGatewayUtil.addLine(l, "dd  = \"" + s.getDdName() + "\"");
            ISPFGatewayUtil.addLine(l, "dsn = \"" + s.getDataSetName() + "\"");
            ISPFGatewayUtil.addLine(l, "shr = \"" + s.getShrCommand() + "\"");
            ISPFGatewayUtil.addLine(l, "new = \"" + s.getNewCommand() + "\"");
            ISPFGatewayUtil.addLine(l, "if \\allocateDataset(dd,dsn,shr,new) then do");
            ISPFGatewayUtil.addLine(l, "  say 'allocation failed: dd='||dd");
            ISPFGatewayUtil.addLine(l, "  call exit 24");
            ISPFGatewayUtil.addLine(l, "end");
        }
        ISPFGatewayUtil.addLine(l, " ");
        ISPFGatewayUtil.addLine(l, "\"" + command + "\"");
        ISPFGatewayUtil.addLine(l, "call exit rc");
        ISPFGatewayUtil.addLine(l, " ");
        ISPFGatewayUtil.addLine(l, "exit:");
        ISPFGatewayUtil.addLine(l, "arg rc .");
        ISPFGatewayUtil.addLine(l, "failure:");
        ISPFGatewayUtil.addLine(l, "say \"JAZZ_TRANSLATOR_RETURN_CODE =\" rc");
        for (Object object : allocationCmdList) {
            s = ISPFGatewayUtil.getAllocInfo(object);
            if (s.getDdName() == null) continue;
            ISPFGatewayUtil.addLine(l, String.format(REXX_DYFREE, s.getDdName()));
        }
        ISPFGatewayUtil.addLine(l, "exit rc");
        ISPFGatewayUtil.addLine(l, " ");
        ISPFGatewayUtil.addLine(l, "allocateMessage:");
        ISPFGatewayUtil.addLine(l, " ");
        ISPFGatewayUtil.addLine(l, "if datatype(s99msg.0,'N') then do");
        ISPFGatewayUtil.addLine(l, "  do i = 1 to s99msg.0");
        ISPFGatewayUtil.addLine(l, "    say s99msg.i");
        ISPFGatewayUtil.addLine(l, "  end");
        ISPFGatewayUtil.addLine(l, "end");
        ISPFGatewayUtil.addLine(l, " ");
        ISPFGatewayUtil.addLine(l, "return");
        if (addAllocateDataSet) {
            ISPFGatewayUtil.addLine(l, " ");
            ISPFGatewayUtil.addLine(l, "allocateDataset: procedure");
            ISPFGatewayUtil.addLine(l, "parse arg dd,dsn,shr,new");
            ISPFGatewayUtil.addLine(l, "alloc = -1");
            ISPFGatewayUtil.addLine(l, " ");
            ISPFGatewayUtil.addLine(l, "doAlloc:");
            ISPFGatewayUtil.addLine(l, "do 5 while alloc \\= 0");
            ISPFGatewayUtil.addLine(l, "  status = listdsi(\"'\"||dsn||\"' recall\")");
            ISPFGatewayUtil.addLine(l, "  ");
            ISPFGatewayUtil.addLine(l, "  select");
            ISPFGatewayUtil.addLine(l, "    when status = 0 then do");
            ISPFGatewayUtil.addLine(l, "      alloc = BPXWDYN(shr)");
            ISPFGatewayUtil.addLine(l, "    end");
            ISPFGatewayUtil.addLine(l, "    when sysreason = 5 then do");
            ISPFGatewayUtil.addLine(l, "      call BPXWDYN new");
            ISPFGatewayUtil.addLine(l, "      if result = 0 then do");
            ISPFGatewayUtil.addLine(l, "        call BPXWDYN \"free dd(\"||dd||\")\"");
            ISPFGatewayUtil.addLine(l, "        address syscall sleep 1");
            ISPFGatewayUtil.addLine(l, "        iterate");
            ISPFGatewayUtil.addLine(l, "      end");
            ISPFGatewayUtil.addLine(l, "    end");
            ISPFGatewayUtil.addLine(l, "    otherwise do");
            ISPFGatewayUtil.addLine(l, "      say 'listdsi failed: dd='||dd||', rc='||status||', rsn='||sysreason");
            ISPFGatewayUtil.addLine(l, "      leave doAlloc");
            ISPFGatewayUtil.addLine(l, "    end");
            ISPFGatewayUtil.addLine(l, "  end");
            ISPFGatewayUtil.addLine(l, "  ");
            ISPFGatewayUtil.addLine(l, "  if alloc \\= 0 then do");
            ISPFGatewayUtil.addLine(l, "    say 'allocation failed: dd='||dd||', rc='||alloc");
            ISPFGatewayUtil.addLine(l, "    call allocateMessage");
            ISPFGatewayUtil.addLine(l, "    address syscall sleep 1");
            ISPFGatewayUtil.addLine(l, "  end");
            ISPFGatewayUtil.addLine(l, "end");
            ISPFGatewayUtil.addLine(l, " ");
            ISPFGatewayUtil.addLine(l, "return (alloc = 0)");
        }
        return l;
    }

    private static AllocInfo getAllocInfo(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof AllocInfo) {
            return (AllocInfo)obj;
        }
        if (obj instanceof String[]) {
            String[] s = (String[])obj;
            String dd = null;
            String cmd = null;
            String[] instream = null;
            if (s.length > 0) {
                dd = s[0];
            }
            if (s.length > 1) {
                cmd = s[1];
            }
            if (s.length > 2) {
                instream = Arrays.copyOfRange(s, 2, s.length);
            }
            return new AllocInfo(dd, null, cmd, null, instream);
        }
        throw new IllegalArgumentException();
    }

    public static int getTranslatorReturnCode(File f, boolean debug) throws IOException {
        int rc = 8;
        BufferedReader reader = new BufferedReader(new FileReader(f), 1024);
        try {
            String s;
            boolean ispf = false;
            while ((s = reader.readLine()) != null) {
                if (!(ispf || s.indexOf("<ISPF>") < 0 && s.indexOf("<TSO>") < 0)) {
                    ispf = true;
                    continue;
                }
                if (!ispf) continue;
                if (s.indexOf(" JAZZ_TRANSLATOR_RETURN_CODE") >= 0) {
                    Pattern p = Pattern.compile("^\\s+JAZZ_TRANSLATOR_RETURN_CODE = (.*)");
                    Matcher m = p.matcher(s);
                    if (!m.matches() || m.groupCount() <= 0) break;
                    try {
                        rc = Integer.parseInt(m.group(1));
                        break;
                    }
                    catch (NumberFormatException e) {
                        if (!debug) {
                            throw e;
                        }
                        break;
                    }
                }
                if (ispf || s.indexOf("</ISPF>") < 0 && s.indexOf("</TSO>") < 0) continue;
                ispf = false;
                break;
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return rc;
    }
}

