/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.zos.utils;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.teamz.build.ant.zos.nls.Messages;
import com.ibm.teamz.build.ant.zos.utils.ILoggingInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class CheckAccessUtil {
    private static final String READ_ONLY = "r";
    private static final String TWO_SLASHES = "//";

    public static void generateDataSetList(Set<String> inputs, Set<String> outputs, File listFile, ILoggingInterface logIntf) throws IOException {
        if (inputs == null) {
            logIntf.err(Messages.NULL_INPUTS);
            return;
        }
        if (outputs == null) {
            logIntf.err(Messages.NULL_OUTPUTS);
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(listFile);
            CheckAccessUtil.generateDataSetList(inputs, outputs, fos, logIntf);
        }
        finally {
            if (fos != null) {
                fos.flush();
                fos.close();
            }
        }
    }

    private static void generateDataSetList(Set<String> inputs, Set<String> outputs, FileOutputStream fos, ILoggingInterface logIntf) throws IOException {
        String dsn;
        for (String input : inputs) {
            dsn = "'" + input + "'";
            boolean exists = CheckAccessUtil.dsExists(dsn);
            if (!exists) {
                throw new IOException(NLS.bind((String)Messages.INPUT_FILE_NOT_FOUND, (Object)input));
            }
            String[] vols = ZFile.locateDSN((String)dsn);
            if (vols == null || vols.length == 0) {
                throw new IOException(NLS.bind((String)Messages.INPUT_FILE_NOT_FOUND, (Object)input));
            }
            if (vols.length > 1) {
                logIntf.warn(NLS.bind((String)Messages.MULTIPLE_DATA_SETS_FOUND, (Object)input));
                continue;
            }
            String vol = vols[0];
            String s = "INPUT " + input + " " + vol + "\n";
            fos.write(s.getBytes());
        }
        for (String output : outputs) {
            String vol;
            dsn = "'" + output + "'";
            boolean exists = CheckAccessUtil.dsExists(dsn);
            if (!exists) {
                vol = "******";
            } else {
                String[] vols = ZFile.locateDSN((String)dsn);
                if (vols == null || vols.length == 0) {
                    vol = "******";
                } else {
                    if (vols.length > 1) {
                        logIntf.warn(NLS.bind((String)Messages.MULTIPLE_DATA_SETS_FOUND, (Object)output));
                        continue;
                    }
                    vol = vols[0];
                }
            }
            String s = "OUTPUT " + output + " " + vol + "\n";
            fos.write(s.getBytes());
        }
    }

    private static boolean dsExists(String singleQuotedDsName) throws ZFileException {
        boolean isExist = false;
        try (ZFile f = null;){
            try {
                f = new ZFile(TWO_SLASHES + singleQuotedDsName, READ_ONLY);
                isExist = true;
            }
            catch (ZFileException zFileException) {
                if (f != null) {
                    f.close();
                }
            }
        }
        return isExist;
    }

    public static boolean canReadHFS(String pathString) {
        File file = new File(pathString);
        return file.canRead();
    }

    public static boolean canWriteHFS(String pathString) {
        File file = new File(pathString);
        return CheckAccessUtil.canWriteHFS(file);
    }

    private static boolean canWriteHFS(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                return file.canWrite() && file.canExecute();
            }
            return file.canWrite();
        }
        return CheckAccessUtil.canWriteHFS(file.getParentFile());
    }

    public static long lastModifiedHFS(File file) {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.lastModified();
        }
        long newestTimestamp = file.lastModified();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            long childTimestamp = CheckAccessUtil.lastModifiedHFS(child);
            if (childTimestamp > newestTimestamp) {
                newestTimestamp = childTimestamp;
            }
            ++n2;
        }
        return newestTimestamp;
    }
}

