/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.jni;

import com.ibm.jzos.FileFactory;
import java.io.UnsupportedEncodingException;

public class Executable {
    private static final String ENCODING_ENVIRONMENT_VARIABLE = "ZLANG";
    private static final String SHARED_LIBRARY = "RTCzMVSExec";
    private static final String SHARED_LIBRARY_64 = "RTCzMVSExec64";
    private static final String VM_BITMODE = "com.ibm.vm.bitmode";
    private static final String BITMODE_64 = "64";
    private static final String Z_OS = "z/OS";
    private static final String OS_NAME = "os.name";

    static {
        Executable.loadNativeLibrary();
    }

    public static void loadNativeLibrary() {
        if (Z_OS.equals(System.getProperty(OS_NAME))) {
            String bitmode = System.getProperty(VM_BITMODE);
            System.loadLibrary(BITMODE_64.equals(bitmode) ? SHARED_LIBRARY_64 : SHARED_LIBRARY);
        }
    }

    public native int compile(byte[] var1, byte[] var2, byte[] var3, boolean var4);

    public int compile(String pgm, String options, String ddnames, boolean attachx) {
        return this.compile(Executable.getBytesInEBCDIC(pgm), Executable.getHalfWordPrefiexedBytes(Executable.getBytesInEBCDIC(options)), Executable.getHalfWordPrefiexedBytes(Executable.getBytesInEBCDIC(ddnames)), attachx);
    }

    public static byte[] getBytesInEBCDIC(String s) {
        byte[] b = null;
        if (s != null) {
            try {
                b = s.getBytes(Executable.retrieveEncoding());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    private static byte[] getHalfWordPrefiexedBytes(byte[] in) {
        byte[] b = null;
        if (in != null) {
            int len = in.length;
            int bufLen = (len + 9) / 8 * 8;
            b = new byte[bufLen];
            b[0] = (byte)(len >> 8 & 0xFF);
            b[1] = (byte)(len & 0xFF);
            System.arraycopy(in, 0, b, 2, len);
        } else {
            b = new byte[8];
        }
        return b;
    }

    public static String retrieveEncoding() {
        String zLang = System.getenv(ENCODING_ENVIRONMENT_VARIABLE);
        return zLang != null && zLang.length() > 0 ? zLang : FileFactory.getDefaultZFileEncoding();
    }
}

