/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.scm.client.internal;

import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IAutoLoadConnectionInfoHandle;
import com.ibm.teami.scm.common.IProjectToLibraryMap;
import com.ibm.teami.scm.common.IProjectToLibraryMapHandle;
import com.ibm.teami.scm.common.IScmIService;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScmIClientLibrary
implements IScmIClientLibrary {
    private final IClientLibraryContext context;

    public ScmIClientLibrary(IClientLibraryContext context) {
        this.context = context;
    }

    @Override
    public IWorkspaceIHandle createWorkspaceI(final IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ScmIClientLibrary.this.getService().createWorkspaceI(workspaceHandle);
            }
        };
        return (IWorkspaceIHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public IWorkspaceIHandle getWorkspaceI(final IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ScmIClientLibrary.this.getService().getWorkspaceI(workspaceHandle);
            }
        };
        return (IWorkspaceIHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public void deleteWorkspaceI(final IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ScmIClientLibrary.this.getService().deleteWorkspaceI(workspaceHandle);
                return null;
            }
        };
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public void setAutoLoad(final IWorkspaceIHandle workspaceIHandle, final boolean autoLoad, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ScmIClientLibrary.this.getService().setAutoLoad(workspaceIHandle, autoLoad);
                return null;
            }
        };
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public boolean getAutoLoad(final IWorkspaceIHandle workspaceIHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return new Boolean(ScmIClientLibrary.this.getService().getAutoLoad(workspaceIHandle));
            }
        };
        return (Boolean)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public IAutoLoadConnectionInfoHandle setAutoLoadConnectionInfo(final IWorkspaceIHandle workspaceIHandle, final String hostname, final String userName, final String password, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ScmIClientLibrary.this.getService().setAutoLoadConnectionInfo(workspaceIHandle, hostname, userName, password);
            }
        };
        return (IAutoLoadConnectionInfoHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public IAutoLoadConnectionInfoHandle getAutoLoadConnectionInfo(final IWorkspaceIHandle workspaceIHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ScmIClientLibrary.this.getService().getAutoLoadConnectionInfo(workspaceIHandle);
            }
        };
        return (IAutoLoadConnectionInfoHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public List<IProjectToLibraryMapHandle> getProjectToLibraryMappings(final IWorkspaceIHandle workspaceIHandle, final List<IFolderHandle> folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IFolderHandle[] folderHandleArray = new IFolderHandle[folderHandles.size()];
                int i = 0;
                while (i < folderHandles.size()) {
                    folderHandleArray[i] = (IFolderHandle)folderHandles.get(i);
                    ++i;
                }
                IProjectToLibraryMapHandle[] resultsArray = ScmIClientLibrary.this.getService().getProjectToLibraryMappings(workspaceIHandle, folderHandleArray);
                return Arrays.asList(resultsArray);
            }
        };
        return (List)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public String getLibrary(final IWorkspaceHandle workspaceHandle, final IFolderHandle folderHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IWorkspaceIHandle workspaceIHandle = ScmIClientLibrary.this.getWorkspaceI(workspaceHandle, monitor);
                ArrayList<IFolderHandle> folderHandles = new ArrayList<IFolderHandle>();
                folderHandles.add(folderHandle);
                List<IProjectToLibraryMapHandle> projectToLibraryMapHandles = ScmIClientLibrary.this.getProjectToLibraryMappings(workspaceIHandle, folderHandles, monitor);
                if (projectToLibraryMapHandles == null || projectToLibraryMapHandles.size() == 0) {
                    return null;
                }
                IProjectToLibraryMapHandle mapHandle = projectToLibraryMapHandles.get(0);
                IProjectToLibraryMap map = (IProjectToLibraryMap)ScmIClientLibrary.this.context.teamRepository().itemManager().fetchCompleteItem((IItemHandle)mapHandle, 1, null);
                return map.getLibrary();
            }
        };
        return (String)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public void setProjectToLibraryMappings(final IWorkspaceIHandle workspaceIHandle, final List<IFolderHandle> folderHandles, final List<String> libraries, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Object> runnable = new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (folderHandles == null || libraries == null) {
                    throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
                }
                if (folderHandles.size() != libraries.size()) {
                    throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
                }
                IFolderHandle[] folderHandleArray = new IFolderHandle[folderHandles.size()];
                String[] libraryArray = new String[libraries.size()];
                int i = 0;
                while (i < folderHandles.size()) {
                    folderHandleArray[i] = (IFolderHandle)folderHandles.get(i);
                    libraryArray[i] = (String)libraries.get(i);
                    ++i;
                }
                ScmIClientLibrary.this.getService().setProjectToLibraryMappings(workspaceIHandle, folderHandleArray, libraryArray);
                return null;
            }
        };
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    private IScmIService getService() throws TeamRepositoryException {
        IScmIService service = (IScmIService)this.context.getServiceInterface(IScmIService.class);
        if (service == null) {
            throw new TeamRepositoryException("Unable to get IScmIService");
        }
        return service;
    }
}

