/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.promotion.toolkit.taskdefs;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.publishing.LinkPublisher;
import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionBuildUtil;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfoUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages;
import com.ibm.teamp.ibmi.promotion.toolkit.taskdefs.PromotionContentPublisher;
import com.ibm.teamp.ibmi.promotion.toolkit.taskdefs.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public class FinalizePromotedBuildMaps
extends AbstractTeamBuildTask {
    private File fCompletePromotionLog = null;
    private PrintWriter fCompletePromotionLogWriter = null;
    String PROPERTY_PROMOTION_INFO = "team.enterprise.promotionInfo";
    private static final String UTF_8 = "UTF-8";
    private String buildResultUUID;
    private static final String BUILD_PROPERTY_CONNECTION_TIMEOUT = "team.enterprise.promotion.connectionTimeoutOverride";
    private static final String BUILD_PROPERTY_MAX_DELAY = "team.enterprise.promotion.finalizePromotedBuildMaps.maxDelay";
    private static final String BUILD_PROPERTY_DO_NOT_CREATE_NEW_THREAD = "team.enterprise.promotion.finalizePromotedBuildMaps.doNotCreateNewThread";
    private static final String BUILD_PROPERTY_ALLOW_CONCURRENT_BUILDS = "team.enterprise.promotion.allowConcurrentBuilds";
    private static final int LINK_PUBLISHER_BATCH_SIZE = 48;

    public final String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public final void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    protected void collectAntAttributes(List arg0) {
    }

    protected void doExecute() throws Exception {
        int connectionTimeoutOverride;
        String promotionFile = this.getProject().getProperty(this.PROPERTY_PROMOTION_INFO);
        File f = new File(promotionFile);
        boolean suppressBuildMapLinks = Boolean.parseBoolean(this.getProject().getProperty("team.enterprise.promotion.suppressBuildMapLinks"));
        boolean shouldPublishBuildMapLinks = !suppressBuildMapLinks && this.buildResultUUID != null;
        boolean doNotCreateNewThread = Boolean.parseBoolean(this.getProject().getProperty(BUILD_PROPERTY_DO_NOT_CREATE_NEW_THREAD));
        int previousConnectionTimeout = -1;
        if (doNotCreateNewThread && (connectionTimeoutOverride = this.retrieveConnectionTimeoutOverride()) > -1) {
            previousConnectionTimeout = this.getTeamRepository().getConnectionTimeout();
            this.getTeamRepository().setConnectionTimeout(connectionTimeoutOverride);
        }
        this.log("Options:", 3);
        this.log("  Suppress publishing build maps=" + suppressBuildMapLinks, 3);
        this.log("  Donot create new thread=" + doNotCreateNewThread, 3);
        this.log("  Repository connection timeout=" + this.getTeamRepository().getConnectionTimeout(), 3);
        try {
            try {
                PromotionInfo pi;
                List buildMaps;
                String content = Util.fileToString(f, UTF_8);
                IPromotionClient promotionClient = (IPromotionClient)this.getTeamRepository().getClientLibrary(IPromotionClient.class);
                String result = null;
                if (doNotCreateNewThread) {
                    result = promotionClient.finalizeTargetBuildMaps2(content, null);
                } else {
                    this.log("Begin finalizeTargetBuildMaps3()", 3);
                    int maxLoop = this.parseInt(this.getProject().getProperty(BUILD_PROPERTY_MAX_DELAY)) / 5;
                    if (maxLoop <= 0) {
                        maxLoop = Integer.MAX_VALUE;
                    }
                    int count = 0;
                    IBuildResultHandle handle = null;
                    if (this.getBuildResultUUID() != null && !this.getBuildResultUUID().isEmpty()) {
                        handle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getBuildResultUUID()), null);
                    }
                    String requestId = promotionClient.finalizeTargetBuildMaps4(content, handle, null);
                    while (result == null && count++ < maxLoop) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        result = promotionClient.getFinalizeBuildMapStatus(requestId, false, null);
                    }
                    this.log("Finish finalizeTargetBuildMaps3()", 3);
                }
                this.fCompletePromotionLogWriter = this.getBuildLogWriter();
                if (result != null && !result.equals("") && (buildMaps = (pi = PromotionInfoUtil.parsePromotionInfo((String)result)).getFinalBuildMaps()) != null) {
                    String publicUriRoot = this.getProject().getProperty("server.webapp.url");
                    if (publicUriRoot == null || publicUriRoot.length() == 0) {
                        publicUriRoot = this.getProject().getProperty("repositoryAddress");
                    }
                    String publishUriRoot = FinalizePromotedBuildMaps.getv60BuildMapURIRoot(publicUriRoot);
                    ArrayList<IBuildResultContribution> linksToPublish = new ArrayList<IBuildResultContribution>(48);
                    IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildResultUUID), null);
                    for (PromotionInfo.BuildMapEntry buildMap : buildMaps) {
                        if (shouldPublishBuildMapLinks) {
                            linksToPublish.add(this.createLinkResultContribution(String.valueOf(publishUriRoot) + buildMap.uri, buildMap.label));
                        }
                        this.writeToPromotionLog(buildMap);
                        if (linksToPublish.size() < 48) continue;
                        this.getTeamBuildClient().addBuildResultContributions(buildResultHandle, linksToPublish.toArray(new IBuildResultContribution[0]), null);
                        linksToPublish.clear();
                    }
                    if (!linksToPublish.isEmpty()) {
                        this.getTeamBuildClient().addBuildResultContributions(buildResultHandle, linksToPublish.toArray(new IBuildResultContribution[0]), null);
                    }
                }
                this.fCompletePromotionLogWriter.println(this.getParentElementsClose());
                if (this.fCompletePromotionLogWriter != null && this.fCompletePromotionLog != null && !this.fCompletePromotionLogWriter.checkError()) {
                    this.fCompletePromotionLogWriter.close();
                    this.fCompletePromotionLogWriter = null;
                    this.publish(this.fCompletePromotionLog);
                }
            }
            catch (Exception e) {
                this.log("An error occurred during FinalizePromotedBuildMaps", e, 0);
                throw e;
            }
        }
        finally {
            if (doNotCreateNewThread && previousConnectionTimeout > -1) {
                this.getTeamRepository().setConnectionTimeout(previousConnectionTimeout);
            }
        }
    }

    private void publish(File filePath) throws TeamRepositoryException {
        IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildResultUUID), null);
        String promotionReportName = "promotionReport.xml";
        PromotionContentPublisher cp = new PromotionContentPublisher(IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID, filePath.getAbsolutePath(), Messages.PROMOTION_REPORT, "text/xml", UTF_8, "promotionReport.xml");
        IBuildResultContribution contribution = cp.publish(buildResultHandle, BuildStatus.OK, this.getTeamRepository());
        if (contribution == null) {
            throw new BuildException("ContentPublisher failed (contribution == null)");
        }
        String publicUriRoot = this.getProject().getProperty("server.webapp.url");
        if (publicUriRoot == null || publicUriRoot.length() == 0) {
            publicUriRoot = this.getProject().getProperty("repositoryAddress");
        }
        String reportURL = String.valueOf(PromotionInfoUtil.getPromotionInfoURIRoot((String)publicUriRoot)) + "promotionReport/_buildResultUUID=" + this.buildResultUUID;
        LinkPublisher lp = new LinkPublisher(reportURL, "promotionReport.xml");
        lp.setComponentName(com.ibm.team.enterprise.build.common.Messages.REPORTS_LABEL);
        contribution = lp.publish(buildResultHandle, BuildStatus.OK, this.getTeamRepository());
        if (contribution == null) {
            throw new BuildException("LinkPublisher failed (contribution == null)");
        }
    }

    private void writeToPromotionLog(PromotionInfo.BuildMapEntry entry) {
        try {
            PrintWriter writer = this.getBuildLogWriter();
            if (writer == null) {
                this.log("Could not output to promotion log");
            } else {
                String buildFileName = entry.label.substring(entry.label.indexOf(40) + 1, entry.label.indexOf(41));
                String buildFilePath = entry.label.substring(0, entry.label.indexOf(40));
                URI buildFileURI = entry.uri;
                writer.println("<bf:file");
                writer.println("\tbf:buildFile=\"" + buildFileName + "\"");
                writer.println("\tbf:buildPath=\"" + buildFilePath + "\"");
                writer.println("\tbf:inputType=\"\"\n\tbf:langDefName=\"\"\n\tbf:languageCode=\"\"\n\tbf:objLib=\"\"\n\tbf:reason=\"\"\n\tbf:rebuild=\"\"\n\tbf:srcLib=\"\"\n\tbf:uuid=\"\"");
                writer.println("\tbf:buildMap=\"" + buildFileURI.toString() + "\"");
                if (entry.versionId != null && !entry.versionId.isEmpty()) {
                    writer.println("\tbf:versionId=\"" + entry.versionId + "\"");
                }
                writer.println("\tbf:maxRc=\"\"/>");
            }
        }
        catch (Exception e) {
            this.log("An exception occurred while trying to write to promotion log");
        }
    }

    private PrintWriter getBuildLogWriter() throws TeamRepositoryException, IOException {
        if (this.fCompletePromotionLogWriter == null) {
            File fPromotionInfoFile = new File(this.getProject().getProperty(this.PROPERTY_PROMOTION_INFO));
            String allowConStr = this.getProject().getProperty(BUILD_PROPERTY_ALLOW_CONCURRENT_BUILDS);
            boolean allowCon = allowConStr == null ? false : Boolean.valueOf(allowConStr);
            String buildLabel = null;
            if (allowCon) {
                buildLabel = this.getProject().getProperty("buildLabel");
            }
            String promReportFilePath = PromotionBuildUtil.getConcurrentFilePath((String)fPromotionInfoFile.getParent(), (String)buildLabel, (String)"promotionReport", (String)".xml", (String)"/");
            this.fCompletePromotionLog = new File(promReportFilePath);
            if (this.fCompletePromotionLog.exists()) {
                this.fCompletePromotionLog.delete();
            }
            this.fCompletePromotionLogWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fCompletePromotionLog), UTF_8)), true);
            this.fCompletePromotionLogWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.fCompletePromotionLogWriter.println("<?xml-stylesheet type=\"text/xsl\" href=\"promotionReport.xsl\"?>");
            this.fCompletePromotionLogWriter.println(this.getBuildableHeader());
            this.fCompletePromotionLogWriter.println(this.getParentElementsOpen());
        }
        return this.fCompletePromotionLogWriter;
    }

    private String getBuildableHeader() {
        return "<bf:buildable\n\txmlns:bf=\"http://www.ibm.com/team/enterprise/build/buildablefiles/1.0/\"\n\txmlns:buildmap=\"http://www.ibm.com/team/enterprise/build/buildmap/1.0/\"\n\txmlns:ds=\"http://www.ibm.com/team/enterprise/build/dependencyset/1.0/\"\n\txmlns:inputs=\"http://www.ibm.com/team/enterprise/build/buildmap/inputs/1.0/\"\n\txmlns:outputs=\"http://www.ibm.com/team/enterprise/build/buildmap/outputs/1.0/\"\n\txmlns:parserOutputs=\"http://www.ibm.com/team/enterprise/build/buildmap/parserOutputs/1.0/\"\n\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n\tbf:report=\"buildReport\">";
    }

    private String getParentElementsOpen() {
        return "<bf:component bf:name=\"\">\n<bf:project\n\tbf:name=\"\">";
    }

    private String getParentElementsClose() {
        return "</bf:project>\n</bf:component>\n</bf:buildable>";
    }

    protected IBuildResultContribution createLinkResultContribution(String url, String label) {
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_URL, url);
        contribution.setLabel(NLS.bind((String)Messages.BUILD_MAP_INFO_PROMOTION, (Object)label));
        contribution.setImpactsPrimaryResult(true);
        contribution.setStatus(BuildStatus.OK);
        contribution.setExtendedContributionTypeId(IBuildResultContribution.LINK_EXTENDED_CONTRIBUTION_ID);
        contribution.setComponentName(Messages.BUILD_MAPS);
        return contribution;
    }

    private int retrieveConnectionTimeoutOverride() {
        String value = this.getProject().getProperty(BUILD_PROPERTY_CONNECTION_TIMEOUT);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private int parseInt(String aString) {
        try {
            if (aString != null) {
                return Integer.parseInt(aString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static String getv60BuildMapURIRoot(String repositoryLocation) {
        StringBuffer buildMapURI = new StringBuffer();
        if (repositoryLocation != null) {
            buildMapURI.append(repositoryLocation);
            if (buildMapURI.charAt(buildMapURI.length() - 1) != '/') {
                buildMapURI.append('/');
            }
            buildMapURI.append("resource");
            buildMapURI.append('/');
        }
        return buildMapURI.toString();
    }
}

