/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.promotion.toolkit.taskdefs;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.teamp.ibmi.promotion.toolkit.taskdefs.Util;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class DeleteTemporaryBuildMaps
extends AbstractTeamBuildTask {
    private File promotionInfoFile;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute() throws Exception {
        int connectionTimeoutOverride;
        Assert.isNotNull((Object)this.promotionInfoFile);
        String content = Util.fileToString(this.promotionInfoFile, "UTF-8");
        IPromotionClient promotionClient = (IPromotionClient)this.getTeamRepository().getClientLibrary(IPromotionClient.class);
        boolean doNotCreateNewThread = Boolean.parseBoolean(this.getProject().getProperty("team.enterprise.promotion.finalizePromotedBuildMaps.doNotCreateNewThread"));
        int previousConnectionTimeout = -1;
        if (doNotCreateNewThread && (connectionTimeoutOverride = this.retrieveConnectionTimeoutOverride()) > -1) {
            previousConnectionTimeout = this.getTeamRepository().getConnectionTimeout();
            this.getTeamRepository().setConnectionTimeout(connectionTimeoutOverride);
        }
        this.log("Options:", 3);
        this.log("  Donot create new thread=" + doNotCreateNewThread, 3);
        this.log("  Repository connection timeout=" + this.getTeamRepository().getConnectionTimeout(), 3);
        try {
            block12: {
                String requestId;
                int count;
                int maxLoop;
                int result;
                block11: {
                    if (doNotCreateNewThread) {
                        promotionClient.deleteTemporaryBuildMaps(content, null);
                        return;
                    }
                    result = -1;
                    maxLoop = this.parseInt(this.getProject().getProperty("team.enterprise.promotion.finalizePromotedBuildMaps.maxDelay")) / 5;
                    if (maxLoop <= 0) {
                        maxLoop = Integer.MAX_VALUE;
                    }
                    count = 0;
                    requestId = promotionClient.deleteTemporaryBuildMaps2(content, null);
                    if (!true) break block11;
                    if (result != -1) return;
                    if (count++ >= maxLoop) break block12;
                }
                do {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    result = promotionClient.getDeletingTemporaryBuildMapsStatus(requestId);
                    if (result != -1) return;
                } while (count++ < maxLoop);
            }
            return;
        }
        finally {
            if (doNotCreateNewThread && previousConnectionTimeout > -1) {
                this.getTeamRepository().setConnectionTimeout(previousConnectionTimeout);
            }
        }
    }

    public void setPromotionInfoFile(File promotionInfoFile) {
        this.promotionInfoFile = promotionInfoFile;
    }

    protected void collectAntAttributes(List arg0) {
    }

    private int retrieveConnectionTimeoutOverride() {
        String value = this.getProject().getProperty("team.enterprise.promotion.connectionTimeoutOverride");
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private int parseInt(String aString) {
        try {
            if (aString != null) {
                return Integer.parseInt(aString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }
}

