/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.promotion.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.MemberDescription;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.QSYSCheckUserAuthority;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBasic;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectNameOnly;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.iant.taskdefs.CPYOBJTask;
import com.ibm.iant.taskdefs.CRTLIBTask;
import com.ibm.iant.taskdefs.DLTOBJTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.AS400Type;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ant.AbstractContentPublisherTask;
import com.ibm.team.build.internal.publishing.ContentPublisher;
import com.ibm.team.build.internal.publishing.LinkPublisher;
import com.ibm.team.enterprise.build.ant.internal.utils.AuthenticationUtilities;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.build.common.promotion.IPromotableFile;
import com.ibm.team.enterprise.build.common.promotion.IPromotableResource;
import com.ibm.team.enterprise.build.common.promotion.impl.PromotableFile;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfoUtil;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teamp.ibmi.promotion.toolkit.taskdefs.AbstractIBMiCommandTeamBuildTask;
import com.ibm.teamp.ibmi.promotion.toolkit.taskdefs.PromotionContentPublisher;
import com.ibm.teamp.ibmi.promotion.toolkit.taskdefs.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class CopyIBMiObjectsTask2
extends AbstractIBMiCommandTeamBuildTask {
    private File promotionInfoFile;
    private String buildResultUUID;
    private final String as400dtInstanceId = "SystemInstance";
    private final String[] DELETE_ORDERED_TYPES = new String[]{"*MODULE", "*SRVPGM", "*PGM", "*FILE"};
    private boolean skipTimestampCheck;
    private boolean runningJUnits = false;
    private static final char SLASH = '/';
    private boolean migratePFData = false;
    private String restorePfUsrCmd = null;

    private void setup() {
        this.getProject().addDataTypeDefinition("AS400Type", AS400Type.class);
        AS400Type _as400dt = (AS400Type)this.getProject().createDataType("AS400Type");
        this.getProject().addReference("SystemInstance", (Object)_as400dt);
        _as400dt.setRefid(new Reference(this.getProject(), "SystemInstance"));
        this.getProject().setProperty("default.system.id", "SystemInstance");
        String restorePfDataOption = this.getProject().getProperty("team.promotion.ibmi.pfRestoreMethod");
        if (restorePfDataOption != null) {
            if ("MIGRATE".equals(restorePfDataOption)) {
                this.migratePFData = true;
            } else if ("USRCMD".equals(restorePfDataOption)) {
                this.migratePFData = true;
                this.restorePfUsrCmd = this.getProject().getProperty("team.promotion.ibmi.pfRestoreCommand");
            }
        }
        this.runningJUnits = Boolean.parseBoolean(this.getProject().getProperty("team.promotion.ibmi.running.junits"));
    }

    protected void doExecute() throws Exception {
        String promotionInfoContent = null;
        PromotionInfo promotionInfo = null;
        try {
            try {
                Assert.isNotNull((Object)this.promotionInfoFile);
                this.setup();
                promotionInfoContent = Util.fileToString(this.promotionInfoFile, "UTF-8");
                promotionInfo = PromotionInfoUtil.parsePromotionInfo((String)promotionInfoContent);
                if (!this.skipTimestampCheck) {
                    this.checkTimestamps(promotionInfo);
                }
                Map resourceMap = promotionInfo.getPromotableResources();
                for (IPromotableResource resource : resourceMap.values()) {
                    List<IPromotableFile> deletingFiles;
                    String srcLibrary = resource.getSourceResource();
                    String targetLibrary = resource.getTargetResource();
                    this.createLibrary(targetLibrary);
                    this.validate(resource.getFiles(), srcLibrary, targetLibrary);
                    List resources = resource.getFiles();
                    List<IPromotableFile> physicalFilesrequiringMigration = this.physicalFilesNeedingMigration(resources, srcLibrary, targetLibrary);
                    if (physicalFilesrequiringMigration.isEmpty()) {
                        deletingFiles = this.getRequiredDeletingFiles(resources, targetLibrary);
                        this.deleteFiles(deletingFiles, targetLibrary);
                        this.copyFiles(resources, srcLibrary, targetLibrary);
                        continue;
                    }
                    this.getProject().log(NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.PROMOTION_DB_MIGRATION, (Object)physicalFilesrequiringMigration.size()));
                    deletingFiles = this.getRequiredDeletingFiles(resources, targetLibrary);
                    HashMap<String, String> tempNameMap = this.getTempNameMap(physicalFilesrequiringMigration, targetLibrary);
                    for (IPromotableFile pf : physicalFilesrequiringMigration) {
                        deletingFiles.remove(pf);
                        IAntTaskUtils.runCommand((String)("RNMOBJ OBJ(" + targetLibrary + '/' + pf.getName() + ") OBJTYPE(*FILE) NEWOBJ(" + tempNameMap.get(pf.getName()) + ")"), (AS400)this.getAS400(), (Project)this.getProject(), (boolean)true);
                        IAntTaskUtils.runCommand((String)("CHGOBJD OBJ(" + targetLibrary + '/' + tempNameMap.get(pf.getName()) + ") OBJTYPE(*FILE) TEXT('EE promotion temp object for " + pf.getName() + "')"), (AS400)this.getAS400(), (Project)this.getProject(), (boolean)true);
                    }
                    this.deleteFiles(deletingFiles, targetLibrary);
                    List<IPromotableFile> logicalFiles = this.getSubsetOfFilesByType(resources, srcLibrary, "*FILE", "LF");
                    for (IPromotableFile res : logicalFiles) {
                        resources.remove(res);
                    }
                    this.copyFiles(resources, srcLibrary, targetLibrary);
                    for (IPromotableFile res : physicalFilesrequiringMigration) {
                        if (this.restorePfUsrCmd != null && !this.restorePfUsrCmd.isEmpty()) {
                            String ifsFileName = String.valueOf(this.getBaseIFSPath(srcLibrary)) + srcLibrary + ".LIB" + "/" + res.getName() + ".FILE";
                            IFSFile ifsFile = new IFSFile(this.getAS400(), ifsFileName);
                            String typeAttribute = "*";
                            if (ifsFile.exists()) {
                                typeAttribute = ifsFile.getSubtype();
                            }
                            String cmd = this.substituteUsrCmdVariables(this.restorePfUsrCmd, srcLibrary, targetLibrary, tempNameMap.get(res.getName()), res.getName(), res.getType(), typeAttribute);
                            IAntTaskUtils.runCommand((String)cmd, (AS400)this.getAS400(), (Project)this.getProject(), (boolean)true);
                            continue;
                        }
                        String cmd = "CPYF FROMFILE(" + targetLibrary + '/' + tempNameMap.get(res.getName()) + ") TOFILE(" + targetLibrary + '/' + res.getName() + ") MBROPT(*REPLACE) FMTOPT(*MAP *DROP) CRTFILE(*NO)";
                        IAntTaskUtils.runCommand((String)cmd, (AS400)this.getAS400(), (Project)this.getProject(), (boolean)true);
                    }
                    this.copyFiles(logicalFiles, srcLibrary, targetLibrary);
                    ArrayList<IPromotableFile> tempFiles = new ArrayList<IPromotableFile>();
                    for (Map.Entry<String, String> tempObject : tempNameMap.entrySet()) {
                        tempFiles.add((IPromotableFile)new PromotableFile(tempObject.getValue(), false, System.currentTimeMillis(), "*FILE"));
                    }
                    this.deleteFiles(tempFiles, targetLibrary);
                }
                if (!this.runningJUnits) {
                    this.updateOutputTimestampInBuildMaps(promotionInfo);
                }
            }
            catch (Exception e) {
                if (promotionInfoContent != null && !this.runningJUnits) {
                    IPromotionClient client = (IPromotionClient)this.getTeamRepository().getClientLibrary(IPromotionClient.class);
                    client.deleteTemporaryBuildMaps(promotionInfoContent, null);
                }
                throw new BuildException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (!this.runningJUnits) {
                this.publishUpdatedPromotionInfo(promotionInfo);
            }
            throw throwable;
        }
        if (!this.runningJUnits) {
            this.publishUpdatedPromotionInfo(promotionInfo);
        }
    }

    protected List<IPromotableFile> getRequiredDeletingFiles(List<IPromotableFile> files, String targetLibrary) {
        HashMap<String, ArrayList<IPromotableFile>> map = new HashMap<String, ArrayList<IPromotableFile>>();
        ArrayList<IPromotableFile> deletingFiles = new ArrayList<IPromotableFile>();
        for (IPromotableFile file : files) {
            if (!this.objectExists(file, targetLibrary)) continue;
            ArrayList<IPromotableFile> list = (ArrayList<IPromotableFile>)map.get(file.getType());
            if (list == null) {
                list = new ArrayList<IPromotableFile>();
            }
            list.add(file);
            map.put(file.getType(), list);
        }
        String[] stringArray = this.DELETE_ORDERED_TYPES;
        int list = this.DELETE_ORDERED_TYPES.length;
        int n = 0;
        while (n < list) {
            String type = stringArray[n];
            List tempFiles = (List)map.get(type);
            if (tempFiles != null && tempFiles.size() > 0) {
                deletingFiles.addAll(tempFiles);
            }
            ++n;
        }
        for (String type : map.keySet()) {
            List tempFiles;
            if (this.isType(this.DELETE_ORDERED_TYPES, type) || (tempFiles = (List)map.get(type)) == null || tempFiles.size() <= 0) continue;
            deletingFiles.addAll(tempFiles);
        }
        return deletingFiles;
    }

    private void createLibrary(String libraryname) throws BuildException {
        try {
            IFSFile ifsFile = new IFSFile(this.getAS400(), String.valueOf(this.getBaseIFSPath(libraryname)) + libraryname + ".LIB");
            if (!ifsFile.exists()) {
                CRTLIBTask crtLibTask = new CRTLIBTask();
                crtLibTask.setLibraryname(libraryname);
                crtLibTask.setProject(this.getProject());
                crtLibTask.setASPGroupName(this.getASPGroupName());
                crtLibTask.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.FAILED_TO_CREATE_LIBRARY, (Object)libraryname));
        }
    }

    private boolean isLibraryExist(String libraryname) throws BuildException {
        try {
            IFSFile ifsFile = new IFSFile(this.getAS400(), String.valueOf(this.getBaseIFSPath(libraryname)) + libraryname + ".LIB");
            return ifsFile.exists();
        }
        catch (Exception e) {
            throw new BuildException(e.getLocalizedMessage());
        }
    }

    private boolean canCopy(IPromotableFile file, String fromLib, String toLib) throws BuildException {
        try {
            AS400 as400 = this.getAS400();
            ISeriesObjectFilterString objectFilterString = new ISeriesObjectFilterString();
            objectFilterString.setObject(toLib);
            objectFilterString.setObjectType(file.getType());
            objectFilterString.setLibrary(fromLib);
            ISeriesListObjects listObjects = new ISeriesListObjects(as400);
            List objectList = listObjects.getList((ISeriesAbstractFilterString)objectFilterString);
            if (objectList.size() == 1 && objectList.get(0) instanceof IISeriesHostObjectNameOnly) {
                IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(toLib)) + toLib + ".LIB");
                QSYSCheckUserAuthority checkUserAuthority = new QSYSCheckUserAuthority(as400, as400.getUserId(), toLib, file.getName(), file.getType());
                if (!ifsFile.canWrite() || !checkUserAuthority.canWrite()) {
                    throw new BuildException(NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.FAILED_TO_COPY_NO_PERMISSION, (Object)(String.valueOf(toLib) + '/' + file.getName() + '.' + file.getType())));
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        return true;
    }

    private boolean objectExists(IPromotableFile file, String toLib) throws BuildException {
        try {
            AS400 as400 = this.getAS400();
            ISeriesObjectFilterString objectFilterString = new ISeriesObjectFilterString();
            objectFilterString.setObject(file.getName());
            objectFilterString.setObjectType(file.getType());
            objectFilterString.setLibrary(toLib);
            ISeriesListObjects listObjects = new ISeriesListObjects(as400);
            List objectList = listObjects.getList((ISeriesAbstractFilterString)objectFilterString);
            return objectList.size() > 0 && objectList.get(0) instanceof IISeriesHostObjectNameOnly;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void deleteFiles(List<IPromotableFile> deletingFiles, String targetLibrary) {
        if (deletingFiles.size() > 0) {
            ArrayList<IPromotableFile> failedFiles = new ArrayList<IPromotableFile>();
            for (IPromotableFile deletingFile : deletingFiles) {
                if (this.deleteFile(deletingFile, targetLibrary)) continue;
                System.out.println(NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.ATTEMPT_DELETE_AGAIN, (Object)deletingFile.getName()));
                failedFiles.add(deletingFile);
            }
            if (failedFiles.size() > 0 && deletingFiles.size() == failedFiles.size()) {
                throw new BuildException(NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.FAILED_TO_DELETE, (Object)targetLibrary));
            }
            this.deleteFiles(failedFiles, targetLibrary);
        }
    }

    private boolean deleteFile(IPromotableFile deletingFile, String targetLibrary) {
        try {
            DLTOBJTask deleteTask = new DLTOBJTask();
            deleteTask.setObject(deletingFile.getName());
            deleteTask.setObjecttype(deletingFile.getType());
            deleteTask.setLibrary(targetLibrary);
            deleteTask.setSystemref(this._systemref);
            deleteTask.setProject(this.getProject());
            deleteTask.setFailOnError(true);
            deleteTask.execute();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void copyFiles(List<IPromotableFile> files, String srcLibrary, String targetLibrary) {
        if (files.size() > 0) {
            ArrayList<IPromotableFile> failedFiles = new ArrayList<IPromotableFile>();
            for (IPromotableFile file : files) {
                if (!this.copyFile(file, srcLibrary, targetLibrary)) {
                    System.out.println(NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.ATTEMPT_COPY_AGAIN, (Object)file.getName()));
                    failedFiles.add(file);
                    continue;
                }
                long timestamp = this.getTimestampOnIBMi(targetLibrary, file.getName(), file.getType());
                if (timestamp <= 0L) continue;
                file.setTimestamp(timestamp);
            }
            if (failedFiles.size() > 0 && files.size() == failedFiles.size()) {
                throw new BuildException(NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.FAILED_TO_COPY, (Object)srcLibrary, (Object)targetLibrary));
            }
            this.copyFiles(failedFiles, srcLibrary, targetLibrary);
        }
    }

    private boolean copyFile(IPromotableFile file, String srcLibrary, String targetLibrary) {
        try {
            CPYOBJTask copyTask = new CPYOBJTask();
            copyTask.setFromlibrary(srcLibrary);
            copyTask.setFromobject(file.getName());
            copyTask.setFromobjecttype(file.getType());
            copyTask.setTolibrary(targetLibrary);
            copyTask.setProject(this.getProject());
            copyTask.setSystemref(this._systemref);
            copyTask.setNewobject(file.getName());
            copyTask.setFailOnError(true);
            copyTask.execute();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean validate(List<IPromotableFile> files, String srcLibrary, String targetLibrary) {
        for (IPromotableFile file : files) {
            if (this.canCopy(file, srcLibrary, targetLibrary)) continue;
            return false;
        }
        return true;
    }

    private boolean isType(String[] predefinedTypes, String type) {
        String[] stringArray = predefinedTypes;
        int n = predefinedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String predefinedType = stringArray[n2];
            if (predefinedType.equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void updateOutputTimestampInBuildMaps(PromotionInfo promotionInfo) throws TeamRepositoryException {
        List slugs = promotionInfo.getTemporaryBuildMaps();
        if (slugs != null) {
            Collection<IPromotableResource> resources = promotionInfo.getPromotableResources().values();
            IBuildMapClient buildMapClient = (IBuildMapClient)this.getTeamRepository().getClientLibrary(IBuildMapClient.class);
            HashMap<String, Long> outputsToTimestampMap = new HashMap<String, Long>();
            for (PromotionInfo.BuildMapEntry entry : slugs) {
                IBuildMapHandle handle = null;
                handle = (IBuildMapHandle)Location.location((URI)entry.uri).getItemHandle();
                if (handle == null) continue;
                try {
                    IBuildMap buildMap = (IBuildMap)buildMapClient.getBuildMap(handle, null).getWorkingCopy();
                    boolean changed = false;
                    int i = 0;
                    while (i < buildMap.getOutputs().size()) {
                        IOutputBuildFile buildFile = (IOutputBuildFile)buildMap.getOutputs().get(i);
                        if (buildFile != null) {
                            String fullPath = this.getFullPathNameForBuildFile(buildFile);
                            Long timestamp = (Long)outputsToTimestampMap.get(fullPath);
                            if (timestamp == null) {
                                timestamp = this.getTimestamp(buildFile.getBuildPath(), buildFile.getBuildFile(), buildFile.getOutputType(), resources);
                                outputsToTimestampMap.put(fullPath, timestamp);
                            }
                            if (timestamp != null && timestamp != -1L && (buildFile.getTimestamp() == null || buildFile.getTimestamp().getTime() != timestamp.longValue())) {
                                buildFile = (IOutputBuildFile)buildFile.getWorkingCopy();
                                buildFile.setTimestamp(new Timestamp(timestamp));
                                buildMap.getOutputs().set(i, buildFile);
                                if (!changed) {
                                    changed = true;
                                }
                            }
                        }
                        ++i;
                    }
                    List parserOutputs = buildMap.getParserOutputs();
                    if (parserOutputs != null && !parserOutputs.isEmpty()) {
                        int i2 = 0;
                        while (i2 < parserOutputs.size()) {
                            IOutputBuildFile parserOutput = (IOutputBuildFile)parserOutputs.get(i2);
                            String fullPath = this.getFullPathNameForBuildFile(parserOutput);
                            Long timestamp = (Long)outputsToTimestampMap.get(fullPath);
                            if (timestamp == null) {
                                timestamp = this.getTimestamp(parserOutput.getBuildPath(), parserOutput.getBuildFile(), parserOutput.getOutputType(), resources);
                                if (timestamp == null || timestamp < 0L) {
                                    timestamp = this.getTimestampOnIBMi(parserOutput.getBuildPath(), parserOutput.getBuildFile(), parserOutput.getOutputType());
                                }
                                outputsToTimestampMap.put(fullPath, timestamp);
                            }
                            if (timestamp != null && timestamp != -1L && (parserOutput.getTimestamp() == null || parserOutput.getTimestamp().getTime() != timestamp.longValue())) {
                                parserOutput = (IOutputBuildFile)parserOutput.getWorkingCopy();
                                parserOutput.setTimestamp(new Timestamp(timestamp));
                                parserOutputs.set(i2, parserOutput);
                                if (!changed) {
                                    changed = true;
                                }
                            }
                            ++i2;
                        }
                    }
                    if (!changed) continue;
                    buildMapClient.saveBuildMap(buildMap, null);
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        }
    }

    private String getFullPathNameForBuildFile(IOutputBuildFile file) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(file.getBuildPath());
        buf.append('(');
        buf.append(file.getBuildFile());
        buf.append(')');
        buf.append('(');
        buf.append((Object)file.isSequential());
        buf.append(')');
        String type = file.getOutputType();
        if (type != null && type.length() > 1) {
            buf.append('.');
            buf.append(type, 1, type.length());
        }
        return buf.toString();
    }

    private long getTimestamp(String library, String name, String type, Collection<IPromotableResource> resources) {
        for (IPromotableResource resource : resources) {
            if (!resource.getTargetResource().equals(library)) continue;
            for (IPromotableFile file : resource.getFiles()) {
                if (!file.getName().equals(name) || !file.getType().equals(type)) continue;
                return file.getTimestamp();
            }
        }
        return -1L;
    }

    private void publishUpdatedPromotionInfo(PromotionInfo promotionInfo) throws BuildException {
        if (this.buildResultUUID == null) {
            this.buildResultUUID = this.getProject().getProperty("buildResultUUID");
        }
        if (this.buildResultUUID == null) {
            return;
        }
        try {
            String promotionInfoLabel = "promotionInfo.xml";
            String xmlContent = PromotionInfoUtil.getXmlString((PromotionInfo)promotionInfo);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.promotionInfoFile), "UTF-8");
            out.write(xmlContent);
            ((Writer)out).flush();
            ((Writer)out).close();
            this.log("uploading promotionInfo.xml", 4);
            PromotionContentPublisherTask jazzPublishTask = new PromotionContentPublisherTask("promotionInfo.xml");
            jazzPublishTask.setProject(this.getProject());
            jazzPublishTask.setFilePath(this.promotionInfoFile);
            jazzPublishTask.setLabel(com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.PROMOTION_INFO_FILE_LABEL);
            jazzPublishTask.setRepositoryAddress(this.getRepositoryAddress());
            AuthenticationUtilities.setAuthenticationAttributes((AbstractTeamBuildTask)jazzPublishTask, (String)this.getRepositoryAddress(), (String)this.getUserId(), (File)this.getPasswordFile());
            jazzPublishTask.setBuildResultUUID(this.buildResultUUID);
            jazzPublishTask.execute();
            this.log("Publishing external link to promotionInfo.xml", 4);
            String publicUriRoot = this.getProject().getProperty("server.webapp.url");
            if (publicUriRoot == null || publicUriRoot.length() == 0) {
                publicUriRoot = this.getProject().getProperty("repositoryAddress");
            }
            String url = String.valueOf(PromotionInfoUtil.getPromotionInfoURIRoot((String)publicUriRoot)) + "promotionInfo/_buildResultUUID=" + this.buildResultUUID;
            IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildResultUUID), null);
            LinkPublisher lp = new LinkPublisher(url, "promotionInfo.xml");
            lp.setComponentName(Messages.REPORTS_LABEL);
            IBuildResultContribution contribution = lp.publish(buildResultHandle, BuildStatus.OK, this.getTeamRepository());
            if (contribution == null) {
                throw new BuildException("LinkPublisher failed (contribution == null)");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void checkTimestamps(PromotionInfo promotionInfo) {
        for (IPromotableResource res : promotionInfo.getPromotableResources().values()) {
            String sourceRes = res.getSourceResource();
            List files = res.getFiles();
            if (!this.isLibraryExist(sourceRes) || files == null) continue;
            for (IPromotableFile file : files) {
                if (!this.objectExists(file, sourceRes)) continue;
                String fullName = String.valueOf(sourceRes) + "/" + file.getName() + " OBJTYPE(" + file.getType() + ")";
                long timestamp = file.getTimestamp();
                if (timestamp != 0L) {
                    long ibmiTimestamp = this.getTimestampOnIBMi(sourceRes, file.getName(), file.getType());
                    if (ibmiTimestamp == 0L) {
                        throw new BuildException(NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.TIMESTAMP_NOT_FOUND_IN_THE_SYSTEM, (Object)fullName));
                    }
                    if (ibmiTimestamp / 1000L == timestamp / 1000L) continue;
                    String errorMessage = NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.TIMESTAMPS_DO_NOT_MATCH, (Object[])new String[]{fullName, Long.toString(timestamp), Long.toString(ibmiTimestamp)});
                    String additionalDetails = this.getAdditionalErrorDetail(files, file, res);
                    if (additionalDetails != null) {
                        errorMessage = String.valueOf(errorMessage) + "   " + additionalDetails;
                    }
                    throw new BuildException(errorMessage);
                }
                throw new BuildException(NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.TIMESTAMP_NOT_FOUND_IN_MANIFEST, (Object)fullName));
            }
        }
    }

    private long getTimestampOnIBMi(String library, String objectName, String objectType) {
        String filterString = String.valueOf(library) + "/" + objectName + " OBJTYPE(" + objectType + ")";
        List objects = IAntTaskUtils.getObjectListForFilterString((String)filterString, (AS400)this.getAS400());
        if (objects.size() == 1) {
            return ((IISeriesHostObjectBasic)objects.get(0)).getDateModified().getTime();
        }
        return 0L;
    }

    public void setPromotionInfoFile(File promotionInfoFile) {
        this.promotionInfoFile = promotionInfoFile;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public void setSkipTimestampCheck(boolean skipTimestampCheck) {
        this.skipTimestampCheck = skipTimestampCheck;
    }

    private List<IPromotableFile> physicalFilesNeedingMigration(List<IPromotableFile> resources, String sourceLib, String destinationLib) throws Exception {
        ArrayList<IPromotableFile> list = new ArrayList<IPromotableFile>();
        if (this.migratePFData) {
            for (IPromotableFile resource : resources) {
                if (!"*FILE".equals(resource.getType()) || !this.isPhysicalFilePopulated(resource, destinationLib)) continue;
                list.add(resource);
            }
        }
        return list;
    }

    HashMap<String, String> getTempNameMap(List<IPromotableFile> resources, String lib) {
        HashMap<String, String> map = new HashMap<String, String>(200);
        String PREFIX = "EEP";
        DecimalFormat df = new DecimalFormat("0000000");
        int count = 0;
        List<ISeriesHostObjectBasic> existingTempObjects = this.resolveFilteredObjects(lib, "EEP*", "*FILE", "*");
        for (IPromotableFile resource : resources) {
            if (!existingTempObjects.isEmpty() || IAntTaskUtils.checkListForObjectName(existingTempObjects, (String)("EEP" + df.format(count)))) {
                while (count <= 9999999 && IAntTaskUtils.checkListForObjectName(existingTempObjects, (String)("EEP" + df.format(count)))) {
                    ++count;
                }
                if (count > 9999999) {
                    return null;
                }
            }
            map.put(resource.getName(), "EEP" + df.format(count++));
        }
        return map;
    }

    private List<IPromotableFile> getSubsetOfFilesByType(List<IPromotableFile> resources, String libraryName, String type, String subType) throws IOException, AS400SecurityException {
        ArrayList<IPromotableFile> list = new ArrayList<IPromotableFile>();
        for (IPromotableFile resource : resources) {
            if (!"*FILE".equals(resource.getType())) continue;
            String ifsFileName = String.valueOf(this.getBaseIFSPath(libraryName)) + libraryName + ".LIB" + "/" + resource.getName() + ".FILE";
            IFSFile ifsFile = new IFSFile(this.getAS400(), ifsFileName);
            if (!ifsFile.exists() || !ifsFile.getSubtype().startsWith(subType)) continue;
            list.add(resource);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPhysicalFilePopulated(IPromotableFile object, String libraryName) throws Exception {
        try {
            String[] ifsMemberNames;
            String ifsFileName = String.valueOf(this.getBaseIFSPath(libraryName)) + libraryName + ".LIB" + "/" + object.getName() + ".FILE";
            IFSFile ifsFile = new IFSFile(this.getAS400(), ifsFileName);
            if (ifsFile.exists() && ifsFile.getSubtype().startsWith("PF") && (ifsMemberNames = ifsFile.list()) != null && ifsMemberNames.length > 0) {
                String[] stringArray = ifsMemberNames;
                int n = ifsMemberNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String ifsMemberName = stringArray[n2];
                    String longMemberName = String.valueOf(ifsFileName) + "/" + ifsMemberName;
                    MemberDescription mbrd = new MemberDescription(this.getAS400(), longMemberName);
                    int numRecords = (Integer)mbrd.getValue(13);
                    if (numRecords > 0) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private List<ISeriesHostObjectBasic> resolveFilteredObjects(String lib, String obj, String type, String attr) {
        String filterString = String.valueOf(lib) + "/" + obj + " IFSFile.separator(" + type + ":" + attr + ")";
        List foundObjects = IAntTaskUtils.getObjectListForFilterString((String)filterString, (AS400)this.getAS400());
        return foundObjects;
    }

    private String substituteUsrCmdVariables(String cmdTemplate, String sourceLib, String destinationLib, String tempName, String objName, String objType, String objAttr) {
        String returnString = new String();
        returnString = cmdTemplate.replaceAll("&S", sourceLib);
        returnString = returnString.replaceAll("&D", destinationLib);
        returnString = returnString.replaceAll("&W", tempName);
        returnString = returnString.replaceAll("&N", objName);
        returnString = returnString.replaceAll("&T", objType);
        returnString = returnString.replaceAll("&A", objAttr);
        return returnString;
    }

    private String getAdditionalErrorDetail(List<IPromotableFile> files, IPromotableFile aFile, IPromotableResource resource) {
        if (files.size() < 2 || aFile == null || aFile.getName() == null || aFile.getName().isEmpty()) {
            return null;
        }
        ArrayList<IPromotableFile> conflictFiles = new ArrayList<IPromotableFile>(3);
        for (IPromotableFile file : files) {
            if (!aFile.getName().equals(file.getName())) continue;
            conflictFiles.add(file);
        }
        if (conflictFiles.size() < 2) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = conflictFiles.iterator();
        while (iterator.hasNext()) {
            buffer.append(((IPromotableFile)iterator.next()).getScmLocation());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return NLS.bind((String)com.ibm.teamp.ibmi.promotion.toolkit.nls.Messages.ERROR_PROMOTION_DUPLICATE_OUTPUT, (Object[])new String[]{buffer.toString(), aFile.getName(), resource.getSourceResource()});
    }

    private class PromotionContentPublisherTask
    extends AbstractContentPublisherTask {
        private String fileName = null;

        public PromotionContentPublisherTask(String fileName) {
            this.fileName = fileName;
        }

        protected ContentPublisher getContentPublisher() {
            return new PromotionContentPublisher(IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID, this.getFile().getAbsolutePath(), this.getLabel(), this.getContentType(), this.getCharacterEncoding(), this.fileName);
        }
    }
}

