/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.promotion.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.QSYSCheckUserAuthority;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectNameOnly;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.CPYOBJTask;
import com.ibm.iant.taskdefs.CRTLIBTask;
import com.ibm.teamp.ibmi.automation.toolkit.IBMiObjectValidater;
import com.ibm.teamp.ibmi.automation.toolkit.ManifestObjectParser;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class CopyIBMiObjectsTask
extends AbstractIBMiCommandTask {
    private String manifestFile;
    private String libraryMappingPropertiesFile;
    private String systemRef;
    private String otherCopyOptions = "";

    public void execute() {
        try {
            ManifestObjectParser manifestObjectParser = new ManifestObjectParser();
            AS400 as400 = this.getAS400();
            List ibmiObjects = manifestObjectParser.getIBMiObjectsFromManifestFile(as400, this.manifestFile);
            IBMiObjectValidater objectValidator = new IBMiObjectValidater(as400, ibmiObjects);
            List existingObjects = objectValidator.getExistingObjects();
            Properties properties = this.getLibraryMappingProperties(as400);
            for (ManifestObjectParser.IBMiObject fromObject : existingObjects) {
                String fromLib = fromObject.getLibrary();
                String toLib = null;
                if (properties.getProperty(fromLib) == null) {
                    throw new BuildException("The user did not specify where to copy this object " + fromObject.getLibrary() + '/' + fromObject.getObjectName() + '.' + fromObject.getObjectType());
                }
                toLib = properties.getProperty(fromLib);
                this.createLibrary(toLib, as400);
                if (!this.canCopy(fromObject, toLib, as400)) continue;
                CPYOBJTask copyTask = new CPYOBJTask();
                copyTask.setFromlibrary(fromObject.getLibrary());
                copyTask.setFromobject(fromObject.getObjectName());
                copyTask.setFromobjecttype(fromObject.getObjectType());
                copyTask.setTolibrary(toLib);
                copyTask.setProject(this.getProject());
                copyTask.setSystemref(this.systemRef);
                copyTask.setNewobject(fromObject.getObjectName());
                copyTask.setOtheroptions(this.otherCopyOptions);
                copyTask.execute();
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setManifestFileDirectory(String manifestFile) {
        this.manifestFile = manifestFile;
    }

    public void setLibraryMappingPropertiesFile(String libraryMappingPropertiesFile) {
        this.libraryMappingPropertiesFile = libraryMappingPropertiesFile;
    }

    public void setSystemRef(String systemRef) {
        this.systemRef = systemRef;
    }

    public void setOtherCopyOptions(String otherCopyOptions) {
        this.otherCopyOptions = otherCopyOptions;
    }

    private Properties getLibraryMappingProperties(AS400 connection) throws Exception {
        Properties properties = new Properties();
        IFSFileInputStream propsFile = new IFSFileInputStream(new IFSFile(connection, this.libraryMappingPropertiesFile));
        properties.load((InputStream)propsFile);
        propsFile.close();
        return properties;
    }

    private boolean canCopy(ManifestObjectParser.IBMiObject fromObject, String toLib, AS400 as400) throws BuildException {
        try {
            ISeriesObjectFilterString objectFilterString = new ISeriesObjectFilterString();
            objectFilterString.setObject(toLib);
            objectFilterString.setObjectType(fromObject.getObjectType());
            objectFilterString.setLibrary(fromObject.getLibrary());
            ISeriesListObjects listObjects = new ISeriesListObjects(as400);
            List objectList = listObjects.getList((ISeriesAbstractFilterString)objectFilterString);
            if (objectList.size() == 1 && objectList.get(0) instanceof IISeriesHostObjectNameOnly) {
                IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(toLib)) + toLib + ".LIB");
                QSYSCheckUserAuthority checkUserAuthority = new QSYSCheckUserAuthority(as400, as400.getUserId(), toLib, fromObject.getObjectName(), fromObject.getObjectType());
                if (!ifsFile.canWrite() || !checkUserAuthority.canWrite()) {
                    throw new BuildException("The user does not have permissions to override object " + toLib + '/' + fromObject.getObjectName() + '.' + fromObject.getObjectType());
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        return true;
    }

    private void createLibrary(String libraryname, AS400 as400) throws BuildException {
        try {
            IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(libraryname)) + libraryname + ".LIB");
            if (!ifsFile.exists()) {
                CRTLIBTask crtLibTask = new CRTLIBTask();
                crtLibTask.setLibraryname(libraryname);
                crtLibTask.setProject(this.getProject());
                crtLibTask.setASPGroupName(this.getASPGroupName());
                crtLibTask.execute();
            }
        }
        catch (Exception e) {
            throw new BuildException(" Cannot create library" + libraryname);
        }
    }
}

