/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.packaging.toolkit;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.comm.ISeriesListLibraries;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesLibraryFilterString;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectNameOnly;
import com.ibm.iant.IBMiLibraryValidator;
import com.ibm.teamp.ibmi.packaging.toolkit.taskdefs.IBMiShipList;
import com.ibm.teamp.packaging.toolkit.Messages;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public class ResolveAsterisk {
    private String libraryName;
    private String resourceFilter;
    private AS400 iServer = null;

    public ResolveAsterisk(AS400 iServer) {
        this.iServer = iServer;
    }

    public ResolveAsterisk(String libraryName, AS400 iServer) {
        this.libraryName = libraryName;
        if (!libraryName.startsWith("\"")) {
            this.libraryName = libraryName.toUpperCase();
        }
        this.iServer = iServer;
    }

    public ResolveAsterisk(String libraryName, AS400 iServer, String resourceFilter) {
        this.libraryName = libraryName;
        if (!libraryName.startsWith("\"")) {
            this.libraryName = libraryName.toUpperCase();
        }
        this.iServer = iServer;
        this.resourceFilter = resourceFilter;
    }

    public void setResourceFile(String resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
        if (!libraryName.startsWith("\"")) {
            this.libraryName = libraryName.toUpperCase();
        }
    }

    public void setAS400(AS400 iServer) {
        this.iServer = iServer;
    }

    public List<String> ResolveLibraryNames(String libraryNameFilter) {
        this.libraryName = libraryNameFilter;
        if (!libraryNameFilter.startsWith("\"")) {
            this.libraryName = libraryNameFilter.toUpperCase();
        }
        ArrayList<String> resolvedLibraryNames = new ArrayList<String>();
        ISeriesLibraryFilterString filterString = new ISeriesLibraryFilterString(this.libraryName);
        ISeriesListLibraries listLibraries = new ISeriesListLibraries();
        listLibraries.setSystem(this.iServer);
        try {
            List list = listLibraries.getListNameOnly((ISeriesAbstractFilterString)filterString);
            if (list != null) {
                for (ISeriesHostObjectNameOnly object : list) {
                    resolvedLibraryNames.add(object.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resolvedLibraryNames;
    }

    public List<ISeriesHostObjectBasic> ResolveObjectsInLibrary(String[] resourceFilter) {
        String resourceNameFilter;
        if (resourceFilter[0] != null) {
            resourceNameFilter = resourceFilter[0];
            if (!resourceNameFilter.startsWith("\"")) {
                resourceNameFilter = resourceNameFilter.toUpperCase();
            }
        } else {
            resourceNameFilter = "*";
        }
        String resourceTypeFilter = resourceFilter[1] != null ? resourceFilter[1].toUpperCase() : "*";
        String filter = new StringBuffer(this.libraryName).append("/").append(resourceNameFilter).append(" OBJTYPE(").append(resourceTypeFilter).append(":").append("*").append(")").toString();
        List resolvedObjects = IBMiShipList.getObjectListForFilterString(filter, this.iServer);
        if (resolvedObjects != null) {
            return resolvedObjects;
        }
        return new ArrayList<ISeriesHostObjectBasic>();
    }

    public List<String> ResolveObjectNamesInLirary(String[] resourceFilter) {
        String resourceNameFilter;
        ArrayList<String> objectNames = new ArrayList<String>();
        if (resourceFilter[0] != null) {
            resourceNameFilter = resourceFilter[0];
            if (!resourceNameFilter.startsWith("\"")) {
                resourceNameFilter = resourceNameFilter.toUpperCase();
            }
        } else {
            resourceNameFilter = "*";
        }
        String resourceTypeFilter = resourceFilter[1] != null ? resourceFilter[1].toUpperCase() : "*";
        if (IBMiLibraryValidator.isValidLibraryName((String)this.libraryName)) {
            String filter = new StringBuffer(this.libraryName).append("/").append(resourceNameFilter).append(" OBJTYPE(").append(resourceTypeFilter).append(":").append("*").append(")").toString();
            try {
                List objects = IBMiShipList.getObjectListForFilterString(filter, this.iServer);
                if (objects != null) {
                    for (ISeriesHostObjectBasic object : objects) {
                        objectNames.add(String.valueOf(object.getName()) + "." + object.getType());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new BuildException(NLS.bind((String)Messages.ResolveAsterisk_LIBRARY_NAME_NOT_VALID_IN_SHIPLIST_FILE, (Object)this.libraryName));
        }
        return objectNames;
    }

    public List<String> getObjectNamesInLibrary() {
        ArrayList<String> objectNames = new ArrayList<String>();
        if (IBMiLibraryValidator.isValidLibraryName((String)this.libraryName)) {
            String filter = new StringBuffer(this.libraryName).append("/").append("*").append(" OBJTYPE(").append("*").append(":").append("*").append(")").toString();
            try {
                List objects = IBMiShipList.getObjectListForFilterString(filter, this.iServer);
                if (objects != null) {
                    for (ISeriesHostObjectBasic object : objects) {
                        objectNames.add(String.valueOf(object.getName()) + "." + object.getType());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new BuildException(NLS.bind((String)Messages.ResolveAsterisk_LIBRARY_NAME_NOT_VALID_IN_SHIPLIST_FILE, (Object)this.libraryName));
        }
        return objectNames;
    }
}

