/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.packaging.toolkit.taskdefs;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.ant.task.ArtifactFilePublisherTask;
import com.ibm.teamp.ibmi.packaging.toolkit.taskdefs.Messages;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class PublishIBMiSavefilesTask
extends AbstractTeamBuildTask {
    private String fPackageDir = null;
    private String fBuildResultUUID = null;

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute("packageDir", this.fPackageDir, true));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute("buildResultUUID", this.fBuildResultUUID, true));
    }

    protected void doExecute() throws Exception {
        Project proj = this.getProject();
        if (this.fPackageDir == null) {
            this.fPackageDir = proj.getProperty("team.package.common.package.dir");
        }
        try {
            File pkgDir = new File(this.fPackageDir);
            String repositoryAddress = this.getRepositoryAddress();
            String userId = this.getUserId();
            boolean usePasswordFile = true;
            File passwordFile = this.getPasswordFile();
            String password = null;
            if (passwordFile == null) {
                password = this.getPassword();
                usePasswordFile = false;
            }
            File[] fileArray = pkgDir.listFiles(new SavefileFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String label = NLS.bind((String)Messages.PublishIBMiSavefilesTask_PACKAGE_SAVEFILE_LABEL, (Object)file.getName());
                if (this.getAuthenticationPolicy() != null) {
                    this.publishFile(file, label);
                } else if (usePasswordFile) {
                    this.publishFile(file, label, repositoryAddress, this.fBuildResultUUID, userId, passwordFile);
                } else {
                    this.publishFile(file, label, repositoryAddress, this.fBuildResultUUID, userId, password);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void publishFile(File file, String label) {
        this.log(NLS.bind((String)Messages.PublishIBMiSavefilesTask_SAVEFILE_WILL_BE_PUBLISHED_WITH_LABEL, (Object)file.getAbsolutePath(), (Object)label), 2);
        ArtifactFilePublisherTask jazzPublishTask = new ArtifactFilePublisherTask();
        jazzPublishTask.setFilePath(file);
        jazzPublishTask.setLabel(label);
        jazzPublishTask.setRepositoryAddress(this.getRepositoryAddress());
        jazzPublishTask.setBuildResultUUID(this.fBuildResultUUID);
        AbstractTeamBuildTask.AuthenticationPolicy policy = this.getAuthenticationPolicy();
        switch (policy) {
            case USERNAME_PASSWORD_POLICY: 
            case UNKNOWN: {
                jazzPublishTask.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.USERNAME_PASSWORD_POLICY);
                jazzPublishTask.setPasswordFile(this.getPasswordFile());
                jazzPublishTask.setUserId(this.getUserId());
                break;
            }
            case CERTIFICATE_FILE_POLICY: {
                jazzPublishTask.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.CERTIFICATE_FILE_POLICY);
                jazzPublishTask.setCertificateFile(this.getCertificateFile());
                jazzPublishTask.setPasswordFile(this.getPasswordFile());
                break;
            }
            case SMART_CARD_POLICY: {
                jazzPublishTask.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.SMART_CARD_POLICY);
                jazzPublishTask.setUserId(this.getUserId());
                break;
            }
            case KERBEROS_POLICY: {
                jazzPublishTask.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.KERBEROS_POLICY);
                jazzPublishTask.setUserId(this.getUserId());
                break;
            }
            case REGISTRY_POLICY: {
                jazzPublishTask.setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy.REGISTRY_POLICY);
                jazzPublishTask.setRepositoriesFile(this.getRepositoriesFile());
            }
        }
        jazzPublishTask.execute();
    }

    public void publishFile(File file, String label, String repo, String buildResultUUID, String userId, File passwordFile) {
        this.log(NLS.bind((String)Messages.PublishIBMiSavefilesTask_SAVEFILE_WILL_BE_PUBLISHED_WITH_LABEL, (Object)file.getAbsolutePath(), (Object)label), 2);
        ArtifactFilePublisherTask jazzPublishTask = new ArtifactFilePublisherTask();
        jazzPublishTask.setFilePath(file);
        jazzPublishTask.setLabel(label);
        jazzPublishTask.setRepositoryAddress(repo);
        jazzPublishTask.setUserId(userId);
        jazzPublishTask.setPasswordFile(passwordFile);
        jazzPublishTask.setBuildResultUUID(buildResultUUID);
        jazzPublishTask.execute();
    }

    public void publishFile(File file, String label, String repo, String buildResultUUID, String userId, String password) {
        this.log(NLS.bind((String)Messages.PublishIBMiSavefilesTask_SAVEFILE_WILL_BE_PUBLISHED_WITH_LABEL, (Object)file.getAbsolutePath(), (Object)label), 2);
        ArtifactFilePublisherTask jazzPublishTask = new ArtifactFilePublisherTask();
        jazzPublishTask.setFilePath(file);
        jazzPublishTask.setLabel(label);
        jazzPublishTask.setRepositoryAddress(repo);
        jazzPublishTask.setUserId(userId);
        jazzPublishTask.setPassword(password);
        jazzPublishTask.setBuildResultUUID(buildResultUUID);
        jazzPublishTask.execute();
    }

    public String getPackageDir() {
        return this.fPackageDir;
    }

    public void setPackageDir(String packageDir) {
        this.fPackageDir = packageDir;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.fBuildResultUUID = buildResultUUID;
    }

    public String getBuildResultUUID() {
        return this.fBuildResultUUID;
    }

    public class SavefileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return file.getName().toUpperCase().endsWith(".SAVF");
        }
    }
}

