/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.packaging.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.iant.IBMiLibraryValidator;
import com.ibm.teamp.ibmi.packaging.toolkit.taskdefs.IBMiPackageTask;
import com.ibm.teamp.ibmi.packaging.toolkit.taskdefs.Messages;
import java.io.BufferedReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public class IBMiShipList {
    private String filePath = null;
    private AS400 iServer = null;
    private IBMiPackageTask task = null;
    private Date baseTime = null;
    private boolean nextLineIsTimestamp = false;
    private int totalNumberOfObjects = 0;
    private Hashtable<String, Set<ISeriesHostObjectBasic>> include = new Hashtable();
    private Hashtable<String, Set<ISeriesHostObjectBasic>> exclude = new Hashtable();
    private Hashtable<String, Set<ISeriesHostObjectBasic>> shipFileSAVFObjects = new Hashtable();
    private Hashtable<String, Set<ISeriesHostObjectBasic>> hTable = this.include;

    public IBMiShipList(String filePath, AS400 server, IBMiPackageTask t) {
        this.filePath = filePath;
        this.iServer = server;
        this.task = t;
    }

    public void readShipFile() {
        IFSFile slf = new IFSFile(this.iServer, this.filePath);
        ISeriesHostObjectBasic o = new ISeriesHostObjectBasic();
        try {
            if (slf.exists()) {
                String line;
                BufferedReader in = new BufferedReader((Reader)new IFSFileReader(slf));
                while ((line = in.readLine()) != null) {
                    line = line.trim();
                    if (this.nextLineIsTimestamp) {
                        this.nextLineIsTimestamp = false;
                        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                        try {
                            if (line.length() != 14 || df.parse(line) == null) continue;
                            this.baseTime = df.parse(line);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (line.compareToIgnoreCase("Include:") == 0) {
                        this.hTable = this.include;
                        continue;
                    }
                    if (line.compareToIgnoreCase("Exclude:") == 0) {
                        this.hTable = this.exclude;
                        continue;
                    }
                    if (line.compareToIgnoreCase("Timestamp:") == 0) {
                        this.nextLineIsTimestamp = true;
                        continue;
                    }
                    if (line.length() == 0) break;
                    this.set(o, line);
                    if (!this.hTable.containsKey(o.getLibrary())) {
                        HashSet s = new HashSet();
                        this.hTable.put(o.getLibrary(), s);
                    }
                    String filter = new StringBuffer(o.getLibrary()).append("/").append(o.getName()).append(" OBJTYPE(").append(o.getType()).append(":").append("*").append(")").toString();
                    try {
                        List objects = IBMiShipList.getObjectListForFilterString(filter, this.iServer);
                        for (ISeriesHostObjectBasic o1 : objects) {
                            this.hTable.get(o.getLibrary()).add(o1);
                        }
                    }
                    catch (Exception objects) {
                        // empty catch block
                    }
                }
                Set<String> keys = this.include.keySet();
                this.shipFileSAVFObjects = (Hashtable)this.include.clone();
                for (String key : keys) {
                    Set<ISeriesHostObjectBasic> si = this.shipFileSAVFObjects.get(key);
                    Set<ISeriesHostObjectBasic> se = this.exclude.get(key);
                    this.task.log("(" + this.getClass().getSimpleName() + ") - Library: " + key, 3);
                    this.task.log("  Include(" + this.include.get(key).size() + "): " + this.include.get(key), 3);
                    this.task.log("  Exclude(" + (this.exclude.get(key) == null ? "--" : Integer.valueOf(this.exclude.get(key).size())) + "): " + this.exclude.get(key), 3);
                    if (si != null && se != null && si.size() > 0 && se.size() > 0) {
                        si.removeAll(se);
                    }
                    if (this.shipFileSAVFObjects.get(key) != null) {
                        this.totalNumberOfObjects += this.shipFileSAVFObjects.get(key).size();
                    }
                    this.task.log("  SAVFObj(" + (this.shipFileSAVFObjects.get(key) == null ? "--" : Integer.valueOf(this.shipFileSAVFObjects.get(key).size())) + "): " + this.shipFileSAVFObjects.get(key), 3);
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void set(ISeriesHostObjectBasic o, String fn) throws BuildException {
        String[] sa = fn.split("[/.]");
        if (sa.length >= 3) {
            String libraryName = sa[0];
            if (!libraryName.startsWith("\"")) {
                libraryName = libraryName.toUpperCase();
            }
            if (!IBMiLibraryValidator.isValidLibraryName((String)libraryName)) {
                throw new BuildException(NLS.bind((String)Messages.IBMiShipList_LIBRARY_NAME_NOT_VALID_IN_SHIPLIST, (Object)libraryName));
            }
            o.setLibrary(libraryName);
            String name = sa[1];
            if (!name.startsWith("\"")) {
                name = name.toUpperCase();
            }
            o.setName(name);
            o.setType(sa[2].toUpperCase());
            if (sa.length > 3 && sa[3] != null) {
                o.setSubType(sa[3].toUpperCase());
            } else {
                o.setSubType("*");
            }
        }
    }

    public Hashtable<String, Set<ISeriesHostObjectBasic>> getShipFileSAVFObjects() {
        return this.shipFileSAVFObjects;
    }

    public Date getBaseTime() {
        return this.baseTime;
    }

    public int getTotalNumberOfObjects() {
        return this.totalNumberOfObjects;
    }

    public static List getObjectListForFilterString(String filter, AS400 system) {
        ISeriesObjectFilterString filterString = new ISeriesObjectFilterString(filter);
        ISeriesListObjects listObjects = new ISeriesListObjects();
        listObjects.setSystem(system);
        List list = null;
        try {
            list = listObjects.getList((ISeriesAbstractFilterString)filterString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }
}

