/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.packaging.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.SaveFile;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.iant.IBMiLibraryValidator;
import com.ibm.iant.IBMiRemoteCommandUtils;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.IBMiRemoteCommand;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.packaging.toolkit.util.CheckPackagingVersions;
import com.ibm.teamp.ibmi.automation.toolkit.util.IBMiQSRSAV0;
import com.ibm.teamp.ibmi.automation.toolkit.util.IBMiUSRSPC;
import com.ibm.teamp.ibmi.packaging.toolkit.taskdefs.IBMiManifest;
import com.ibm.teamp.ibmi.packaging.toolkit.taskdefs.IBMiShipList;
import com.ibm.teamp.ibmi.packaging.toolkit.taskdefs.Messages;
import com.ibm.teamp.packaging.toolkit.ISeriesHostObjectBasicWithWorkItem;
import com.ibm.teamp.packaging.toolkit.ResolveAsterisk;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class IBMiPackageTask
extends AbstractIBMiCommandTask {
    private final Vector<IBMiRemoteCommand> beforeCommands = new Vector();
    private final Vector<IBMiRemoteCommand> afterCommands = new Vector();
    private String destinationFolder = null;
    private String intermediateSaveFileLibrary = null;
    private String shipListFile = null;
    private String restoreMappingPath = null;
    private String applicationName = null;
    private String applicationDescription = null;
    private String applicationVersion = null;
    private int isCompletePackage = -1;
    private String fullDestinationFolder = null;
    private Date timestamp = null;
    private Boolean isPreview = false;
    private boolean timestampAttributeUsed = false;
    private String savefileOptions = null;
    private String[] libraries = null;
    private String[] exclude = null;
    private String[] includeTags = null;
    private boolean pvtautOption = false;
    private final int YES = 1;
    private final int NO = 0;
    private final String SLASH = "/";
    private final String[] emptyStringArray = new String[0];
    private String beginTS = "";
    private final DateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
    private final Vector<String> savfVector = new Vector();
    private final Vector<IBMiQSRSAV0> apiVector = new Vector();
    private Vector<String> commandVector = new Vector();
    private IBMiManifest manifest = null;
    private Hashtable<String, Set<ISeriesHostObjectBasic>> objects2Save = new Hashtable();
    private static AS400 connection = null;

    public void execute() throws BuildException {
        this.manifest = new IBMiManifest(this);
        if (connection == null) {
            connection = this.getAS400();
        }
        this.updateTaskAttributesWithProperties();
        if (this.shipListFile != null && this.shipListFile.length() > 0) {
            if (CheckPackagingVersions.isDefinitionVersionGreaterThan30((Project)this.getProject())) {
                this.executeUsingBuildObjectXMLFile();
            } else {
                this.executeUsingBuildObjectListFile();
            }
        } else {
            this.executeUsingBuiltObjects();
        }
    }

    private void executeUsingBuildObjectXMLFile() throws BuildException {
        try {
            IFSFile shiplist = new IFSFile(connection, String.valueOf(this.fullDestinationFolder) + "/" + "filteredShiplist.xml");
            if (shiplist.exists()) {
                this.shipListFile = String.valueOf(this.fullDestinationFolder) + "/" + "filteredShiplist.xml";
            }
            this.readXMLshiplistFile();
            this.timestamp = this.getTimestampFromBuildRequest();
            this.performPackagingUsingShipListViaAPI();
            Manifest packageManifest = new Manifest();
            for (String containerName : this.objects2Save.keySet()) {
                Container manifestContainer = new Container();
                manifestContainer.setName(containerName);
                manifestContainer.setType("IBMiLibrary");
                for (ISeriesHostObjectBasic object : this.objects2Save.get(containerName)) {
                    Resource manifestResource = new Resource();
                    manifestResource.setName(object.getName());
                    manifestResource.setType("IBMiObject");
                    manifestResource.setLastModifiedTimestamp(Long.toString(object.getDateModified().getTime()));
                    manifestResource.setIbmiType(object.getType());
                    manifestResource.setIbmiAttrribute(object.getSubType());
                    if (object instanceof ISeriesHostObjectBasicWithWorkItem) {
                        manifestResource.setWorkitemUUID(((ISeriesHostObjectBasicWithWorkItem)object).getWorkItemUUID());
                        manifestResource.setWorkItemId(((ISeriesHostObjectBasicWithWorkItem)object).getWorkItemId());
                        manifestResource.setLanguageDefinitionName(((ISeriesHostObjectBasicWithWorkItem)object).getLanguageDefinitionName());
                        manifestResource.setLanguageDefinitionUUID(((ISeriesHostObjectBasicWithWorkItem)object).getLanguageDefinitionUUID());
                        manifestResource.setDeployType(((ISeriesHostObjectBasicWithWorkItem)object).getDeployType());
                        manifestResource.setVersionId(((ISeriesHostObjectBasicWithWorkItem)object).getVersionId());
                    }
                    manifestContainer.addResource(manifestResource);
                }
                packageManifest.addContainer(manifestContainer);
            }
            packageManifest.setType("MANIFEST_LIST");
            IFSFile packageManifestXMLFile = new IFSFile(connection, String.valueOf(this.fullDestinationFolder) + "/" + "packageManifest.xml");
            packageManifestXMLFile.createNewFile();
            IFSFileOutputStream packageManifestXMLStream = new IFSFileOutputStream(packageManifestXMLFile);
            ManifestWriter.getInstance().write((OutputStream)packageManifestXMLStream, packageManifest);
            packageManifestXMLStream.close();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void readXMLshiplistFile() throws BuildException {
        try {
            IFSFile shiplistXMLFile = new IFSFile(connection, this.shipListFile);
            IFSFileInputStream shiplistXMLStream = new IFSFileInputStream(shiplistXMLFile);
            Manifest shiplistManifest = ManifestReader.getInstance().getManifest((InputStream)shiplistXMLStream);
            List containers = shiplistManifest.getContainers();
            ResolveAsterisk asteriskResolver = new ResolveAsterisk(connection);
            for (Container container : containers) {
                if (container.getType().equals("IBMiLibrary")) {
                    List<String> containerNames = asteriskResolver.ResolveLibraryNames(container.getName());
                    if (containerNames.size() == 0) {
                        this.getProject().log(NLS.bind((String)Messages.IBMiPackageTask_CONTAINER_NAME_NOT_RESOLVED, (Object)container.getName()));
                    }
                    for (String libraryName : containerNames) {
                        if (IBMiLibraryValidator.isValidLibraryName((String)libraryName)) {
                            Set<Object> objectsForLibrary;
                            if (!this.objects2Save.containsKey(libraryName)) {
                                objectsForLibrary = new HashSet();
                                this.objects2Save.put(libraryName, objectsForLibrary);
                            } else {
                                objectsForLibrary = this.objects2Save.get(libraryName);
                            }
                            Iterator resourceIterator = container.getResourcesIterator();
                            while (resourceIterator.hasNext()) {
                                Resource resource = (Resource)resourceIterator.next();
                                if (resource.getType().equals("IBMiObject")) {
                                    asteriskResolver.setLibraryName(libraryName);
                                    List<ISeriesHostObjectBasic> resolvedObjects = asteriskResolver.ResolveObjectsInLibrary(new String[]{resource.getName(), resource.getIbmiType()});
                                    for (ISeriesHostObjectBasic object : resolvedObjects) {
                                        if (object.getName().equals(resource.getName()) && object.getType().equals(resource.getIbmiType())) {
                                            objectsForLibrary.add((Object)new ISeriesHostObjectBasicWithWorkItem(object, resource.getWorkItemId(), resource.getWorkitemUUID(), resource.getLanguageDefinitionName(), resource.getLanguageDefinitionUUID(), resource.getDeployType(), resource.getVersionId()));
                                            continue;
                                        }
                                        objectsForLibrary.add(object);
                                    }
                                    continue;
                                }
                                throw new BuildException(Messages.IBMiPackageTask_RESOURCE_TYPE_MUST_BE_IBMIOBJECT);
                            }
                            if (objectsForLibrary.size() >= 1) continue;
                            this.objects2Save.remove(libraryName);
                            continue;
                        }
                        throw new BuildException(NLS.bind((String)Messages.IBMiPackageTask_LIBRARY_NAME_NOT_VALID_IN_SHIPLIST, (Object)libraryName));
                    }
                    continue;
                }
                throw new BuildException(Messages.IBMiPackageTask_CONTAINER_TYPE_MUST_BE_IBMILIBRARY);
            }
            if (this.objects2Save.keySet().size() < 1) {
                throw new BuildException(Messages.IBMiPackageTask_NOTHING_TO_PACKAGE);
            }
            shiplistXMLStream.close();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void executeUsingBuildObjectListFile() {
        try {
            IFSFile objList = new IFSFile(connection, this.shipListFile);
            if (objList.exists()) {
                IBMiShipList sl = new IBMiShipList(this.shipListFile, connection, this);
                sl.readShipFile();
                this.objects2Save = sl.getShipFileSAVFObjects();
                this.timestamp = sl.getBaseTime() != null ? sl.getBaseTime() : this.getTimestampFromBuildRequest();
                if (sl.getTotalNumberOfObjects() == 0) {
                    throw new BuildException(NLS.bind((String)Messages.IBMiPackageTask_SHIPLIST_RESOLVED_TO_ZERO_OBJECTS, (Object)((Object)((Object)this)).getClass().getSimpleName()));
                }
                this.performPackagingUsingShipListViaAPI();
            } else {
                this.log((Task)this, NLS.bind((String)Messages.IBMiPackageTask_SHIPLIST_FILE_NOT_FOUND, (Object)this.shipListFile), 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeUsingBuiltObjects() {
        int commandErrors = 0;
        StringBuffer c = new StringBuffer("");
        if (this.libraries == null || this.libraries.length < 1 || this.intermediateSaveFileLibrary == null) {
            this.log((Task)this, Messages.IBMiPackageTask_MISSING_REQUIRED_ARGUMENTS, 0);
            return;
        }
        if (connection != null && connection.isConnected()) {
            try {
                SaveFile sf;
                IFSFile mfFolder;
                IFSFile libSAVF = new IFSFile(connection, String.valueOf(this.getBaseIFSPath(this.intermediateSaveFileLibrary)) + this.intermediateSaveFileLibrary + ".LIB");
                if (!libSAVF.exists()) {
                    this.beforeCommands.add(0, new IBMiRemoteCommand("CRTLIB LIB(" + this.intermediateSaveFileLibrary + ") TEXT('" + "Intermediate Save File Library for Packaging" + "')" + IAntTaskUtils.getCRTLIBASPArguments((String)this.getASPGroupName())));
                }
                if (!IBMiRemoteCommandUtils.executeIBMiRemoteCommands(this.beforeCommands, (String)"PRE ", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false)) {
                    ++commandErrors;
                }
                if (!(mfFolder = new IFSFile(connection, this.fullDestinationFolder)).exists()) {
                    mfFolder.mkdirs();
                }
                this.manifest.setiServer(connection);
                String[] stringArray = this.libraries;
                int n = this.libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    String l = stringArray[n2];
                    Vector<String> objExclude = new Vector<String>();
                    if (this.exclude != null && this.exclude.length > 0) {
                        String[] stringArray2 = this.exclude;
                        int n3 = this.exclude.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String s = stringArray2[n4];
                            objExclude.add(s);
                            ++n4;
                        }
                    }
                    sf = new SaveFile(connection, this.intermediateSaveFileLibrary, l);
                    sf.delete();
                    sf.create();
                    c = new StringBuffer("SAVLIB LIB(" + l + ") DEV(*SAVF) SAVF(" + this.intermediateSaveFileLibrary + "/" + l + ") " + this.savefileOptions);
                    if (this.includeTags != null && this.includeTags.length > 0) {
                        IFSFile ifsFile = new IFSFile(connection, String.valueOf(this.getBaseIFSPath(l)) + l + ".LIB");
                        IFSFile[] objects = ifsFile.listFiles();
                        String tag = "";
                        IFSFile[] iFSFileArray = objects;
                        int n5 = objects.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IFSFile f = iFSFileArray[n6];
                            tag = new ObjectDescription(connection, f.getPath()).getValueAsString(204);
                            String name = f.getName();
                            int lastDot = name.lastIndexOf(".");
                            boolean exclude = true;
                            String[] stringArray3 = this.includeTags;
                            int n7 = this.includeTags.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String t = stringArray3[n8];
                                if (tag.compareTo(t.trim()) == 0 && lastDot > 0) {
                                    exclude = false;
                                }
                                ++n8;
                            }
                            if (exclude) {
                                objExclude.add(String.valueOf(name.substring(0, lastDot)) + " *" + name.substring(lastDot + 1));
                            }
                            ++n6;
                        }
                    }
                    if (this.timestamp != null) {
                        IFSFile ifsFile = new IFSFile(connection, String.valueOf(this.getBaseIFSPath(l)) + l + ".LIB");
                        IFSFile[] objects = ifsFile.listFiles();
                        Date lastChangedDate = null;
                        IFSFile[] iFSFileArray = objects;
                        int n9 = objects.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            IFSFile f = iFSFileArray[n10];
                            long ts = f.lastModified();
                            lastChangedDate = new Date(ts);
                            String name = f.getName();
                            int lastDot = name.lastIndexOf(".");
                            if (lastChangedDate.before(this.timestamp)) {
                                objExclude.add(String.valueOf(name.substring(0, lastDot)) + " *" + name.substring(lastDot + 1));
                            }
                            ++n10;
                        }
                    }
                    if (objExclude != null && objExclude.size() > 0) {
                        if (objExclude.size() <= 300) {
                            c.append(" OMITOBJ(");
                            for (String filter : objExclude) {
                                c.append("(" + filter + ") ");
                            }
                            c.append(")");
                        } else {
                            IBMiUSRSPC usrspc = new IBMiUSRSPC();
                            usrspc.createUSRSPC(l, this.getBaseIFSPath(this.intermediateSaveFileLibrary), this.intermediateSaveFileLibrary, new HashSet(), objExclude, connection, this.savefileOptions, this.getPvtautOption());
                            c.append(" OMITOBJ(*USRSPC) CMDUSRSPC(" + this.intermediateSaveFileLibrary + "/" + l + ")");
                        }
                    }
                    this.savfVector.add(c.toString());
                    ++n2;
                }
                if (!IBMiRemoteCommandUtils.executeRemoteCommands(this.savfVector, (String)"SAVF", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false)) {
                    ++commandErrors;
                }
                this.commandVector = new Vector();
                int count = 0;
                String[] stringArray4 = this.libraries;
                int n11 = this.libraries.length;
                n = 0;
                while (n < n11) {
                    String l = stringArray4[n];
                    this.commandVector.add("CPY OBJ('" + this.getBaseIFSPath(this.intermediateSaveFileLibrary) + this.intermediateSaveFileLibrary + ".LIB" + "/" + l + ".FILE') TOOBJ('" + this.fullDestinationFolder + "/" + l + ".savf') replace(*YES)");
                    sf = new SaveFile(connection, this.intermediateSaveFileLibrary, l);
                    this.manifest.addSAVF(this.savfVector.get(count++), sf);
                    ++n;
                }
                if (this.restoreMappingPath != null && this.restoreMappingPath.length() > 0) {
                    if (CheckPackagingVersions.isDefinitionVersionGreaterThan30((Project)this.getProject())) {
                        this.commandVector.add("CPY OBJ('" + this.restoreMappingPath + "') TOOBJ('" + this.fullDestinationFolder + "/containerMapper.xml') replace(*YES)");
                    } else {
                        this.commandVector.add("CPY OBJ('" + this.restoreMappingPath + "') TOOBJ('" + this.fullDestinationFolder + "/map.mf') replace(*YES)");
                    }
                }
                if (!IBMiRemoteCommandUtils.executeRemoteCommands(this.commandVector, (String)"SAVF", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false)) {
                    ++commandErrors;
                }
                this.manifest.writeIt(this.fullDestinationFolder, "package.mf", "package.mf.lst");
                if (!IBMiRemoteCommandUtils.executeIBMiRemoteCommands(this.afterCommands, (String)"POST", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false)) {
                    ++commandErrors;
                }
            }
            catch (Exception e) {
                this.log(e.toString());
                throw new BuildException(NLS.bind((String)Messages.IBMiPackageTask_UNEXPECTED_ERROR_PACKAGING_OBJECTS, (Object)((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            }
            if (commandErrors > 0) {
                throw new BuildException(NLS.bind((String)Messages.IBMiPackageTask_AT_LEAST_ONE_TOOLBOX_CMD_RESULTED_IN_ERROR, (Object)((Object)((Object)this)).getClass().getSimpleName()));
            }
        } else {
            this.log((Task)this, Messages.IBMiPackageTask_NO_IBMI_CONNECTION_AVAILABLE, 0);
        }
    }

    public IBMiRemoteCommand createPost() {
        IBMiRemoteCommand c = new IBMiRemoteCommand();
        this.afterCommands.add(c);
        return c;
    }

    public IBMiRemoteCommand createPre() {
        IBMiRemoteCommand c = new IBMiRemoteCommand();
        this.beforeCommands.add(c);
        return c;
    }

    public void setApplicationName(String applicationName) {
        if (applicationName != null && applicationName.length() > 0) {
            this.applicationName = applicationName;
        }
    }

    public void setApplicationDescription(String applicationDescription) {
        if (applicationDescription != null && applicationDescription.length() > 0) {
            this.applicationDescription = applicationDescription;
        }
    }

    public void setisCompletePackage(String isCompletePackage) {
        if (isCompletePackage != null && isCompletePackage.length() > 0) {
            this.isCompletePackage = isCompletePackage.compareToIgnoreCase("true") == 0 ? 1 : 0;
        }
    }

    public void setApplicationVersion(String applicationVersion) {
        if (applicationVersion != null && applicationVersion.length() > 0) {
            this.applicationVersion = applicationVersion;
        }
    }

    public void setDestinationFolder(String destinationFolder) {
        if (destinationFolder != null && destinationFolder.length() > 0) {
            this.destinationFolder = destinationFolder;
        }
    }

    public void setHostCredentials(String hc) {
        String[] credentials = hc.split("[:\\s]");
        if (credentials.length == 3) {
            try {
                connection = new AS400(credentials[0], credentials[1], credentials[2]);
                connection.setGuiAvailable(false);
                connection.connectService(2);
            }
            catch (Exception e) {
                throw new BuildException(Messages.IBMiPackageTask_FAILED_TO_CONNECT_TO_IBMI_WITH_CREDENTIALS, (Throwable)e);
            }
        }
    }

    public void setExclude(String objects) {
        this.exclude = objects.trim().length() > 0 ? objects.trim().split("[,]") : this.emptyStringArray;
    }

    public void setLibraries(String libs) {
        if (libs.trim().length() > 0) {
            this.libraries = libs.split("[,]");
            HashSet<String> set = new HashSet<String>();
            String[] stringArray = this.libraries;
            int n = this.libraries.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                if (!l.startsWith("\"")) {
                    l = l.toUpperCase();
                }
                set.add(l);
                ++n2;
            }
            this.libraries = set.toArray(new String[set.size()]);
        } else {
            this.libraries = this.emptyStringArray;
        }
    }

    public void setObjectListFile(String objectListFile) {
        if (objectListFile != null && objectListFile.length() > 0) {
            this.shipListFile = objectListFile;
        }
    }

    public void setsavefileOptions(String savefileOptions) {
        if (savefileOptions != null && savefileOptions.length() > 0) {
            this.savefileOptions = savefileOptions;
        }
    }

    public void setShipListFile(String shipListFile) {
        this.shipListFile = shipListFile;
    }

    public void setIntermediateSaveFileLibrary(String lib) {
        this.intermediateSaveFileLibrary = lib.trim();
        if (!this.intermediateSaveFileLibrary.startsWith("\"")) {
            this.intermediateSaveFileLibrary = this.intermediateSaveFileLibrary.toUpperCase();
        }
    }

    public void setIncludeTags(String tags) {
        this.includeTags = tags.trim().length() > 0 ? tags.split("[,]") : this.emptyStringArray;
    }

    public void setTimestamp(String timestamp) {
        timestamp = timestamp.trim();
        this.timestampAttributeUsed = true;
        try {
            if (timestamp.length() == 14 && this.df.parse(timestamp) != null) {
                this.timestamp = this.df.parse(timestamp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Date getTimestampFromBuildRequest() {
        Date baseTimestamp = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = this.computeInitialStringValue("team.package.common.packageBinariesSinceTimestamp", "");
        if (timestamp == null || timestamp == "") {
            return baseTimestamp;
        }
        try {
            if (timestamp.indexOf("-") > 0) {
                timestamp = String.valueOf(timestamp.substring(0, 8)) + timestamp.substring(9, 15);
            }
            baseTimestamp = df.parse(timestamp);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.log((Task)this, NLS.bind((String)Messages.IBMiPackageTask_PACKAGING_OBJECTS_NEWER_THAN_TIMESTAMP, (Object)baseTimestamp.toString()), 0);
        return baseTimestamp;
    }

    private void updateTaskAttributesWithProperties() {
        String fd;
        if (this.destinationFolder == null) {
            this.destinationFolder = this.computeInitialStringValue("team.package.ibmi.destinationBaseFolder", "/QIBM/UserData/rtcp/V3.0/Packages");
        }
        if (this.applicationDescription == null) {
            this.applicationDescription = this.computeInitialStringValue("team.package.common.applicationDescription", "");
        }
        if (this.shipListFile == null) {
            this.shipListFile = this.computeInitialStringValue("team.package.common.shiplistFilePath", "");
        }
        if (this.savefileOptions == null) {
            this.savefileOptions = this.computeInitialStringValue("team.package.ibmi.savefileOptions", "");
        }
        if (this.applicationName == null) {
            this.applicationName = this.computeInitialStringValue("team.package.common.applicationName", "");
        }
        if (this.applicationVersion == null) {
            this.applicationVersion = this.computeInitialStringValue("team.package.common.version", "");
        }
        if (this.isCompletePackage == -1) {
            String p = this.getProject().getProperty("team.package.common.isCompletePackage");
            int n = this.isCompletePackage = p != null && p.compareToIgnoreCase("true") == 0 ? 1 : 0;
        }
        if (this.isCompletePackage != 1) {
            this.beginTS = new SimpleDateFormat("yyyyMMddhhmmss").format(System.currentTimeMillis());
        }
        if ((fd = this.getProject().getProperty("team.package.common.package.dir")) != null && fd.length() > 0) {
            this.fullDestinationFolder = fd;
        } else {
            this.fullDestinationFolder = String.valueOf(this.destinationFolder) + "/" + this.applicationName + "/" + this.applicationVersion + (this.beginTS.length() < 1 ? "" : "/V" + this.beginTS);
            this.getProject().setProperty("team.package.common.package.dir.last", this.fullDestinationFolder);
        }
        if (this.restoreMappingPath == null) {
            this.restoreMappingPath = this.computeInitialStringValue("team.package.common.restoreMappingPath", "");
        }
        if (this.intermediateSaveFileLibrary == null) {
            this.intermediateSaveFileLibrary = this.computeInitialStringValue("team.package.ibmi.intermediateSavefileLibrary", "");
            if (!this.intermediateSaveFileLibrary.startsWith("\"")) {
                this.intermediateSaveFileLibrary = this.intermediateSaveFileLibrary.toUpperCase();
            }
        }
        String s = null;
        if (this.libraries == null) {
            s = this.computeInitialStringValue("team.package.ibmi.libraries", "");
            this.setLibraries(s);
        }
        if (this.exclude == null) {
            s = this.computeInitialStringValue("team.package.ibmi.exclude.filters", "");
            this.setExclude(s);
        }
        if (this.includeTags == null) {
            s = this.computeInitialStringValue("team.package.ibmi.include.tagIDs", "");
            this.setIncludeTags(s);
        }
        if (!this.timestampAttributeUsed) {
            s = this.computeInitialStringValue("team.package.ibmi.include.timestamp", "");
            this.setTimestamp(s);
        }
        this.pvtautOption = Boolean.parseBoolean(this.getProject().getProperty("team.package.ibmi.pvtautOption"));
    }

    private void performPackagingUsingShipListViaAPI() {
        int commandErrors = 0;
        int objectCount = 0;
        if (connection != null && connection.isConnected()) {
            try {
                SaveFile sf;
                IFSFile mfFolder;
                IFSFile libSAVF = new IFSFile(connection, String.valueOf(this.getBaseIFSPath(this.intermediateSaveFileLibrary)) + this.intermediateSaveFileLibrary + ".LIB");
                if (!libSAVF.exists()) {
                    this.beforeCommands.add(0, new IBMiRemoteCommand("CRTLIB LIB(" + this.intermediateSaveFileLibrary + ") TEXT('" + "Intermediate Save File Library for Packaging" + "')" + IAntTaskUtils.getCRTLIBASPArguments((String)this.getASPGroupName())));
                }
                if (!IBMiRemoteCommandUtils.executeIBMiRemoteCommands(this.beforeCommands, (String)"PRE ", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false)) {
                    ++commandErrors;
                }
                if (!(mfFolder = new IFSFile(connection, this.fullDestinationFolder)).exists()) {
                    mfFolder.mkdirs();
                }
                this.manifest.setiServer(connection);
                Set<String> keys = this.objects2Save.keySet();
                HashSet<String> keysToOmit = new HashSet<String>();
                this.log("QSRSAVO API: " + (this.getPvtautOption() ? "PVTAUT(*YES)" : "PVTAUT(*NO)"));
                for (String l : keys) {
                    Vector<String> objExclude = new Vector<String>();
                    if (this.exclude != null && this.exclude.length > 0) {
                        String[] stringArray = this.exclude;
                        int n = this.exclude.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            objExclude.add(s);
                            ++n2;
                        }
                    }
                    sf = new SaveFile(connection, this.intermediateSaveFileLibrary, l);
                    sf.delete();
                    sf.create();
                    Set<ISeriesHostObjectBasic> objects = this.objects2Save.get(l);
                    HashSet<ISeriesHostObjectBasic> excludeSet = new HashSet<ISeriesHostObjectBasic>();
                    if (this.includeTags != null && this.includeTags.length > 0) {
                        IFSFile f = null;
                        String ifsLib = l.compareToIgnoreCase("qsys") == 0 ? "/QSYS.LIB" : String.valueOf(this.getBaseIFSPath(l)) + l + ".LIB";
                        String tag = "";
                        for (ISeriesHostObjectBasic o : objects) {
                            String type = o.getType();
                            if (type.startsWith("*")) {
                                type = type.substring(1);
                            }
                            f = new IFSFile(connection, ifsLib, String.valueOf(o.getName()) + "." + type);
                            tag = new ObjectDescription(connection, f.getPath()).getValueAsString(204);
                            String name = f.getName();
                            int lastDot = name.lastIndexOf(".");
                            boolean exclude = true;
                            String[] stringArray = this.includeTags;
                            int n = this.includeTags.length;
                            int n3 = 0;
                            while (n3 < n) {
                                String t = stringArray[n3];
                                if (tag.compareTo(t.trim()) == 0 && lastDot > 0) {
                                    exclude = false;
                                }
                                ++n3;
                            }
                            if (!exclude) continue;
                            excludeSet.add(o);
                        }
                        objects.removeAll(excludeSet);
                    }
                    if (this.timestamp != null) {
                        excludeSet = new HashSet();
                        for (ISeriesHostObjectBasic o : objects) {
                            if (!o.getDateModified().before(this.timestamp)) continue;
                            excludeSet.add(o);
                        }
                        objects.removeAll(excludeSet);
                    }
                    if (objects.size() == 0) {
                        keysToOmit.add(l);
                        continue;
                    }
                    IBMiUSRSPC usrspc = new IBMiUSRSPC();
                    usrspc.createUSRSPC(l, this.getBaseIFSPath(this.intermediateSaveFileLibrary), this.intermediateSaveFileLibrary, objects, objExclude, connection, this.savefileOptions, this.getPvtautOption());
                    this.apiVector.add(new IBMiQSRSAV0(connection, l, this.intermediateSaveFileLibrary, objects.size()));
                }
                keys.removeAll(keysToOmit);
                if (!this.getIsPreview().booleanValue()) {
                    for (IBMiQSRSAV0 api : this.apiVector) {
                        objectCount += api.runAPI(false, (AbstractIBMiCommandTask)this, connection, this.intermediateSaveFileLibrary);
                    }
                }
                this.commandVector = new Vector();
                int count = 0;
                for (String l : keys) {
                    this.commandVector.add("CPY OBJ('" + this.getBaseIFSPath(this.intermediateSaveFileLibrary) + this.intermediateSaveFileLibrary + ".LIB" + "/" + l + ".FILE') TOOBJ('" + this.fullDestinationFolder + "/" + l + ".savf') replace(*YES)");
                    sf = new SaveFile(connection, this.intermediateSaveFileLibrary, l);
                    this.manifest.addSAVF(this.apiVector.get(count++).getCommand(), sf);
                }
                if (this.restoreMappingPath != null && this.restoreMappingPath.length() > 0) {
                    if (CheckPackagingVersions.isDefinitionVersionGreaterThan30((Project)this.getProject())) {
                        this.commandVector.add("CPY OBJ('" + this.restoreMappingPath + "') TOOBJ('" + this.fullDestinationFolder + "/containerMapper.xml') replace(*YES)");
                    } else {
                        this.commandVector.add("CPY OBJ('" + this.restoreMappingPath + "') TOOBJ('" + this.fullDestinationFolder + "/map.mf') replace(*YES)");
                    }
                }
                if (!this.getIsPreview().booleanValue()) {
                    if (!IBMiRemoteCommandUtils.executeRemoteCommands(this.commandVector, (String)"IFS ", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false)) {
                        ++commandErrors;
                    } else {
                        this.deleteTempSaveFiles(keys);
                        this.deleteTempUserSpaces(keys);
                    }
                }
                if (!CheckPackagingVersions.isDefinitionVersionGreaterThan30((Project)this.getProject())) {
                    this.manifest.writeIt(this.fullDestinationFolder, "package.mf", "package.mf.lst");
                }
                if (!IBMiRemoteCommandUtils.executeIBMiRemoteCommands(this.afterCommands, (String)"POST", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false)) {
                    ++commandErrors;
                }
            }
            catch (Exception e) {
                this.log(e.toString());
                throw new BuildException(NLS.bind((String)Messages.IBMiPackageTask_UNEXPECTED_ERROR_PACKAGING_OBJECTS, (Object)((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            }
            if (objectCount == 0 && !this.getIsPreview().booleanValue()) {
                throw new BuildException(Messages.IBMiPackageTask_NOTHING_TO_PACKAGE);
            }
            if (commandErrors > 0) {
                throw new BuildException(NLS.bind((String)Messages.IBMiPackageTask_AT_LEAST_ONE_TOOLBOX_CMD_RESULTED_IN_ERROR, (Object)((Object)((Object)this)).getClass().getSimpleName()));
            }
        } else {
            this.log((Task)this, Messages.IBMiPackageTask_NO_IBMI_CONNECTION_AVAILABLE, 0);
        }
    }

    private String computeInitialStringValue(String propertyName, String defaultValue) {
        String p = this.getProject().getProperty(propertyName);
        return p != null && p.length() > 0 ? p : defaultValue;
    }

    private void deleteTempSaveFiles(Set<String> keys) {
        Vector<String> dltfCommandVector = new Vector<String>();
        for (String l : keys) {
            dltfCommandVector.add("DLTF FILE(" + this.intermediateSaveFileLibrary + "/" + l + ")");
        }
        try {
            if (!IBMiRemoteCommandUtils.executeRemoteCommands(dltfCommandVector, (String)"DLTF", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false)) {
                this.log((Task)this, Messages.IBMiPackageTask_ERROR_ON_TEMP_SAVF_CLEANUP, 1);
            }
        }
        catch (Exception e) {
            this.log((Task)this, Messages.IBMiPackageTask_ERROR_ON_TEMP_SAVF_CLEANUP, e, 1);
        }
    }

    private void deleteTempUserSpaces(Set<String> keys) {
        Vector<String> dltUsrspcCommandVector = new Vector<String>();
        for (String l : keys) {
            dltUsrspcCommandVector.add("DLTUSRSPC USRSPC(" + this.intermediateSaveFileLibrary + "/" + l + ")");
        }
        try {
            if (!IBMiRemoteCommandUtils.executeRemoteCommands(dltUsrspcCommandVector, (String)"DLTUSRSPC", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false)) {
                this.log((Task)this, Messages.IBMiPackageTask_ERROR_ON_TEMP_SAVF_CLEANUP, 1);
            }
        }
        catch (Exception e) {
            this.log((Task)this, Messages.IBMiPackageTask_ERROR_ON_TEMP_SAVF_CLEANUP, e, 1);
        }
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public String getIntermediateSaveFileLibrary() {
        return this.intermediateSaveFileLibrary;
    }

    public String getShipListFile() {
        return this.shipListFile;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationDescription() {
        return this.applicationDescription;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public int getIsCompletePackage() {
        return this.isCompletePackage;
    }

    public String getFullDestinationFolder() {
        return this.fullDestinationFolder;
    }

    public String getsavefileOptions() {
        return this.savefileOptions;
    }

    public void setIsPreviewString(String isPreviewString) {
        this.isPreview = Boolean.parseBoolean(isPreviewString);
    }

    public Boolean getIsPreview() {
        return this.isPreview;
    }

    public String[] getIncludeTags() {
        return this.includeTags;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    private boolean getPvtautOption() {
        return this.pvtautOption;
    }

    private void log(Task t, String s, int type) {
        this.log(t, s, null, type);
    }

    private void log(Task t, String s, Exception ex, int type) {
        try {
            Thread.sleep(1L);
            t.log(s, (Throwable)ex, type);
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

