/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.packaging.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileWriter;
import com.ibm.as400.access.SaveFile;
import com.ibm.as400.access.SaveFileEntry;
import com.ibm.teamp.ibmi.packaging.toolkit.taskdefs.IBMiPackageTask;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Vector;

public class IBMiManifest {
    private IBMiPackageTask task = null;
    private final String SLASH = "/";
    private AS400 iServer = null;
    private Vector<CompositeSAVF> savfVector = new Vector();

    public IBMiManifest(IBMiPackageTask t) {
        this.task = t;
    }

    public void addSAVF(String command, SaveFile sf) {
        this.savfVector.add(new CompositeSAVF(command, sf));
    }

    public boolean writeIt(String fullDestinationFolder, String manifestFileName, String manifestListFileName) {
        boolean success = true;
        IFSFile mf = new IFSFile(this.iServer, String.valueOf(fullDestinationFolder) + "/" + manifestFileName);
        IFSFile mfl = new IFSFile(this.iServer, String.valueOf(fullDestinationFolder) + "/" + manifestListFileName);
        IFSFile mfFolder = new IFSFile(this.iServer, fullDestinationFolder);
        try {
            if (!mfFolder.exists()) {
                mfFolder.mkdirs();
            }
            if (mf.exists()) {
                mf.delete();
            }
            mf.createNewFile();
            mf.setCCSID(1208);
            PrintWriter writer = new PrintWriter(new BufferedWriter((Writer)new IFSFileWriter(mf)));
            mfl.createNewFile();
            mf.setCCSID(1208);
            PrintWriter writerl = new PrintWriter(new BufferedWriter((Writer)new IFSFileWriter(mfl)));
            int rel = this.iServer.getVRM();
            writer.println("Connection-information: IBM i Toolbox");
            writer.println("  Server-name: " + this.iServer.getSystemName());
            writer.println("  Release: V" + (rel >> 16) + "R" + (rel >> 8 & 0xFF) + "M" + (rel & 0xFF));
            writer.println("  CCSID: " + this.iServer.getJobCCSIDEncoding());
            writer.println("  User ID: " + this.iServer.getUserId());
            writer.println("key-Ant-attributes-used-by-task: IBMiPackageTask");
            writer.println("  applicationName: " + this.task.getApplicationName());
            writer.println("  applicationDescription: " + this.task.getApplicationDescription());
            writer.println("  applicationVersion: " + this.task.getApplicationVersion());
            writer.println("  isCompletePackage: " + (1 == this.task.getIsCompletePackage() ? "YES" : "NO"));
            writer.println("  shipListFile: " + this.task.getShipListFile());
            writer.println("  destinationFolder: " + this.task.getDestinationFolder());
            writer.println("  intermediateSaveFileLibrary: " + this.task.getIntermediateSaveFileLibrary());
            writer.println("  saveCommandOptions: " + this.task.getsavefileOptions());
            writer.print("  includeTimestamp: ");
            if (this.task.getTimestamp() != null) {
                writer.print(this.task.getTimestamp().toString());
            }
            writer.println();
            writer.print("  includeTags: ");
            String[] tags = this.task.getIncludeTags();
            if (tags != null) {
                String[] stringArray = tags;
                int n = tags.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    writer.print("[" + s + "]");
                    ++n2;
                }
            }
            writer.println();
            writer.println("Bundle-NumberOfOutputLibraries: " + this.savfVector.size());
            int count = 0;
            DecimalFormat df5 = new DecimalFormat("00000");
            DecimalFormat df3 = new DecimalFormat("000");
            for (CompositeSAVF sf : this.savfVector) {
                SaveFile f = sf.getSavf();
                writer.println("SAVF-" + df3.format(count) + "-file: " + f.getPath());
                writer.println("  SAVF-" + df3.format(count) + "-command: " + sf.getCreationCommand());
                SaveFileEntry[] o = f.listEntries();
                writer.println("  SAVF-" + df3.format(count) + "-objectCount: " + o.length);
                int i = 1;
                SaveFileEntry[] saveFileEntryArray = o;
                int n = o.length;
                int n3 = 0;
                while (n3 < n) {
                    SaveFileEntry sfe = saveFileEntryArray[n3];
                    writer.println("    SAVF-" + df3.format(count) + "-object[" + df5.format(i++) + "]: " + sfe.getLibrary() + "/" + sfe.getName() + "." + sfe.getType());
                    writerl.println(String.valueOf(sfe.getLibrary()) + "/" + sfe.getName() + "." + sfe.getType());
                    ++n3;
                }
                ++count;
            }
            writer.flush();
            writerl.flush();
            writer.close();
            writerl.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public void setiServer(AS400 iServer) {
        this.iServer = iServer;
    }

    public class CompositeSAVF {
        private String creationCommand = "";
        private SaveFile savf = null;

        public CompositeSAVF() {
        }

        public CompositeSAVF(String c, SaveFile sf) {
            this.creationCommand = c;
            this.savf = sf;
        }

        public String getCreationCommand() {
            return this.creationCommand;
        }

        public SaveFile getSavf() {
            return this.savf;
        }
    }
}

