/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.packaging.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.team.enterprise.packaging.toolkit.util.CheckPackagingVersions;
import com.ibm.teamp.ibmi.packaging.toolkit.taskdefs.Messages;
import com.ibm.teamp.packaging.toolkit.FilterXMLShipList;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class FilterXMLShipListTask
extends AbstractIBMiCommandTask {
    String localDir;
    private static AS400 connection = null;

    public void execute() throws BuildException {
        Project proj;
        if (connection == null) {
            connection = this.getAS400();
        }
        if (CheckPackagingVersions.isDefinitionVersionGreaterThan30((Project)(proj = this.getProject()))) {
            String wiShipListPath = proj.getProperty("team.package.common.workItemFilePath");
            String shipListPath = wiShipListPath != null && wiShipListPath.length() > 0 ? wiShipListPath : proj.getProperty("team.package.common.shiplistFilePath");
            String excludeListPath = proj.getProperty("team.package.common.excludeFilePath");
            File shipListFile = new File(shipListPath);
            if (!shipListFile.exists()) {
                throw new BuildException(Messages.FilterXMLShipListTask_SHIPLIST_DOES_NOT_EXIST);
            }
            if (excludeListPath != null && !"".equals(excludeListPath)) {
                File excludeFile = new File(excludeListPath);
                if (!excludeFile.exists()) {
                    throw new BuildException(NLS.bind((String)Messages.FilterXMLShipListTask_EXCLUDE_FILE_DOES_NOT_EXIST, (Object)excludeListPath));
                }
                try {
                    String isZOSString = proj.getProperty("isZOSFileSystem");
                    boolean isZOS = false;
                    if (isZOSString != null) {
                        isZOS = Boolean.parseBoolean(isZOSString);
                    }
                    new FilterXMLShipList(shipListPath, excludeListPath, String.valueOf(this.localDir) + "/filteredShiplist.xml", connection, isZOS);
                }
                catch (Exception e) {
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void setLocalDir(String localDir) {
        this.localDir = localDir;
    }
}

