/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.deployment.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.comm.QSYSCheckUserAuthority;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.DLTOBJTask;
import com.ibm.teamp.deployment.toolkit.taskdefs.Messages;
import com.ibm.teamp.ibmi.automation.toolkit.IBMiObjectValidater;
import com.ibm.teamp.ibmi.automation.toolkit.ManifestObjectParser;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public class RollbackDeleteObjectTask
extends AbstractIBMiCommandTask {
    private String manifestFileDirectory;
    private String libraryMapping;
    private String _systemref;

    public void execute() {
        try {
            ManifestObjectParser manifestDeleteObjectParser = new ManifestObjectParser();
            AS400 as400 = this.getAS400();
            List deleteObjects = manifestDeleteObjectParser.getIBMiObjectsFromManifestFile(as400, String.valueOf(this.manifestFileDirectory) + '/' + "package.mf.lst");
            IBMiObjectValidater objectValidator = new IBMiObjectValidater(as400, deleteObjects);
            List existingObjects = objectValidator.getExistingObjects();
            for (ManifestObjectParser.IBMiObject ibmiObject : existingObjects) {
                QSYSCheckUserAuthority checkUserAuthority = new QSYSCheckUserAuthority(as400, as400.getUserId(), ibmiObject.getLibrary(), ibmiObject.getObjectName(), ibmiObject.getObjectType());
                if (!checkUserAuthority.canWrite()) {
                    throw new BuildException(NLS.bind((String)Messages.RollbackDeleteObjectTask_NO_PERMISSIONS_TO_DELETE_OBJECT, (Object)(String.valueOf(ibmiObject.getLibrary()) + '/' + ibmiObject.getObjectName() + '.' + ibmiObject.getObjectType())));
                }
                DLTOBJTask deleteTask = new DLTOBJTask();
                deleteTask.setLibrary(ibmiObject.getLibrary());
                deleteTask.setObject(ibmiObject.getObjectName());
                deleteTask.setObjecttype(ibmiObject.getObjectType());
                deleteTask.setProject(this.getProject());
                deleteTask.setSystemref(this._systemref);
                deleteTask.execute();
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setManifestFileDirectory(String manifestFileDirectory) {
        this.manifestFileDirectory = manifestFileDirectory;
    }

    public void setLibraryMapping(String libraryMapping) {
        this.libraryMapping = libraryMapping;
    }

    public void setSystemref(String systemref) {
        this._systemref = systemref;
    }
}

