/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.deployment.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.teamp.deployment.toolkit.taskdefs.AbstractIBMiBuildTask;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class RecordLoadedPackageTask
extends AbstractIBMiBuildTask {
    private AS400 connection;
    private String localPackageDir;

    public void execute() throws BuildException {
        if (this.connection == null) {
            this.connection = this.getAS400();
        }
        Project proj = this.getProject();
        if (this.localPackageDir == null) {
            this.localPackageDir = proj.getProperty("team.deploy.common.localPackageRoot.dir");
        }
        IBuildResultContribution summaryContribution = BuildItemFactory.createBuildResultContribution();
        summaryContribution.setLabel(proj.getProperty("team.deploy.common.filesystem"));
        summaryContribution.setExtendedContributionTypeId(AutomationResultContribution.LOAD_OVERVIEW_EXTENDED_CONTRIBUTION_ID);
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME, proj.getProperty("team.deploy.common.applicationName"));
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION, proj.getProperty("team.deploy.common.version"));
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION, proj.getProperty("team.deploy.common.applicationDescription"));
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME, "Unknown");
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, this.localPackageDir);
        String timestamp = this.localPackageDir.substring(this.localPackageDir.lastIndexOf(File.separator) + 2);
        summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, timestamp);
        try {
            ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository()).addBuildResultContribution((IBuildResultHandle)this.getBuildResult(), summaryContribution, this.getProgressMonitor());
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setLocalPackageDir(String dir) {
        this.localPackageDir = dir;
    }
}

