/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.deployment.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.teamp.deployment.toolkit.taskdefs.AbstractIBMiBuildTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class RecordDeployedObjectsTask
extends AbstractIBMiBuildTask {
    private AS400 connection;
    private String localPackageDir;
    private boolean isDeployment;

    public void execute() throws BuildException {
        block15: {
            if (this.connection == null) {
                this.connection = this.getAS400();
            }
            Project proj = this.getProject();
            if (this.localPackageDir == null) {
                this.localPackageDir = proj.getProperty("team.deploy.common.localPackageRoot.dir");
            }
            String packageManifestFileList = String.valueOf(this.localPackageDir) + "/" + "package.mf" + ".lst";
            if (this.connection != null) {
                ArrayList<IBuildResultContribution> contributions = new ArrayList<IBuildResultContribution>();
                try {
                    IFSFile mf = new IFSFile(this.connection, packageManifestFileList);
                    if (!mf.exists()) break block15;
                    String mfLine = null;
                    try (BufferedReader reader = new BufferedReader((Reader)new IFSFileReader(mf));){
                        IBuildResultContribution summaryContribution = BuildItemFactory.createBuildResultContribution();
                        if (this.isDeployment) {
                            summaryContribution.setLabel(proj.getProperty("team.deploy.common.filesystem"));
                            summaryContribution.setExtendedContributionTypeId(AutomationResultContribution.DEPLOYMENT_OVERVIEW_EXTENDED_CONTRIBUTION_ID);
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME, proj.getProperty("team.deploy.common.applicationName"));
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION, proj.getProperty("team.deploy.common.version"));
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION, proj.getProperty("team.deploy.common.applicationDescription"));
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME, "Unknown");
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, this.localPackageDir);
                            if (Boolean.parseBoolean(proj.getProperty("team.deploy.common.isCompletePackage"))) {
                                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, proj.getProperty("team.deploy.common.newDeployTimeStamp"));
                            } else {
                                summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, proj.getProperty("team.deploy.common.newUpdateDeployTimeStamp"));
                            }
                            proj.log(summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP));
                        } else {
                            summaryContribution.setLabel(proj.getProperty("team.package.common.filesystem"));
                            summaryContribution.setExtendedContributionTypeId(AutomationResultContribution.PACKAGING_OVERVIEW_EXTENDED_CONTRIBUTION_ID);
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME, proj.getProperty("team.package.common.applicationName"));
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION, proj.getProperty("team.package.common.version"));
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION, proj.getProperty("team.package.common.applicationDescription"));
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME, "Unknown");
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR, this.localPackageDir);
                            String timestamp = this.localPackageDir.substring(this.localPackageDir.lastIndexOf(File.separator) + 2);
                            summaryContribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP, timestamp);
                            proj.log(timestamp);
                        }
                        contributions.add(summaryContribution);
                        while ((mfLine = reader.readLine()) != null) {
                            IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
                            if (this.isDeployment) {
                                contribution.setExtendedContributionTypeId(AutomationResultContribution.DEPLOYED_OBJECT_EXTENDED_CONTRIBUTION_ID);
                            } else {
                                contribution.setExtendedContributionTypeId(AutomationResultContribution.PACKAGED_OBJECT_EXTENDED_CONTRIBUTION_ID);
                            }
                            contribution.setLabel(mfLine);
                            contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTTYPE, " ");
                            contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_CONTAINER, " ");
                            contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_OBJECTSUBTYPE, " ");
                            contribution.setExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_LAST_MODIFIED, " ");
                            contributions.add(contribution);
                        }
                        ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository()).addBuildResultContributions((IBuildResultHandle)this.getBuildResult(), contributions.toArray(new IBuildResultContribution[contributions.size()]), this.getProgressMonitor());
                    }
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    public void setLocalPackageDir(String dir) {
        this.localPackageDir = dir;
    }

    public void setObjectType(String type) {
        this.isDeployment = type.equals("deployObject");
    }
}

