/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.deployment.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.iant.IBMiRemoteCommandUtils;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.CRTLIBTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.taskdefs.GenerateDeployStatusTask;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.teamp.deployment.toolkit.taskdefs.Messages;
import com.ibm.teamp.deployment.toolkit.util.IBMiDeleteObjectCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class IBMiUninstallTask
extends AbstractIBMiCommandTask {
    private final String SLASH = "/";
    private AS400 connection;
    private String intermediateSaveFileLibrary;
    private String rollbackDir;
    private String deployStatusFile;
    private String cumulativeDeployXML;
    private final Vector<String> rollbackCmds = new Vector();
    private boolean pvtautOption = false;

    public String getRollbackDir() {
        return this.rollbackDir;
    }

    public void setRollbackDir(String rollbackDir) {
        this.rollbackDir = rollbackDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        Project proj = this.getProject();
        if (!CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj)) {
            return;
        }
        if (this.connection == null) {
            this.connection = this.getAS400();
        }
        if (this.deployStatusFile == null) {
            this.deployStatusFile = proj.getProperty("team.deploy.common.deployStatusFile");
        }
        if (this.cumulativeDeployXML == null) {
            this.cumulativeDeployXML = String.valueOf(proj.getProperty("team.deploy.common.localPackageRoot.dir")) + File.separator + proj.getProperty("team.deploy.common.applicationName") + File.separator + proj.getProperty("team.deploy.common.version") + File.separator + "cumulativeDeployed.xml";
        }
        if (this.intermediateSaveFileLibrary == null) {
            this.intermediateSaveFileLibrary = proj.getProperty("team.deploy.ibmi.intermediateSaveFileLibrary");
            if (this.intermediateSaveFileLibrary != null && !this.intermediateSaveFileLibrary.startsWith("\"")) {
                this.intermediateSaveFileLibrary = this.intermediateSaveFileLibrary.toUpperCase();
            }
        }
        if (this.rollbackDir == null) {
            this.rollbackDir = proj.getProperty("team.deploy.common.rollback.dir");
        }
        this.pvtautOption = Boolean.parseBoolean(this.getProject().getProperty("team.package.ibmi.pvtautOption"));
        if (this.connection != null) {
            File manifest = new File(this.cumulativeDeployXML);
            try {
                ManifestReader mr = ManifestReader.getInstance();
                if (!manifest.exists()) return;
                Manifest cumulative = mr.getManifest(manifest);
                Iterator containerIterator = cumulative.getCreatedContainersIterator();
                this.addDeleteObjectCommands(this.connection, containerIterator, this.rollbackCmds);
                this.addRestoreCommands(this.connection, this.rollbackCmds);
                Boolean success = this.executeRollbackCommands(this.connection, this.rollbackCmds);
                this.rollbackCmds.removeAllElements();
                this.addDeleteLibraryCommands(this.connection, containerIterator, this.rollbackCmds);
                this.executeRollbackCommands(this.connection, this.rollbackCmds);
                if (success.booleanValue()) return;
                throw new BuildException(Messages.IBMiUninstallTask_AT_LEAST_ONE_CMD_EXECUTION_RESULTED_IN_ERROR);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            this.log(Messages.IBMiUninstallTask_NO_IBMI_CONNECTION_AVAILABLE, 0);
        }
    }

    private void addRestoreCommands(AS400 as400, Vector<String> rollbackCmds) {
        try {
            List<String> timestampList = this.getTimestampList();
            for (String timestamp : timestampList) {
                IFSFile[] allFiles;
                IFSFile timestampDir = new IFSFile(as400, String.valueOf(this.rollbackDir) + "/" + timestamp);
                if (!timestampDir.exists() || !timestampDir.isDirectory()) continue;
                IFSFile[] iFSFileArray = allFiles = timestampDir.listFiles();
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IFSFile savefile = iFSFileArray[n2];
                    String library = savefile.getName();
                    library = library.substring(0, library.lastIndexOf(46));
                    String copyCmd = "CPYFRMSTMF FROMSTMF('" + savefile.getAbsolutePath() + "') TOMBR('" + this.getBaseIFSPath(this.intermediateSaveFileLibrary) + this.intermediateSaveFileLibrary + ".LIB" + "/" + library + ".FILE" + "') MBROPT(*REPLACE)";
                    rollbackCmds.add(copyCmd);
                    String pvtautString = this.getPvtautOption() ? " PVTAUT(*YES) " : "";
                    String rstCmd = "RSTLIB SAVLIB(" + library + ") DEV(*SAVF) SAVF(" + this.intermediateSaveFileLibrary + "/" + library + ")" + pvtautString;
                    rollbackCmds.add(rstCmd);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> getTimestampList() throws Exception {
        ArrayList<String> timestampList = new ArrayList<String>();
        String timestamps = GenerateDeployStatusTask.getTimestamps((String)this.deployStatusFile);
        StringTokenizer strTokens = new StringTokenizer(timestamps, ",");
        while (strTokens.hasMoreTokens()) {
            timestampList.add(strTokens.nextToken());
        }
        return timestampList;
    }

    private boolean executeRollbackCommands(AS400 connection, Vector<String> rollbackCmds) throws Exception {
        this.createLibrary(this.intermediateSaveFileLibrary, connection);
        return IBMiRemoteCommandUtils.executeRemoteCommands(rollbackCmds, (String)"RST", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false);
    }

    public boolean libraryExistsOnServer(AS400 connection, String libName) {
        return IAntTaskUtils.doesLibraryExist((AS400)connection, (String)libName);
    }

    public void setIntermediateSaveFileLibrary(String lib) {
        this.intermediateSaveFileLibrary = lib;
    }

    private void createLibrary(String libraryname, AS400 as400) throws BuildException {
        try {
            IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(libraryname)) + libraryname + ".LIB");
            if (!ifsFile.exists()) {
                CRTLIBTask crtLibTask = new CRTLIBTask();
                crtLibTask.setLibraryname(libraryname);
                crtLibTask.setText("'Intermediate Save File Library for Deployment'");
                crtLibTask.setProject(this.getProject());
                crtLibTask.setSystemref("SystemInstance");
                crtLibTask.setASPGroupName(this.getASPGroupName());
                crtLibTask.execute();
            }
        }
        catch (Exception e) {
            throw new BuildException(NLS.bind((String)Messages.IBMiUninstallTask_CANNOT_CREATE_LIBRARY_ERROR, (Object)libraryname), (Throwable)e);
        }
    }

    private void addDeleteObjectCommands(AS400 as400, Iterator<Container> deletedContainer, Vector<String> rollbackCmds) {
        while (deletedContainer.hasNext()) {
            Container container = deletedContainer.next();
            String library = container.getName();
            Iterator resourceItr = container.getResourcesIterator();
            while (resourceItr.hasNext()) {
                Resource resource = (Resource)resourceItr.next();
                String object = resource.getName();
                String type = resource.getIbmiType();
                try {
                    IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(library)) + library + ".LIB" + "/" + object + "." + type);
                    if (!ifsFile.exists()) continue;
                    rollbackCmds.add(IBMiDeleteObjectCommand.getDeleteObjectCommand(library, object, type));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addDeleteLibraryCommands(AS400 as400, Iterator<Container> deletedContainer, Vector<String> rollbackCmds) {
        while (deletedContainer.hasNext()) {
            Container container = deletedContainer.next();
            String library = container.getName();
            IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(library)) + library + ".LIB");
            try {
                IFSFile[] allFiles;
                if (!ifsFile.exists() || !container.getChangeType().equals("ADD") || (allFiles = ifsFile.listFiles()).length != 0) continue;
                String dltCmd = "DLTLIB LIB(" + library + ")";
                rollbackCmds.add(dltCmd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean getPvtautOption() {
        return this.pvtautOption;
    }
}

