/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.deployment.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.as400.access.IFSFileWriter;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.iant.IBMiLibraryValidator;
import com.ibm.iant.IBMiRemoteCommandUtils;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.CRTLIBTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.team.enterprise.deployment.toolkit.util.ContainerMappingProperties;
import com.ibm.teamp.deployment.toolkit.taskdefs.Messages;
import com.ibm.teamp.ibmi.automation.toolkit.util.IBMiUSRSPC;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class IBMiSaveRollbackTask
extends AbstractIBMiCommandTask {
    private final String NUM_OUTPUT_LIBRARIES_PROP = "Bundle-NumberOfOutputLibraries";
    private final String PROPERTY_SEPARATOR = ":";
    private final String TEMP_LIBRARY = "QTEMP";
    private final String SLASH = "/";
    private final String FALSE = "false";
    private AS400 connection;
    private String localPackageDir;
    private String intermediateSaveFileLibrary;
    private String packageManifestFile;
    private String restoreMappingFilePath;
    private String rollbackDir;
    private String omitRollbackFile;
    Properties restoreMappingProperties = null;
    private final Hashtable<String, HashSet<Resource>> packageManifestResources = new Hashtable();
    private final Vector<String> saveCmds = new Vector();
    private final Vector<String> savefiles = new Vector();
    private final Vector<String> savefilesOmitted = new Vector();
    private final Vector<String> saveLibs = new Vector();
    private final Vector<String> omittedLibsCreated = new Vector();
    private final HashSet<String> rstObjs = new HashSet();
    private final Vector<String> saveObjs = new Vector();
    private final Vector<String> saveObjsOmitted = new Vector();
    private final Vector<String> dltObjs = new Vector();
    private final Vector<String> createdObjectsOmitted = new Vector();
    private final Vector<String> allLibs = new Vector();
    private boolean migratePfData = false;
    private boolean savePfForRollback = true;
    private boolean pvtautOption = false;

    public String getRollbackDir() {
        return this.rollbackDir;
    }

    public void setRollbackDir(String rollbackDir) {
        this.rollbackDir = rollbackDir;
    }

    public void execute() throws BuildException {
        String savePfForRollbackOption;
        String restorePfDataOption;
        if (this.connection == null) {
            this.connection = this.getAS400();
        }
        Project proj = this.getProject();
        if (this.localPackageDir == null) {
            this.localPackageDir = proj.getProperty("team.deploy.common.localPackageRoot.dir");
        }
        if (this.intermediateSaveFileLibrary == null) {
            this.intermediateSaveFileLibrary = proj.getProperty("team.deploy.ibmi.intermediateSaveFileLibrary");
            if (this.intermediateSaveFileLibrary != null && !this.intermediateSaveFileLibrary.startsWith("\"")) {
                this.intermediateSaveFileLibrary = this.intermediateSaveFileLibrary.toUpperCase();
            }
        }
        if (this.restoreMappingFilePath == null || this.restoreMappingFilePath.equals("")) {
            this.restoreMappingFilePath = proj.getProperty("team.deploy.common.restoreMappingPath");
            if (this.restoreMappingFilePath == null || this.restoreMappingFilePath.equals("")) {
                this.restoreMappingFilePath = CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj) ? String.valueOf(this.localPackageDir) + "/" + "containerMapper.xml" : String.valueOf(this.localPackageDir) + "/" + "map.mf";
            }
        }
        if (this.omitRollbackFile == null) {
            this.omitRollbackFile = proj.getProperty("team.deploy.common.exclude.file.rollback");
        }
        if ((restorePfDataOption = proj.getProperty("team.deploy.ibmi.pfRestoreMethod")) != null && "MIGRATE".equals(restorePfDataOption)) {
            this.migratePfData = true;
        }
        if ((savePfForRollbackOption = proj.getProperty("team.deploy.ibmi.savePfForRollback")) != null && "false".equalsIgnoreCase(savePfForRollbackOption)) {
            this.savePfForRollback = false;
        }
        this.pvtautOption = Boolean.parseBoolean(this.getProject().getProperty("team.package.ibmi.pvtautOption"));
        try {
            this.restoreMappingProperties = this.getRestoreMappingProperties(proj);
            if (this.rollbackDir == null) {
                this.rollbackDir = proj.getProperty("team.deploy.common.rollback.dir");
            }
            this.packageManifestFile = CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj) ? String.valueOf(this.localPackageDir) + "/" + "packageManifest.xml" : String.valueOf(this.localPackageDir) + "/" + "package.mf";
            if (this.connection != null) {
                IFSFile mf = new IFSFile(this.connection, this.packageManifestFile);
                IFSFile rollbackIFSDir = new IFSFile(this.connection, this.rollbackDir);
                if (!mf.exists()) {
                    throw new BuildException(NLS.bind((String)Messages.IBMiSaveRollbackTask_PACKAGE_MANIFEST_FILE_NOT_FOUND, (Object)this.packageManifestFile));
                }
                if (!rollbackIFSDir.exists()) {
                    rollbackIFSDir.mkdirs();
                }
                if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj)) {
                    this.createSavfCmdsFromPackageManifestXML(mf);
                } else {
                    this.createSavfCmdsFromPackageManifest(mf);
                }
                this.saveRollback(this.saveCmds, this.saveLibs, this.allLibs, proj);
            } else {
                this.log(Messages.IBMiSaveRollbackTask_NO_IBMI_CONNECTION_AVAILABLE, 0);
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void createSavfCmdsFromPackageManifestXML(IFSFile mf) throws BuildException {
        try {
            IFSFileInputStream packageManifestXMLStream = new IFSFileInputStream(mf);
            Manifest packageManifest = ManifestReader.getInstance().getManifest((InputStream)packageManifestXMLStream);
            List containers = packageManifest.getContainers();
            Manifest omitFileForRollback = null;
            if (this.omitRollbackFile != null && !this.omitRollbackFile.equals("")) {
                IFSFile rf = new IFSFile(this.connection, this.omitRollbackFile);
                IFSFileInputStream omitFileForRollbackStream = new IFSFileInputStream(rf);
                omitFileForRollback = ManifestReader.getInstance().getManifest((InputStream)omitFileForRollbackStream);
            }
            for (Container container : containers) {
                if (container.getType().equals("IBMiLibrary")) {
                    HashSet<Object> manifestResources;
                    boolean resourceSaved = false;
                    Iterator resourceIterator = container.getResourcesIterator();
                    if (this.packageManifestResources.containsKey(container.getName())) {
                        manifestResources = this.packageManifestResources.get(container.getName());
                    } else {
                        manifestResources = new HashSet();
                        this.packageManifestResources.put(container.getName(), manifestResources);
                    }
                    while (resourceIterator.hasNext()) {
                        Resource resource = (Resource)resourceIterator.next();
                        if (resource.getType().equals("IBMiObject")) {
                            String libName = this.getMappedLibName(this.restoreMappingProperties, container.getName());
                            manifestResources.add(resource);
                            if (this.shouldSaveResource(resource, libName, omitFileForRollback)) {
                                this.rstObjs.add(String.valueOf(libName) + "/" + resource.getName() + "." + resource.getIbmiType());
                                this.saveObjs.add(String.valueOf(container.getName()) + "/" + resource.getName() + "." + resource.getIbmiType());
                                resourceSaved = true;
                                continue;
                            }
                            this.saveObjsOmitted.add(String.valueOf(libName) + "/" + resource.getName() + "." + resource.getIbmiType().substring(1));
                            continue;
                        }
                        throw new BuildException(Messages.IBMiSaveRollbackTask_RESOURCE_TYPE_MUST_BE_IBMIOBJECT);
                    }
                    if (resourceSaved) {
                        this.savefiles.add(container.getName());
                        continue;
                    }
                    this.savefilesOmitted.add(container.getName());
                    continue;
                }
                throw new BuildException(Messages.IBMiSaveRollbackTask_CONTAINER_TYPE_MUST_BE_IBMILIBRARY);
            }
            packageManifestXMLStream.close();
            for (String savfile : this.savefiles) {
                String saveCmd = this.getSaveCommand(savfile);
                if (saveCmd == null) continue;
                this.saveCmds.add(saveCmd);
            }
            for (String savfile : this.savefilesOmitted) {
                this.updateAllLibsListWithOmits(savfile);
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void updateAllLibsListWithOmits(String savf) {
        String savfName;
        String libName;
        if (savf != null && !this.allLibs.contains(libName = this.getMappedLibName(this.restoreMappingProperties, savfName = this.getSavfName(savf)))) {
            this.allLibs.add(libName);
            if (!this.libraryExistsOnServer(this.connection, libName)) {
                this.omittedLibsCreated.add(libName);
            }
        }
    }

    private boolean shouldSaveResource(Resource omitResource, String ContainerName, Manifest omitFileForRollback) {
        if (!this.savePfForRollback && "*FILE".equals(omitResource.getIbmiType()) && "PF-DTA".equals(omitResource.getIbmiAttrribute())) {
            return false;
        }
        if (omitFileForRollback != null) {
            List containers = omitFileForRollback.getContainers();
            for (Container container : containers) {
                if (!container.getType().equals("IBMiLibrary") || !container.getName().equals(ContainerName)) continue;
                Iterator resourceIterator = container.getResourcesIterator();
                while (resourceIterator.hasNext()) {
                    Resource resource = (Resource)resourceIterator.next();
                    if (!resource.getType().equals("IBMiObject") || !resource.getName().equals(omitResource.getName())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void createSavfCmdsFromPackageManifest(IFSFile mf) throws AS400SecurityException, IOException, Exception {
        String numFiles = null;
        Pattern savfFilePattern = Pattern.compile("SAVF-.*-file");
        Pattern savfObjectPattern = Pattern.compile("SAVF-.*-object\\[");
        BufferedReader reader = new BufferedReader((Reader)new IFSFileReader(mf));
        String mfLine = null;
        String savf = null;
        String object = null;
        while ((mfLine = reader.readLine()) != null) {
            Matcher matchedObject;
            Matcher matchedSavfFile;
            if (mfLine.startsWith("Bundle-NumberOfOutputLibraries")) {
                numFiles = this.getPropertyValue(mfLine, "Bundle-NumberOfOutputLibraries", ":");
            }
            if ((matchedSavfFile = savfFilePattern.matcher(mfLine)).find()) {
                savf = this.getPropertyValue(mfLine, mfLine.substring(matchedSavfFile.start(), matchedSavfFile.end()), ":");
                this.savefiles.add(savf);
            }
            if (!(matchedObject = savfObjectPattern.matcher(mfLine)).find()) continue;
            object = this.getPropertyValue(mfLine, mfLine.substring(matchedObject.start(), matchedObject.end()), ":");
            this.saveObjs.add(object);
        }
        reader.close();
        for (String savfile : this.savefiles) {
            String saveCmd = this.getSaveCommand(savfile);
            if (saveCmd == null) continue;
            this.saveCmds.add(saveCmd);
        }
        if (this.savefiles.size() != Integer.parseInt(numFiles)) {
            this.log(NLS.bind((String)Messages.IBMiSaveRollbackTask_PROPERTY_DOESNT_EQUAL_NUMBER_OF_SAVF_FILES_TO_RESTORE, (Object)this.packageManifestFile), 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean saveRollback(Vector<String> saveCmds, Vector<String> saveLibraries, Vector<String> allLibraries, Project project) throws BuildException {
        if (this.connection != null && this.connection.isConnected()) {
            try {
                if (this.intermediateSaveFileLibrary == null) {
                    this.intermediateSaveFileLibrary = "QTEMP";
                }
                if (!saveLibraries.isEmpty()) {
                    this.createLibrary(this.intermediateSaveFileLibrary, this.connection);
                    String timestamp = null;
                    if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)project)) {
                        String isCompletePackageValue = project.getProperty("team.deploy.common.isCompletePackage");
                        timestamp = Boolean.parseBoolean(isCompletePackageValue) ? project.getProperty("team.deploy.common.newDeployTimeStamp") : project.getProperty("team.deploy.common.newUpdateDeployTimeStamp");
                    }
                    for (String library : saveLibraries) {
                        String crtSavfCmd = "CRTSAVF FILE(" + this.intermediateSaveFileLibrary + "/" + library + ")";
                        saveCmds.add(0, crtSavfCmd);
                        ISeriesObjectFilterString objectFilterString = new ISeriesObjectFilterString();
                        objectFilterString.setObject(library);
                        objectFilterString.setObjectType("*FILE");
                        objectFilterString.setLibrary(this.intermediateSaveFileLibrary);
                        ISeriesListObjects listObjects = new ISeriesListObjects(this.getAS400());
                        List objectList = listObjects.getList((ISeriesAbstractFilterString)objectFilterString);
                        if (objectList.size() != 0) {
                            String dltSavfCmd = "DLTF FILE(" + this.intermediateSaveFileLibrary + "/" + library + ")";
                            saveCmds.add(0, dltSavfCmd);
                        }
                        String copyCmd = "CPYTOSTMF TOSTMF('" + this.rollbackDir + "/" + library + ".savf" + "') FROMMBR('" + this.getBaseIFSPath(this.intermediateSaveFileLibrary) + this.intermediateSaveFileLibrary + ".LIB" + "/" + library + ".FILE" + "') STMFOPT(*REPLACE)";
                        saveCmds.add(copyCmd);
                        if (!CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)project) || timestamp == null) continue;
                        IFSFile timstampDir = new IFSFile(this.connection, String.valueOf(this.rollbackDir) + "/" + timestamp);
                        if (!timstampDir.exists()) {
                            timstampDir.mkdir();
                        }
                        copyCmd = "CPYTOSTMF TOSTMF('" + this.rollbackDir + "/" + project.getProperty("team.deploy.common.newDeployTimeStamp") + "/" + library + ".savf" + "') FROMMBR('" + this.getBaseIFSPath(this.intermediateSaveFileLibrary) + this.intermediateSaveFileLibrary + ".LIB" + "/" + library + ".FILE" + "') STMFOPT(*REPLACE)";
                        saveCmds.add(copyCmd);
                    }
                    if (!IBMiRemoteCommandUtils.executeRemoteCommands(saveCmds, (String)"SAV", (AbstractIBMiCommandTask)this, (AS400)this.connection, (boolean)false)) {
                        throw new BuildException(Messages.IBMiRestorePackageTask_AT_LEAST_ONE_RSTOBJ_CMD_EXECUTION_FAILED);
                    }
                    this.deleteTempSaveFiles(saveLibraries);
                } else {
                    this.log(Messages.IBMiSaveRollbackTask_DEPLOYMENT_LIBRARIES_DONT_EXIST_NOBACKUP_MADE, 1);
                }
                if (allLibraries.isEmpty()) return true;
                this.getDltObjects();
                this.getCreatedButOmittedObjects();
                if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)project)) {
                    this.writeRollbackManifestXML(saveLibraries, allLibraries);
                    this.writeDeltaDeployManifestXML(saveLibraries, allLibraries);
                    return true;
                }
                this.writeRollbackManifest(saveLibraries, allLibraries);
                return true;
            }
            catch (Exception e) {
                this.log(e.toString());
                throw new BuildException(NLS.bind((String)Messages.IBMiSaveRollbackTask_UNEXPECTED_ERROR_BACKING_UP_LIBRARIES, (Object)((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            }
        } else {
            this.log(Messages.IBMiSaveRollbackTask_NO_IBMI_CONNECTION_AVAILABLE, 0);
        }
        return true;
    }

    private void writeRollbackManifestXML(Vector<String> saveLibraries, Vector<String> allLibraries) throws Exception {
        Set<String> oldContainerNames = this.packageManifestResources.keySet();
        Manifest rollbackManifest = new Manifest();
        rollbackManifest.setType("MANIFEST_LIST");
        if (this.saveObjs.size() > 0) {
            for (String oldContainerName : oldContainerNames) {
                HashSet<Resource> originalResourceSet = this.packageManifestResources.get(oldContainerName);
                String newContainerName = this.getMappedLibName(this.restoreMappingProperties, oldContainerName);
                if (IBMiLibraryValidator.isValidLibraryName((String)newContainerName)) {
                    if (!saveLibraries.contains(newContainerName) && !this.omittedLibsCreated.contains(newContainerName)) {
                        Container newContainer = new Container();
                        newContainer.setName(newContainerName);
                        newContainer.setType("IBMiLibrary");
                        newContainer.setChangeType("DELETE");
                        for (Resource resource : originalResourceSet) {
                            String object = String.valueOf(newContainerName) + "/" + resource.getName() + "." + resource.getIbmiType().substring(1);
                            if (this.saveObjsOmitted.contains(object)) continue;
                            newContainer.addResource(resource);
                        }
                        rollbackManifest.addDeletedContainer(newContainer);
                        continue;
                    }
                    Container containerWithDeletedResources = new Container();
                    Container containerWithUpdatedResources = new Container();
                    containerWithDeletedResources.setName(newContainerName);
                    containerWithUpdatedResources.setName(newContainerName);
                    containerWithDeletedResources.setType("IBMiLibrary");
                    containerWithUpdatedResources.setType("IBMiLibrary");
                    containerWithDeletedResources.setChangeType("UPDATE");
                    containerWithUpdatedResources.setChangeType("UPDATE");
                    for (Resource resource : originalResourceSet) {
                        String object = String.valueOf(newContainerName) + "/" + resource.getName() + "." + resource.getIbmiType().substring(1);
                        if (this.dltObjs.contains(object)) {
                            containerWithDeletedResources.addResource(resource);
                            continue;
                        }
                        if (this.saveObjsOmitted.contains(object)) continue;
                        containerWithUpdatedResources.addResource(resource);
                    }
                    if (containerWithDeletedResources.getResourcesIterator().hasNext()) {
                        rollbackManifest.addDeletedContainer(containerWithDeletedResources);
                    }
                    if (!containerWithUpdatedResources.getResourcesIterator().hasNext()) continue;
                    rollbackManifest.addUpdatedContainer(containerWithUpdatedResources);
                    continue;
                }
                throw new BuildException(NLS.bind((String)Messages.IBMiSaveRollbackTask_RESTORE_LIBRARY_NOT_VALID_NAME, (Object)newContainerName));
            }
        }
        IFSFile rollbackXMLFile = new IFSFile(this.connection, String.valueOf(this.rollbackDir) + "/" + "rollbackManifest.xml");
        rollbackXMLFile.createNewFile();
        IFSFileOutputStream rollbackXMLStream = new IFSFileOutputStream(rollbackXMLFile);
        ManifestWriter.getInstance().write((OutputStream)rollbackXMLStream, rollbackManifest);
        rollbackXMLStream.close();
    }

    private void writeDeltaDeployManifestXML(Vector<String> saveLibraries, Vector<String> allLibraries) throws Exception {
        Set<String> oldContainerNames = this.packageManifestResources.keySet();
        Manifest deltaDeployManifest = new Manifest();
        deltaDeployManifest.setType("MANIFEST_LIST");
        for (String oldContainerName : oldContainerNames) {
            HashSet<Resource> originalResourceSet = this.packageManifestResources.get(oldContainerName);
            String newContainerName = this.getMappedLibName(this.restoreMappingProperties, oldContainerName);
            if (IBMiLibraryValidator.isValidLibraryName((String)newContainerName)) {
                if (!saveLibraries.contains(newContainerName) && !this.omittedLibsCreated.contains(newContainerName)) {
                    Container newContainer = new Container();
                    newContainer.setName(newContainerName);
                    newContainer.setType("IBMiLibrary");
                    newContainer.setChangeType("ADD");
                    for (Resource resource : originalResourceSet) {
                        newContainer.addResource(resource);
                    }
                    deltaDeployManifest.addCreatedContainer(newContainer);
                    continue;
                }
                Container containerWithCreatedResources = new Container();
                Container containerWithUpdatedResources = new Container();
                containerWithCreatedResources.setName(newContainerName);
                containerWithUpdatedResources.setName(newContainerName);
                containerWithCreatedResources.setType("IBMiLibrary");
                containerWithUpdatedResources.setType("IBMiLibrary");
                containerWithCreatedResources.setChangeType("UPDATE");
                containerWithUpdatedResources.setChangeType("UPDATE");
                for (Resource resource : originalResourceSet) {
                    String object = String.valueOf(newContainerName) + "/" + resource.getName() + "." + resource.getIbmiType().substring(1);
                    if (this.dltObjs.contains(object) || this.createdObjectsOmitted.contains(object)) {
                        containerWithCreatedResources.addResource(resource);
                        continue;
                    }
                    containerWithUpdatedResources.addResource(resource);
                }
                if (containerWithCreatedResources.getResourcesIterator().hasNext()) {
                    deltaDeployManifest.addCreatedContainer(containerWithCreatedResources);
                }
                if (!containerWithUpdatedResources.getResourcesIterator().hasNext()) continue;
                deltaDeployManifest.addUpdatedContainer(containerWithUpdatedResources);
                continue;
            }
            throw new BuildException(NLS.bind((String)Messages.IBMiSaveRollbackTask_RESTORE_LIBRARY_NOT_VALID_NAME, (Object)newContainerName));
        }
        IFSFile deltaDeployXMLFile = new IFSFile(this.connection, String.valueOf(this.localPackageDir) + "/" + "deltaDeployed.xml");
        deltaDeployXMLFile.createNewFile();
        IFSFileOutputStream deltaDeployXMLStream = new IFSFileOutputStream(deltaDeployXMLFile);
        ManifestWriter.getInstance().write((OutputStream)deltaDeployXMLStream, deltaDeployManifest);
        deltaDeployXMLStream.close();
    }

    private void deleteTempSaveFiles(Vector<String> savfs) {
        Vector<String> dltfCommandVector = new Vector<String>();
        for (String l : savfs) {
            dltfCommandVector.add("DLTF FILE(" + this.intermediateSaveFileLibrary + "/" + l + ")");
        }
        try {
            if (!IBMiRemoteCommandUtils.executeRemoteCommands(dltfCommandVector, (String)"DLTF", (AbstractIBMiCommandTask)this, (AS400)this.connection, (boolean)false)) {
                this.log(Messages.IBMiRestorePackageTask_ERROR_ON_TEMP_SAVF_CLEANUP, 1);
            }
        }
        catch (Exception e) {
            this.log(Messages.IBMiRestorePackageTask_ERROR_ON_TEMP_SAVF_CLEANUP, e, 1);
        }
    }

    private String getSavfName(String savf) {
        int i = savf.lastIndexOf("/");
        int k = savf.lastIndexOf(".");
        if (i != -1 && k != -1) {
            return savf.substring(i + 1, k);
        }
        return savf;
    }

    private String getLibName(String obj) {
        int i = obj.indexOf("/");
        return obj.substring(0, i);
    }

    private String getObjName(String obj) {
        int i = obj.indexOf("/");
        int k = obj.lastIndexOf(".");
        return obj.substring(i + 1, k);
    }

    private String getObjType(String obj) {
        int k = obj.lastIndexOf(".");
        String type = obj.substring(k + 1);
        if (type.startsWith("*")) {
            return type.substring(1);
        }
        return type;
    }

    public void writeRollbackManifest(Vector<String> savedLibraries, Vector<String> allLibraries) throws BuildException {
        try {
            IFSFile mf = new IFSFile(this.connection, String.valueOf(this.rollbackDir) + "/" + "rollbackLibs.mf");
            if (mf.exists()) {
                mf.delete();
            }
            mf.createNewFile();
            mf.setCCSID(1208);
            PrintWriter writer = new PrintWriter(new BufferedWriter((Writer)new IFSFileWriter(mf)));
            for (String library : allLibraries) {
                if (savedLibraries.contains(library)) {
                    writer.println("RST: " + library);
                    continue;
                }
                writer.println("DLT: " + library);
            }
            for (String obj : this.dltObjs) {
                writer.println("DLTOBJ: " + obj);
            }
            writer.flush();
            writer.close();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void writeRollbackTimestamp(Project proj, String timestamp) throws BuildException {
        try {
            BufferedWriter writer;
            IFSFile file = new IFSFile(this.connection, String.valueOf(this.rollbackDir) + "/" + "rollbackTimestamp");
            String isCompletePackageValue = proj.getProperty("team.deploy.common.isCompletePackage");
            if (Boolean.parseBoolean(isCompletePackageValue) && file.exists()) {
                file.delete();
            }
            if (!file.exists()) {
                file.createNewFile();
                writer = new BufferedWriter((Writer)new IFSFileWriter(file));
            } else {
                writer = new BufferedWriter((Writer)new IFSFileWriter(file, true));
            }
            file.setCCSID(1208);
            writer.write(timestamp);
            writer.newLine();
            writer.flush();
            writer.close();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String getSaveCommand(String savf) {
        String savfName;
        String libName;
        String saveCmd = null;
        if (this.intermediateSaveFileLibrary == null) {
            this.intermediateSaveFileLibrary = "QTEMP";
        }
        if (savf != null && !this.allLibs.contains(libName = this.getMappedLibName(this.restoreMappingProperties, savfName = this.getSavfName(savf)))) {
            this.allLibs.add(libName);
            try {
                if (this.libraryExistsOnServer(this.connection, libName)) {
                    IFSFile[] objects;
                    this.saveLibs.add(libName);
                    Vector<String> objExclude = new Vector<String>();
                    IFSFile ifsFile = new IFSFile(this.connection, String.valueOf(this.getBaseIFSPath(libName)) + libName + ".LIB");
                    String pvtautString = this.getPvtautOption() ? "PVTAUT(*YES) " : "";
                    StringBuffer c = new StringBuffer("SAVLIB LIB(" + libName + ") DEV(*SAVF) SAVF(" + this.intermediateSaveFileLibrary + "/" + libName + ") " + pvtautString);
                    IFSFile[] iFSFileArray = objects = ifsFile.listFiles();
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFSFile f = iFSFileArray[n2];
                        String name = f.getName();
                        int lastDot = name.lastIndexOf(".");
                        String type = "*" + name.substring(lastDot + 1);
                        if (!this.isObjectInPackage(libName, name.substring(0, lastDot), type)) {
                            objExclude.add(String.valueOf(name.substring(0, lastDot)) + " " + type);
                        }
                        ++n2;
                    }
                    if (objExclude != null && objExclude.size() > 0) {
                        if (objExclude.size() <= 300) {
                            c.append(" OMITOBJ(");
                            for (String filter : objExclude) {
                                c.append("(" + filter + ") ");
                            }
                            c.append(")");
                        } else {
                            IBMiUSRSPC usrspc = new IBMiUSRSPC();
                            usrspc.createUSRSPC(libName, this.getBaseIFSPath(this.intermediateSaveFileLibrary), this.intermediateSaveFileLibrary, new HashSet(), objExclude, this.connection, "", this.getPvtautOption());
                            c.append(" OMITOBJ(*USRSPC) CMDUSRSPC(" + this.intermediateSaveFileLibrary + "/" + libName + ")");
                        }
                    }
                    saveCmd = c.toString();
                    this.log(NLS.bind((String)Messages.IBMiSaveRollbackTask_SAVE_COMMAND, (Object)saveCmd), 1);
                } else {
                    this.log(NLS.bind((String)Messages.IBMiSaveRollbackTask_RUNTIME_LIBRARY_DOESNT_EXIST_AND_CANT_BE_BACKED_UP, (Object)libName), 1);
                }
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        return saveCmd;
    }

    private String getMappedLibName(Properties restoreMappings, String savfName) {
        String libName = savfName;
        if (this.restoreMappingProperties != null && !this.restoreMappingProperties.isEmpty()) {
            if (restoreMappings.getProperty(savfName) != null) {
                libName = restoreMappings.getProperty(savfName);
            } else {
                throw new BuildException(NLS.bind((String)Messages.IBMiSaveRollbackTask_NO_MAPPING_FOUND_FOR_LIBRARY, (Object)savfName));
            }
        }
        return libName;
    }

    private boolean isObjectInPackage(String libName, String name, String type) {
        return this.rstObjs.contains(String.valueOf(libName) + "/" + name + "." + type);
    }

    public boolean libraryExistsOnServer(AS400 connection, String libName) {
        return IAntTaskUtils.doesLibraryExist((AS400)connection, (String)libName);
    }

    private String getPropertyValue(String line, String property, String separator) {
        int start = line.indexOf(separator);
        return line.substring(start + 2);
    }

    public void setLocalPackageDir(String dir) {
        this.localPackageDir = dir;
    }

    public void setIntermediateSaveFileLibrary(String lib) {
        this.intermediateSaveFileLibrary = lib;
    }

    public void setRestoreMappingFilePath(String restorMappingFile) {
        this.restoreMappingFilePath = restorMappingFile;
    }

    private void createLibrary(String libraryname, AS400 as400) throws BuildException {
        try {
            IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(libraryname)) + libraryname + ".LIB");
            if (!ifsFile.exists()) {
                CRTLIBTask crtLibTask = new CRTLIBTask();
                crtLibTask.setLibraryname(libraryname);
                crtLibTask.setText("'Intermediate Save File Library for Deployment'");
                crtLibTask.setProject(this.getProject());
                crtLibTask.setSystemref("SystemInstance");
                crtLibTask.setASPGroupName(this.getASPGroupName());
                crtLibTask.execute();
            }
        }
        catch (Exception e) {
            throw new BuildException(NLS.bind((String)Messages.IBMiSaveRollbackTask_CANNOT_CREATE_LIBRARY_ERROR, (Object)libraryname), (Throwable)e);
        }
    }

    private Properties getRestoreMappingProperties(Project project) throws Exception {
        if (this.restoreMappingProperties == null) {
            this.restoreMappingProperties = new Properties();
            IFSFile mappingsFile = new IFSFile(this.connection, this.restoreMappingFilePath);
            if (mappingsFile.exists()) {
                this.restoreMappingProperties = ContainerMappingProperties.getRestoreMappingProperties((Project)project, (InputStream)new IFSFileInputStream(mappingsFile), (Reader)new IFSFileReader(mappingsFile));
            }
        }
        return this.restoreMappingProperties;
    }

    private void getDltObjects() {
        for (String obj : this.saveObjs) {
            String libName = this.getMappedLibName(this.restoreMappingProperties, this.getLibName(obj));
            String objName = this.getObjName(obj);
            String objType = this.getObjType(obj);
            try {
                String objPath;
                IFSFile ifsFile;
                if (!this.libraryExistsOnServer(this.connection, libName) || (ifsFile = new IFSFile(this.connection, objPath = String.valueOf(this.getBaseIFSPath(libName)) + libName + ".LIB" + "/" + objName + "." + objType)).exists()) continue;
                this.dltObjs.add(String.valueOf(libName) + "/" + objName + "." + objType);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void getCreatedButOmittedObjects() {
        for (String obj : this.saveObjsOmitted) {
            String libName = this.getLibName(obj);
            String objName = this.getObjName(obj);
            String objType = this.getObjType(obj);
            try {
                String objPath;
                IFSFile ifsFile;
                if (!this.libraryExistsOnServer(this.connection, libName) || (ifsFile = new IFSFile(this.connection, objPath = String.valueOf(this.getBaseIFSPath(libName)) + libName + ".LIB" + "/" + objName + "." + objType)).exists()) continue;
                this.createdObjectsOmitted.add(String.valueOf(libName) + "/" + objName + "." + objType);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private boolean getPvtautOption() {
        return this.pvtautOption;
    }
}

