/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.deployment.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.iant.IBMiLibraryValidator;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.CRTLIBTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.teamp.deployment.toolkit.taskdefs.IBMiRestorePackageTask;
import com.ibm.teamp.deployment.toolkit.taskdefs.Messages;
import com.ibm.teamp.deployment.toolkit.util.IBMiDeleteObjectCommand;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class IBMiRollbackRestoreTask
extends AbstractIBMiCommandTask {
    private final String SLASH = "/";
    private AS400 connection;
    private String intermediateSaveFileLibrary;
    private String rollbackDir;
    private String rollbackManifestFile;
    private boolean pvtautOption = false;
    private final Vector<String> rollbackCmds = new Vector();
    private Vector<LibraryRollbackAction> rollbackActions = new Vector();
    HashSet<String> maybeDeletedLibraries = new HashSet();

    public String getRollbackDir() {
        return this.rollbackDir;
    }

    public void setRollbackDir(String rollbackDir) {
        this.rollbackDir = rollbackDir;
    }

    public void execute() throws BuildException {
        if (this.connection == null) {
            this.connection = this.getAS400();
        }
        Project proj = this.getProject();
        if (this.intermediateSaveFileLibrary == null) {
            this.intermediateSaveFileLibrary = proj.getProperty("team.deploy.ibmi.intermediateSaveFileLibrary");
            if (this.intermediateSaveFileLibrary != null && !this.intermediateSaveFileLibrary.startsWith("\"")) {
                this.intermediateSaveFileLibrary = this.intermediateSaveFileLibrary.toUpperCase();
            }
        }
        if (this.rollbackDir == null) {
            this.rollbackDir = proj.getProperty("team.deploy.common.rollback.dir");
        }
        this.rollbackManifestFile = CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj) ? String.valueOf(this.rollbackDir) + "/" + "rollbackManifest.xml" : String.valueOf(this.rollbackDir) + "/" + "rollbackLibs.mf";
        this.pvtautOption = Boolean.parseBoolean(this.getProject().getProperty("team.package.ibmi.pvtautOption"));
        if (this.connection != null) {
            try {
                this.rollbackActions = CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj) ? this.getRollbackActionsFromXML(this.connection, this.rollbackManifestFile) : this.getRollbackActions(this.connection, this.rollbackManifestFile);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            if (this.rollbackActions.isEmpty()) {
                this.log(NLS.bind((String)Messages.IBMiRollbackRestoreTask_NO_ROLLBACK_ACTIONS_PERFORMED, (Object)(String.valueOf(this.rollbackDir) + "rollbackLibs.mf")), 1);
            } else {
                try {
                    if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj)) {
                        this.addRestoreCommands(this.rollbackActions);
                        this.addDeleteObjectCommands(this.connection, this.rollbackActions);
                        this.executeRollbackCommands(this.connection, this.rollbackCmds);
                        this.rollbackCmds.clear();
                        this.rollbackActions.clear();
                        this.rollbackActions = this.addDeleteCommands();
                        this.addDeleteCommands(this.rollbackActions);
                        this.executeRollbackCommands(this.connection, this.rollbackCmds);
                    }
                    this.addDeleteCommands(this.rollbackActions);
                    this.addRestoreCommands(this.rollbackActions);
                    this.addDeleteObjectCommands(this.connection, this.rollbackActions);
                    this.executeRollbackCommands(this.connection, this.rollbackCmds);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        } else {
            this.log(Messages.IBMiRollbackRestoreTask_NO_IBMI_CONNECTION, 0);
        }
    }

    private Vector<LibraryRollbackAction> addDeleteCommands() throws Exception {
        for (String maybeDeletedLibrary : this.maybeDeletedLibraries) {
            IFSFile[] objects;
            IFSFile ifsFile = new IFSFile(this.connection, String.valueOf(this.getBaseIFSPath(maybeDeletedLibrary)) + maybeDeletedLibrary + ".LIB");
            if (!ifsFile.exists() || (objects = ifsFile.listFiles()).length >= 1) continue;
            this.rollbackActions.add(new LibraryRollbackAction("DLT", maybeDeletedLibrary));
        }
        return this.rollbackActions;
    }

    private Vector<LibraryRollbackAction> getRollbackActionsFromXML(AS400 connection, String rollbackManifestFile) throws Exception {
        IFSFile mfdir = new IFSFile(connection, this.rollbackDir);
        if (!mfdir.exists()) {
            throw new BuildException(NLS.bind((String)Messages.IBMiRollbackRestoreTask_ROLLBACK_MANIFEST_DIRECTORY_NOT_FOUND, (Object)this.rollbackDir));
        }
        IFSFile mf = new IFSFile(connection, rollbackManifestFile);
        if (!mf.exists()) {
            throw new BuildException(NLS.bind((String)Messages.IBMiRollbackRestoreTask_ROLLBACK_MANIFEST_NOT_FOUND, (Object)rollbackManifestFile));
        }
        HashSet<String> updateLibraries = new HashSet<String>();
        IFSFileInputStream rollbackManifestXMLStream = new IFSFileInputStream(mf);
        Manifest rollbackManifest = ManifestReader.getInstance().getManifest((InputStream)rollbackManifestXMLStream);
        List deleteContainers = rollbackManifest.getDeletedContainers();
        List updateContainers = rollbackManifest.getUpdatedContainers();
        for (Container container : deleteContainers) {
            if (container.getType().equals("IBMiLibrary")) {
                if (container.getChangeType().equals("UPDATE")) {
                    updateLibraries.add(container.getName());
                } else if (container.getChangeType().equals("DELETE")) {
                    this.maybeDeletedLibraries.add(container.getName());
                }
                Iterator resourceIterator = container.getResourcesIterator();
                while (resourceIterator.hasNext()) {
                    Resource resource = (Resource)resourceIterator.next();
                    if (resource.getType().equals("IBMiObject")) {
                        this.rollbackActions.add(new ObjectRollbackAction("DLTOBJ", container.getName(), resource.getName(), resource.getIbmiType(), resource.getIbmiAttrribute()));
                        continue;
                    }
                    throw new BuildException(Messages.IBMiRollbackRestoreTask_CONTAINER_TYPE_MUST_BE_AN_IBMIOBJECT);
                }
                continue;
            }
            throw new BuildException(Messages.IBMiRollbackRestoreTask_CONTAINER_TYPE_MUST_BE_AN_IBMILIBRARY);
        }
        for (Container container : updateContainers) {
            if (container.getType().equals("IBMiLibrary")) {
                if (!container.getChangeType().equals("UPDATE")) continue;
                updateLibraries.add(container.getName());
                continue;
            }
            throw new BuildException(Messages.IBMiRollbackRestoreTask_CONTAINER_TYPE_MUST_BE_AN_IBMILIBRARY);
        }
        for (String updateLibrary : updateLibraries) {
            LibraryRollbackAction rollbackAction = new LibraryRollbackAction("RST", updateLibrary);
            String savfIfsName = String.valueOf(this.rollbackDir) + "/" + updateLibrary + ".savf";
            IFSFile savf = new IFSFile(connection, savfIfsName);
            if (savf.exists()) {
                this.rollbackActions.add(rollbackAction);
                continue;
            }
            throw new BuildException(NLS.bind((String)Messages.IBMiRollbackRestoreTask_ROLLBACK_ARCHIVE_NOT_FOUND_FOR_LIBRARY, (Object)updateLibrary, (Object)(String.valueOf(this.rollbackDir) + updateLibrary)));
        }
        return this.rollbackActions;
    }

    private Vector<LibraryRollbackAction> getRollbackActions(AS400 connection, String rollbackManifestFileName) throws Exception {
        IFSFile mfdir = new IFSFile(connection, this.rollbackDir);
        if (!mfdir.exists()) {
            throw new BuildException(NLS.bind((String)Messages.IBMiRollbackRestoreTask_ROLLBACK_MANIFEST_DIRECTORY_NOT_FOUND, (Object)this.rollbackDir));
        }
        IFSFile mf = new IFSFile(connection, rollbackManifestFileName);
        if (!mf.exists()) {
            throw new BuildException(NLS.bind((String)Messages.IBMiRollbackRestoreTask_ROLLBACK_MANIFEST_NOT_FOUND, (Object)rollbackManifestFileName));
        }
        String mfLine = null;
        try (BufferedReader reader = new BufferedReader((Reader)new IFSFileReader(mf));){
            while ((mfLine = reader.readLine()) != null) {
                mfLine = mfLine.trim();
                String action = null;
                String library = null;
                String object = null;
                String type = null;
                StringTokenizer tokens = new StringTokenizer(mfLine, "://.");
                if (tokens == null) continue;
                if (tokens.hasMoreTokens()) {
                    action = tokens.nextToken();
                    action = action.trim();
                }
                if (tokens.hasMoreTokens()) {
                    library = tokens.nextToken();
                    if (!IBMiLibraryValidator.isValidLibraryName((String)(library = library.trim()))) {
                        throw new BuildException(NLS.bind((String)Messages.IBMiRollbackRestoreTask_LIBRARY_NAME_NOT_VALID_IN_MANIFEST, (Object)library));
                    }
                }
                if (tokens.hasMoreTokens()) {
                    object = tokens.nextToken().trim();
                }
                if (tokens.hasMoreTokens()) {
                    type = tokens.nextToken().trim();
                }
                if (action == null || action == "" || !(library != null & library != "")) continue;
                LibraryRollbackAction rollbackAction = new LibraryRollbackAction(action, library);
                if (action.equals("RST")) {
                    String savfIfsName = String.valueOf(this.rollbackDir) + "/" + library + ".savf";
                    IFSFile savf = new IFSFile(connection, savfIfsName);
                    if (savf.exists()) {
                        this.rollbackActions.add(rollbackAction);
                        continue;
                    }
                    throw new BuildException(NLS.bind((String)Messages.IBMiRollbackRestoreTask_ROLLBACK_ARCHIVE_NOT_FOUND_FOR_LIBRARY, (Object)library, (Object)(String.valueOf(this.rollbackDir) + library)));
                }
                if (action.equals("DLT")) {
                    this.rollbackActions.add(rollbackAction);
                    continue;
                }
                if (action.equals("DLTOBJ")) {
                    if (object == null || object == "" || !(type != null & type != "")) continue;
                    this.rollbackActions.add(new ObjectRollbackAction(action, library, object, type));
                    continue;
                }
                this.log(NLS.bind((String)Messages.IBMiRollbackRestoreTask_ROLLBACK_ACTION_UNDEFINED_FOR_LIBRARY, (Object)action, (Object)library), 1);
            }
        }
        return this.rollbackActions;
    }

    private void addDeleteCommands(Vector<LibraryRollbackAction> rollbackActns) {
        if (!rollbackActns.isEmpty()) {
            for (LibraryRollbackAction rollbackAction : rollbackActns) {
                if (!rollbackAction.action.equals("DLT")) continue;
                String dltCmd = "DLTLIB LIB(" + rollbackAction.library + ")";
                this.rollbackCmds.add(dltCmd);
            }
        }
    }

    private void addRestoreCommands(Vector<LibraryRollbackAction> rollbackActns) {
        if (!rollbackActns.isEmpty()) {
            for (LibraryRollbackAction rollbackAction : rollbackActns) {
                if (!rollbackAction.action.equals("RST")) continue;
                String library = rollbackAction.library;
                String copyCmd = "CPYFRMSTMF FROMSTMF('" + this.rollbackDir + "/" + library + ".savf" + "') TOMBR('" + this.getBaseIFSPath(this.intermediateSaveFileLibrary) + this.intermediateSaveFileLibrary + ".LIB" + "/" + library + ".FILE" + "') MBROPT(*REPLACE)";
                this.rollbackCmds.add(copyCmd);
                String pvtautString = this.getPvtautOption() ? " PVTAUT(*YES) " : "";
                String rstCmd = "RSTLIB SAVLIB(" + library + ") DEV(*SAVF) SAVF(" + this.intermediateSaveFileLibrary + "/" + library + ") " + this.getRestoreAdditionalOptions() + pvtautString;
                this.rollbackCmds.add(rstCmd);
            }
        }
    }

    private String getRestoreAdditionalOptions() {
        Project proj = this.getProject();
        String additionalOptions = " ";
        String additionalOptionsProp = proj.getProperty("team.enterprise.deployment.additional.rstobj.params");
        additionalOptions = additionalOptionsProp != null ? (additionalOptionsProp.contains("ALWOBJDIF") ? " " + additionalOptionsProp + " " : " MBROPT(*ALL) ALWOBJDIF(*ALL) ") : " MBROPT(*ALL) ALWOBJDIF(*ALL) ";
        return additionalOptions;
    }

    private void executeRollbackCommands(AS400 connection, Vector<String> rollbackCmds) throws Exception {
        this.createLibrary(this.intermediateSaveFileLibrary, connection);
        boolean success = IBMiRestorePackageTask.executeRemoteCommands(rollbackCmds, "RST", this, connection, false, false);
        if (!success) {
            throw new BuildException(Messages.IBMiRollbackRestoreTask_ONE_OR_MORE_ROLLBACK_COMMANDS_FAILED);
        }
    }

    public boolean libraryExistsOnServer(AS400 connection, String libName) {
        return IAntTaskUtils.doesLibraryExist((AS400)connection, (String)libName);
    }

    public void setIntermediateSaveFileLibrary(String lib) {
        this.intermediateSaveFileLibrary = lib;
    }

    private void createLibrary(String libraryname, AS400 as400) throws BuildException {
        try {
            IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(libraryname)) + libraryname + ".LIB");
            if (!ifsFile.exists()) {
                CRTLIBTask crtLibTask = new CRTLIBTask();
                crtLibTask.setLibraryname(libraryname);
                crtLibTask.setText("'Intermediate Save File Library for Deployment'");
                crtLibTask.setProject(this.getProject());
                crtLibTask.setSystemref("SystemInstance");
                crtLibTask.setASPGroupName(this.getASPGroupName());
                crtLibTask.execute();
            }
        }
        catch (Exception e) {
            throw new BuildException(NLS.bind((String)Messages.IBMiRollbackRestoreTask_CANNOT_CREATE_LIBRARY, (Object)libraryname), (Throwable)e);
        }
    }

    private void addDeleteObjectCommands(AS400 as400, Vector<LibraryRollbackAction> rollbackActions) {
        if (!rollbackActions.isEmpty()) {
            Vector<String> finalRollbackCmds = new Vector<String>();
            for (LibraryRollbackAction rollbackAction : rollbackActions) {
                if (!rollbackAction.action.equals("DLTOBJ")) continue;
                String library = rollbackAction.library;
                String object = ((ObjectRollbackAction)rollbackAction).getObject();
                String type = ((ObjectRollbackAction)rollbackAction).getType();
                String attribute = ((ObjectRollbackAction)rollbackAction).getAttribute();
                boolean isPfFile = false;
                if (attribute != null && "PF-DTA".equals(attribute)) {
                    isPfFile = true;
                }
                if (type.startsWith("*")) {
                    type = type.substring(1);
                }
                try {
                    IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(library)) + library + ".LIB" + "/" + object + "." + type);
                    if (!ifsFile.exists()) continue;
                    if (!isPfFile) {
                        this.rollbackCmds.add(IBMiDeleteObjectCommand.getDeleteObjectCommand(library, object, "*" + type));
                        continue;
                    }
                    finalRollbackCmds.add(IBMiDeleteObjectCommand.getDeleteObjectCommand(library, object, "*" + type));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (String rollbackCmd : finalRollbackCmds) {
                this.rollbackCmds.add(rollbackCmd);
            }
        }
    }

    private boolean getPvtautOption() {
        return this.pvtautOption;
    }

    public class LibraryRollbackAction {
        private String action;
        private String library;

        LibraryRollbackAction(String action, String library) {
            this.action = action;
            this.library = library;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getLibrary() {
            return this.library;
        }

        public void setLibrary(String library) {
            this.library = library;
        }
    }

    public class ObjectRollbackAction
    extends LibraryRollbackAction {
        private String object;
        private String type;
        private String attribute;

        ObjectRollbackAction(String action, String library, String object, String type) {
            super(action, library);
            this.object = object;
            this.type = type;
        }

        ObjectRollbackAction(String action, String library, String object, String type, String attribute) {
            super(action, library);
            this.object = object;
            this.type = type;
            this.attribute = attribute;
        }

        public String getObject() {
            return this.object;
        }

        public void setObject(String object) {
            this.object = object;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }
    }
}

