/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.deployment.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.as400.access.MemberDescription;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.iant.IBMiLibraryValidator;
import com.ibm.iant.IBMiRemoteCommandUtils;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.CRTLIBTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.team.enterprise.deployment.toolkit.util.ContainerMappingProperties;
import com.ibm.teamp.deployment.toolkit.taskdefs.Messages;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class IBMiRestorePackageTask
extends AbstractIBMiCommandTask {
    private final String NUM_OUTPUT_LIBRARIES_PROP = "Bundle-NumberOfOutputLibraries";
    private final String PROPERTY_SEPARATOR = ":";
    private final String TEMP_LIBRARY = "QTEMP";
    private final String SLASH = "/";
    private AS400 connection;
    private String localPackageDir;
    private String intermediateSaveFileLibrary;
    private String packageManifestFile;
    private String restoreMappingFilePath;
    private final Vector<String> restoreCmds = new Vector();
    private final Vector<String> restoreSavf = new Vector();
    private boolean migratePfData = false;
    private boolean migratePfDataWithUsrCmd = false;
    private String restorePfUsrCmd;
    Vector<String> dltPFCmds = new Vector();
    private boolean intermediateSaveFileLibraryExists = false;
    private String tmpPrefix = null;
    private boolean pvtautOption = false;

    public void execute() throws BuildException {
        if (this.connection == null) {
            this.connection = this.getAS400();
        }
        Project proj = this.getProject();
        if (this.localPackageDir == null) {
            this.localPackageDir = proj.getProperty("team.deploy.common.localPackageRoot.dir");
        }
        if (this.intermediateSaveFileLibrary == null) {
            this.intermediateSaveFileLibrary = proj.getProperty("team.deploy.ibmi.intermediateSaveFileLibrary");
            if (this.intermediateSaveFileLibrary != null && !this.intermediateSaveFileLibrary.startsWith("\"")) {
                this.intermediateSaveFileLibrary = this.intermediateSaveFileLibrary.toUpperCase();
            }
        }
        if (this.restoreMappingFilePath == null || this.restoreMappingFilePath.equals("")) {
            this.restoreMappingFilePath = proj.getProperty("team.deploy.common.restoreMappingPath");
            if (this.restoreMappingFilePath == null || this.restoreMappingFilePath.equals("")) {
                this.restoreMappingFilePath = CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj) ? String.valueOf(this.localPackageDir) + "/" + "containerMapper.xml" : String.valueOf(this.localPackageDir) + "/" + "map.mf";
            }
        }
        this.pvtautOption = Boolean.parseBoolean(this.getProject().getProperty("team.package.ibmi.pvtautOption"));
        String restorePfDataOption = proj.getProperty("team.deploy.ibmi.pfRestoreMethod");
        if (restorePfDataOption != null) {
            if ("MIGRATE".equals(restorePfDataOption)) {
                this.migratePfData = true;
            } else if ("USRCMD".equals(restorePfDataOption)) {
                this.migratePfData = true;
                this.restorePfUsrCmd = proj.getProperty("team.deploy.ibmi.pfRestoreUsrCmd");
                if (this.restorePfUsrCmd != null && this.restorePfUsrCmd.length() != 0) {
                    this.migratePfDataWithUsrCmd = true;
                }
            }
        }
        String restorePfUsrCmdOption = proj.getProperty("team.deploy.ibmi.pfRestoreUsrCmd");
        if (this.connection != null) {
            if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj)) {
                this.packageManifestFile = String.valueOf(this.localPackageDir) + "/" + "packageManifest.xml";
                IFSFile mf = new IFSFile(this.connection, this.packageManifestFile);
                try {
                    if (!mf.exists()) {
                        throw new BuildException(NLS.bind((String)Messages.IBMiRestorePackageTask_PACKAGE_MANIFEST_NOT_FOUND, (Object)this.packageManifestFile));
                    }
                    this.populateRestoreSavfAndCmds(mf, proj);
                    this.restoreSavf(this.restoreSavf, this.restoreCmds);
                }
                catch (Exception e) {
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
            } else {
                this.packageManifestFile = String.valueOf(this.localPackageDir) + "/" + "package.mf";
                IFSFile mf = new IFSFile(this.connection, this.packageManifestFile);
                try {
                    if (!mf.exists()) {
                        throw new BuildException(NLS.bind((String)Messages.IBMiRestorePackageTask_PACKAGE_MANIFEST_NOT_FOUND, (Object)this.packageManifestFile));
                    }
                    String numFiles = null;
                    Pattern savfFilePattern = Pattern.compile("SAVF-.*-file");
                    Pattern savfCommandPattern = Pattern.compile("SAVF-.*-command");
                    BufferedReader reader = new BufferedReader((Reader)new IFSFileReader(mf));
                    String mfLine = null;
                    String savf = null;
                    while ((mfLine = reader.readLine()) != null) {
                        String savCommand;
                        String rstCommand;
                        Matcher matchedSavfCommand;
                        Matcher matchedSavfFile;
                        if (mfLine.startsWith("Bundle-NumberOfOutputLibraries")) {
                            numFiles = this.getPropertyValue(mfLine, "Bundle-NumberOfOutputLibraries", ":");
                        }
                        if ((matchedSavfFile = savfFilePattern.matcher(mfLine)).find()) {
                            savf = this.getPropertyValue(mfLine, mfLine.substring(matchedSavfFile.start(), matchedSavfFile.end()), ":");
                            this.restoreSavf.add(savf);
                        }
                        if (!(matchedSavfCommand = savfCommandPattern.matcher(mfLine)).find() || (rstCommand = this.getRestoreCommand(savCommand = this.getPropertyValue(mfLine, mfLine.substring(matchedSavfCommand.start(), matchedSavfCommand.end()), ":"), savf, proj)) == null || rstCommand.equals("")) continue;
                        this.restoreCmds.add(rstCommand);
                    }
                    reader.close();
                    if (this.restoreSavf.size() != Integer.parseInt(numFiles)) {
                        this.log(NLS.bind((String)Messages.IBMiRestorePackageTask_NUMBER_OF_OUTPUT_LIBS_DOES_NOT_MATCH_SAVF_FILES, (Object)this.packageManifestFile), 1);
                    }
                    this.restoreSavf(this.restoreSavf, this.restoreCmds);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.log(Messages.IBMiRestorePackageTask_NO_IBMI_CONNECTION_AVAILABLE, 0);
        }
    }

    private void populateRestoreSavfAndCmds(IFSFile packageManifestXMLFile, Project proj) {
        try {
            IFSFile mappingFile = new IFSFile(this.connection, this.restoreMappingFilePath);
            Properties mappedLib = null;
            if (mappingFile.exists()) {
                mappedLib = this.getRestoreMappingProperties(proj);
            }
            IFSFileInputStream packageManifestXMLStream = new IFSFileInputStream(packageManifestXMLFile);
            Manifest packageManifest = ManifestReader.getInstance().getManifest((InputStream)packageManifestXMLStream);
            List manifestContainers = packageManifest.getContainers();
            String additionalOptions = " ";
            String additionalOptionsProp = proj.getProperty("team.enterprise.deployment.additional.rstobj.params");
            String omitFileOption = " ";
            if (additionalOptionsProp != null) {
                additionalOptions = additionalOptionsProp.contains("ALWOBJDIF") ? String.valueOf(additionalOptions) + additionalOptionsProp : " MBROPT(*ALL) ALWOBJDIF(*ALL)";
            }
            if (this.migratePfData) {
                omitFileOption = " OMITOBJ((*ALL *FILE))";
            }
            for (Container container : manifestContainers) {
                this.restoreSavf.add(container.getName());
                String toLib = container.getName();
                boolean runRestoreAllCommand = true;
                if (this.migratePfData) {
                    runRestoreAllCommand = this.hasNonFileObjects(proj, packageManifest, container);
                }
                if (mappedLib != null) {
                    toLib = mappedLib.getProperty(container.getName());
                }
                if (toLib != null && !toLib.startsWith("\"")) {
                    toLib.toUpperCase();
                }
                String restoreCmd = "RSTOBJ SAVLIB(" + container.getName() + ") SAVF(" + this.intermediateSaveFileLibrary + "/" + container.getName() + ") DEV(*SAVF) OBJ(*ALL) OBJTYPE(*ALL)" + additionalOptions + omitFileOption + this.getPvtautString();
                if (mappedLib != null) {
                    if (toLib != null && !toLib.equals("") && IBMiLibraryValidator.isValidLibraryName((String)toLib)) {
                        this.createLibrary(toLib, this.connection, false);
                        if (runRestoreAllCommand) {
                            this.restoreCmds.add(String.valueOf(restoreCmd) + " RSTLIB(" + toLib + ")");
                        }
                    } else {
                        this.createLibrary(container.getName(), this.connection, false);
                        if (runRestoreAllCommand) {
                            this.restoreCmds.add(restoreCmd);
                        }
                    }
                } else {
                    this.createLibrary(container.getName(), this.connection, false);
                    if (runRestoreAllCommand) {
                        this.restoreCmds.add(restoreCmd);
                    }
                }
                if (!this.migratePfData) continue;
                this.copySavefileToTemp(container.getName());
                this.restoreFilesSeparately(proj, packageManifest, container, container.getName(), toLib, additionalOptions);
            }
            packageManifestXMLStream.close();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasNonFileObjects(Project proj, Manifest packageManifest, Container container) {
        Iterator resourceIterator = container.getResourcesIterator();
        while (resourceIterator.hasNext()) {
            Resource resource = (Resource)resourceIterator.next();
            if (!"IBMiObject".equals(resource.getType()) || "*FILE".equals(resource.getIbmiType())) continue;
            return true;
        }
        return false;
    }

    private void restoreFilesSeparately(Project proj, Manifest packageManifest, Container container, String savLib, String toLib, String additionalOptions) {
        if (toLib == null || toLib.equals("") || !IBMiLibraryValidator.isValidLibraryName((String)toLib)) {
            toLib = savLib;
        }
        if (container.getType().equals("IBMiLibrary")) {
            Iterator resourceIterator = container.getResourcesIterator();
            HashSet<Resource> pfResources = new HashSet<Resource>();
            HashSet<Resource> lfResources = new HashSet<Resource>();
            HashSet<Resource> otherFileResources = new HashSet<Resource>();
            while (resourceIterator.hasNext()) {
                Resource resource = (Resource)resourceIterator.next();
                if (!"IBMiObject".equals(resource.getType()) || !"*FILE".equals(resource.getIbmiType())) continue;
                if ("PF-DTA".equals(resource.getIbmiAttrribute())) {
                    pfResources.add(resource);
                    continue;
                }
                if ("LF".equals(resource.getIbmiAttrribute())) {
                    lfResources.add(resource);
                    continue;
                }
                otherFileResources.add(resource);
            }
            try {
                this.restorePFs(pfResources, savLib, toLib, additionalOptions);
                this.restoreLFs(lfResources, savLib, toLib, additionalOptions);
                this.cleanupTempPFs(savLib, toLib);
                this.restoreOtherFiles(otherFileResources, savLib, toLib, additionalOptions);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void restorePFs(HashSet<Resource> fileResources, String savLib, String toLib, String additionalOptions) throws Exception {
        Iterator<Resource> fileIterator = fileResources.iterator();
        Vector<String> cmds = new Vector<String>();
        while (fileIterator.hasNext()) {
            Resource pf = fileIterator.next();
            String pfName = pf.getName();
            String dltFCmd = null;
            cmds.clear();
            String cmd = "";
            String rstAdditionalOptions = " MBROPT(*ALL) ALWOBJDIF(*ALL)";
            if (additionalOptions != null && !additionalOptions.trim().isEmpty() && additionalOptions.contains("ALWOBJDIF")) {
                rstAdditionalOptions = additionalOptions.contains("MBROPT") ? additionalOptions : " MBROPT(*ALL) " + additionalOptions;
            }
            if (this.fileExists(toLib, pfName)) {
                if (this.fileHasRecords(toLib, pfName)) {
                    if (this.migratePfDataWithUsrCmd) {
                        cmd = this.substituteUsrCmdVariables(this.restorePfUsrCmd, savLib, toLib, this.intermediateSaveFileLibrary, pfName, "*FILE", "PF-DTA");
                        cmds.add(cmd);
                    } else {
                        String backupFileName = this.findUnusedObjectName(toLib, "*FILE", this.getPrefix());
                        if (backupFileName == null) {
                            throw new BuildException(String.valueOf(Messages.IBMiRestorePackageTask_ERROR_FINDING_UNUSED_OBJ_NAME) + toLib);
                        }
                        cmds.add("RNMOBJ OBJ(" + toLib + "/" + pfName + ") OBJTYPE(*FILE) NEWOBJ(" + backupFileName + ")");
                        cmds.add("CHGOBJD OBJ(" + toLib + "/" + backupFileName + ") OBJTYPE(*FILE) TEXT('EWM TEMP OBJ - RENAMED FROM " + pfName + "')");
                        cmds.add("RSTOBJ SAVLIB(" + savLib + ") SAVF(" + this.intermediateSaveFileLibrary + "/" + savLib + ") DEV(*SAVF) OBJ(" + pfName + ") OBJTYPE(*FILE) " + this.getRstObjRstLibClause(savLib, toLib) + rstAdditionalOptions + this.getPvtautString());
                        cmds.add("CPYF FROMFILE(" + toLib + "/" + backupFileName + ") TOFILE(" + toLib + "/" + pfName + ") MBROPT(*REPLACE) FMTOPT(*MAP *DROP) CRTFILE(*NO)");
                        dltFCmd = "DLTF FILE(" + toLib + "/" + backupFileName + ")";
                    }
                } else {
                    cmds.add("RSTOBJ SAVLIB(" + savLib + ") SAVF(" + this.intermediateSaveFileLibrary + "/" + savLib + ") DEV(*SAVF) OBJ(" + pfName + ") OBJTYPE(*FILE) " + this.getRstObjRstLibClause(savLib, toLib) + rstAdditionalOptions + this.getPvtautString());
                }
            } else {
                cmd = "RSTOBJ SAVLIB(" + savLib + ") SAVF(" + this.intermediateSaveFileLibrary + "/" + savLib + ") DEV(*SAVF) OBJ(" + pfName + ") OBJTYPE(*FILE) " + this.getRstObjRstLibClause(savLib, toLib) + additionalOptions + this.getPvtautString();
                cmds.add(cmd);
            }
            if (!IBMiRestorePackageTask.executeRemoteCommands(cmds, "RSTPF[" + toLib + "/" + pfName + "]:", this, this.connection, false, true)) {
                if (this.migratePfDataWithUsrCmd) {
                    this.log(NLS.bind((String)Messages.IBMiRestorePackageTask_ERROR_ON_MIGRATING_WITH_USRCMD, (Object[])new Object[]{cmd, pfName, toLib}), 0);
                    throw new BuildException(NLS.bind((String)Messages.IBMiRestorePackageTask_ERROR_ON_MIGRATING_WITH_USRCMD, (Object[])new Object[]{cmd, pfName, toLib}));
                }
                this.log(NLS.bind((String)Messages.IBMiRestorePackageTask_ERROR_ON_MIGRATING_PF2, (Object[])new Object[]{toLib, pfName, "PF-DTA"}), 0);
                throw new BuildException(NLS.bind((String)Messages.IBMiRestorePackageTask_ERROR_ON_MIGRATING_PF2, (Object[])new Object[]{toLib, pfName, "PF-DTA"}));
            }
            if (dltFCmd == null) continue;
            this.dltPFCmds.add(dltFCmd);
            dltFCmd = null;
        }
    }

    private void cleanupTempPFs(String savLib, String toLib) {
        if (!this.migratePfDataWithUsrCmd) {
            try {
                if (!this.dltPFCmds.isEmpty()) {
                    IBMiRestorePackageTask.executeRemoteCommands(this.dltPFCmds, "CLEAN_TMP_PF:", this, this.connection, false, false);
                }
            }
            catch (Exception e) {
                this.log(String.valueOf(Messages.IBMiRestorePackageTask_WARN_TEMP_PF_NOT_DELETED) + toLib + "/" + this.getPrefix() + "*.", e, 2);
            }
        } else {
            Vector<String> cmds = new Vector<String>();
            String cmd = this.substituteUsrCmdVariables(this.restorePfUsrCmd, savLib, toLib, this.intermediateSaveFileLibrary, "*END", "*FILE", "LF");
            cmds.add(cmd);
            try {
                if (!IBMiRestorePackageTask.executeRemoteCommands(cmds, "CLEAN-USRCMD:", this, this.connection, false, false)) {
                    this.log(String.valueOf(Messages.IBMiRestorePackageTask_WARN_USR_CMD_ERROR_ON_CLEANUP) + cmd, 1);
                }
            }
            catch (Exception e) {
                this.log(String.valueOf(Messages.IBMiRestorePackageTask_WARN_USR_CMD_ERROR_ON_CLEANUP) + cmd, e, 1);
            }
        }
    }

    private void restoreLFs(HashSet<Resource> fileResources, String savLib, String toLib, String additionalOptions) throws Exception {
        Iterator<Resource> fileIterator = fileResources.iterator();
        Vector<String> cmds = new Vector<String>();
        while (fileIterator.hasNext()) {
            String cmd;
            Resource fileResource = fileIterator.next();
            String fileName = fileResource.getName();
            if (this.fileExists(toLib, fileName)) {
                cmd = "DLTF FILE(" + toLib + "/" + fileName + ")";
                cmds.add(cmd);
            }
            cmd = "RSTOBJ SAVLIB(" + savLib + ") SAVF(" + this.intermediateSaveFileLibrary + "/" + savLib + ") DEV(*SAVF) OBJ(" + fileName + ") OBJTYPE(*FILE) " + this.getRstObjRstLibClause(savLib, toLib) + additionalOptions + this.getPvtautString();
            cmds.add(cmd);
        }
        if (!IBMiRestorePackageTask.executeRemoteCommands(cmds, "RSTLF[" + toLib + "]:", this, this.connection, false, false)) {
            this.log(NLS.bind((String)Messages.IBMiRestorePackageTask_ERROR_ON_MIGRATING_FILES, (Object)toLib), 0);
            throw new BuildException(NLS.bind((String)Messages.IBMiRestorePackageTask_ERROR_ON_MIGRATING_FILES, (Object)toLib));
        }
    }

    private void restoreOtherFiles(HashSet<Resource> fileResources, String savLib, String toLib, String additionalOptions) throws Exception {
        Iterator<Resource> fileIterator = fileResources.iterator();
        Vector<String> cmds = new Vector<String>();
        while (fileIterator.hasNext()) {
            Resource fileResource = fileIterator.next();
            String fileName = fileResource.getName();
            String cmd = "RSTOBJ SAVLIB(" + savLib + ") SAVF(" + this.intermediateSaveFileLibrary + "/" + savLib + ") DEV(*SAVF) OBJ(" + fileName + ") OBJTYPE(*FILE)" + this.getRstObjRstLibClause(savLib, toLib) + additionalOptions + this.getPvtautString();
            cmds.add(cmd);
        }
        if (!IBMiRestorePackageTask.executeRemoteCommands(cmds, "RSTF[" + toLib + "]:", this, this.connection, false, false)) {
            this.log(NLS.bind((String)Messages.IBMiRestorePackageTask_ERROR_ON_MIGRATING_FILES, (Object)toLib), 0);
            throw new BuildException(NLS.bind((String)Messages.IBMiRestorePackageTask_ERROR_ON_MIGRATING_FILES, (Object)toLib));
        }
    }

    private String substituteUsrCmdVariables(String cmdTemplate, String savLib, String toLib, String tempLib, String fileName, String objType, String fileAttr) {
        String returnString = new String(cmdTemplate);
        returnString = returnString.replaceAll("&S", this.squote(savLib));
        returnString = returnString.replaceAll("&R", this.squote(toLib));
        returnString = returnString.replaceAll("&W", this.squote(tempLib));
        returnString = returnString.replaceAll("&N", this.squote(fileName));
        returnString = returnString.replaceAll("&T", this.squote(objType));
        returnString = returnString.replaceAll("&A", this.squote(fileAttr));
        return returnString;
    }

    private String squote(String orig) {
        return new String("'" + orig + "'");
    }

    private String getRstObjRstLibClause(String savLib, String toLib) {
        if (savLib.equalsIgnoreCase(toLib)) {
            return new String(" ");
        }
        return new String(" RSTLIB(" + toLib + ") ");
    }

    private boolean restoreSavf(Vector<String> restoreSavf, Vector<String> restoreCmds) throws BuildException {
        if (restoreSavf.size() != restoreCmds.size()) {
            this.log(Messages.IBMiRestorePackageTask_NUM_SAVF_FILE_OBJS_DOESNT_EQUAL_SAVF_CMD_OBJECTS, 1);
        }
        if (this.connection != null && this.connection.isConnected()) {
            try {
                if (!this.migratePfData) {
                    if (this.intermediateSaveFileLibrary == null) {
                        this.intermediateSaveFileLibrary = "QTEMP";
                    }
                    this.createLibrary(this.intermediateSaveFileLibrary, this.connection, true);
                    for (String savf : restoreSavf) {
                        String savfName = this.getSavfName(savf);
                        String copyCmd = "CPYFRMSTMF FROMSTMF('" + this.localPackageDir + "/" + savfName + ".savf" + "') TOMBR('" + this.getBaseIFSPath(this.intermediateSaveFileLibrary) + this.intermediateSaveFileLibrary + ".LIB" + "/" + savfName + ".FILE" + "') MBROPT(*REPLACE)";
                        restoreCmds.add(0, copyCmd);
                    }
                }
                if (!IBMiRestorePackageTask.executeRemoteCommands(restoreCmds, "RST", this, this.connection, false, false)) {
                    throw new BuildException(Messages.IBMiRestorePackageTask_AT_LEAST_ONE_RSTOBJ_CMD_EXECUTION_FAILED);
                }
                this.deleteTempSaveFiles(restoreSavf);
            }
            catch (Exception e) {
                this.log(e.toString());
                throw new BuildException(NLS.bind((String)Messages.IBMiRestorePackageTask_UNEXPECTED_ERROR_RESTORING_SAVE_FILE, (Object)((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            }
        } else {
            this.log(Messages.IBMiRestorePackageTask_NO_IBMI_CONNECTION_AVAILABLE, 0);
        }
        return true;
    }

    private void copySavefileToTemp(String savf) throws BuildException {
        try {
            if (this.intermediateSaveFileLibrary == null) {
                this.intermediateSaveFileLibrary = "QTEMP";
            }
            if (!this.intermediateSaveFileLibraryExists) {
                this.createLibrary(this.intermediateSaveFileLibrary, this.connection, true);
                this.intermediateSaveFileLibraryExists = true;
            }
            Vector<String> cpySavfCmds = new Vector<String>();
            String savfName = this.getSavfName(savf);
            String copyCmd = "CPYFRMSTMF FROMSTMF('" + this.localPackageDir + "/" + savfName + ".savf" + "') TOMBR('" + this.getBaseIFSPath(this.intermediateSaveFileLibrary) + this.intermediateSaveFileLibrary + ".LIB" + "/" + savfName + ".FILE" + "') MBROPT(*REPLACE)";
            cpySavfCmds.add(copyCmd);
            if (!IBMiRestorePackageTask.executeRemoteCommands(cpySavfCmds, "RST", this, this.connection, false, false)) {
                throw new BuildException(Messages.IBMiRestorePackageTask_AT_LEAST_ONE_RSTOBJ_CMD_EXECUTION_FAILED);
            }
        }
        catch (Exception e) {
            this.log(e.toString());
            throw new BuildException(NLS.bind((String)Messages.IBMiRestorePackageTask_UNEXPECTED_ERROR_RESTORING_SAVE_FILE, (Object)((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
        }
    }

    public static boolean executeRemoteCommands(Vector<String> cmds, String prefix, AbstractIBMiCommandTask task, AS400 connection, boolean quietly, boolean quitOnFirstFailure) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        boolean allCommandsSucceded = true;
        boolean RSTCommand = false;
        for (String c : cmds) {
            String remoteCmd = c;
            if (remoteCmd.length() > 0) {
                CommandCall cmd = new CommandCall(connection);
                cmd.setMessageOption(2);
                if (!quietly) {
                    task.log(String.valueOf(prefix) + ">>" + remoteCmd);
                }
                boolean success = cmd.run(remoteCmd);
                RSTCommand = (remoteCmd.startsWith("RSTOBJ") || remoteCmd.startsWith("RSTLIB")) && remoteCmd.contains("ALWOBJDIF");
                if (!success && !RSTCommand) {
                    allCommandsSucceded = false;
                }
                AS400Message[] messageList = cmd.getMessageList();
                int highestSev = 0;
                boolean differencesFound = false;
                AS400Message lastMsg = null;
                if (messageList.length > 0) {
                    AS400Message[] aS400MessageArray = messageList;
                    int n = messageList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AS400Message m = aS400MessageArray[n2];
                        if (RSTCommand) {
                            if (m.getSeverity() > highestSev) {
                                highestSev = m.getSeverity();
                            }
                            if (!differencesFound && (m.getID().equals("CPF3848") || m.getID().equals("CPI320A"))) {
                                differencesFound = true;
                            }
                        }
                        if (!quietly) {
                            Thread.sleep(1L);
                            task.log("  <<" + m.getID() + " - " + m.getSeverity() + ": " + m.getText(), success ? 2 : 0);
                            if (m.getHelp() != null && !m.getHelp().equals("")) {
                                task.log("  <<" + m.getHelp(), success ? 2 : 0);
                            }
                            Thread.sleep(1L);
                        }
                        lastMsg = m;
                        ++n2;
                    }
                }
                if (!(success || !RSTCommand || differencesFound && lastMsg.getType() == 15 && highestSev <= 20)) {
                    allCommandsSucceded = false;
                }
                if (success || !quitOnFirstFailure || highestSev <= 20) continue;
                return false;
            }
            if (quietly) continue;
            Thread.sleep(1L);
            task.log(String.valueOf(prefix) + Messages.IBMiRestorePackageTask_ERROR_NOTHING_TO_EXECUTE, 0);
            Thread.sleep(1L);
        }
        return allCommandsSucceded;
    }

    private void deleteTempSaveFiles(Vector<String> savfs) {
        Vector<String> dltfCommandVector = new Vector<String>();
        for (String l : savfs) {
            dltfCommandVector.add("DLTF FILE(" + this.intermediateSaveFileLibrary + "/" + l + ")");
        }
        try {
            if (!IBMiRemoteCommandUtils.executeRemoteCommands(dltfCommandVector, (String)"DLTF", (AbstractIBMiCommandTask)this, (AS400)this.connection, (boolean)false)) {
                this.log(Messages.IBMiRestorePackageTask_ERROR_ON_TEMP_SAVF_CLEANUP, 1);
            }
        }
        catch (Exception e) {
            this.log(Messages.IBMiRestorePackageTask_ERROR_ON_TEMP_SAVF_CLEANUP, e, 1);
        }
    }

    private String getSavfName(String savf) {
        int i = savf.lastIndexOf("/");
        int k = savf.lastIndexOf(".");
        if (i != -1 && k != -1) {
            return savf.substring(i + 1, k);
        }
        return savf;
    }

    private String getRestoreCommand(String packageCmd, String savf, Project project) {
        String restoreCmd = null;
        packageCmd = packageCmd.toUpperCase();
        if (this.intermediateSaveFileLibrary == null) {
            this.intermediateSaveFileLibrary = "QTEMP";
        }
        this.log(NLS.bind((String)Messages.IBMiRestorePackageTask_PACKAGE_COMMAND, (Object)packageCmd), 1);
        if (packageCmd.startsWith("SAVLIB")) {
            restoreCmd = packageCmd.replace("SAVLIB", "RSTLIB");
            restoreCmd = restoreCmd.replace("LIB(", "SAVLIB(");
            restoreCmd = restoreCmd.replaceAll("SAVF\\(.*/", "SAVF(" + this.intermediateSaveFileLibrary + "/");
            restoreCmd = restoreCmd.replaceAll("TGTRLS\\([^\\)]*\\) ", " ");
        } else if (savf != null) {
            String savfName = this.getSavfName(savf);
            restoreCmd = "RSTOBJ SAVLIB(" + savfName + ") SAVF(" + this.intermediateSaveFileLibrary + "/" + savfName + ") DEV(*SAVF) OBJ(*ALL) OBJTYPE(*ALL)" + this.getPvtautString();
        }
        restoreCmd = this.getRestoreLibrary(restoreCmd, project);
        this.log(NLS.bind((String)Messages.IBMiRestorePackageTask_RESTORE_COMMAND, (Object)restoreCmd), 1);
        return restoreCmd;
    }

    private String getPropertyValue(String line, String property, String separator) {
        int start = line.indexOf(separator);
        return line.substring(start + 2);
    }

    public void setLocalPackageDir(String dir) {
        this.localPackageDir = dir;
    }

    public void setIntermediateSaveFileLibrary(String lib) {
        this.intermediateSaveFileLibrary = lib;
    }

    public void setRestoreMappingFilePath(String restorMappingFile) {
        this.restoreMappingFilePath = restorMappingFile;
    }

    private Properties getRestoreMappingProperties(Project project) throws Exception {
        IFSFile mappingsFile = new IFSFile(this.connection, this.restoreMappingFilePath);
        return ContainerMappingProperties.getRestoreMappingProperties((Project)project, (InputStream)new IFSFileInputStream(mappingsFile), (Reader)new IFSFileReader(mappingsFile));
    }

    private String getRestoreLibrary(String restoreCmd, Project project) {
        int end;
        IFSFile mappingFile = new IFSFile(this.connection, this.restoreMappingFilePath);
        String restoreLibCmd = restoreCmd;
        int start = restoreCmd.indexOf("SAVLIB(");
        String fromLib = restoreCmd.substring(start + 7, end = restoreCmd.indexOf(")"));
        if (fromLib != null && !fromLib.startsWith("\"")) {
            fromLib = fromLib.toUpperCase();
        }
        try {
            if (mappingFile.exists()) {
                Properties mappedLib = this.getRestoreMappingProperties(project);
                if (fromLib != "" && mappedLib != null) {
                    String toLib = mappedLib.getProperty(fromLib);
                    if (toLib != null && !toLib.startsWith("\"")) {
                        toLib = toLib.toUpperCase();
                    }
                    if (toLib != null && !toLib.equals("") && IBMiLibraryValidator.isValidLibraryName((String)toLib)) {
                        this.createLibrary(toLib, this.connection, false);
                        restoreLibCmd = String.valueOf(restoreCmd) + " RSTLIB(" + toLib + ")";
                    }
                }
            } else if (fromLib != "") {
                this.createLibrary(fromLib, this.connection, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return restoreLibCmd;
    }

    private void createLibrary(String libraryname, AS400 as400, boolean isIntermediate) throws BuildException {
        try {
            IFSFile ifsFile = new IFSFile(as400, String.valueOf(this.getBaseIFSPath(libraryname)) + libraryname + ".LIB");
            if (!ifsFile.exists()) {
                CRTLIBTask crtLibTask = new CRTLIBTask();
                crtLibTask.setLibraryname(libraryname);
                if (!isIntermediate) {
                    crtLibTask.setText("'Deployment Restore To Library'");
                } else {
                    crtLibTask.setText("'Intermediate Save File Library for Deployment'");
                }
                crtLibTask.setProject(this.getProject());
                crtLibTask.setSystemref("SystemInstance");
                crtLibTask.setASPGroupName(this.getASPGroupName());
                crtLibTask.execute();
            }
        }
        catch (Exception e) {
            throw new BuildException(NLS.bind((String)Messages.IBMiRestorePackageTask_CANNOT_CREATE_LIBRARY_ERROR, (Object)libraryname), (Throwable)e);
        }
    }

    private boolean fileExists(String libraryName, String fileName) throws Exception {
        try {
            IFSFile ifsFile = new IFSFile(this.connection, String.valueOf(this.getBaseIFSPath(libraryName)) + libraryName + ".LIB" + "/" + fileName + ".FILE");
            return ifsFile.exists();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fileHasRecords(String libraryName, String fileName) throws Exception {
        try {
            String ifsFileName = String.valueOf(this.getBaseIFSPath(libraryName)) + libraryName + ".LIB" + "/" + fileName + ".FILE";
            IFSFile ifsFile = new IFSFile(this.connection, ifsFileName);
            String[] ifsMemberNames = ifsFile.list();
            if (ifsMemberNames.length == 0) {
                return false;
            }
            String[] stringArray = ifsMemberNames;
            int n = ifsMemberNames.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String ifsMemberName = stringArray[n2];
                String memberName = this.stripExtension(ifsMemberName);
                if (!ifsMemberName.equals(memberName)) {
                    String longMemberName = String.valueOf(ifsFileName) + "/" + ifsMemberName;
                    MemberDescription mbrd = new MemberDescription(this.connection, longMemberName);
                    int numRecords = (Integer)mbrd.getValue(13);
                    if (numRecords != 0) return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private String stripExtension(String ifsLeafName) {
        int i = ifsLeafName.lastIndexOf(".");
        if (i != -1) {
            return ifsLeafName.substring(0, i);
        }
        return ifsLeafName;
    }

    private void debugLogCommands(Vector<String> cmds, String title) {
        this.log("===============================");
        this.log("DEBUG COMMANDS LIST: " + title);
        this.log("===============================");
        for (String c : cmds) {
            this.log("  CMD: " + c);
        }
        this.log("===============================");
    }

    private String findUnusedObjectName(String lib, String objType, String prefix) {
        String objNameFilter = String.valueOf(prefix) + "*";
        int i = 9999999;
        boolean candidateFound = false;
        String unusedName = null;
        List<ISeriesHostObjectBasic> existingObjects = this.resolveFilteredObjects(lib, objNameFilter, objType, "*");
        if (existingObjects.isEmpty()) {
            unusedName = this.createFileName(prefix, i);
        }
        while (i >= 0 && !candidateFound) {
            String candidate = this.createFileName(prefix, i);
            boolean isCandidateStillViable = true;
            for (ISeriesHostObjectBasic o : existingObjects) {
                if (!candidate.equals(o.getName())) continue;
                isCandidateStillViable = false;
                break;
            }
            if (isCandidateStillViable) {
                unusedName = candidate;
                candidateFound = true;
                break;
            }
            --i;
        }
        if (unusedName != null) {
            return unusedName;
        }
        return null;
    }

    private String createFileName(String prefix, int suffix) {
        return String.format("%3s%07d", prefix, suffix);
    }

    private List<ISeriesHostObjectBasic> resolveFilteredObjects(String lib, String obj, String type, String attr) {
        String filterString = String.valueOf(lib) + "/" + obj + " OBJTYPE(" + type + ":" + attr + ")";
        List foundObjects = IAntTaskUtils.getObjectListForFilterString((String)filterString, (AS400)this.connection);
        return foundObjects;
    }

    private String getPrefix() {
        if (this.tmpPrefix == null) {
            this.tmpPrefix = "QJX";
        }
        return this.tmpPrefix;
    }

    private boolean getPvtautOption() {
        return this.pvtautOption;
    }

    private String getPvtautString() {
        return this.getPvtautOption() ? " PVTAUT(*YES) " : "";
    }

    private void debugLogHostObjects(List<ISeriesHostObjectBasic> hostObjects, String title) {
        this.log("===============================");
        this.log("LIST OF OBJECTS: " + title);
        this.log("===============================");
        for (ISeriesHostObjectBasic obj : hostObjects) {
            this.log("  " + obj.getLibrary() + "/" + obj.getName() + " OBJTYPE(" + obj.getType() + ":" + obj.getSubType() + ")");
        }
        this.log("==========END==================");
    }
}

