/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.deployment.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400FTP;
import com.ibm.iant.IBMiRemoteCommandUtils;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.types.IBMiRemoteCommand;
import com.ibm.teamp.deployment.toolkit.taskdefs.Messages;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public class IBMiLoadTask
extends AbstractIBMiCommandTask {
    private Vector<IBMiRemoteCommand> beforeCommands = new Vector();
    private Vector<IBMiRemoteCommand> afterCommands = new Vector();
    private String localFolder = null;
    private String remoteFolder = null;
    private String mountedDrivePrefix = null;
    private int dataTransferType = -1;
    private int port = -1;
    private int bufferSize = -1;
    private int push = -1;
    private Vector<FileFilter> fileFilters = new Vector();
    private HashSet<String> fileObjects = new HashSet();
    private final int YES = 1;
    private final int NO = 0;
    private final int BINARY = 1;
    private final int ASCII = 0;
    private final String SLASH = "/";
    private static AS400 connection = null;
    private static AS400 remoteTargetConnection = null;
    private String remoteHostname = null;
    private String remoteUserid = null;
    private String remotePassword = null;

    public void execute() {
        if (connection == null) {
            connection = this.getAS400();
        }
        this.updateTaskAttributesWithProperties();
        if (remoteTargetConnection == null && this.remoteHostname != null && this.remoteHostname.length() >= 1 && this.remoteUserid != null && this.remoteUserid.length() >= 1 && this.remotePassword != null && this.remotePassword.length() >= 1) {
            try {
                remoteTargetConnection = new AS400(this.remoteHostname, this.remoteUserid, this.remotePassword);
                remoteTargetConnection.setGuiAvailable(false);
                remoteTargetConnection.connectService(2);
            }
            catch (Exception e) {
                throw new BuildException(Messages.IBMiLoadTask_FAILED_TO_CREATE_IBMI_CONNECTION, (Throwable)e);
            }
        }
        AS400FTP ftpRemote = new AS400FTP(remoteTargetConnection);
        AS400FTP ftpLocal = new AS400FTP(connection);
        if (this.localFolder == null || this.localFolder.length() < 1 || this.remoteFolder == null || this.remoteFolder.length() < 1 || this.fileFilters.size() == 0 || ftpRemote == null) {
            this.log(Messages.IBMiLoadTask_MISSING_REQUIRED_ATTRIBUTES, 0);
        } else {
            try {
                boolean isSourceFolderValid;
                IBMiRemoteCommandUtils.executeIBMiRemoteCommands(this.beforeCommands, (String)"PRE ", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false);
                ftpLocal.connect();
                ftpRemote.connect();
                boolean bl = isSourceFolderValid = this.push == 0 ? ftpRemote.setCurrentDirectory(this.remoteFolder) : ftpLocal.setCurrentDirectory(this.localFolder);
                if (isSourceFolderValid) {
                    if (this.dataTransferType == -1 || this.dataTransferType == 1) {
                        ftpRemote.setDataTransferType(1);
                    }
                    if (this.bufferSize != -1) {
                        ftpRemote.setBufferSize(this.bufferSize);
                    }
                    if (this.port != -1) {
                        ftpRemote.setPort(this.port);
                    }
                    for (FileFilter ff : this.fileFilters) {
                        String fn = ff.getFilter();
                        String[] fna = this.push == 1 ? ftpLocal.ls(fn) : ftpRemote.ls(fn);
                        String s1 = "[" + fn + "]-->";
                        String[] stringArray = fna;
                        int n = fna.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            this.fileObjects.add(s);
                            s1 = String.valueOf(s1) + "[" + s + "]";
                            ++n2;
                        }
                        this.log(s1, 3);
                    }
                    this.performTransfer(ftpRemote);
                } else {
                    this.log(NLS.bind((String)Messages.IBMiLoadTask_SOURCE_FOLDER_MISSING_ABORTING_TRANSFER, (Object)(this.push == 0 ? this.remoteFolder : this.localFolder), (Object)(this.push == 0 ? remoteTargetConnection.getSystemName() : connection.getSystemName())), 0);
                }
                IBMiRemoteCommandUtils.executeIBMiRemoteCommands(this.afterCommands, (String)"POST", (AbstractIBMiCommandTask)this, (AS400)connection, (boolean)false);
            }
            catch (Exception e) {
                this.log(e.toString());
                throw new BuildException(NLS.bind((String)Messages.IBMiLoadTask_UNEXPECTED_EXCEPTION_LOADING_OBJECTS, (Object)((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            }
        }
    }

    private void performTransfer(AS400FTP ftp) throws IOException {
        int bad = 0;
        String localFileFolder = String.valueOf(this.mountedDrivePrefix != null && this.mountedDrivePrefix.length() > 1 ? this.mountedDrivePrefix : "") + this.localFolder;
        if (this.push == 1) {
            if (ftp.cd(this.remoteFolder)) {
                for (String s : this.fileObjects) {
                    this.log("  >> PUT " + s);
                    bad += ftp.put(String.valueOf(localFileFolder) + "/" + s, s) ? 0 : 1;
                    this.log("  <<" + ftp.getLastMessage());
                }
                this.log(NLS.bind((String)Messages.IBMiLoadTask_TRANSFERED_OBJECTS_FROM_MESSAGE, (Object[])new Object[]{this.fileObjects.size(), localFileFolder, remoteTargetConnection.getSystemName(), this.remoteFolder, bad}));
            } else {
                this.log(NLS.bind((String)Messages.IBMiLoadTask_REMOTE_DESTINATION_DOES_NOT_EXIST_ABORT_MSG, (Object)this.remoteFolder, (Object)remoteTargetConnection.getSystemName()), 0);
            }
        } else {
            File d = new File(localFileFolder);
            if (!d.exists()) {
                d.mkdirs();
            }
            if (!d.exists()) {
                this.log(NLS.bind((String)Messages.IBMiLoadTask_LOAD_DESTINATION_DOES_NOT_EXIST_ABORT_MSG, (Object)this.localFolder), 0);
            } else {
                for (String s : this.fileObjects) {
                    this.log("  >> GET " + s);
                    bad += ftp.get(s, String.valueOf(localFileFolder) + "/" + s) ? 0 : 1;
                    this.log("  <<" + ftp.getLastMessage());
                }
                this.log(NLS.bind((String)Messages.IBMiLoadTask_TRANSFERED_OBJECTS_TO_MESSAGE, (Object[])new Object[]{this.fileObjects.size(), localFileFolder, remoteTargetConnection.getSystemName(), this.remoteFolder, bad}));
            }
        }
    }

    private void updateTaskAttributesWithProperties() {
        if (this.localFolder == null) {
            this.localFolder = this.computeInitialStringValue("team.package.dir", "");
        }
        if (this.remoteFolder == null) {
            this.remoteFolder = this.computeInitialStringValue("team.deploy.common.loadPackageRoot.dir", "");
        }
        if (this.mountedDrivePrefix == null) {
            this.mountedDrivePrefix = this.computeInitialStringValue("team.transfer.ibmi.mountedDrivePrefix", "");
        }
        if (this.fileFilters.size() == 0) {
            String p = this.getProject().getProperty("team.transfer.ibmi.fileFilters");
            if (p != null && p.length() > 0) {
                FileFilter c = new FileFilter();
                this.fileFilters.add(c);
                c.setFilter(p);
            } else {
                FileFilter c = new FileFilter();
                this.fileFilters.add(c);
                c.setFilter("*");
            }
        }
        if (this.dataTransferType == -1) {
            this.dataTransferType = this.computeInitialIntegerValue("team.transfer.ibmi.dataTransferType", -1);
        }
        if (this.port == -1) {
            this.port = this.computeInitialIntegerValue("team.transfer.ibmi.port", -1);
        }
        if (this.push == -1) {
            this.push = this.computeInitialIntegerValue("team.transfer.ibmi.push", 0);
        }
        if (this.bufferSize == -1) {
            this.bufferSize = this.computeInitialIntegerValue("team.transfer.ibmi.bufferSize", -1);
        }
        if (this.remoteHostname == null) {
            this.remoteHostname = this.computeInitialStringValue("team.deploy.common.load.ftp.hostname", "");
        }
        if (this.remoteUserid == null) {
            this.remoteUserid = this.computeInitialStringValue("team.deploy.common.load.ftp.userid", "");
        }
        if (this.remotePassword == null) {
            this.remotePassword = this.computeInitialStringValue("team.deploy.common.load.ftp.password", "");
        }
    }

    private int computeInitialIntegerValue(String propertyName, int defaultValue) {
        String p = this.getProject().getProperty(propertyName);
        return p != null && p.length() > 0 ? Integer.parseInt(p) : defaultValue;
    }

    private String computeInitialStringValue(String propertyName, String defaultValue) {
        String p = this.getProject().getProperty(propertyName);
        return p != null && p.length() > 0 ? p : defaultValue;
    }

    public FileFilter createFileFilters() {
        FileFilter c = new FileFilter();
        this.fileFilters.add(c);
        return c;
    }

    public IBMiRemoteCommand createPost() {
        IBMiRemoteCommand c = new IBMiRemoteCommand();
        this.afterCommands.add(c);
        return c;
    }

    public IBMiRemoteCommand createPre() {
        IBMiRemoteCommand c = new IBMiRemoteCommand();
        this.beforeCommands.add(c);
        return c;
    }

    public void setLocalFolder(String localFolder) {
        if (localFolder != null && localFolder.length() > 0) {
            this.localFolder = localFolder;
        }
    }

    public void setRemoteFolder(String remoteFolder) {
        if (remoteFolder != null && remoteFolder.length() > 0) {
            this.remoteFolder = remoteFolder;
        }
    }

    public void setMountedDrivePrefix(String mountedDrivePrefix) {
        if (mountedDrivePrefix != null && mountedDrivePrefix.length() > 0) {
            this.mountedDrivePrefix = mountedDrivePrefix;
        }
    }

    public void setRemoteHostname(String remoteHostname) {
        if (remoteHostname != null && remoteHostname.length() > 0) {
            this.remoteHostname = remoteHostname;
        }
    }

    public void setRemoteUserid(String remoteUserid) {
        if (remoteUserid != null && remoteUserid.length() > 0) {
            this.remoteUserid = remoteUserid;
        }
    }

    public void setRemotePassword(String remotePassword) {
        if (remotePassword != null && remotePassword.length() > 0) {
            this.remotePassword = remotePassword;
        }
    }

    public void setDataTransferType(String dataTransferType) {
        try {
            this.dataTransferType = dataTransferType.trim().compareToIgnoreCase("bin") == 0 ? 1 : 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setPort(String port) {
        try {
            this.port = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setPush(String push) {
        this.push = push.trim().compareToIgnoreCase("true") == 0 ? 1 : 0;
    }

    public void setBufferSize(String bufferSize) {
        try {
            this.bufferSize = Integer.parseInt(bufferSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setTargetHostCredentials(String hc) {
        String[] credentials = hc.split("[:\\s]");
        if (credentials.length == 3) {
            try {
                remoteTargetConnection = new AS400(credentials[0], credentials[1], credentials[2]);
                remoteTargetConnection.setGuiAvailable(false);
                remoteTargetConnection.connectService(2);
            }
            catch (Exception e) {
                throw new BuildException(Messages.IBMiLoadTask_FAILED_TO_CREATE_TARGET_IBMI_CONNECTION, (Throwable)e);
            }
        }
    }

    public void setLocalHostCredentials(String hc) {
        String[] credentials = hc.split("[:\\s]");
        if (credentials.length == 3) {
            try {
                connection = new AS400(credentials[0], credentials[1], credentials[2]);
                connection.setGuiAvailable(false);
                connection.connectService(2);
            }
            catch (Exception e) {
                throw new BuildException(Messages.IBMiLoadTask_FAILED_TO_CREATE_IBMI_CONNECTION, (Throwable)e);
            }
        }
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public String getRemoteUserid() {
        return this.remoteUserid;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public class FileFilter {
        private String filter = "";

        public FileFilter() {
        }

        public FileFilter(String filter) {
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String s) {
            this.filter = s;
        }
    }
}

