/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.deployment.toolkit.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.as400.access.IFSFileWriter;
import com.ibm.iant.IBMiRemoteCommandUtils;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.CRTLIBTask;
import com.ibm.team.enterprise.deployment.toolkit.util.CheckDeploymentVersions;
import com.ibm.team.enterprise.deployment.toolkit.util.ContainerMappingProperties;
import com.ibm.teamp.deployment.toolkit.taskdefs.Messages;
import com.ibm.teamp.ibmi.automation.toolkit.IBMiLibraryValidater;
import com.ibm.teamp.ibmi.automation.toolkit.util.IBMiUSRSPC;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.osgi.util.NLS;

public class CopyOfIBMiSaveRollbackTask
extends AbstractIBMiCommandTask {
    private final String NUM_OUTPUT_LIBRARIES_PROP = "Bundle-NumberOfOutputLibraries";
    private final String PROPERTY_SEPARATOR = ":";
    private final String TEMP_LIBRARY = "QTEMP";
    private final String SLASH = "/";
    private AS400 connection;
    private String localPackageDir;
    private String intermediateSaveFileLibrary;
    private String packageManifestFile;
    private String restoreMappingFilePath;
    private String rollbackDir;
    Properties restoreMappingProperties = null;
    private boolean pvtautOption = false;
    private final Vector<String> saveCmds = new Vector();
    private final Vector<String> savefiles = new Vector();
    private final Vector<String> saveLibs = new Vector();
    private final Vector<String> saveObjs = new Vector();
    private final Vector<String> dltObjs = new Vector();
    private final Vector<String> allLibs = new Vector();

    public String getRollbackDir() {
        return this.rollbackDir;
    }

    public void setRollbackDir(String rollbackDir) {
        this.rollbackDir = rollbackDir;
    }

    public void execute() throws BuildException {
        if (this.connection == null) {
            this.connection = this.getAS400();
        }
        Project proj = this.getProject();
        if (this.localPackageDir == null) {
            this.localPackageDir = proj.getProperty("team.deploy.common.localPackageRoot.dir");
        }
        if (this.intermediateSaveFileLibrary == null) {
            this.intermediateSaveFileLibrary = proj.getProperty("team.deploy.ibmi.intermediateSaveFileLibrary");
            if (this.intermediateSaveFileLibrary != null && !this.intermediateSaveFileLibrary.startsWith("\"")) {
                this.intermediateSaveFileLibrary = this.intermediateSaveFileLibrary.toUpperCase();
            }
        }
        if (this.restoreMappingFilePath == null || this.restoreMappingFilePath.equals("")) {
            this.restoreMappingFilePath = proj.getProperty("team.deploy.common.restoreMappingPath");
            if (this.restoreMappingFilePath == null || this.restoreMappingFilePath.equals("")) {
                this.restoreMappingFilePath = CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj) ? String.valueOf(this.localPackageDir) + "/" + "containerMapper.xml" : String.valueOf(this.localPackageDir) + "/" + "map.mf";
            }
        }
        this.restoreMappingProperties = this.getRestoreMappingProperties(proj);
        if (this.rollbackDir == null) {
            this.rollbackDir = proj.getProperty("team.deploy.common.rollback.dir");
        }
        this.pvtautOption = Boolean.parseBoolean(this.getProject().getProperty("team.package.ibmi.pvtautOption"));
        this.packageManifestFile = String.valueOf(this.localPackageDir) + "/" + "package.mf";
        if (this.connection != null) {
            IFSFile mf = new IFSFile(this.connection, this.packageManifestFile);
            IFSFile rollbackIFSDir = new IFSFile(this.connection, this.rollbackDir);
            try {
                if (!mf.exists()) {
                    throw new BuildException(NLS.bind((String)Messages.CopyOfIBMiSaveRollbackTask_PACKAGE_MANIFEST_NOT_FOUND, (Object)this.packageManifestFile));
                }
                if (!rollbackIFSDir.exists()) {
                    rollbackIFSDir.mkdirs();
                }
                if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)proj)) {
                    this.createSavfCmdsFromPackageManifestXML(mf);
                } else {
                    this.createSavfCmdsFromPackageManifest(mf);
                }
                this.saveRollback(this.saveCmds, this.saveLibs, this.allLibs, proj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.log(Messages.CopyOfIBMiSaveRollbackTask_NO_CONNECTION_AVAILABLE, 0);
        }
    }

    private void createSavfCmdsFromPackageManifestXML(IFSFile mf) {
    }

    private void createSavfCmdsFromPackageManifest(IFSFile mf) throws AS400SecurityException, IOException, Exception {
        String numFiles = null;
        Pattern savfFilePattern = Pattern.compile("SAVF-.*-file");
        Pattern savfObjectPattern = Pattern.compile("SAVF-.*-object\\[");
        BufferedReader reader = new BufferedReader((Reader)new IFSFileReader(mf));
        String mfLine = null;
        String savf = null;
        String object = null;
        while ((mfLine = reader.readLine()) != null) {
            Matcher matchedObject;
            Matcher matchedSavfFile;
            if (mfLine.startsWith("Bundle-NumberOfOutputLibraries")) {
                numFiles = this.getPropertyValue(mfLine, "Bundle-NumberOfOutputLibraries", ":");
            }
            if ((matchedSavfFile = savfFilePattern.matcher(mfLine)).find()) {
                savf = this.getPropertyValue(mfLine, mfLine.substring(matchedSavfFile.start(), matchedSavfFile.end()), ":");
                this.savefiles.add(savf);
            }
            if (!(matchedObject = savfObjectPattern.matcher(mfLine)).find()) continue;
            object = this.getPropertyValue(mfLine, mfLine.substring(matchedObject.start(), matchedObject.end()), ":");
            this.saveObjs.add(object);
        }
        reader.close();
        for (String savfile : this.savefiles) {
            String saveCmd = this.getSaveCommand(savfile);
            if (saveCmd == null) continue;
            this.saveCmds.add(saveCmd);
        }
        if (this.savefiles.size() != Integer.parseInt(numFiles)) {
            this.log(NLS.bind((String)Messages.CopyOfIBMiSaveRollbackTask_NUMBER_OF_OUTPUT_LIBRARIES_DOES_NOT_MATCH_SAVE_FILES, (Object)this.packageManifestFile), 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean saveRollback(Vector<String> saveCmds, Vector<String> saveLibraries, Vector<String> allLibraries, Project project) throws BuildException {
        if (this.connection != null && this.connection.isConnected()) {
            try {
                if (this.intermediateSaveFileLibrary == null) {
                    this.intermediateSaveFileLibrary = "QTEMP";
                }
                if (!saveLibraries.isEmpty()) {
                    this.createLibrary(this.intermediateSaveFileLibrary, this.connection);
                    String timestamp = null;
                    if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)project)) {
                        String isCompletePackageValue = project.getProperty("team.deploy.common.isCompletePackage");
                        timestamp = Boolean.parseBoolean(isCompletePackageValue) ? project.getProperty("team.deploy.common.newDeployTimeStamp") : project.getProperty("team.deploy.common.newUpdateDeployTimeStamp");
                    }
                    for (String library : saveLibraries) {
                        String crtSavfCmd = "CRTSAVF FILE(" + this.intermediateSaveFileLibrary + "/" + library + ")";
                        saveCmds.add(0, crtSavfCmd);
                        String dltSavfCmd = "DLTF FILE(" + this.intermediateSaveFileLibrary + "/" + library + ")";
                        saveCmds.add(0, dltSavfCmd);
                        String copyCmd = "CPYTOSTMF TOSTMF('" + this.rollbackDir + "/" + library + ".savf" + "') FROMMBR('QSYS.LIB" + "/" + this.intermediateSaveFileLibrary + ".LIB" + "/" + library + ".FILE" + "') STMFOPT(*REPLACE)";
                        saveCmds.add(copyCmd);
                        if (!CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)project)) continue;
                        IFSFile timstampDir = new IFSFile(this.connection, String.valueOf(this.rollbackDir) + "/" + timestamp);
                        if (!timstampDir.exists()) {
                            timstampDir.mkdir();
                        }
                        copyCmd = "CPYTOSTMF TOSTMF('" + this.rollbackDir + "/" + project.getProperty("team.deploy.common.newDeployTimeStamp") + "/" + library + ".savf" + "') FROMMBR('QSYS.LIB" + "/" + this.intermediateSaveFileLibrary + ".LIB" + "/" + library + ".FILE" + "') STMFOPT(*REPLACE)";
                        saveCmds.add(copyCmd);
                    }
                    IBMiRemoteCommandUtils.executeRemoteCommands(saveCmds, (String)"SAV", (AbstractIBMiCommandTask)this, (AS400)this.connection, (boolean)false);
                } else {
                    this.log(Messages.CopyOfIBMiSaveRollbackTask_DEPLOYMENT_RUNTIME_LIBRARIES_DONT_EXIST, 1);
                }
                if (allLibraries.isEmpty()) return true;
                this.getDltObjects();
                if (CheckDeploymentVersions.isDefinitionVersionGreaterThan30((Project)project)) {
                    this.writeRollbackManifestXML(saveLibraries, allLibraries);
                    return true;
                }
                this.writeRollbackManifest(saveLibraries, allLibraries);
                return true;
            }
            catch (Exception e) {
                this.log(e.toString());
                throw new BuildException(NLS.bind((String)Messages.CopyOfIBMiSaveRollbackTask_UNEXPECTED_ERROR_BACKING_UP_LIBRARIES, (Object)((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            }
        } else {
            this.log(Messages.CopyOfIBMiSaveRollbackTask_NO_CONNECTION_AVAILABLE, 0);
        }
        return true;
    }

    private void writeRollbackManifestXML(Vector<String> saveLibraries, Vector<String> allLibraries) {
    }

    private String getSavfName(String savf) {
        int i = savf.lastIndexOf("/");
        int k = savf.lastIndexOf(".");
        return savf.substring(i + 1, k);
    }

    private String getLibName(String obj) {
        int i = obj.indexOf("/");
        return obj.substring(0, i);
    }

    private String getObjName(String obj) {
        int i = obj.indexOf("/");
        int k = obj.lastIndexOf(".");
        return obj.substring(i + 1, k);
    }

    private String getObjType(String obj) {
        int k = obj.lastIndexOf(".");
        String type = obj.substring(k + 1);
        if (type.startsWith("*")) {
            return type.substring(1);
        }
        return type;
    }

    public void writeRollbackManifest(Vector<String> savedLibraries, Vector<String> allLibraries) throws BuildException {
        try {
            IFSFile mf = new IFSFile(this.connection, String.valueOf(this.rollbackDir) + "/" + "rollbackLibs.mf");
            if (mf.exists()) {
                mf.delete();
            }
            mf.createNewFile();
            mf.setCCSID(1208);
            PrintWriter writer = new PrintWriter(new BufferedWriter((Writer)new IFSFileWriter(mf)));
            for (String library : allLibraries) {
                if (savedLibraries.contains(library)) {
                    writer.println("RST: " + library);
                    continue;
                }
                writer.println("DLT: " + library);
            }
            for (String obj : this.dltObjs) {
                writer.println("DLTOBJ: " + obj);
            }
            writer.flush();
            writer.close();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void writeRollbackTimestamp(Project proj, String timestamp) throws BuildException {
        try {
            BufferedWriter writer;
            IFSFile file = new IFSFile(this.connection, String.valueOf(this.rollbackDir) + "/" + "rollbackTimestamp");
            String isCompletePackageValue = proj.getProperty("team.deploy.common.isCompletePackage");
            if (Boolean.parseBoolean(isCompletePackageValue) && file.exists()) {
                file.delete();
            }
            if (!file.exists()) {
                file.createNewFile();
                writer = new BufferedWriter((Writer)new IFSFileWriter(file));
            } else {
                writer = new BufferedWriter((Writer)new IFSFileWriter(file, true));
            }
            file.setCCSID(1208);
            writer.write(timestamp);
            writer.newLine();
            writer.flush();
            writer.close();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String getSaveCommand(String savf) {
        String saveCmd = null;
        if (this.intermediateSaveFileLibrary == null) {
            this.intermediateSaveFileLibrary = "QTEMP";
        }
        if (savf != null) {
            String savfName = this.getSavfName(savf);
            String libName = this.getMappedLibName(this.restoreMappingProperties, savfName);
            this.allLibs.add(libName);
            try {
                if (this.libraryExistsOnServer(this.connection, libName)) {
                    IFSFile[] objects;
                    this.saveLibs.add(libName);
                    Vector<String> objExclude = new Vector<String>();
                    IFSFile ifsFile = new IFSFile(this.connection, "/QSYS.LIB/" + libName + ".LIB");
                    String pvtautString = this.getPvtautOption() ? "PVTAUT(*YES) " : "";
                    StringBuffer c = new StringBuffer("SAVLIB LIB(" + libName + ") DEV(*SAVF) SAVF(" + this.intermediateSaveFileLibrary + "/" + libName + ") " + pvtautString);
                    IFSFile[] iFSFileArray = objects = ifsFile.listFiles();
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int lastDot;
                        String type;
                        IFSFile f = iFSFileArray[n2];
                        String name = f.getName();
                        if (!this.isObjectInPackage(savfName, name, type = "*" + name.substring((lastDot = name.lastIndexOf(".")) + 1))) {
                            objExclude.add(String.valueOf(name.substring(0, lastDot)) + " " + type);
                        }
                        ++n2;
                    }
                    if (objExclude != null && objExclude.size() > 0) {
                        if (objExclude.size() <= 300) {
                            c.append(" OMITOBJ(");
                            for (String filter : objExclude) {
                                c.append("(" + filter + ") ");
                            }
                            c.append(")");
                        } else {
                            IBMiUSRSPC usrspc = new IBMiUSRSPC();
                            usrspc.createUSRSPC(libName, this.getBaseIFSPath(this.intermediateSaveFileLibrary), this.intermediateSaveFileLibrary, new HashSet(), objExclude, this.connection, "", this.getPvtautOption());
                            c.append(" OMITOBJ(*USRSPC) CMDUSRSPC(" + this.intermediateSaveFileLibrary + "/" + libName + ")");
                        }
                    }
                    saveCmd = c.toString();
                    this.log(NLS.bind((String)Messages.CopyOfIBMiSaveRollbackTask_SAVE_COMMAND_INFO_MSG, (Object)saveCmd), 1);
                } else {
                    this.log(NLS.bind((String)Messages.CopyOfIBMiSaveRollbackTask_RUNTIME_LIBARY_DOES_NOT_EXIST_AND_CANT_BE_BACKED_UP, (Object)libName), 1);
                }
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        return saveCmd;
    }

    private String getMappedLibName(Properties restoreMappings, String savfName) {
        String libName = savfName;
        if (this.restoreMappingProperties != null) {
            if (restoreMappings.getProperty(savfName) != null) {
                libName = restoreMappings.getProperty(savfName);
            } else {
                System.out.println(NLS.bind((String)Messages.CopyOfIBMiSaveRollbackTask_NO_MAPPING_FOUND, (Object)savfName));
            }
        }
        return libName;
    }

    private boolean isObjectInPackage(String libName, String name, String type) {
        return this.saveObjs.contains(String.valueOf(libName) + "/" + name + "." + type);
    }

    public boolean libraryExistsOnServer(AS400 connection, String libName) {
        boolean libExists = false;
        ArrayList<String> validationLibraries = new ArrayList<String>();
        validationLibraries.add(libName);
        try {
            IBMiLibraryValidater libraryValidator = new IBMiLibraryValidater(connection, validationLibraries);
            if (libraryValidator.numberOfMissingLibraries() == 0) {
                libExists = true;
            }
        }
        catch (Exception e) {
            this.log(NLS.bind((String)Messages.CopyOfIBMiSaveRollbackTask_ERROR_IN_LIBRARY_VALIDATOR, (Object)libName), e, 1);
        }
        return libExists;
    }

    private String getPropertyValue(String line, String property, String separator) {
        int start = line.indexOf(separator);
        return line.substring(start + 2);
    }

    public void setLocalPackageDir(String dir) {
        this.localPackageDir = dir;
    }

    public void setIntermediateSaveFileLibrary(String lib) {
        this.intermediateSaveFileLibrary = lib;
    }

    public void setRestoreMappingFilePath(String restorMappingFile) {
        this.restoreMappingFilePath = restorMappingFile;
    }

    private void createLibrary(String libraryname, AS400 as400) throws BuildException {
        try {
            IFSFile ifsFile = new IFSFile(as400, "/QSYS.LIB/" + libraryname + ".LIB");
            if (!ifsFile.exists()) {
                CRTLIBTask crtLibTask = new CRTLIBTask();
                crtLibTask.setLibraryname(libraryname);
                crtLibTask.setProject(this.getProject());
                crtLibTask.setText("'Intermediate Save File Library for Deployment'");
                crtLibTask.setSystemref("SystemInstance");
                crtLibTask.execute();
            }
        }
        catch (Exception e) {
            throw new BuildException(NLS.bind((String)Messages.CopyOfIBMiSaveRollbackTask_CANNOT_CREATE_LIBRARY, (Object)libraryname), (Throwable)e);
        }
    }

    private Properties getRestoreMappingProperties(Project project) {
        if (this.restoreMappingProperties == null) {
            this.restoreMappingProperties = new Properties();
            try {
                IFSFile mappingsFile = new IFSFile(this.connection, this.restoreMappingFilePath);
                if (mappingsFile.exists()) {
                    this.restoreMappingProperties = ContainerMappingProperties.getRestoreMappingProperties((Project)project, (InputStream)new IFSFileInputStream(mappingsFile), (Reader)new IFSFileReader(mappingsFile));
                }
            }
            catch (Exception e) {
                System.out.println(NLS.bind((String)Messages.CopyOfIBMiSaveRollbackTask_ERROR_GETTING_RESTORE_MAPPING, (Object)this.restoreMappingFilePath));
                e.printStackTrace();
            }
        }
        return this.restoreMappingProperties;
    }

    private void getDltObjects() {
        for (String obj : this.saveObjs) {
            String libName = this.getMappedLibName(this.restoreMappingProperties, this.getLibName(obj));
            String objName = this.getObjName(obj);
            String objType = this.getObjType(obj);
            try {
                String objPath;
                IFSFile ifsFile;
                if (!this.libraryExistsOnServer(this.connection, libName) || (ifsFile = new IFSFile(this.connection, objPath = "/QSYS.LIB/" + libName + ".LIB" + "/" + objName + "." + objType)).exists()) continue;
                this.dltObjs.add(String.valueOf(libName) + "/" + objName + "." + objType);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private boolean getPvtautOption() {
        return this.pvtautOption;
    }
}

