/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.automation.toolkit.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.UserSpace;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class IBMiUSRSPC {
    private int usrspcOffset = 0;

    public void createUSRSPC(String lib, String tempLib, Set<ISeriesHostObjectBasic> objs, Vector<String> omitObjs, AS400 connection, String savefileOptions) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createUSRSPC(lib, "/QSYS.LIB/", objs, omitObjs, connection, savefileOptions);
    }

    public void createUSRSPC(String lib, String qsysBase, String tempLib, Set<ISeriesHostObjectBasic> objs, Vector<String> omitObjs, AS400 connection, String savefileOptions, boolean pvtautOption) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.usrspcOffset = 0;
        HashSet<SaveObject> objects = new HashSet<SaveObject>();
        HashSet<SaveOmitObject> objects2Omit = new HashSet<SaveOmitObject>();
        AS400Bin4 ib = new AS400Bin4();
        UserSpace US = new UserSpace(connection, String.valueOf(qsysBase) + tempLib + ".LIB/" + lib + ".USRSPC");
        US.create(256, true, "", (byte)0, "Created by IBM i packaging Ant task", "*USE");
        for (ISeriesHostObjectBasic o : objs) {
            objects.add(new SaveObject(connection, o.getName(), o.getType()));
        }
        for (String s : omitObjs) {
            String[] sa = s.trim().split("[ ]");
            objects2Omit.add(new SaveOmitObject(connection, lib, sa[0], sa.length == 1 ? "*ALL" : sa[1]));
        }
        SAVFOptions savfOptions = new SAVFOptions(savefileOptions);
        this.append(US, ib.toBytes(this.numVariableRecords(5, savfOptions, objects2Omit, pvtautOption)));
        this.append(US, ib.toBytes(13));
        this.append(US, ib.toBytes(12));
        this.append(US, ib.toBytes(1));
        this.append(US, new AS400Text(1).toBytes((Object)"1"));
        if (savfOptions.getTGTRLS().length() > 0) {
            this.append(US, ib.toBytes(22));
            this.append(US, ib.toBytes(11));
            this.append(US, ib.toBytes(14));
            this.append(US, new AS400Text(10).toBytes((Object)savfOptions.getTGTRLS()));
        }
        if (pvtautOption) {
            this.append(US, ib.toBytes(13));
            this.append(US, ib.toBytes(47));
            this.append(US, ib.toBytes(1));
            this.append(US, new AS400Text(1).toBytes((Object)"1"));
        }
        this.append(US, ib.toBytes(26));
        this.append(US, ib.toBytes(2));
        this.append(US, ib.toBytes(14));
        this.append(US, ib.toBytes(1));
        this.append(US, new AS400Text(10).toBytes((Object)lib));
        this.append(US, ib.toBytes(26));
        this.append(US, ib.toBytes(3));
        this.append(US, ib.toBytes(14));
        this.append(US, ib.toBytes(1));
        this.append(US, new AS400Text(10).toBytes((Object)"*SAVF"));
        this.append(US, ib.toBytes(32));
        this.append(US, ib.toBytes(4));
        this.append(US, ib.toBytes(20));
        this.append(US, new AS400Text(10).toBytes((Object)lib));
        this.append(US, new AS400Text(10).toBytes((Object)tempLib));
        this.append(US, ib.toBytes(16 + objects.size() * 20));
        this.append(US, ib.toBytes(1));
        this.append(US, ib.toBytes(24));
        this.append(US, ib.toBytes(objects.size()));
        for (SaveObject saveObject : objects) {
            this.append(US, saveObject.getName());
            this.append(US, saveObject.getType());
        }
        if (objects2Omit.size() > 0) {
            this.append(US, ib.toBytes(16 + objects2Omit.size() * 30));
            this.append(US, ib.toBytes(30));
            this.append(US, ib.toBytes(34));
            this.append(US, ib.toBytes(objects2Omit.size()));
            for (SaveOmitObject saveOmitObject : objects2Omit) {
                this.append(US, saveOmitObject.getName());
                this.append(US, saveOmitObject.getLib());
                this.append(US, saveOmitObject.getType());
            }
        }
        US.close();
    }

    private void dumpUserSpc(UserSpace US) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] bytes = new byte[US.getLength()];
        int count = US.read(bytes, 0);
        int i = 0;
        while (i < count) {
            if (i % 16 == 0) {
                System.out.format("\n%06X: ", i);
            }
            System.out.format("[%02X] ", bytes[i] & 0xFF);
            ++i;
        }
        System.out.println("");
    }

    private void append(UserSpace us, byte[] ba) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        us.write(ba, this.usrspcOffset);
        this.usrspcOffset += ba.length;
    }

    private int numVariableRecords(int minimal, SAVFOptions savfOptions, Set<SaveOmitObject> objects2Omit, boolean pvtAut) {
        return minimal + savfOptions.getLength() + (objects2Omit.size() > 0 ? 1 : 0) + (pvtAut ? 1 : 0);
    }

    protected void log(String msg) {
        System.out.println(msg);
    }

    private class SAVFOptions {
        private String TGTRLS = "";

        public SAVFOptions(String options) {
            if (options != null) {
                String[] o;
                String[] stringArray = o = options.split("[ ]");
                int n = o.length;
                int n2 = 0;
                while (n2 < n) {
                    String opt = stringArray[n2];
                    String[] s = opt.split("[()]");
                    if (s.length == 2 && s[0].trim().toUpperCase().compareToIgnoreCase("TGTRLS") == 0) {
                        this.TGTRLS = s[1].trim().toUpperCase();
                    }
                    ++n2;
                }
            }
        }

        public String getTGTRLS() {
            return this.TGTRLS;
        }

        public int getLength() {
            int l = 0;
            return l += this.TGTRLS.length() > 0 ? 1 : 0;
        }
    }

    private class SaveObject {
        byte[] name;
        byte[] type;
        public static final int size = 20;

        public SaveObject(AS400 conn, String name, String type) {
            this.name = new AS400Text(10).toBytes((Object)name);
            this.type = new AS400Text(10).toBytes((Object)type);
        }

        public byte[] getName() {
            return this.name;
        }

        public byte[] getType() {
            return this.type;
        }
    }

    private class SaveOmitObject {
        byte[] lib;
        byte[] name;
        byte[] type;
        public static final int size = 30;

        public SaveOmitObject(AS400 conn, String lib, String name, String type) {
            this.lib = new AS400Text(10).toBytes((Object)lib);
            this.name = new AS400Text(10).toBytes((Object)name);
            this.type = new AS400Text(10).toBytes((Object)type);
        }

        public byte[] getName() {
            return this.name;
        }

        public byte[] getType() {
            return this.type;
        }

        public byte[] getLib() {
            return this.lib;
        }
    }
}

