/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.automation.toolkit.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.SaveFile;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.teamp.ibmi.automation.toolkit.util.IBMiSAVF;
import com.ibm.teamp.ibmi.automation.toolkit.util.Messages;
import java.beans.PropertyVetoException;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class IBMiQSRSAV0 {
    private IBMiSAVF data = new IBMiSAVF();

    public IBMiQSRSAV0(AS400 conn, String lib, String tempLib, int objectCount) {
        this.data.lib = lib;
        this.data.tempLib = tempLib;
        this.data.conn = conn;
        this.data.objectCount = objectCount;
    }

    public int runAPI(boolean quietly, AbstractIBMiCommandTask task, AS400 connection, String intermediateSaveFileLibrary) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, PropertyVetoException {
        Boolean success = true;
        int count = 0;
        if (this.data.objectCount >= 1) {
            byte[][] userSpaceName = new byte[][]{new AS400Text(10).toBytes((Object)this.data.lib), new AS400Text(10).toBytes((Object)this.data.tempLib)};
            ProgramParameter[] parameterList = new ProgramParameter[]{new ProgramParameter(IBMiQSRSAV0.convert2to1(userSpaceName)), new ProgramParameter(new byte[32], 0)};
            ProgramCall pgm = new ProgramCall(this.data.conn);
            if (!quietly) {
                task.log("SAVF>> " + this.getCommand());
            }
            if (!(success = Boolean.valueOf(pgm.run("QSYS.LIB/QSYS.LIB/QSRSAVO.PGM", parameterList))).booleanValue()) {
                AS400Message[] msgList = pgm.getMessageList();
                this.log((Task)task, NLS.bind((String)Messages.IBMiQSRSAV0_UNABLE_TO_SAVE_OBJECTS, (Object)(String.valueOf(this.data.tempLib) + "/" + this.data.lib)), 0);
                int i1 = 0;
                while (i1 < msgList.length) {
                    task.log("  <<" + msgList[i1].getText(), 0);
                    ++i1;
                }
                throw new BuildException(NLS.bind((String)Messages.IBMiQSRSAV0_UNABLE_TO_SAVE_OBJECTS, (Object)(String.valueOf(this.data.tempLib) + "/" + this.data.lib)));
            }
            int c = new SaveFile(connection, intermediateSaveFileLibrary, this.data.lib).listEntries().length;
            count += c;
            this.log((Task)task, NLS.bind((String)Messages.IBMiQSRSAV0_4, (Object)c, (Object)(String.valueOf(this.data.lib) + ".*SAVF")), 2);
        } else if (!quietly) {
            this.log((Task)task, NLS.bind((String)Messages.IBMiQSRSAV0_NOTHING_TO_SAVE, (Object)this.data.lib), 2);
        }
        return count;
    }

    public String getCommand() {
        return "API QSRSAVO, userspace=" + this.data.tempLib + "/" + this.data.lib + ".USRSPC";
    }

    private static byte[] convert2to1(byte[][] data2) {
        int size = 0;
        byte[][] byArray = data2;
        int n = data2.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] e = byArray[n2];
            size += e.length;
            ++n2;
        }
        byte[] data1 = new byte[size];
        int i = 0;
        byte[][] byArray2 = data2;
        int n3 = data2.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] e;
            byte[] byArray3 = e = byArray2[n4];
            int n5 = e.length;
            int n6 = 0;
            while (n6 < n5) {
                byte eb = byArray3[n6];
                data1[i++] = eb;
                ++n6;
            }
            ++n4;
        }
        return data1;
    }

    private void log(Task t, String s, int type) {
        try {
            Thread.sleep(1L);
            t.log(s, type);
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

