/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.automation.toolkit;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManifestObjectParser {
    List<IBMiObject> ibmiObjects = new ArrayList<IBMiObject>();
    BufferedReader manifestFile;

    public List<IBMiObject> getIbmiObjects() {
        return this.ibmiObjects;
    }

    public List<IBMiObject> getIBMiObjectsFromManifestFile(AS400 connection, String filename) throws FileNotFoundException, IOException {
        String line;
        try {
            this.manifestFile = new BufferedReader((Reader)new IFSFileReader(new IFSFile(connection, filename)));
        }
        catch (AS400SecurityException e) {
            e.printStackTrace();
        }
        while ((line = this.manifestFile.readLine()) != null) {
            this.findIBMiObjects(line);
        }
        return this.ibmiObjects;
    }

    public boolean findIBMiObjects(String line) {
        Pattern SAVFfileObject = Pattern.compile("(.*)/(.*)\\.(.*)");
        Matcher matchedSAVFfileObject = SAVFfileObject.matcher(line);
        if (matchedSAVFfileObject.find()) {
            IBMiObject ibmiObject = new IBMiObject(matchedSAVFfileObject.group(2), matchedSAVFfileObject.group(3), matchedSAVFfileObject.group(1));
            this.ibmiObjects.add(ibmiObject);
            return true;
        }
        return false;
    }

    public class IBMiObject {
        private String objectType;
        private String objectName;
        private String library;

        IBMiObject(String objectName, String objectType, String library) {
            this.objectName = objectName;
            this.objectType = objectType;
            this.library = library;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getLibrary() {
            return this.library;
        }

        public void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public void setLibrary(String library) {
            this.library = library;
        }
    }
}

