/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.automation.toolkit;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectNameOnly;
import com.ibm.teamp.ibmi.automation.toolkit.ManifestObjectParser;
import java.util.ArrayList;
import java.util.List;

public class IBMiObjectValidater {
    List<ManifestObjectParser.IBMiObject> existingObjects = new ArrayList<ManifestObjectParser.IBMiObject>();
    AS400 as400;
    StringBuffer missingObjects;

    public IBMiObjectValidater(AS400 as400, List<ManifestObjectParser.IBMiObject> deleteObjects) throws Exception {
        this.as400 = as400;
        this.missingObjects = new StringBuffer();
        for (ManifestObjectParser.IBMiObject deleteObject : deleteObjects) {
            ISeriesObjectFilterString objectFilterString = new ISeriesObjectFilterString();
            objectFilterString.setObject(deleteObject.getObjectName());
            objectFilterString.setObjectType(deleteObject.getObjectType());
            objectFilterString.setLibrary(deleteObject.getLibrary());
            ISeriesListObjects listObjects = new ISeriesListObjects(as400);
            List objectList = listObjects.getList((ISeriesAbstractFilterString)objectFilterString);
            if (objectList.size() == 1 && objectList.get(0) instanceof IISeriesHostObjectNameOnly) {
                this.existingObjects.add(deleteObject);
                continue;
            }
            this.missingObjects.append(String.valueOf(deleteObject.getLibrary()) + '/' + deleteObject.getObjectName() + '.' + deleteObject.getObjectType() + ' ');
        }
    }

    public List<ManifestObjectParser.IBMiObject> getExistingObjects() throws Exception {
        return this.existingObjects;
    }

    public String getMissingObjects() {
        return this.missingObjects.toString();
    }
}

