/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.ibmi.automation.toolkit;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectNameOnly;
import java.util.ArrayList;
import java.util.List;

public class IBMiLibraryValidater {
    List<String> existingLibraries = new ArrayList<String>();
    AS400 as400;
    List<String> missingLibraries;

    public IBMiLibraryValidater(AS400 as400, List<String> libraries) throws Exception {
        this.as400 = as400;
        this.missingLibraries = new ArrayList<String>();
        for (String library : libraries) {
            ISeriesObjectFilterString objectFilterString = new ISeriesObjectFilterString();
            objectFilterString.setObject(library);
            objectFilterString.setObjectType("*LIB");
            objectFilterString.setLibrary("QSYS");
            ISeriesListObjects listObjects = new ISeriesListObjects(as400);
            List objectList = listObjects.getList((ISeriesAbstractFilterString)objectFilterString);
            if (objectList.size() == 1 && objectList.get(0) instanceof IISeriesHostObjectNameOnly) {
                this.existingLibraries.add(library);
                continue;
            }
            this.missingLibraries.add(library);
        }
    }

    public List<String> getExistingObjects() throws Exception {
        return this.existingLibraries;
    }

    public List<String> getMissingLibraries() {
        return this.missingLibraries;
    }

    public int numberOfMissingLibraries() {
        return this.missingLibraries.size();
    }
}

