/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import java.beans.PropertyVetoException;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class VerifyHostConnectionAction {
    private String hostname;
    private String userid;
    private String password;

    public VerifyHostConnectionAction(String hostname, String userid, String password) {
        this.hostname = hostname;
        this.userid = userid;
        this.password = password;
    }

    public IStatus verifyInformation() {
        if (this.hostname == null || this.hostname.trim().length() == 0) {
            return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_NO_HOST_NAME);
        }
        if (this.userid == null || this.userid.trim().length() == 0) {
            return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_NO_USER_NAME);
        }
        if (this.password == null || this.password.trim().length() == 0) {
            return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_NO_PASSWORD);
        }
        return Status.OK_STATUS;
    }

    public IStatus verifyConnection() {
        IStatus status = this.verifyInformation();
        if (status.getSeverity() != 0) {
            return status;
        }
        AS400 as400 = new AS400(this.hostname, this.userid, this.password);
        try {
            as400.setGuiAvailable(false);
            as400.connectService(0);
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        catch (IOException e) {
            return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.bind((String)Messages.ERROR_HOST_CANNOT_BE_REACHED, (Object[])new String[]{this.hostname}));
        }
        catch (AS400SecurityException e) {
            String msgText;
            switch (e.getReturnCode()) {
                case 8: {
                    msgText = Messages.SIGNON_PASSWORD_INCORRECT;
                    break;
                }
                case 6: {
                    msgText = Messages.SIGNON_PASSWORD_ERROR;
                    break;
                }
                case 9: {
                    msgText = Messages.SIGNON_PASSWORD_INCORRECT_USER_DISABLED;
                    break;
                }
                case 28: {
                    msgText = Messages.bind((String)Messages.SIGNON_USERID_ERROR, (Object)this.userid);
                    break;
                }
                case 32: {
                    msgText = Messages.bind((String)Messages.SIGNON_USERID_INVALID, (Object)this.userid);
                    break;
                }
                case 31: {
                    msgText = Messages.bind((String)Messages.SIGNON_USERID_DISABLED, (Object)this.userid);
                    break;
                }
                case 7: {
                    msgText = Messages.SIGNON_PASSWORD_EXPIRED;
                    break;
                }
                case 10: {
                    msgText = Messages.SIGNON_PASSWORD_INCORRECT;
                    break;
                }
                default: {
                    msgText = Messages.SIGNON_GENERAL_ERROR;
                }
            }
            return new Status(4, "com.ibm.teamp.filesystem.ide.ui", msgText);
        }
        return Status.OK_STATUS;
    }

    public void setConnectionInfo(String hostname, String userid, String password) {
        this.hostname = hostname;
        this.userid = userid;
        this.password = password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

