/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.util;

import com.ibm.teami.filesystem.ide.ui.Activator;
import com.ibm.teami.filesystem.ide.ui.util.HostConnectionInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.IDialogSettings;

public class DialogSettingsUtil {
    public static final String SHOW_FILES_ONLY_ON_HOST = "SHOW_FILES_ONLY_ON_HOST";
    public static final String SHOW_FILES_ONLY_IN_SCM = "SHOW_FILES_ONLY_IN_SCM";
    public static final String IBM_HOST = "IBM_HOST";
    private static final String HOST_SEPARATOR = ";";
    private static final String HOST_ATTR_SEPARATOR = "|";
    public static final String USER_ID_ATTR = "userId";

    public static IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    private static List<HostConnectionInfo> parseHostConnectionInfos() {
        ArrayList<HostConnectionInfo> list = new ArrayList<HostConnectionInfo>();
        String hosts = DialogSettingsUtil.getDialogSettings().get(IBM_HOST);
        if (hosts != null) {
            StringTokenizer st = new StringTokenizer(hosts, HOST_SEPARATOR);
            while (st.hasMoreTokens()) {
                String hostString = st.nextToken();
                StringTokenizer st1 = new StringTokenizer(hostString, HOST_ATTR_SEPARATOR);
                if (st1.countTokens() == 0) continue;
                HostConnectionInfo connInfo = st1.countTokens() == 1 ? new HostConnectionInfo(st1.nextToken(), "") : new HostConnectionInfo(st1.nextToken(), st1.nextToken());
                list.add(connInfo);
            }
        }
        return list;
    }

    private static void saveHostConnectionInfos(List<HostConnectionInfo> hosts) {
        StringBuffer buffer = new StringBuffer();
        Iterator<HostConnectionInfo> iterator = hosts.iterator();
        while (iterator.hasNext()) {
            HostConnectionInfo info = iterator.next();
            buffer.append(info.getHostname());
            if (!info.getUserId().equals("")) {
                buffer.append(HOST_ATTR_SEPARATOR).append(info.getUserId());
            }
            if (!iterator.hasNext()) continue;
            buffer.append(';');
        }
        DialogSettingsUtil.getDialogSettings().put(IBM_HOST, buffer.toString());
    }

    public static void saveHostConnectionInfo(HostConnectionInfo host) {
        if (host == null || "".equals(host.getHostname())) {
            return;
        }
        List<HostConnectionInfo> hosts = DialogSettingsUtil.parseHostConnectionInfos();
        int index = DialogSettingsUtil.getHostConnectionInfoIndex(hosts, host);
        if (index == -1) {
            hosts.add(host);
        } else {
            HostConnectionInfo tempInfo = hosts.get(index);
            tempInfo.setUserId(host.getUserId());
            hosts.set(index, tempInfo);
        }
        DialogSettingsUtil.saveHostConnectionInfos(hosts);
    }

    private static int getHostConnectionInfoIndex(List<HostConnectionInfo> hosts, HostConnectionInfo host) {
        int i = 0;
        while (i < hosts.size()) {
            if (hosts.get(i).getHostname().equals(host.getHostname())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static HostConnectionInfo[] getAllHostConnectionInfos() {
        List<HostConnectionInfo> hosts = DialogSettingsUtil.parseHostConnectionInfos();
        return hosts.toArray(new HostConnectionInfo[hosts.size()]);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = DialogSettingsUtil.getDialogSettings().get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static void setBoolean(String key, boolean value) {
        DialogSettingsUtil.getDialogSettings().put(key, value);
    }
}

