/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.properties;

import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.common.util.IProjectInfo;
import com.ibm.teami.filesystem.common.validators.IBMiLibraryValidator;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IProjectToLibraryMap;
import com.ibm.teami.scm.common.IProjectToLibraryMapHandle;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;

public class ProjectToLibraryMappingsPropertyPage
extends PropertyPage {
    private static final int ISTATUS_ERROR_MAPPINGS_INCOMPLETE_CODE = 100;
    private static final int ERROR_MAPPINGS_INCOMPLETE_CODE = 101;
    private static final int ERROR_NAME_CONFORMANCE_CODE = 102;
    private static final int ERROR_DUPLICATE_NAMES_CODE = 103;
    private Table table;
    private TableViewer tableViewer;
    private ITeamRepository repository;
    private IWorkspace workspace;
    private IScmIClientLibrary clientLibrary = null;
    private IWorkspaceIHandle workspaceIHandle = null;
    private final boolean enableEditSupport;
    private boolean dialogCancelled = false;
    private boolean dialogClosed = false;
    private final IProgressMonitor globalMonitor = new NullProgressMonitor();
    private List<Mapping> allNeededMappings = null;

    public ProjectToLibraryMappingsPropertyPage() {
        this.enableEditSupport = true;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.team.filesystem.ide.ui.iprojtolibprop");
        Composite autoLoadComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        autoLoadComposite.setLayoutData((Object)new GridData(1808));
        layout.numColumns = 1;
        autoLoadComposite.setLayout((Layout)layout);
        this.table = new Table(autoLoadComposite, 68354);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.widthHint = 200;
        data.heightHint = 300;
        this.table.setLayoutData((Object)data);
        TableColumn iProjectColumn = new TableColumn(this.table, 0, 0);
        iProjectColumn.setText(Messages.I_PROJECTS_TABLE_COLUMN_HEADER);
        ColumnWeightData iProjectColumnData = new ColumnWeightData(50, true);
        tableLayout.addColumnData((ColumnLayoutData)iProjectColumnData);
        TableColumn libraryColumn = new TableColumn(this.table, 0, 1);
        libraryColumn.setText(Messages.LIBRARY_TABLE_COLUMN_HEADER);
        ColumnWeightData libraryColumnData = new ColumnWeightData(50, true);
        tableLayout.addColumnData((ColumnLayoutData)libraryColumnData);
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(this.table);
        this.initialize();
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setComparator((ViewerComparator)new MappingComparator());
        TableViewerColumn iProjectViewerColumn = new TableViewerColumn(this.tableViewer, iProjectColumn);
        iProjectViewerColumn.setEditingSupport((EditingSupport)new ProjectEditingSupport((ColumnViewer)this.tableViewer));
        iProjectViewerColumn.setLabelProvider((CellLabelProvider)new ProjectLabelProvider());
        TableViewerColumn libraryViewerColumn = new TableViewerColumn(this.tableViewer, libraryColumn);
        libraryViewerColumn.setEditingSupport((EditingSupport)new LibraryEditingSupport((ColumnViewer)this.tableViewer));
        libraryViewerColumn.setLabelProvider((CellLabelProvider)new LibraryLabelProvider());
        this.tableViewer.setInput((Object)this.workspace);
        this.table.setEnabled(this.enableEditSupport);
        return parent;
    }

    protected void initialize() {
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof ContributorPlaceWrapper) {
            ContributorPlaceWrapper wrapper = (ContributorPlaceWrapper)adaptable;
            this.repository = wrapper.getRepository();
            this.workspace = wrapper.getWorkspace();
            this.clientLibrary = (IScmIClientLibrary)this.repository.getClientLibrary(IScmIClientLibrary.class);
            Job job = new Job(Messages.IPROJECT_LIBRARY_MAPPING_JOB_NAME){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ProjectToLibraryMappingsPropertyPage.this.workspaceIHandle = ProjectToLibraryMappingsPropertyPage.this.clientLibrary.getWorkspaceI((IWorkspaceHandle)ProjectToLibraryMappingsPropertyPage.this.workspace, null);
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_FINDING_IWORKSPACE);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                this.setErrorMessage(NLS.bind((String)Messages.ERROR_JOB_INTERRUPTED, (Object)job.getName()));
                return;
            }
            IStatus result = job.getResult();
            if (result.isOK()) {
                return;
            }
            if (result.getSeverity() == 4) {
                this.setErrorMessage(result.getMessage());
            }
            return;
        }
    }

    public boolean performOk() {
        if (!this.enableEditSupport) {
            return true;
        }
        boolean result = this.validateLibraries();
        if (result) {
            this.dialogClosed = true;
            this.globalMonitor.setCanceled(true);
            return super.performOk();
        }
        return result;
    }

    public boolean validateLibraries() {
        this.setErrorMessage(null);
        Job job = new Job(Messages.IPROJECT_LIBRARY_MAPPING_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                if (ProjectToLibraryMappingsPropertyPage.this.workspaceIHandle == null) {
                    try {
                        ProjectToLibraryMappingsPropertyPage.this.workspaceIHandle = ProjectToLibraryMappingsPropertyPage.this.clientLibrary.createWorkspaceI((IWorkspaceHandle)ProjectToLibraryMappingsPropertyPage.this.workspace, null);
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_CREATING_IWORKSPACE);
                    }
                }
                if (ProjectToLibraryMappingsPropertyPage.this.allNeededMappings == null || ProjectToLibraryMappingsPropertyPage.this.allNeededMappings.size() == 0) {
                    return Status.OK_STATUS;
                }
                ArrayList<IFolderHandle> resultFolderHandles = new ArrayList<IFolderHandle>();
                ArrayList<String> resultLibraryNames = new ArrayList<String>();
                ArrayList<String> resultUppercaseLibraryNames = new ArrayList<String>();
                Status returnStatus = null;
                boolean hasDuplicateLibraries = false;
                int i = 0;
                while (i < ProjectToLibraryMappingsPropertyPage.this.allNeededMappings.size()) {
                    Mapping mapping = (Mapping)ProjectToLibraryMappingsPropertyPage.this.allNeededMappings.get(i);
                    String libName = mapping.getLibName();
                    String uppercaseName = mapping.getLibName();
                    if (libName == null || libName == "") {
                        return new Status(0, "com.ibm.teamp.filesystem.ide.ui", 101, Messages.ERROR_MAPPINGS_INCOMPLETE, null);
                    }
                    if (!IBMiLibraryValidator.isValidLibraryName((String)libName)) {
                        return new Status(0, "com.ibm.teamp.filesystem.ide.ui", 102, NLS.bind((String)Messages.ERROR_NAME_CONFORMANCE, (Object)libName), null);
                    }
                    if (libName.startsWith("\"")) {
                        String tempLib = libName.substring(1, libName.length() - 1);
                        if (tempLib.equals(tempLib.toUpperCase())) {
                            uppercaseName = tempLib;
                        }
                        if (!hasDuplicateLibraries && resultUppercaseLibraryNames.contains(uppercaseName)) {
                            hasDuplicateLibraries = true;
                            returnStatus = new Status(0, "com.ibm.teamp.filesystem.ide.ui", 103, Messages.WARNING_DUPLICATE_NAMES, null);
                        }
                    } else {
                        uppercaseName = libName.toUpperCase();
                        if (!hasDuplicateLibraries && resultUppercaseLibraryNames.contains(uppercaseName)) {
                            hasDuplicateLibraries = true;
                            returnStatus = new Status(0, "com.ibm.teamp.filesystem.ide.ui", 103, Messages.WARNING_DUPLICATE_NAMES, null);
                        }
                    }
                    resultFolderHandles.add(mapping.getProjectInfo().getFolderHandle());
                    resultLibraryNames.add(libName);
                    resultUppercaseLibraryNames.add(uppercaseName);
                    ++i;
                }
                try {
                    ProjectToLibraryMappingsPropertyPage.this.clientLibrary.setProjectToLibraryMappings(ProjectToLibraryMappingsPropertyPage.this.workspaceIHandle, resultFolderHandles, resultLibraryNames, null);
                    if (returnStatus == null) {
                        return Status.OK_STATUS;
                    }
                    return returnStatus;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_SAVING_IWORKSPACE);
                }
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            this.setErrorMessage(NLS.bind((String)Messages.ERROR_JOB_INTERRUPTED, (Object)job.getName()));
            return false;
        }
        IStatus result = job.getResult();
        if (result.isOK()) {
            int returnCode = result.getCode();
            if (returnCode == 101 || returnCode == 102) {
                this.setErrorMessage(result.getMessage());
                return false;
            }
            if (returnCode == 103) {
                this.setMessage(result.getMessage(), 2);
                return true;
            }
            return true;
        }
        if (result.getSeverity() == 4) {
            this.setErrorMessage(result.getMessage());
        }
        return false;
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16512);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 1);
    }

    protected Text createText(Composite parent, int span, boolean isPassword) {
        Text text = null;
        text = !isPassword ? new Text(parent, 16512) : new Text(parent, 0x404080);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        text.setLayoutData((Object)data);
        return text;
    }

    protected Text createText(Composite parent, boolean isPassword) {
        return this.createText(parent, 1, isPassword);
    }

    public boolean performCancel() {
        this.dialogCancelled = true;
        this.globalMonitor.setCanceled(true);
        return super.performCancel();
    }

    private class LibraryEditingSupport
    extends EditingSupport {
        private TextCellEditor textCellEditor;

        public LibraryEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.textCellEditor = null;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.textCellEditor == null) {
                this.textCellEditor = new TextCellEditor((Composite)ProjectToLibraryMappingsPropertyPage.this.table);
            }
            return this.textCellEditor;
        }

        protected Object getValue(Object element) {
            if (element instanceof Mapping) {
                Mapping mapping = (Mapping)element;
                String name = mapping.getLibName();
                if (name != null) {
                    return name;
                }
                return "";
            }
            return "";
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof Mapping) {
                Mapping mapping = (Mapping)element;
                if (value != null && value instanceof String) {
                    mapping.setLibName((String)value);
                    this.getViewer().update(element, null);
                }
            }
        }
    }

    private class LibraryLabelProvider
    extends ColumnLabelProvider {
        private LibraryLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Mapping) {
                Mapping mapping = (Mapping)element;
                String name = mapping.getLibName();
                if (name != null) {
                    return name;
                }
                return "";
            }
            return "";
        }
    }

    private class Mapping {
        private final IProjectInfo projectInfo;
        private String libName;

        private Mapping(IProjectInfo projectInfo) {
            this.projectInfo = projectInfo;
        }

        public IProjectInfo getProjectInfo() {
            return this.projectInfo;
        }

        private String getLibName() {
            return this.libName;
        }

        private void setLibName(String libName) {
            this.libName = libName;
        }
    }

    class MappingComparator
    extends ViewerComparator {
        MappingComparator() {
        }

        public int compare(Viewer viewer, Object object1, Object object2) {
            if (object1 == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            String proj1Name = ((Mapping)object1).getProjectInfo().getName();
            String proj2Name = ((Mapping)object2).getProjectInfo().getName();
            return proj1Name.compareTo(proj2Name);
        }
    }

    private class ProjectEditingSupport
    extends EditingSupport {
        public ProjectEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return false;
        }

        protected CellEditor getCellEditor(Object element) {
            return null;
        }

        protected Object getValue(Object element) {
            return null;
        }

        protected void setValue(Object element, Object value) {
        }
    }

    private class ProjectLabelProvider
    extends ColumnLabelProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Mapping) {
                Mapping mapping = (Mapping)element;
                String name = mapping.getProjectInfo().getName();
                if (name != null) {
                    mapping.getProjectInfo().isDuplicateInWorkspace();
                    return name;
                }
                return "";
            }
            return "";
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(final Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            if (inputElement instanceof IWorkspace) {
                Job job = new Job(Messages.IPROJECT_LIBRARY_MAPPING_JOB_NAME){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            List allProjects = FileSystemIUtil.getInstance().getIProjectsWithInfos((IWorkspaceHandle)((IWorkspace)inputElement), ProjectToLibraryMappingsPropertyPage.this.repository, false, ProjectToLibraryMappingsPropertyPage.this.globalMonitor);
                            ArrayList<IFolderHandle> folderHandles = new ArrayList<IFolderHandle>();
                            int i = 0;
                            while (i < allProjects.size()) {
                                folderHandles.add(((IProjectInfo)allProjects.get(i)).getFolderHandle());
                                ++i;
                            }
                            List allMappedProjects = null;
                            if (ProjectToLibraryMappingsPropertyPage.this.workspaceIHandle != null) {
                                allMappedProjects = ProjectToLibraryMappingsPropertyPage.this.clientLibrary.getProjectToLibraryMappings(ProjectToLibraryMappingsPropertyPage.this.workspaceIHandle, folderHandles, null);
                            }
                            ProjectToLibraryMappingsPropertyPage.this.allNeededMappings = new ArrayList();
                            IStatus returnStatus = Status.OK_STATUS;
                            for (IProjectInfo projectInfo : allProjects) {
                                IFolderHandle folderHandle = projectInfo.getFolderHandle();
                                Mapping tempMap = new Mapping(projectInfo);
                                if (allMappedProjects != null) {
                                    if (allMappedProjects.size() < allProjects.size()) {
                                        returnStatus = new Status(0, "com.ibm.teamp.filesystem.ide.ui", 100, Messages.ERROR_MAPPINGS_INCOMPLETE, null);
                                    }
                                    int k = 0;
                                    while (k < allMappedProjects.size()) {
                                        IProjectToLibraryMapHandle mapHandle = (IProjectToLibraryMapHandle)allMappedProjects.get(k);
                                        IProjectToLibraryMap temp = (IProjectToLibraryMap)ProjectToLibraryMappingsPropertyPage.this.repository.itemManager().fetchCompleteItem((IItemHandle)mapHandle, 1, null);
                                        if (temp.getFolder().sameItemId((IItemHandle)folderHandle)) {
                                            tempMap.setLibName(temp.getLibrary());
                                        }
                                        ++k;
                                    }
                                }
                                ProjectToLibraryMappingsPropertyPage.this.allNeededMappings.add(tempMap);
                            }
                            if (!ProjectToLibraryMappingsPropertyPage.this.dialogCancelled && !ProjectToLibraryMappingsPropertyPage.this.dialogClosed) {
                                new UIJob(""){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (!ProjectToLibraryMappingsPropertyPage.this.tableViewer.getTable().isDisposed()) {
                                            ProjectToLibraryMappingsPropertyPage.this.tableViewer.setInput((Object)ProjectToLibraryMappingsPropertyPage.this.allNeededMappings);
                                        }
                                        return Status.OK_STATUS;
                                    }
                                }.schedule();
                            }
                            return returnStatus;
                        }
                        catch (TeamRepositoryException e) {
                            return new Status(4, "com.ibm.teamp.filesystem.ide.ui", e.getLocalizedMessage());
                        }
                    }
                };
                job.schedule();
                return new Mapping[]{new Mapping(new IProjectInfo(Messages.IPROJECT_LIBRARY_MAPPING_LOADING, null, null))};
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

