/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.properties;

import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.filesystem.ide.ui.util.VerifyHostConnectionAction;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IAutoLoadConnectionInfo;
import com.ibm.teami.scm.common.IAutoLoadConnectionInfoHandle;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class IBMIConnectionPropertyPage
extends PropertyPage {
    private static final int ISTATUS_WORKSPACEI_HANDLE_NULL_CODE = 100;
    private static final int ISTATUS_AUTOLOADCONNECTIONINFO_HANDLE_NULL_CODE = 101;
    private Text hostnameText;
    private Text userNameText;
    private Text passwordText;
    private Button verifyConnectionBtn;
    private ITeamRepository repository;
    private IWorkspace workspace;
    private IScmIClientLibrary clientLibrary = null;
    private IWorkspaceIHandle workspaceIHandle = null;
    private IAutoLoadConnectionInfoHandle autoLoadConnectionInfoHandle = null;
    private IAutoLoadConnectionInfo autoLoadConnectionInfo = null;
    private final VerifyHostConnectionAction verifyConnectionAction = new VerifyHostConnectionAction("", "", "");

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.team.filesystem.ide.ui.ibmiconnectionprop");
        Composite autoLoadComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        autoLoadComposite.setLayoutData((Object)new GridData(1808));
        layout.numColumns = 2;
        autoLoadComposite.setLayout((Layout)layout);
        this.createLabel(autoLoadComposite, Messages.CONNECTION_CHECKBOX_LABEL, 2);
        this.createLabel(autoLoadComposite, Messages.HOST_NAME_LABEL);
        this.hostnameText = this.createText(autoLoadComposite, false);
        this.createLabel(autoLoadComposite, Messages.USER_NAME_LABEL, 1);
        this.userNameText = this.createText(autoLoadComposite, false);
        this.createLabel(autoLoadComposite, Messages.PASSWORD_LABEL, 1);
        this.passwordText = this.createText(autoLoadComposite, true);
        this.verifyConnectionBtn = new Button(autoLoadComposite, 8);
        this.verifyConnectionBtn.setText(Messages.VERIFY_CONNECTION_LABEL);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.verifyConnectionBtn.setLayoutData((Object)gridData);
        this.verifyConnectionBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IBMIConnectionPropertyPage.this.verifyConnectionAction.setConnectionInfo(IBMIConnectionPropertyPage.this.hostnameText.getText(), IBMIConnectionPropertyPage.this.userNameText.getText(), IBMIConnectionPropertyPage.this.passwordText.getText());
                IStatus status = IBMIConnectionPropertyPage.this.verifyConnectionAction.verifyConnection();
                if (status.isOK()) {
                    IBMIConnectionPropertyPage.this.setMessage(Messages.INFO_VALID_HOST_CONNECTION);
                    IBMIConnectionPropertyPage.this.setErrorMessage(null);
                } else {
                    IBMIConnectionPropertyPage.this.setMessage(null);
                    IBMIConnectionPropertyPage.this.setErrorMessage(status.getMessage());
                }
            }
        });
        this.initialize();
        return parent;
    }

    protected void initialize() {
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof ContributorPlaceWrapper) {
            String password;
            String userName;
            String hostname;
            ContributorPlaceWrapper wrapper = (ContributorPlaceWrapper)adaptable;
            this.repository = wrapper.getRepository();
            this.workspace = wrapper.getWorkspace();
            this.clientLibrary = (IScmIClientLibrary)this.repository.getClientLibrary(IScmIClientLibrary.class);
            Job job = new Job(Messages.CONNECTION_JOB_NAME){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IBMIConnectionPropertyPage.this.workspaceIHandle = IBMIConnectionPropertyPage.this.clientLibrary.getWorkspaceI((IWorkspaceHandle)IBMIConnectionPropertyPage.this.workspace, null);
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_FINDING_IWORKSPACE);
                    }
                    if (IBMIConnectionPropertyPage.this.workspaceIHandle == null) {
                        return new Status(0, "com.ibm.teamp.filesystem.ide.ui", 100, "", null);
                    }
                    try {
                        IBMIConnectionPropertyPage.this.autoLoadConnectionInfoHandle = IBMIConnectionPropertyPage.this.clientLibrary.getAutoLoadConnectionInfo(IBMIConnectionPropertyPage.this.workspaceIHandle, null);
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_FINDING_CONNECTION_INFO);
                    }
                    if (IBMIConnectionPropertyPage.this.autoLoadConnectionInfoHandle == null) {
                        return new Status(0, "com.ibm.teamp.filesystem.ide.ui", 101, "", null);
                    }
                    try {
                        IBMIConnectionPropertyPage.this.autoLoadConnectionInfo = (IAutoLoadConnectionInfo)IBMIConnectionPropertyPage.this.repository.itemManager().fetchCompleteItem((IItemHandle)IBMIConnectionPropertyPage.this.autoLoadConnectionInfoHandle, 1, null);
                        return Status.OK_STATUS;
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_GETTING_CONNECTION_INFO_ITEM);
                    }
                }
            };
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                this.setErrorMessageFromBackgroundJob(NLS.bind((String)Messages.ERROR_JOB_INTERRUPTED, (Object)job.getName()));
                return;
            }
            IStatus result = job.getResult();
            if (!result.isOK()) {
                if (result.getSeverity() == 2) {
                    this.setErrorMessage(result.getMessage());
                    return;
                }
            } else {
                this.setErrorMessage(null);
                if (result.getCode() == 100) {
                    this.setTextEmpty();
                    return;
                }
                if (result.getCode() == 101) {
                    this.setTextEmpty();
                    return;
                }
            }
            if ((hostname = this.autoLoadConnectionInfo.getHostname()) == null) {
                hostname = "";
            }
            if ((userName = this.autoLoadConnectionInfo.getUserName()) == null) {
                userName = "";
            }
            if ((password = this.autoLoadConnectionInfo.getPassword()) == null) {
                password = "";
            }
            this.hostnameText.setText(hostname);
            this.userNameText.setText(userName);
            this.passwordText.setText(password);
        }
    }

    protected void setTextEmpty() {
        this.hostnameText.setText("");
        this.userNameText.setText("");
        this.passwordText.setText("");
    }

    public boolean performOk() {
        final String hostname = this.hostnameText.getText();
        final String userName = this.userNameText.getText();
        final String password = this.passwordText.getText();
        Job job = new Job(Messages.CONNECTION_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                String tempHostname = hostname;
                String tempUserName = userName;
                String tempPassword = password;
                if (IBMIConnectionPropertyPage.this.workspaceIHandle == null) {
                    try {
                        IBMIConnectionPropertyPage.this.workspaceIHandle = IBMIConnectionPropertyPage.this.clientLibrary.getWorkspaceI((IWorkspaceHandle)IBMIConnectionPropertyPage.this.workspace, null);
                        if (IBMIConnectionPropertyPage.this.workspaceIHandle == null) {
                            IBMIConnectionPropertyPage.this.workspaceIHandle = IBMIConnectionPropertyPage.this.clientLibrary.createWorkspaceI((IWorkspaceHandle)IBMIConnectionPropertyPage.this.workspace, null);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_CREATING_IWORKSPACE);
                    }
                }
                try {
                    IBMIConnectionPropertyPage.this.clientLibrary.setAutoLoad(IBMIConnectionPropertyPage.this.workspaceIHandle, true, null);
                }
                catch (TeamRepositoryException e) {
                    return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_SETTING_LOADI_CONNECTION);
                }
                if (tempHostname.equals("")) {
                    tempHostname = null;
                }
                if (tempUserName.equals("")) {
                    tempUserName = null;
                }
                if (tempPassword.equals("")) {
                    tempPassword = null;
                }
                try {
                    IBMIConnectionPropertyPage.this.autoLoadConnectionInfoHandle = IBMIConnectionPropertyPage.this.clientLibrary.setAutoLoadConnectionInfo(IBMIConnectionPropertyPage.this.workspaceIHandle, tempHostname, tempUserName, tempPassword, null);
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    if (hostname == null || userName == null || password == null) {
                        return Status.OK_STATUS;
                    }
                    return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_SETTING_LOADI_CONNECTION);
                }
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            this.setErrorMessageFromBackgroundJob(NLS.bind((String)Messages.ERROR_JOB_INTERRUPTED, (Object)job.getName()));
            return false;
        }
        IStatus result = job.getResult();
        if (result.isOK()) {
            this.setErrorMessage(null);
            return super.performOk();
        }
        if (result.getSeverity() == 2) {
            this.setErrorMessage(result.getMessage());
        }
        return false;
    }

    protected void performDefaults() {
        this.setTextEmpty();
        this.setErrorMessage(null);
        super.performDefaults();
    }

    protected Button createCheckBox(Composite parent, String text, int span) {
        Button button = new Button(parent, 32);
        button.setText(Messages.CONNECTION_CHECKBOX_LABEL);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16512);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 1);
    }

    protected Text createText(Composite parent, int span, boolean isPassword) {
        Text text = null;
        text = !isPassword ? new Text(parent, 2052) : new Text(parent, 0x400804);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        text.setLayoutData((Object)data);
        return text;
    }

    protected Text createText(Composite parent, boolean isPassword) {
        return this.createText(parent, 1, isPassword);
    }

    private void setErrorMessageFromBackgroundJob(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IBMIConnectionPropertyPage.this.setErrorMessage(message);
            }
        });
    }
}

