/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.wizards.pages;

import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.client.internal.metadata.ScmComponentMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmWorkspaceMetadata;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.ide.ui.HelpContextIds;
import com.ibm.teami.filesystem.ide.ui.LoggingHelper;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.filesystem.ide.ui.util.ImageUtil;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IProjectToLibraryMap;
import com.ibm.teami.scm.common.IProjectToLibraryMapHandle;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SelectProjectPage
extends WizardPage {
    static final int NO_ERROR = 0;
    static final int NO_MAPPING_LIBRARY_ERROR = 1;
    static final int LEGACY_PROJECT_FOUND_ERROR = 2;
    static final int SOME_ERRORS = 3;
    private CheckboxTreeViewer fProjectViewer;
    private ScmWorkspaceMetadata scmWorkspace;
    private Button selectAllBtn;
    private Button deselectAllBtn;
    private StackLayout stackLayout;
    private Composite stackComposite;
    private Composite viewerComposite;
    private Composite pendingComposite;
    private Label pendingLabel;
    private Job retrieveIWorkspaceJob;

    public SelectProjectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.SELECT_PROJECT_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.stackLayout = new StackLayout();
        this.stackComposite = new Composite(mainComposite, 0);
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.stackComposite.setLayoutData((Object)new GridData(1808));
        this.stackComposite.setBackground(parent.getDisplay().getSystemColor(1));
        this.viewerComposite = new Composite(this.stackComposite, 0);
        this.viewerComposite.setLayoutData((Object)new GridData(1808));
        this.viewerComposite.setLayout((Layout)new FillLayout());
        this.pendingComposite = new Composite(this.stackComposite, 0);
        this.pendingComposite.setBackground(this.stackComposite.getBackground());
        this.pendingComposite.setLayoutData((Object)new GridData(1808));
        this.pendingComposite.setLayout((Layout)new GridLayout());
        Composite buttonComposite = new Composite(mainComposite, 0);
        GridLayout bcLayout = new GridLayout();
        bcLayout.marginHeight = 0;
        buttonComposite.setLayout((Layout)bcLayout);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        this.fProjectViewer = new CheckboxTreeViewer(this.viewerComposite, 2818);
        this.fProjectViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fProjectViewer.setLabelProvider((IBaseLabelProvider)new MetadataLabelProvider());
        this.addCheckedStateListener();
        this.selectAllBtn = new Button(buttonComposite, 8);
        this.selectAllBtn.setText(Messages.SELECT_ALL_BUTTON_LABEL);
        this.selectAllBtn.setLayoutData((Object)new GridData(768));
        this.selectAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectProjectPage.this.setAllCheckedState(true);
                SelectProjectPage.this.validatePageComplete(true);
            }
        });
        this.deselectAllBtn = new Button(buttonComposite, 8);
        this.deselectAllBtn.setText(Messages.DESELECT_ALL_BUTTON_LABEL);
        this.deselectAllBtn.setLayoutData((Object)new GridData(768));
        this.deselectAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectProjectPage.this.setAllCheckedState(false);
                SelectProjectPage.this.validatePageComplete(true);
            }
        });
        this.pendingLabel = new Label(this.pendingComposite, 0x2000040);
        this.pendingLabel.setText(Messages.PENDING_LABEL);
        this.pendingLabel.setBackground(this.pendingComposite.getBackground());
        this.stackLayout.topControl = this.pendingComposite;
        this.stackComposite.layout();
        this.enableButtons(true);
        HelpContextIds.hookHelpListener((Control)mainComposite, "com.ibm.team.filesystem.ide.ui.comparewizard_selectproject");
        this.setControl((Control)mainComposite);
    }

    protected void enableButtons(boolean isPending) {
        this.selectAllBtn.setEnabled(!isPending);
        this.deselectAllBtn.setEnabled(!isPending);
        this.validatePageComplete(false);
    }

    public void setWorkspaceSelection(ContributorPlaceWrapper cpWrapper) {
        ITeamRepository repository = cpWrapper.getRepository();
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)cpWrapper.getWorkspace().getItemHandle();
        this.scmWorkspace = new ScmWorkspaceMetadata(cpWrapper.getWorkspace().getName(), repository, workspaceHandle);
        this.retrieveIWorkspaceJob = new Job(Messages.RETRIEVE_IPROJECTS_JOB_LABEL){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    final int rc = SelectProjectPage.this.retrieveComponentMetadatas(SelectProjectPage.this.scmWorkspace, monitor);
                    SelectProjectPage.this.getWizard().getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SelectProjectPage.this.fProjectViewer.setInput((Object)SelectProjectPage.this.scmWorkspace);
                            SelectProjectPage.this.setAllCheckedState(true);
                            SelectProjectPage.this.enableButtons(false);
                            if (SelectProjectPage.this.scmWorkspace == null || SelectProjectPage.this.scmWorkspace.getAllScmComponentMetadatas().length == 0) {
                                SelectProjectPage.this.setErrorMessage(Messages.INFO_NO_MAPPINGS_FOUND);
                                SelectProjectPage.this.enableButtons(true);
                            } else if ((rc & 3) == 3) {
                                SelectProjectPage.this.setMessage(Messages.INFO_RETRIEVE_PROJECTS_0, 2);
                            } else if ((rc & 1) == 1) {
                                SelectProjectPage.this.setMessage(Messages.INFO_RETRIEVE_PROJECTS_1, 2);
                            } else if ((rc & 2) == 2) {
                                SelectProjectPage.this.setMessage(Messages.INFO_RETRIEVE_PROJECTS_2, 2);
                            }
                            ((SelectProjectPage)(this).SelectProjectPage.this).stackLayout.topControl = SelectProjectPage.this.viewerComposite;
                            SelectProjectPage.this.stackComposite.layout();
                        }
                    });
                }
                catch (OperationCanceledException rc) {
                }
                catch (Exception e) {
                    LoggingHelper.error("com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_RUNNING_ACTION, e);
                    return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_RUNNING_ACTION, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        this.retrieveIWorkspaceJob.schedule();
    }

    private void addCheckedStateListener() {
        this.fProjectViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean isCheck = event.getCheckable().getChecked(element);
                if (element instanceof ScmComponentMetadata) {
                    SelectProjectPage.this.fProjectViewer.setSubtreeChecked(element, isCheck);
                    if (!isCheck) {
                        SelectProjectPage.this.fProjectViewer.setGrayed(element, false);
                    }
                } else if (element instanceof ScmLibraryMetadata) {
                    ScmLibraryMetadata scmLibrary = (ScmLibraryMetadata)element;
                    ScmComponentMetadata scmComponent = scmLibrary.getScmComponentMetadata();
                    if (SelectProjectPage.this.fProjectViewer.getChecked((Object)scmLibrary)) {
                        if (SelectProjectPage.this.hasUncheckedChildren(scmComponent)) {
                            SelectProjectPage.this.fProjectViewer.setGrayChecked((Object)scmComponent, true);
                        } else {
                            SelectProjectPage.this.fProjectViewer.setGrayed((Object)scmComponent, false);
                            SelectProjectPage.this.fProjectViewer.setChecked((Object)scmComponent, true);
                        }
                    } else if (SelectProjectPage.this.hasCheckedChildren(scmComponent)) {
                        SelectProjectPage.this.fProjectViewer.setGrayChecked((Object)scmComponent, true);
                    } else {
                        SelectProjectPage.this.fProjectViewer.setGrayed((Object)scmComponent, false);
                        SelectProjectPage.this.fProjectViewer.setChecked((Object)scmComponent, false);
                    }
                }
                SelectProjectPage.this.validatePageComplete(true);
            }
        });
    }

    public ScmWorkspaceMetadata getAllCheckedElements() {
        ScmWorkspaceMetadata newScmWorkspace = new ScmWorkspaceMetadata(this.scmWorkspace.getName(), this.scmWorkspace.getRepository(), this.scmWorkspace.getWorkspaceHandle());
        Iterator iterator = this.scmWorkspace.scmComponentMetadatas();
        while (iterator.hasNext()) {
            ScmComponentMetadata scmComponent = (ScmComponentMetadata)iterator.next();
            ScmComponentMetadata checkedComponent = new ScmComponentMetadata(scmComponent.getName(), scmComponent.getComponentHandle(), newScmWorkspace);
            if (this.fProjectViewer.getGrayed((Object)scmComponent)) {
                Iterator libraries = scmComponent.libraryMetadatas();
                while (libraries.hasNext()) {
                    ScmLibraryMetadata library = (ScmLibraryMetadata)libraries.next();
                    if (!this.fProjectViewer.getChecked((Object)library)) continue;
                    checkedComponent.addLibraryMetadata(library);
                }
            } else if (this.fProjectViewer.getChecked((Object)scmComponent)) {
                checkedComponent.addAllLibraryMetadatas(scmComponent.getLibraryMetadataList());
            }
            if (!checkedComponent.hasLibraryMetadatas()) continue;
            newScmWorkspace.addScmComponentMetadata(checkedComponent);
        }
        return newScmWorkspace;
    }

    protected boolean hasCheckedElements() {
        ScmWorkspaceMetadata scmWorkspace = this.getAllCheckedElements();
        return scmWorkspace.hasScmComponentMetadatas();
    }

    protected void validatePageComplete(boolean showMessage) {
        if (this.hasCheckedElements()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            if (showMessage) {
                this.setErrorMessage(Messages.ERROR_NO_PROJECT);
            }
            this.setPageComplete(false);
        }
    }

    protected void setAllCheckedState(boolean state) {
        Iterator iterator = this.scmWorkspace.scmComponentMetadatas();
        while (iterator.hasNext()) {
            ScmComponentMetadata scmComponent = (ScmComponentMetadata)iterator.next();
            this.fProjectViewer.setSubtreeChecked((Object)scmComponent, state);
            if (state) continue;
            this.fProjectViewer.setGrayed((Object)scmComponent, false);
        }
    }

    protected int retrieveComponentMetadatas(ScmWorkspaceMetadata scmWorkspace, IProgressMonitor monitor) throws TeamRepositoryException, OperationCanceledException {
        int rc = 0;
        ITeamRepository repository = scmWorkspace.getRepository();
        IWorkspaceHandle workspaceHandle = scmWorkspace.getWorkspaceHandle();
        IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspaceHandle, monitor);
        IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repository.getClientLibrary(IScmIClientLibrary.class);
        IWorkspaceIHandle wsIHandle = clientLibrary.getWorkspaceI(workspaceHandle, null);
        if (wsIHandle == null) {
            LoggingHelper.warn("com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_RUNNING_ACTION);
            return rc;
        }
        List componentHandles = wsConn.getComponents();
        if (componentHandles == null || componentHandles.isEmpty()) {
            LoggingHelper.warn("com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_NO_COMPONENT_FOUND);
            return rc;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(componentHandles.size() * 2));
        for (IComponentHandle componentHandle : componentHandles) {
            List mappingHandles;
            List iProjectHandles;
            IComponent component = (IComponent)repository.itemManager().fetchPartialItem((IItemHandle)componentHandle, 0, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
            String componentName = "";
            if (component != null) {
                componentName = component.getName();
            }
            if ((iProjectHandles = FileSystemIUtil.getInstance().getIProjects(workspaceHandle, componentHandle, repository, (IProgressMonitor)progress.newChild(1))) == null) continue;
            IConfiguration configuration = wsConn.configuration(componentHandle);
            List nonLegacyProjectHandles = FileSystemIUtil.getInstance().filterOutLegacyIProjects(iProjectHandles, configuration);
            if ((rc & 2) != 2 && iProjectHandles.size() != nonLegacyProjectHandles.size()) {
                rc |= 2;
            }
            if ((mappingHandles = clientLibrary.getProjectToLibraryMappings(wsIHandle, nonLegacyProjectHandles, null)) == null) continue;
            if ((rc & 1) != 1 && nonLegacyProjectHandles.size() != mappingHandles.size()) {
                rc |= 1;
            }
            ScmComponentMetadata componentMetadata = new ScmComponentMetadata(componentName, componentHandle, scmWorkspace);
            SubMonitor loopProgress2 = progress.newChild(1).setWorkRemaining(mappingHandles.size());
            for (IProjectToLibraryMapHandle mapHandle : mappingHandles) {
                try {
                    IProjectToLibraryMap plMap = (IProjectToLibraryMap)repository.itemManager().fetchCompleteItem((IItemHandle)mapHandle, 1, monitor);
                    IFolder project = (IFolder)configuration.fetchPartialItem((IVersionableHandle)plMap.getFolder(), Collections.singletonList(IFolder.NAME_PROPERTY), (IProgressMonitor)loopProgress2.newChild(1));
                    ScmLibraryMetadata scmLibrary = new ScmLibraryMetadata(project.getName(), plMap.getFolder(), componentMetadata, plMap.getLibrary());
                    componentMetadata.addLibraryMetadata(scmLibrary);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
            if (!componentMetadata.hasLibraryMetadatas()) continue;
            scmWorkspace.addScmComponentMetadata(componentMetadata);
        }
        return rc;
    }

    protected boolean hasUncheckedChildren(ScmComponentMetadata scmComponent) {
        return this.hasChildWithCheckedState(scmComponent, false);
    }

    protected boolean hasCheckedChildren(ScmComponentMetadata scmComponent) {
        return this.hasChildWithCheckedState(scmComponent, true);
    }

    protected boolean hasChildWithCheckedState(ScmComponentMetadata scmComponent, boolean isCheck) {
        ScmLibraryMetadata[] libraries = scmComponent.getLibraryMetadatas();
        int i = 0;
        while (i < libraries.length) {
            if (this.fProjectViewer.getChecked((Object)libraries[i]) == isCheck) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void cancelRetrieveIWorkspaceJob() {
        if (this.retrieveIWorkspaceJob == null || this.retrieveIWorkspaceJob.getState() == 0) {
            return;
        }
        this.retrieveIWorkspaceJob.cancel();
    }

    public void performHelp() {
        HelpContextIds.hookHelpListener((Control)this.getShell(), "com.ibm.team.filesystem.ide.ui.comparewizard_selectproject");
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ScmWorkspaceMetadata) {
                return ((ScmWorkspaceMetadata)parentElement).getAllScmComponentMetadatas();
            }
            if (parentElement instanceof ScmComponentMetadata) {
                return ((ScmComponentMetadata)parentElement).getLibraryMetadatas();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class MetadataLabelProvider
    extends LabelProvider {
        ImageUtil imageUtil;
        private final ImageDescriptor componentImage;
        private final ImageDescriptor projectImage;

        MetadataLabelProvider() {
            this.imageUtil = new ImageUtil(SelectProjectPage.this.fProjectViewer.getControl());
            this.componentImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.teamp.filesystem.ide.ui", (String)"icons/obj16/component.gif");
            this.projectImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.teamp.filesystem.ide.ui", (String)"icons/obj16/project.gif");
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDesc = this.getImageDescriptor(element);
            if (imageDesc != null) {
                return this.imageUtil.getImage(imageDesc);
            }
            return super.getImage(element);
        }

        private ImageDescriptor getImageDescriptor(Object element) {
            if (element instanceof ScmComponentMetadata) {
                return this.componentImage;
            }
            if (element instanceof ScmLibraryMetadata) {
                return this.projectImage;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ScmComponentMetadata) {
                return ((ScmComponentMetadata)element).getName();
            }
            if (element instanceof ScmLibraryMetadata) {
                return String.valueOf(((ScmLibraryMetadata)element).getName()) + "  [" + ((ScmLibraryMetadata)element).getMappingLibrary() + "]";
            }
            return "";
        }
    }
}

