/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.wizards.pages;

import com.ibm.as400.access.AS400;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiHelperFactory;
import com.ibm.teami.filesystem.ide.ui.HelpContextIds;
import com.ibm.teami.filesystem.ide.ui.LoggingHelper;
import com.ibm.teami.filesystem.ide.ui.compare.composites.SelectHostComposite;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.filesystem.ide.ui.util.VerifyHostConnectionAction;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IAutoLoadConnectionInfo;
import com.ibm.teami.scm.common.IAutoLoadConnectionInfoHandle;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectHostPage
extends WizardPage
implements IPropertyChangeListener {
    private String hostName;
    private String userName;
    private String password;
    private SelectHostComposite selectHostComposite;
    private Button saveHostInfo;
    private ContributorPlaceWrapper cpWrapper;
    private final VerifyHostConnectionAction verifyConnectionAction;

    public SelectHostPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.SELECT_HOST_PAGE_DESC);
        this.verifyConnectionAction = new VerifyHostConnectionAction("", "", "");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.selectHostComposite = new SelectHostComposite(composite, false);
        this.selectHostComposite.setLayoutData(new GridData(768));
        this.enableChangeListener();
        this.saveHostInfo = new Button(composite, 32);
        this.saveHostInfo.setText(Messages.SAVE_HOST_CONNECTION_LABEL);
        this.setControl((Control)composite);
        this.validatePageComplete(false);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.filesystem.ide.ui.comparewizard_selecthost");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Job job = new Job(Messages.RETRIEVE_CONNECTIONS_JOB_LABEL){

                public IStatus run(IProgressMonitor monitor) {
                    boolean rc = false;
                    try {
                        IAutoLoadConnectionInfoHandle autoLoadConnectionInfoHandle;
                        ITeamRepository repository = SelectHostPage.this.cpWrapper.getRepository();
                        IWorkspaceHandle wsHandle = (IWorkspaceHandle)SelectHostPage.this.cpWrapper.getWorkspace().getItemHandle();
                        IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repository.getClientLibrary(IScmIClientLibrary.class);
                        IWorkspaceIHandle wsIHandle = clientLibrary.getWorkspaceI(wsHandle, null);
                        if (wsIHandle != null && (autoLoadConnectionInfoHandle = clientLibrary.getAutoLoadConnectionInfo(wsIHandle, null)) != null) {
                            final IAutoLoadConnectionInfo autoLoadConnectionInfo = (IAutoLoadConnectionInfo)repository.itemManager().fetchCompleteItem((IItemHandle)autoLoadConnectionInfoHandle, 0, null);
                            if (SelectHostPage.this.isWizardUp()) {
                                SelectHostPage.this.getWizard().getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        SelectHostPage.this.setHostConnection(autoLoadConnectionInfo.getHostname(), autoLoadConnectionInfo.getUserName(), autoLoadConnectionInfo.getPassword());
                                    }
                                });
                            }
                            rc = true;
                        }
                        if (!rc && SelectHostPage.this.isWizardUp()) {
                            SelectHostPage.this.getWizard().getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    SelectHostPage.this.setHostConnection("", "", "");
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        LoggingHelper.debug("com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_RUNNING_ACTION, e);
                        return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_RUNNING_ACTION, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            if (this.hostName == null || this.hostName.equals("")) {
                this.selectHostComposite.setHostName(Messages.PENDING_LABEL);
                job.schedule();
            }
        }
    }

    private boolean isWizardUp() {
        return this.getWizard() != null && this.getWizard().getContainer() != null;
    }

    private void validatePageComplete(boolean showMessage) {
        this.verifyConnectionAction.setConnectionInfo(this.hostName, this.userName, this.password);
        IStatus status = this.verifyConnectionAction.verifyInformation();
        if (status.isOK()) {
            this.setErrorMessage(null);
            this.setMessage(Messages.SELECT_HOST_PAGE_DESC);
            this.setPageComplete(true);
        } else {
            if (showMessage) {
                this.setErrorMessage(status.getMessage());
            }
            this.setPageComplete(false);
        }
    }

    public AS400 getAS400() {
        return IBMiHelperFactory.instance().getAS400(this.hostName, this.userName, this.password);
    }

    public void setWorkspaceSelection(ContributorPlaceWrapper cpWrapper) {
        this.cpWrapper = cpWrapper;
    }

    public void performHelp() {
        HelpContextIds.hookHelpListener((Control)this.getShell(), "com.ibm.team.filesystem.ide.ui.comparewizard_selecthost");
    }

    public void disableChangeListener() {
        this.selectHostComposite.removePropertyChangeListener(this);
    }

    public void enableChangeListener() {
        this.selectHostComposite.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        boolean needValidation = true;
        if (event.getProperty().equals("hostname")) {
            this.hostName = (String)event.getNewValue();
        } else if (event.getProperty().equals("username")) {
            this.userName = (String)event.getNewValue();
        } else if (event.getProperty().equals("password")) {
            this.password = (String)event.getNewValue();
        }
        if (needValidation) {
            this.validatePageComplete(true);
        }
    }

    public void setHostConnection(String hostname, String username, String password) {
        this.disableChangeListener();
        this.hostName = hostname;
        this.userName = username;
        this.password = password;
        this.selectHostComposite.setHostName(hostname);
        this.selectHostComposite.setUserName(username);
        this.selectHostComposite.setPassword(password);
        this.validatePageComplete(false);
        this.enableChangeListener();
    }

    public String[] getHostConnection() {
        if (this.userName == null) {
            this.userName = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        return new String[]{this.hostName, this.userName, this.password};
    }

    public boolean isHostConnectionValid() {
        VerifyHostConnectionAction action = new VerifyHostConnectionAction(this.hostName, this.userName, this.password);
        IStatus status = action.verifyConnection();
        if (status.isOK()) {
            return true;
        }
        this.setErrorMessage(status.getMessage());
        return false;
    }

    public boolean isSaveHostInfo() {
        return this.saveHostInfo.getSelection();
    }
}

