/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.wizards;

import com.ibm.as400.access.AS400;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.client.internal.metadata.ScmWorkspaceMetadata;
import com.ibm.teami.filesystem.ide.ui.LoggingHelper;
import com.ibm.teami.filesystem.ide.ui.compare.wizards.pages.SelectHostPage;
import com.ibm.teami.filesystem.ide.ui.compare.wizards.pages.SelectProjectPage;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CompareIProjectWizard
extends Wizard {
    private SelectProjectPage selectProjectPage;
    private SelectHostPage selectHostPage;
    private ScmWorkspaceMetadata scmWorkspace;
    private ContributorPlaceWrapper cpWrapper;
    private AS400 as400;

    public CompareIProjectWizard() {
        this.setWindowTitle(Messages.COMPARE_PROJECT_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.teamp.filesystem.ide.ui", (String)"icons/wizban/compare_with_ibmi.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.selectProjectPage = new SelectProjectPage("SelectProjectPage", Messages.SELECT_PROJECT_PAGE_TITLE, null);
        this.addPage((IWizardPage)this.selectProjectPage);
        this.selectProjectPage.setWorkspaceSelection(this.cpWrapper);
        this.selectHostPage = new SelectHostPage("SelectHostPage", Messages.SELECT_HOST_PAGE_TITLE, null);
        this.addPage((IWizardPage)this.selectHostPage);
        this.selectHostPage.setWorkspaceSelection(this.cpWrapper);
    }

    public void setWorkspaceSelection(ContributorPlaceWrapper cpWrapper) {
        this.cpWrapper = cpWrapper;
    }

    public ScmWorkspaceMetadata getScmWorkspaceMetadata() {
        return this.scmWorkspace;
    }

    public AS400 getAS400() {
        return this.as400;
    }

    public boolean performFinish() {
        if (!this.selectHostPage.isHostConnectionValid()) {
            return false;
        }
        this.scmWorkspace = this.selectProjectPage.getAllCheckedElements();
        this.as400 = this.selectHostPage.getAS400();
        try {
            if (this.selectHostPage.isSaveHostInfo()) {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ITeamRepository repository = CompareIProjectWizard.this.scmWorkspace.getRepository();
                            IWorkspaceHandle wsHandle = CompareIProjectWizard.this.scmWorkspace.getWorkspaceHandle();
                            IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repository.getClientLibrary(IScmIClientLibrary.class);
                            IWorkspaceIHandle wsIHandle = clientLibrary.getWorkspaceI(wsHandle, null);
                            String[] hostConnection = CompareIProjectWizard.this.selectHostPage.getHostConnection();
                            clientLibrary.setAutoLoadConnectionInfo(wsIHandle, hostConnection[0], hostConnection[1], hostConnection[2], null);
                            monitor.done();
                        }
                        catch (Exception e) {
                            LoggingHelper.error("com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_SAVING_HOST_CONNECTION, e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LoggingHelper.error("com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_SAVING_HOST_CONNECTION, e);
        }
        return true;
    }

    public boolean performCancel() {
        this.selectProjectPage.cancelRetrieveIWorkspaceJob();
        return super.performCancel();
    }
}

