/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.views;

import com.ibm.teami.filesystem.ide.ui.compare.views.IDiffNode;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ConflictTooltip {
    private Shell shell;
    private Widget target;
    private Label label;

    public ConflictTooltip(Shell parent) {
        this.shell = new Shell(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        this.shell.setLayout((Layout)gridLayout);
        this.label = new Label((Composite)this.shell, 16384);
        this.label.setLayoutData((Object)new GridData(768));
    }

    public void addHoverListener(Tree tree) {
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                ConflictTooltip.this.hideTooltip();
            }
        });
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent event) {
                ConflictTooltip.this.hideTooltip();
            }

            public void mouseHover(MouseEvent event) {
                ConflictTooltip.this.displayTooltip((Tree)event.widget, new Point(event.x, event.y));
            }
        });
    }

    protected void hideTooltip() {
        if (this.shell.isVisible()) {
            this.shell.setVisible(false);
        }
        this.target = null;
    }

    protected void displayTooltip(Tree tree, Point location) {
        TreeItem widget = tree.getItem(location);
        if (widget == null || widget == this.target) {
            this.hideTooltip();
            return;
        }
        this.target = widget;
        Object element = this.target.getData();
        if (!(element instanceof IDiffNode)) {
            this.hideTooltip();
            return;
        }
        IDiffNode targetNode = (IDiffNode)element;
        if (targetNode.getTooltip() == null) {
            this.hideTooltip();
            return;
        }
        this.label.setText(targetNode.getTooltip());
        Point position = tree.toDisplay(location);
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.setHoverLocation(position);
        this.shell.setVisible(true);
    }

    protected void setHoverLocation(Point position) {
        Rectangle displayBounds = this.shell.getDisplay().getBounds();
        Rectangle shellBounds = this.shell.getBounds();
        shellBounds.x = position.x;
        shellBounds.y = position.y + 16;
        if (shellBounds.y + shellBounds.height >= displayBounds.height) {
            shellBounds.y = position.y - shellBounds.height;
        }
        this.shell.setBounds(shellBounds);
    }
}

