/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.views;

import com.ibm.as400.access.AS400;
import com.ibm.teami.filesystem.client.internal.metadata.ScmWorkspaceMetadata;
import com.ibm.teami.filesystem.ide.ui.HelpContextIds;
import com.ibm.teami.filesystem.ide.ui.compare.actions.AbstractUIUpdateAction;
import com.ibm.teami.filesystem.ide.ui.compare.actions.CompareAction;
import com.ibm.teami.filesystem.ide.ui.compare.actions.LoadiAction;
import com.ibm.teami.filesystem.ide.ui.compare.actions.OpenCompareEditorAction;
import com.ibm.teami.filesystem.ide.ui.compare.actions.SelectHostAction;
import com.ibm.teami.filesystem.ide.ui.compare.composites.DiffDetailComposite;
import com.ibm.teami.filesystem.ide.ui.compare.composites.ProgressComposite;
import com.ibm.teami.filesystem.ide.ui.compare.views.ActionUIUpdateEvent;
import com.ibm.teami.filesystem.ide.ui.compare.views.CenteringLayout;
import com.ibm.teami.filesystem.ide.ui.compare.views.CompareViewFilter;
import com.ibm.teami.filesystem.ide.ui.compare.views.CompareViewerSorter;
import com.ibm.teami.filesystem.ide.ui.compare.views.CustomizeFilterAction;
import com.ibm.teami.filesystem.ide.ui.compare.views.DiffContentProvider;
import com.ibm.teami.filesystem.ide.ui.compare.views.DiffLabelProvider;
import com.ibm.teami.filesystem.ide.ui.compare.views.IActionUIUpdateListener;
import com.ibm.teami.filesystem.ide.ui.compare.views.IDetailSupplier;
import com.ibm.teami.filesystem.ide.ui.compare.views.IDiffContainerNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.IDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.LibraryDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.RootNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.ScmComponentNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.SourceFileDiffNode;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.filesystem.ide.ui.util.DialogSettingsUtil;
import com.ibm.teami.filesystem.ide.ui.util.HostConnectionInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CompareRemoteView
extends ViewPart
implements IActionUIUpdateListener,
IShellProvider {
    private TreeViewer viewer;
    private LoadiAction loadiAction;
    private CompareAction compareAction;
    private AbstractUIUpdateAction refreshAction;
    private Action collapseAllAction;
    private Action expandAllAction;
    private OpenCompareEditorAction openInCompareAction;
    private CustomizeFilterAction showChangeAction;
    private StackLayout stackLayout;
    private ProgressComposite progressComposite;
    private Composite mainComposite;
    private SelectHostAction selectHostAction;
    private DiffDetailComposite diffDetailComposite;
    private SashForm sashForm;

    public void createPartControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.stackLayout);
        this.sashForm = new SashForm(this.mainComposite, 256);
        this.sashForm.setLayout((Layout)new FillLayout());
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer((Composite)this.sashForm);
        this.viewer.setContentProvider((IContentProvider)new DiffContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new DiffLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.setSorter((ViewerSorter)new CompareViewerSorter());
        this.resetViewFilter();
        this.progressComposite = new ProgressComposite(this.mainComposite, "");
        this.progressComposite.setLayoutData(new GridData(1808));
        this.progressComposite.setLayout(new CenteringLayout());
        this.createActions();
        this.fillLocalToolBar(this.getViewSite().getActionBars().getToolBarManager());
        this.configureListeners();
        this.diffDetailComposite = new DiffDetailComposite((Composite)this.sashForm, this);
        this.diffDetailComposite.setLayout((Layout)new FillLayout());
        this.flipToView();
        this.sashForm.setWeights(new int[]{1, 1});
        HelpContextIds.hookHelpListener((Control)this.mainComposite, "com.ibm.team.filesystem.ide.ui.compareview_usage");
    }

    public void setInput(ScmWorkspaceMetadata scmWorkspace, AS400 as400) {
        this.compareAction.setScmWorkspaceMetadata(scmWorkspace);
        this.compareAction.setAS400(as400);
        this.compareAction.setRefreshScmWorkspace(true);
        this.compareAction.run();
    }

    public void resetViewFilter() {
        this.viewer.setFilters(new ViewerFilter[]{new CompareViewFilter()});
    }

    protected void refreshView(CompareAction compareAction) {
        if (compareAction.getWorkspaceDiffNode() != null) {
            this.setContentDescription(String.valueOf(compareAction.getWorkspaceDiffNode().getLabel()) + "  <->  " + compareAction.getIHostName());
            this.viewer.setInput((Object)compareAction.getWorkspaceDiffNode());
            this.viewer.expandAll();
        }
    }

    protected boolean hasChanges(RootNode root) {
        IDiffNode[] components = root.getChildren();
        int i = 0;
        while (i < components.length) {
            ScmComponentNode component = (ScmComponentNode)components[i];
            IDiffNode[] libraries = component.getChildren();
            int j = 0;
            while (j < libraries.length) {
                LibraryDiffNode library = (LibraryDiffNode)libraries[j];
                if (library.getChangeType() != 0 || library.hasChildren()) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    protected void flipToView() {
        this.stackLayout.topControl = this.sashForm;
        this.mainComposite.layout();
        this.enableActions(true);
    }

    protected void flipToProgress(AbstractUIUpdateAction action) {
        this.progressComposite.setMessage(action.getDescription());
        this.progressComposite.setAction(action);
        this.progressComposite.layout();
        this.stackLayout.topControl = this.progressComposite;
        this.mainComposite.layout();
        this.enableActions(false);
    }

    @Override
    public void actionPerformed(ActionUIUpdateEvent event) {
        if (event.getType() == 1) {
            this.flipToProgress(event.getAction());
        } else if (event.getType() == 2) {
            if (event.getStatus().getSeverity() == 0) {
                IDiffNode node;
                if (event.getAction() instanceof CompareAction) {
                    this.refreshView((CompareAction)event.getAction());
                    DialogSettingsUtil.saveHostConnectionInfo(new HostConnectionInfo(this.compareAction.getIHostName(), this.compareAction.getIHostUserId()));
                } else if (event.getAction() instanceof LoadiAction && (node = ((LoadiAction)event.getAction()).getDiffNode()) != null) {
                    if (node instanceof LibraryDiffNode) {
                        node.setChangeType(0);
                        ((LibraryDiffNode)node).removeAllChildren();
                    } else {
                        IDiffContainerNode parentNode = node.getParent();
                        parentNode.removeChild(node);
                        if (parentNode instanceof SourceFileDiffNode && !parentNode.hasChildren()) {
                            IDiffContainerNode grandParentNode = parentNode.getParent();
                            grandParentNode.removeChild(parentNode);
                            if (!grandParentNode.hasChildren()) {
                                grandParentNode.setChangeType(0);
                            }
                        } else if (parentNode instanceof LibraryDiffNode && !parentNode.hasChildren()) {
                            parentNode.setChangeType(0);
                        }
                    }
                    this.viewer.refresh();
                }
                if (!this.hasChanges(this.compareAction.getWorkspaceDiffNode())) {
                    this.diffDetailComposite.displayMessage(Messages.ALL_FILES_IN_SYNC);
                } else {
                    this.diffDetailComposite.displayDefault();
                }
            } else if (event.getStatus().getSeverity() == 8) {
                if (event.getAction() instanceof CompareAction) {
                    this.refreshView((CompareAction)event.getAction());
                    DialogSettingsUtil.saveHostConnectionInfo(new HostConnectionInfo(this.compareAction.getIHostName(), this.compareAction.getIHostUserId()));
                }
                this.diffDetailComposite.displayMessage(Messages.INFO_ACTION_CANCEL);
            } else {
                if (event.getAction() instanceof CompareAction) {
                    this.refreshView((CompareAction)event.getAction());
                }
                this.handleMessage(event.getStatus());
                if (event.getStatus().getSeverity() != 1) {
                    this.diffDetailComposite.displayMessage(Messages.ERROR_RUNNING_ACTION_3);
                }
            }
            this.flipToView();
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
    }

    protected void configureListeners() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CompareRemoteView.this.openInCompareAction.run();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                CompareRemoteView.this.loadiAction.selectionChanged(ss);
                CompareRemoteView.this.openInCompareAction.selectionChanged(ss);
                Object selectedObject = ss.getFirstElement();
                if (selectedObject != null && selectedObject instanceof IDetailSupplier) {
                    CompareRemoteView.this.diffDetailComposite.displayDetails((IDetailSupplier)selectedObject);
                }
            }
        });
    }

    protected void createActions() {
        this.loadiAction = new LoadiAction(this);
        this.loadiAction.addActionRunningListener(this);
        this.compareAction = new CompareAction(this);
        this.compareAction.addActionRunningListener(this);
        this.collapseAllAction = new Action(){

            public void run() {
                CompareRemoteView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setText(Messages.COLLPASE_ALL_MENU_ACTION);
        this.collapseAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.teamp.filesystem.ide.ui", (String)"icons/elcl16/collapse_all.gif"));
        this.expandAllAction = new Action(){

            public void run() {
                CompareRemoteView.this.viewer.expandAll();
            }
        };
        this.expandAllAction.setText(Messages.EXPAND_ALL_MENU_ACTION);
        this.expandAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.teamp.filesystem.ide.ui", (String)"icons/elcl16/expand_all.gif"));
        this.refreshAction = new AbstractUIUpdateAction(this, Messages.REFRESH_ACTION_TEXT, Messages.REFRESH_ACTION_DESC){

            @Override
            protected IStatus performAction(IProgressMonitor monitor) throws CoreException {
                CompareRemoteView.this.compareAction.setRefreshScmWorkspace(true);
                CompareRemoteView.this.compareAction.runWithDescription(this.getDescription());
                return Status.OK_STATUS;
            }
        };
        this.refreshAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.teamp.filesystem.ide.ui", (String)"icons/elcl16/refresh.gif"));
        this.selectHostAction = new SelectHostAction(this.compareAction);
        this.openInCompareAction = new OpenCompareEditorAction(this);
        this.showChangeAction = new CustomizeFilterAction(this);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.loadiAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.selectHostAction);
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IAction)this.showChangeAction);
    }

    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    protected void enableActions(boolean enable) {
        this.loadiAction.setEnabled(enable);
        this.collapseAllAction.setEnabled(enable);
        this.expandAllAction.setEnabled(enable);
        this.selectHostAction.setEnabled(enable);
        this.refreshAction.setEnabled(enable);
        this.showChangeAction.setEnabled(enable);
    }

    protected void handleMessage(IStatus status) {
        switch (status.getSeverity()) {
            case 1: {
                MessageDialog.openInformation((Shell)this.viewer.getTree().getShell(), (String)Messages.COMPARE_INFO_DIALOG_LABEL, (String)status.getMessage());
                break;
            }
            case 2: {
                MessageDialog.openError((Shell)this.viewer.getTree().getShell(), (String)Messages.COMPARE_ERROR_DIALOG_LABEL, (String)status.getMessage());
            }
        }
    }
}

