/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.views;

import com.ibm.etools.iseries.projects.core.IIBMiPropertyKeyConstants;
import com.ibm.teami.filesystem.client.internal.metadata.IMetadata;
import com.ibm.teami.filesystem.ide.ui.compare.views.IDiffContainerNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.IDiffNode;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.filesystem.ide.ui.util.ImageUtil;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractDiffNode
implements IDiffNode {
    protected IMetadata scmMetadata;
    protected IMetadata ibmiMetadata;
    protected int changeType;
    protected IDiffContainerNode parentNode;
    protected String[] changedAttributes;

    public AbstractDiffNode(IMetadata scmMetadata, IMetadata ibmiMetadata, int changeType) {
        this(scmMetadata, ibmiMetadata, changeType, null);
    }

    public AbstractDiffNode(IMetadata scmMetadata, IMetadata ibmiMetadata, int changeType, String[] changedAttributes) {
        this.scmMetadata = scmMetadata;
        this.ibmiMetadata = ibmiMetadata;
        this.changeType = changeType;
        this.changedAttributes = changedAttributes == null ? new String[0] : changedAttributes;
    }

    public IMetadata getScmMetadata() {
        return this.scmMetadata;
    }

    public IMetadata getIBMiMetadata() {
        return this.ibmiMetadata;
    }

    protected abstract ImageDescriptor getBaseImageDescriptor();

    @Override
    public Image getImage(ImageUtil imageUtil) {
        ImageDescriptor baseImageDescriptor = this.getBaseImageDescriptor();
        Image baseImage = null;
        if (baseImageDescriptor != null && imageUtil != null) {
            baseImage = imageUtil.getImage(baseImageDescriptor);
        }
        return baseImage;
    }

    @Override
    public String getLabel() {
        String label = "";
        switch (this.changeType) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                label = this.scmMetadata.getName();
                break;
            }
            case 3: 
            case 5: {
                label = this.ibmiMetadata.getName();
            }
        }
        return label;
    }

    @Override
    public void setParent(IDiffContainerNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public IDiffContainerNode getParent() {
        return this.parentNode;
    }

    @Override
    public void setChangeType(int type) {
        this.changeType = type;
    }

    @Override
    public int getChangeType() {
        return this.changeType;
    }

    public void setChangedAttributes(String[] changedAttributes) {
        this.changedAttributes = changedAttributes == null ? new String[0] : changedAttributes;
    }

    public boolean hasChangedAttributes() {
        return this.changedAttributes.length > 0;
    }

    public String[] getAllChangedAttributes() {
        return this.changedAttributes;
    }

    @Override
    public String getTooltip() {
        return null;
    }

    protected String getCSS4Details() {
        StringBuffer buffer = new StringBuffer("<style type=\"text/css\">\n");
        buffer.append("BODY {background-color: white; color: black; font-family: arial, tahoma, helvetica, sans-serif; font-size: 9pt;}\n");
        buffer.append("H3 {color:#387C44}\n");
        buffer.append("H4 {color:#387C44}\n");
        buffer.append("TABLE.ATTRIBUTE {background-color:#FFFFDA; font-size: 9pt; font-family: arial, tahoma, helvetica, sans-serif;}\n");
        buffer.append("TR.HEADER {text-align: center; color:#FFFFFF; background-color:#54C571; font-weight:bold}\n");
        buffer.append("TR.ATTR_ROW {color:#000000;}\n");
        buffer.append("TABLE.CONFLICT {font-size: 9pt; font-family: arial, tahoma, helvetica, sans-serif;}\n");
        buffer.append(".DATE_CONFLICT {color: red; font-weight: bold;}\n");
        buffer.append(".BOLD_TEXT {font-weight:bold}\n");
        buffer.append("</style>");
        return buffer.toString();
    }

    @Override
    public String getDetailContent() {
        StringBuffer buffer = new StringBuffer(this.getCSS4Details());
        buffer.append("<H4>").append(Messages.bind((String)Messages.DETAIL_MESSAGE, (Object[])new String[]{this.getLabel()})).append("</H4>\n");
        buffer.append(this.getDetailHtml());
        return buffer.toString();
    }

    protected String getDetailHtml() {
        return "";
    }

    protected String getHtml4ChangedAttributes() {
        if (this.changedAttributes.length > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<p>").append(Messages.ATTRIBUTE_CHANGED_MESSAGE);
            buffer.append("<table class=\"ATTRIBUTE\" border='1'><tr class=\"HEADER\">");
            buffer.append("<td>").append(Messages.COLUMN1_TABLE_HEADER).append("</td>");
            buffer.append("<td>").append(Messages.COLUMN2_TABLE_HEADER).append("</td>");
            buffer.append("<td>").append(Messages.COLUMN3_TABLE_HEADER).append("</td></tr>");
            int i = 0;
            while (i < this.changedAttributes.length) {
                String attr = this.changedAttributes[i];
                String attrValue1 = this.addHtmlSpaceIfEmpty(this.scmMetadata.getAttribute(attr));
                String attrValue2 = this.addHtmlSpaceIfEmpty(this.ibmiMetadata.getAttribute(attr));
                buffer.append("<tr class=\"ATTR_ROW\"><td>").append(this.getAttributeLabel(attr)).append("</td><td>").append(attrValue1).append("</td>");
                buffer.append("<td>").append(attrValue2).append("</td></tr>");
                ++i;
            }
            buffer.append("</table>\n");
            return buffer.toString();
        }
        return "";
    }

    protected String getAttributeLabel(String id) {
        if (IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString().equals(id)) {
            return Messages.ATTR_TEXT_DESCRIPTION;
        }
        if (IIBMiPropertyKeyConstants.KEY_RECORD_LENGTH.toString().equals(id)) {
            return Messages.ATTR_RECORD_LENGTH;
        }
        if (IIBMiPropertyKeyConstants.KEY_CCSID.toString().equals(id)) {
            return Messages.ATTR_CCSID;
        }
        return id;
    }

    private String addHtmlSpaceIfEmpty(String value) {
        if (value == null || value.equals("")) {
            return "&nbsp";
        }
        return value;
    }

    protected String getConflictHtml() {
        StringBuffer buffer = new StringBuffer("<table class=\"CONFLICT\"><tr><td>");
        buffer.append(Messages.CONFLICT_LAST_LOADED);
        buffer.append("</td><td class=\"DATE_CONFLICT\">");
        buffer.append(this.formatTimestamp(this.ibmiMetadata.getIbmiMetadataLastModification()));
        buffer.append("</td></tr><tr><td>");
        buffer.append(Messages.CONFLICT_LAST_MODIFICATION_ON_IBMI).append("</td><td class=\"DATE_CONFLICT\">");
        buffer.append(this.formatTimestamp(this.ibmiMetadata.getIbmiFileLastModification())).append("</tr></table>");
        return buffer.toString();
    }

    private String formatTimestamp(long timestamp) {
        if (timestamp == -1L) {
            return Messages.NO_TIMESTAMP;
        }
        return DateFormat.getDateTimeInstance().format(new Date(timestamp));
    }
}

