/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.views;

import com.ibm.teami.filesystem.client.internal.metadata.IMetadata;
import com.ibm.teami.filesystem.ide.ui.compare.views.AbstractDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.IDiffContainerNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.IDiffNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDiffContainerNode
extends AbstractDiffNode
implements IDiffContainerNode {
    protected List<IDiffNode> children = new ArrayList<IDiffNode>();

    public AbstractDiffContainerNode(IMetadata scmMetadata, IMetadata ibmiMetadata, int changeType) {
        super(scmMetadata, ibmiMetadata, changeType);
    }

    @Override
    public void addChild(IDiffNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public IDiffNode[] getChildren() {
        IDiffNode[] temp = new IDiffNode[this.children.size()];
        return this.children.toArray(temp);
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public void removeChild(IDiffNode child) {
        if (child == null) {
            return;
        }
        this.children.remove(child);
        child.setParent(null);
    }

    @Override
    public void removeAllChildren() {
        this.children.clear();
    }

    public IDiffNode[] getAllOutgoingChangeChildren() {
        ArrayList<IDiffNode> result = new ArrayList<IDiffNode>(this.children.size());
        for (IDiffNode next : this.children) {
            if (next.getChangeType() != 2 && next.getChangeType() != 1 && next.getChangeType() != 3) continue;
            result.add(next);
        }
        return result.toArray(new IDiffNode[result.size()]);
    }

    public IDiffNode[] getAllIncomingChangeChildren() {
        ArrayList<IDiffNode> result = new ArrayList<IDiffNode>(this.children.size());
        for (IDiffNode next : this.children) {
            if (next.getChangeType() != 5 && next.getChangeType() != 4 && next.getChangeType() != 6) continue;
            result.add(next);
        }
        return result.toArray(new IDiffNode[result.size()]);
    }
}

