/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.dialogs;

import com.ibm.teami.filesystem.ide.ui.compare.composites.SelectHostComposite;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.filesystem.ide.ui.util.VerifyHostConnectionAction;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectHostDialog
extends Dialog {
    private SelectHostComposite selectHostComposite;
    private Label fMessage;
    private String hostName;
    private String userName;
    private String password;
    private final VerifyHostConnectionAction verifyConnectionAction = new VerifyHostConnectionAction("", "", "");

    public SelectHostDialog(Shell parentShell) {
        super(parentShell);
    }

    public void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SELECT_HOST_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData();
        gridData.widthHint = 350;
        composite.setLayoutData((Object)gridData);
        this.selectHostComposite = new SelectHostComposite(composite, true);
        if (this.hostName != null) {
            this.selectHostComposite.setHostName(this.hostName);
        }
        if (this.userName != null) {
            this.selectHostComposite.setUserName(this.userName);
        }
        this.selectHostComposite.initializeFocus();
        this.selectHostComposite.setLayoutData(new GridData(1808));
        this.selectHostComposite.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                boolean needValidation = true;
                if (event.getProperty().equals("hostname")) {
                    SelectHostDialog.this.hostName = (String)event.getNewValue();
                } else if (event.getProperty().equals("username")) {
                    SelectHostDialog.this.userName = (String)event.getNewValue();
                } else if (event.getProperty().equals("password")) {
                    SelectHostDialog.this.password = (String)event.getNewValue();
                } else if (event.getProperty().equals("verify")) {
                    needValidation = false;
                    IStatus status = (IStatus)event.getNewValue();
                    if (status.isOK()) {
                        SelectHostDialog.this.setInfoMessage(Messages.INFO_VALID_HOST_CONNECTION);
                    } else {
                        SelectHostDialog.this.setErrorMessage(status.getMessage());
                    }
                }
                if (needValidation) {
                    SelectHostDialog.this.validateDialogComplete(true);
                }
            }
        });
        this.fMessage = new Label(composite, 16448);
        gridData = new GridData(1792);
        GC gc = new GC((Drawable)this.getShell().getDisplay());
        Point ptX = gc.stringExtent("X");
        gridData.heightHint = ptX.y * 2;
        gc.dispose();
        this.fMessage.setLayoutData((Object)gridData);
        return composite;
    }

    public void create() {
        super.create();
        this.validateDialogComplete(false);
    }

    protected void validateDialogComplete(boolean showMessage) {
        this.verifyConnectionAction.setConnectionInfo(this.hostName, this.userName, this.password);
        IStatus status = this.verifyConnectionAction.verifyInformation();
        if (status.isOK()) {
            this.setInfoMessage("");
            this.getButton(0).setEnabled(true);
        } else {
            if (showMessage) {
                this.setErrorMessage(status.getMessage());
            }
            this.getButton(0).setEnabled(false);
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private void setErrorMessage(String errorMessage) {
        this.fMessage.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.fMessage.setText(errorMessage);
    }

    private void setInfoMessage(String message) {
        this.fMessage.setForeground(null);
        this.fMessage.setText(message);
    }
}

