/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.composites;

import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.filesystem.ide.ui.util.VerifyHostConnectionAction;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectHostComposite
extends Composite {
    private final Text fHostName;
    private final Text fUserName;
    private final Text fPassword;
    private Button fVerifyConnection;
    private final ListenerList listeners = new ListenerList();

    public SelectHostComposite(Composite parent, boolean allowVerifyConnection) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        this.createLabel(this, Messages.HOST_NAME_LABEL);
        this.fHostName = this.createText(this, false);
        this.fHostName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectHostComposite.this.firePropertyChangeListener(new PropertyChangeEvent((Object)SelectHostComposite.this.fHostName, "hostname", null, (Object)SelectHostComposite.this.fHostName.getText()));
            }
        });
        this.createLabel(this, Messages.USER_NAME_LABEL);
        this.fUserName = this.createText(this, false);
        this.fUserName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectHostComposite.this.firePropertyChangeListener(new PropertyChangeEvent((Object)SelectHostComposite.this.fUserName, "username", null, (Object)SelectHostComposite.this.fUserName.getText()));
            }
        });
        this.createLabel(this, Messages.PASSWORD_LABEL);
        this.fPassword = this.createText(this, true);
        this.fPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectHostComposite.this.firePropertyChangeListener(new PropertyChangeEvent((Object)SelectHostComposite.this.fPassword, "password", null, (Object)SelectHostComposite.this.fPassword.getText()));
            }
        });
        if (allowVerifyConnection) {
            this.fVerifyConnection = new Button((Composite)this, 8);
            this.fVerifyConnection.setText(Messages.VERIFY_CONNECTION_LABEL);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.fVerifyConnection.setLayoutData((Object)gridData);
            this.fVerifyConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    VerifyHostConnectionAction action = new VerifyHostConnectionAction(SelectHostComposite.this.fHostName.getText(), SelectHostComposite.this.fUserName.getText(), SelectHostComposite.this.fPassword.getText());
                    IStatus status = action.verifyConnection();
                    SelectHostComposite.this.firePropertyChangeListener(new PropertyChangeEvent((Object)SelectHostComposite.this.fVerifyConnection, "verify", null, (Object)status));
                }
            });
        }
    }

    protected Text createText(Composite parent, boolean isPassword) {
        Text text = null;
        text = isPassword ? new Text(parent, 0x400804) : new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        label.setLayoutData((Object)new GridData());
    }

    public void setHostName(String hostname) {
        if (hostname != null) {
            this.fHostName.setText(hostname);
        }
    }

    public void setUserName(String username) {
        if (username != null) {
            this.fUserName.setText(username);
        }
    }

    public void setPassword(String password) {
        if (password != null) {
            this.fPassword.setText(password);
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void firePropertyChangeListener(PropertyChangeEvent event) {
        Object[] tempListeners = this.listeners.getListeners();
        int i = 0;
        while (i < tempListeners.length) {
            ((IPropertyChangeListener)tempListeners[i]).propertyChange(event);
            ++i;
        }
    }

    public void initializeFocus() {
        if (this.fHostName != null && this.fHostName.getText().equals("")) {
            this.fHostName.setFocus();
        } else if (this.fUserName != null && this.fUserName.getText().equals("")) {
            this.fUserName.setFocus();
        } else {
            this.fPassword.setFocus();
        }
    }
}

