/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.composites;

import com.ibm.teami.filesystem.ide.ui.compare.actions.AbstractUIUpdateAction;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressComposite
extends Composite {
    private Label label;
    private AbstractUIUpdateAction action;
    private Button cancelBtn;

    public ProgressComposite(Composite parent, String message) {
        super(parent, 0);
        this.setBackground(parent.getShell().getDisplay().getSystemColor(1));
        Composite c = new Composite((Composite)this, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setBackground(this.getBackground());
        this.label = new Label(c, 256);
        this.label.setText(message);
        this.label.setLayoutData((Object)new GridData(768));
        this.label.setBackground(this.getBackground());
        ProgressBar bar = new ProgressBar(c, 258);
        GridData gridData = new GridData();
        gridData.widthHint = 250;
        bar.setLayoutData((Object)gridData);
        this.cancelBtn = new Button(c, 8);
        this.cancelBtn.setText(Messages.CANCEL_BTN_LABEL);
        this.cancelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ProgressComposite.this.action != null) {
                    ProgressComposite.this.action.cancel();
                }
            }
        });
    }

    public void setMessage(String message) {
        this.label.setText(message);
    }

    public void setAction(AbstractUIUpdateAction action) {
        this.action = action;
        if (this.action.isCancelAllow()) {
            this.cancelBtn.setVisible(true);
        } else {
            this.cancelBtn.setVisible(false);
        }
    }
}

