/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.composites;

import com.ibm.teami.filesystem.ide.ui.LoggingHelper;
import com.ibm.teami.filesystem.ide.ui.compare.views.CompareRemoteView;
import com.ibm.teami.filesystem.ide.ui.compare.views.IDetailSupplier;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.osgi.framework.Bundle;

public class DiffDetailComposite
extends Composite {
    private final Browser browser;
    private final CompareRemoteView view;

    public DiffDetailComposite(Composite parent, CompareRemoteView view) {
        super(parent, 0);
        this.view = view;
        this.browser = new Browser((Composite)this, 2048);
        this.browser.setLayoutData((Object)new GridData(1808));
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
                DiffDetailComposite.this.handleClick(event);
            }
        });
        this.displayDefault();
    }

    public void displayDetails(IDetailSupplier detailSupplier) {
        this.browser.setText(detailSupplier.getDetailContent());
    }

    public void displayMessage(String message) {
        this.browser.setText(message);
    }

    public void displayDefault() {
        this.browser.setText(Messages.SELECT_ITEM_MESSAGE);
    }

    protected void handleClick(LocationEvent event) {
        StringTokenizer st;
        String type;
        String url = event.location;
        if (url != null && (type = (st = new StringTokenizer(url, ":")).nextToken()).equals("action")) {
            this.handleAction(st.nextToken(), st.nextToken());
            event.doit = false;
        }
    }

    private void handleAction(String bundleId, String actionClass) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        try {
            Class aClass = bundle.loadClass(actionClass);
            IAction action = null;
            Constructor<?>[] ctrs = aClass.getConstructors();
            int i = 0;
            while (i < ctrs.length) {
                Class<?>[] parameters = ctrs[i].getParameterTypes();
                if (parameters.length == 1 && parameters[0].getName().equals(IShellProvider.class.getName())) {
                    action = (IAction)ctrs[i].newInstance(this.view);
                    break;
                }
                ++i;
            }
            if (action == null) {
                action = (IAction)aClass.newInstance();
            }
            if (action instanceof SelectionListenerAction) {
                ((SelectionListenerAction)action).selectionChanged(this.view.getSelection());
            }
            action.run();
        }
        catch (Exception e) {
            LoggingHelper.error("com.ibm.teamp.filesystem.ide.ui", e.getMessage(), e);
        }
    }
}

