/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.actions;

import com.ibm.as400.access.AS400;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiHelperFactory;
import com.ibm.teami.filesystem.ide.ui.compare.actions.CompareAction;
import com.ibm.teami.filesystem.ide.ui.compare.dialogs.SelectHostDialog;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.filesystem.ide.ui.util.DialogSettingsUtil;
import com.ibm.teami.filesystem.ide.ui.util.HostConnectionInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SelectHostAction
extends Action
implements IMenuCreator,
SelectionListener {
    private Menu hostMenu;
    private final CompareAction compareAction;

    public SelectHostAction(CompareAction compareAction) {
        super(Messages.SELECT_HOST_ACTION_TEXT);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.teamp.filesystem.ide.ui", (String)"icons/elcl16/select_host.gif"));
        this.setMenuCreator(this);
        this.compareAction = compareAction;
    }

    public void dispose() {
        if (this.hostMenu != null) {
            this.hostMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.hostMenu != null) {
            this.hostMenu.dispose();
        }
        this.hostMenu = new Menu(parent);
        this.hostMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                SelectHostAction.this.fillMenu();
            }
        });
        return this.hostMenu;
    }

    protected void selectNewHost() {
        SelectHostDialog dialog = new SelectHostDialog(this.hostMenu.getShell());
        if (dialog.open() == 0 && !dialog.getHostName().equals(this.compareAction.getIHostName())) {
            AS400 as400 = IBMiHelperFactory.instance().getAS400(dialog.getHostName(), dialog.getUserName(), dialog.getPassword());
            if (this.compareAction != null) {
                this.runCompareWithHost(as400);
            }
        }
    }

    protected void fillMenu() {
        MenuItem newHost = new MenuItem(this.hostMenu, 8);
        newHost.setText(Messages.NEW_HOST_MENU_ACTION);
        newHost.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectHostAction.this.selectNewHost();
            }
        });
        new MenuItem(this.hostMenu, 2);
        HostConnectionInfo[] hosts = DialogSettingsUtil.getAllHostConnectionInfos();
        int i = 0;
        while (i < 5 && i < hosts.length) {
            MenuItem menuItem = new MenuItem(this.hostMenu, 32);
            menuItem.setText(hosts[i].getHostname());
            menuItem.setData("userId", (Object)hosts[i].getUserId());
            menuItem.addSelectionListener((SelectionListener)this);
            ++i;
        }
        this.initMenuSelection();
    }

    protected void initMenuSelection() {
        MenuItem[] items = this.hostMenu.getItems();
        if (items == null || items.length == 0) {
            return;
        }
        String currentHostName = null;
        if (this.compareAction != null) {
            currentHostName = this.compareAction.getIHostName();
        }
        if (currentHostName == null) {
            currentHostName = items[2].getText();
            items[2].setSelection(true);
            return;
        }
        int i = 2;
        while (i < items.length) {
            if (items[i].getText().equals(currentHostName)) {
                items[i].setSelection(true);
                return;
            }
            ++i;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        String hostname = item.getText();
        String userId = (String)item.getData("userId");
        if (this.compareAction != null && !hostname.equals(this.compareAction.getIHostName())) {
            this.runCompareWithHost(IBMiHelperFactory.instance().getAS400(hostname, userId));
        }
    }

    public void run() {
        this.selectNewHost();
    }

    protected void runCompareWithHost(AS400 as400) {
        this.compareAction.setAS400(as400);
        this.compareAction.setRefreshScmWorkspace(true);
        this.compareAction.run();
    }
}

