/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.actions;

import com.ibm.teami.filesystem.client.internal.metadata.IBMiMemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmMemberMetadata;
import com.ibm.teami.filesystem.ide.ui.Activator;
import com.ibm.teami.filesystem.ide.ui.compare.views.CompareRemoteEditorInput;
import com.ibm.teami.filesystem.ide.ui.compare.views.MemberDiffNode;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class OpenCompareEditorAction
extends SelectionListenerAction {
    public static final String ACTION_URI = "com.ibm.teamp.filesystem.ide.ui:com.ibm.teami.filesystem.ide.ui.compare.actions.OpenCompareEditorAction";
    private IStructuredSelection selection;
    private final CompareConfiguration configuration = new CompareConfiguration();
    private final IShellProvider shellProvider;

    public OpenCompareEditorAction(IShellProvider shellProvider) {
        super(Messages.OPEN_COMPARE_EDITOR_ACTION_TEXT);
        this.configuration.setLeftEditable(false);
        this.configuration.setRightEditable(false);
        this.shellProvider = shellProvider;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        return true;
    }

    public void run() {
        if (this.selection == null || this.selection.getFirstElement() == null) {
            return;
        }
        try {
            if (this.selection.getFirstElement() instanceof MemberDiffNode) {
                byte[] byteContents1;
                MemberDiffNode node = (MemberDiffNode)this.selection.getFirstElement();
                ScmMemberMetadata scmMember = (ScmMemberMetadata)node.getScmMetadata();
                IBMiMemberMetadata ibmiMember = (IBMiMemberMetadata)node.getIBMiMetadata();
                if (scmMember != null) {
                    this.configuration.setLeftLabel(String.valueOf(scmMember.getName()) + " " + Messages.LEFT_LABEL_FOR_COMPARE_EDITOR);
                }
                if (ibmiMember != null) {
                    this.configuration.setRightLabel(String.valueOf(ibmiMember.getName()) + " " + Messages.RIGHT_LABEL_FOR_COMPARE_EDITOR);
                }
                if ((byteContents1 = scmMember.getContents()) == null) {
                    MessageDialog.openError((Shell)this.shellProvider.getShell(), (String)Messages.COMPARE_ERROR_DIALOG_LABEL, (String)Messages.ERROR_READING_CONTENTS_FROM_REPO);
                    return;
                }
                String ccsidmapping = Activator.getDefault().getPreferenceStore().getString("teamp.scm.ccsidmappings");
                byte[] byteContents2 = ibmiMember.getContents(ccsidmapping);
                if (byteContents2 == null) {
                    MessageDialog.openError((Shell)this.shellProvider.getShell(), (String)Messages.COMPARE_ERROR_DIALOG_LABEL, (String)Messages.ERROR_READING_CONTENTS_FROM_HOST);
                    return;
                }
                CompareUI.openCompareEditor((CompareEditorInput)new CompareRemoteEditorInput(byteContents1, scmMember.getName(), byteContents2, ibmiMember.getName(), this.configuration));
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.shellProvider.getShell(), (String)Messages.COMPARE_ERROR_DIALOG_LABEL, (String)e.getLocalizedMessage());
        }
    }
}

