/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.actions;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.projects.core.IBMiProjectResourceNameUtil;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiHelperFactory;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiMemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSaveFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSourceFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.LibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmComponentMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmMemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmSaveFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmSourceFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmWorkspaceMetadata;
import com.ibm.teami.filesystem.client.internal.operations.LoadICmd;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.ide.ui.Activator;
import com.ibm.teami.filesystem.ide.ui.LoggingHelper;
import com.ibm.teami.filesystem.ide.ui.compare.actions.AbstractUIUpdateAction;
import com.ibm.teami.filesystem.ide.ui.compare.views.IDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.LibraryDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.MemberDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.SaveFileDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.SourceFileDiffNode;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LoadiAction
extends AbstractUIUpdateAction {
    private IDiffNode diffNode;
    private boolean isClearLib;

    public LoadiAction(IShellProvider shellProvider) {
        super(shellProvider, Messages.LOADI_ACTION_TEXT, Messages.LOADI_ACTION_DESCRIPTION);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.teamp.filesystem.ide.ui", (String)"icons/elcl16/loadi.gif"));
        this.isClearLib = true;
        this.supportCancel = true;
    }

    public void selectionChanged(IStructuredSelection selection) {
        Object element;
        this.diffNode = null;
        if (selection != null && !selection.isEmpty() && ((element = selection.getFirstElement()) instanceof LibraryDiffNode || element instanceof SourceFileDiffNode || element instanceof MemberDiffNode || element instanceof SaveFileDiffNode)) {
            this.diffNode = (IDiffNode)element;
        }
    }

    @Override
    protected IStatus performAction(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.diffNode == null) {
            return new Status(1, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_NO_SELECTION_TO_LOAD);
        }
        if (this.diffNode.getChangeType() == 3 || this.diffNode.getChangeType() == 5) {
            return new Status(1, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_CANNOT_LOAD_DELETED_OBJECT);
        }
        if (this.diffNode instanceof LibraryDiffNode && ((LibraryDiffNode)this.diffNode).getChildren().length == 0 && this.diffNode.getChangeType() == 0) {
            return new Status(1, "com.ibm.teamp.filesystem.ide.ui", Messages.INFO_CANNOT_LOAD_LIB);
        }
        String ccsidmapping = Activator.getDefault().getPreferenceStore().getString("teamp.scm.ccsidmappings");
        LoadICmd command = new LoadICmd(null, ccsidmapping, new HashMap());
        try {
            if (this.diffNode instanceof LibraryDiffNode) {
                this.shellProvider.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        LoadiAction.this.isClearLib = MessageDialog.openQuestion((Shell)LoadiAction.this.shellProvider.getShell(), (String)Messages.COMPARE_INFO_DIALOG_LABEL, (String)Messages.CLEAR_LIBS_QUESTION);
                    }
                });
                LibraryDiffNode libraryDiffNode = (LibraryDiffNode)this.diffNode;
                ScmLibraryMetadata scmLibrary = (ScmLibraryMetadata)libraryDiffNode.getScmMetadata();
                IBMiLibraryMetadata ibmiLibrary = (IBMiLibraryMetadata)libraryDiffNode.getIBMiMetadata();
                ScmComponentMetadata scmComponent = scmLibrary.getScmComponentMetadata();
                ScmWorkspaceMetadata scmWorkspace = scmComponent.getScmWorkspaceMetadata();
                command.loadProject(scmWorkspace.getRepository(), scmWorkspace.getWorkspaceHandle(), scmComponent.getComponentHandle(), scmLibrary.getProjectHandle(), ibmiLibrary.getName(), ibmiLibrary.getAS400(), this.isClearLib, null, (IProgressMonitor)progress.newChild(100));
            } else if (this.diffNode instanceof SourceFileDiffNode) {
                SourceFileDiffNode sourceFileDiffNode = (SourceFileDiffNode)this.diffNode;
                ScmSourceFileMetadata scmSourceFile = (ScmSourceFileMetadata)sourceFileDiffNode.getScmMetadata();
                IBMiSourceFileMetadata ibmiSourceFile = (IBMiSourceFileMetadata)sourceFileDiffNode.getIBMiMetadata();
                ScmLibraryMetadata scmLibrary = (ScmLibraryMetadata)scmSourceFile.getLibraryMetadata();
                LibraryDiffNode libraryDiffNode = (LibraryDiffNode)sourceFileDiffNode.getParent();
                IBMiLibraryMetadata ibmiLibrary = (IBMiLibraryMetadata)libraryDiffNode.getIBMiMetadata();
                ScmComponentMetadata scmComponent = ((ScmLibraryMetadata)scmSourceFile.getLibraryMetadata()).getScmComponentMetadata();
                ScmWorkspaceMetadata scmWorkspace = scmComponent.getScmWorkspaceMetadata();
                ibmiSourceFile = command.loadSourceFile(scmWorkspace.getRepository(), scmWorkspace.getWorkspaceHandle(), scmComponent.getComponentHandle(), scmLibrary.getProjectHandle(), ibmiLibrary.getName(), scmSourceFile.getSourceFileHandle(), ibmiLibrary, ibmiLibrary.getAS400(), false, true, (IProgressMonitor)progress.newChild(70));
                if (ibmiSourceFile != null) {
                    IBMiHelperFactory.instance().getIFSMetadataWriter(ibmiLibrary.getAS400()).saveSourceFile(ibmiSourceFile, (IProgressMonitor)progress.newChild(30));
                }
            } else if (this.diffNode instanceof SaveFileDiffNode) {
                SaveFileDiffNode saveFileDiffNode = (SaveFileDiffNode)this.diffNode;
                ScmSaveFileMetadata scmSaveFile = (ScmSaveFileMetadata)saveFileDiffNode.getScmMetadata();
                ScmComponentMetadata scmComponent = ((ScmLibraryMetadata)scmSaveFile.getLibraryMetadata()).getScmComponentMetadata();
                ScmWorkspaceMetadata scmWorkspace = scmComponent.getScmWorkspaceMetadata();
                ScmLibraryMetadata scmLibrary = (ScmLibraryMetadata)scmSaveFile.getLibraryMetadata();
                LibraryDiffNode libraryDiffNode = (LibraryDiffNode)saveFileDiffNode.getParent();
                IBMiLibraryMetadata ibmiLibrary = (IBMiLibraryMetadata)libraryDiffNode.getIBMiMetadata();
                IBMiSaveFileMetadata ibmiSaveFile = command.loadSaveFile(scmWorkspace.getRepository(), scmWorkspace.getWorkspaceHandle(), scmComponent.getComponentHandle(), scmLibrary.getProjectHandle(), ibmiLibrary.getName(), (IFileItemHandle)scmSaveFile.getFileItem(), ibmiLibrary, ibmiLibrary.getAS400(), false, (IProgressMonitor)progress.newChild(70));
                if (ibmiSaveFile != null) {
                    IBMiHelperFactory.instance().getIFSMetadataWriter(ibmiLibrary.getAS400()).saveSaveFile(ibmiSaveFile, (IProgressMonitor)progress.newChild(30));
                }
            } else if (this.diffNode instanceof MemberDiffNode) {
                MemberDiffNode memberDiffNode = (MemberDiffNode)this.diffNode;
                ScmMemberMetadata scmMember = (ScmMemberMetadata)memberDiffNode.getScmMetadata();
                ScmSourceFileMetadata scmSourceFile = (ScmSourceFileMetadata)scmMember.getObjectMetadata();
                ScmLibraryMetadata scmLibrary = (ScmLibraryMetadata)scmSourceFile.getLibraryMetadata();
                ScmComponentMetadata scmComponent = scmLibrary.getScmComponentMetadata();
                ScmWorkspaceMetadata scmWorkspace = scmComponent.getScmWorkspaceMetadata();
                LibraryDiffNode libraryDiffNode = (LibraryDiffNode)memberDiffNode.getParent().getParent();
                IBMiLibraryMetadata ibmiLibrary = (IBMiLibraryMetadata)libraryDiffNode.getIBMiMetadata();
                IBMiSourceFileMetadata ibmiSourceFile = new IBMiSourceFileMetadata(scmSourceFile.getName(), -1L, (LibraryMetadata)ibmiLibrary, new Attributes());
                IBMiMemberMetadata ibmiMember = command.loadMember(scmWorkspace.getRepository(), scmWorkspace.getWorkspaceHandle(), scmComponent.getComponentHandle(), scmLibrary.getProjectHandle(), ibmiLibrary.getName(), scmSourceFile.getSourceFileHandle(), (IFileItemHandle)scmMember.getFileItem(), ibmiLibrary.getAS400(), ibmiSourceFile, false, (IProgressMonitor)progress.newChild(70));
                if (ibmiMember != null) {
                    long pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp((String)ibmiLibrary.getName(), (String)IBMiProjectResourceNameUtil.unEscapeFileName((String)scmSourceFile.getName()), (AS400)ibmiLibrary.getAS400());
                    long attrTimestamp = scmSourceFile.getAttributesLastModification();
                    IBMiHelperFactory.instance().getIFSMetadataWriter(ibmiLibrary.getAS400()).saveMember(ibmiMember, pfTimestamp, attrTimestamp, (IProgressMonitor)progress.newChild(30));
                }
            }
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.bind((String)Messages.ERROR_RUNNING_ACTION_2, (Object[])command.getErrorMessages()));
        }
        return Status.OK_STATUS;
    }

    private void logErrorMessages(String[] errorMessages) {
        if (errorMessages != null && errorMessages.length > 0) {
            String lf = System.getProperty("line.separator");
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < errorMessages.length) {
                buffer.append(lf).append(errorMessages[i]);
                ++i;
            }
            LoggingHelper.error("com.ibm.teamp.filesystem.ide.ui", buffer);
        }
    }

    public IDiffNode getDiffNode() {
        return this.diffNode;
    }
}

