/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.actions;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import com.ibm.etools.iseries.projects.core.IBMiProjectResourceNameUtil;
import com.ibm.etools.iseries.projects.core.IIBMiPropertyKeyConstants;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiHelperFactory;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiMemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiMetadataReader;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSaveFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSourceFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ObjectMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmComponentMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmMemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmMetadataReader;
import com.ibm.teami.filesystem.client.internal.metadata.ScmSaveFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmSourceFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmWorkspaceMetadata;
import com.ibm.teami.filesystem.ide.ui.Activator;
import com.ibm.teami.filesystem.ide.ui.compare.actions.AbstractUIUpdateAction;
import com.ibm.teami.filesystem.ide.ui.compare.dialogs.SelectHostDialog;
import com.ibm.teami.filesystem.ide.ui.compare.views.LibraryDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.MemberDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.ObjectDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.RootNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.SaveFileDiffNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.ScmComponentNode;
import com.ibm.teami.filesystem.ide.ui.compare.views.SourceFileDiffNode;
import com.ibm.teami.filesystem.ide.ui.nls.Messages;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IProjectToLibraryMap;
import com.ibm.teami.scm.common.IProjectToLibraryMapHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;

public class CompareAction
extends AbstractUIUpdateAction {
    protected ScmWorkspaceMetadata scmWorkspace;
    protected RootNode workspaceDiffNode;
    protected AS400 as400;
    protected boolean refreshScmWorkspace = false;
    private boolean isConnected;
    private static final String[] comparingMemberAttributes = new String[]{IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString()};
    private static final String[] comparingSaveFileAttributes = new String[]{IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString()};
    private static final String[] comparingSourceFileAttributes = new String[]{IIBMiPropertyKeyConstants.KEY_CCSID.toString(), IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), IIBMiPropertyKeyConstants.KEY_RECORD_LENGTH.toString()};

    public CompareAction(IShellProvider shellProvider) {
        super(shellProvider, Messages.COMPARE_ACTION_TEXT, Messages.COMPARE_ACTION_DESCRIPTION);
    }

    public void setScmWorkspaceMetadata(ScmWorkspaceMetadata scmWorkspace) {
        this.scmWorkspace = scmWorkspace;
    }

    public void setAS400(AS400 as400) {
        this.as400 = as400;
    }

    @Override
    protected IStatus performAction(IProgressMonitor monitor) throws CoreException {
        if (this.scmWorkspace == null) {
            return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_NO_WORKSPACE_SELECTED);
        }
        this.workspaceDiffNode = new RootNode(this.scmWorkspace.getName());
        String ccsidJob = Activator.getDefault().getPreferenceStore().getString("teamp.build.jobCCSID");
        boolean bl = this.isConnected = this.as400 == null || this.as400.isConnected(0);
        if (!this.isConnected) {
            if (ccsidJob != null && !ccsidJob.equals("")) {
                try {
                    this.as400.setCcsid(new Integer(ccsidJob).intValue());
                }
                catch (Exception e) {
                    return new Status(2, "com.ibm.teamp.filesystem.ide.ui", NLS.bind((String)Messages.WARNING_JOB_CCSID_USE, (Object)ccsidJob));
                }
            }
            this.attemptToConnectToHost();
            if (!this.isConnected) {
                return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_HOST_CONNECTION_INVALID);
            }
        }
        if (ccsidJob != null && !ccsidJob.equals("")) {
            CommandCall command = new CommandCall(this.as400);
            String changeJobCommandString = "CHGJOB CCSID(" + ccsidJob + ")";
            try {
                boolean ok = command.run(changeJobCommandString);
                if (!ok) {
                    return new Status(2, "com.ibm.teamp.filesystem.ide.ui", NLS.bind((String)Messages.WARNING_JOB_CCSID_USE, (Object)ccsidJob));
                }
            }
            catch (Exception e) {
                return new Status(2, "com.ibm.teamp.filesystem.ide.ui", NLS.bind((String)Messages.WARNING_JOB_CCSID_USE, (Object)ccsidJob));
            }
        }
        ITeamRepository repository = null;
        IWorkspaceHandle workspaceHandle = null;
        IBMiMetadataReader ifsMetadataReader = null;
        ScmMetadataReader scmMetadataReader = null;
        try {
            repository = this.scmWorkspace.getRepository();
            workspaceHandle = this.scmWorkspace.getWorkspaceHandle();
            scmMetadataReader = new ScmMetadataReader(repository, workspaceHandle);
            ifsMetadataReader = IBMiHelperFactory.instance().getIFSMetadataReader(this.as400);
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_REPOSITORY_INVALID);
        }
        if (repository == null || workspaceHandle == null || ifsMetadataReader == null) {
            return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.ERROR_REPOSITORY_INVALID);
        }
        try {
            List<IProjectToLibraryMap> mappings = null;
            if (this.refreshScmWorkspace) {
                mappings = this.getIProjectToLibraryMappings(repository, workspaceHandle, monitor);
            }
            Iterator iterator = this.scmWorkspace.scmComponentMetadatas();
            while (iterator.hasNext()) {
                ScmComponentMetadata scmComponent = (ScmComponentMetadata)iterator.next();
                ScmComponentNode componentDiffNode = new ScmComponentNode(scmComponent);
                Iterator iterator2 = scmComponent.libraryMetadatas();
                while (iterator2.hasNext()) {
                    ScmLibraryMetadata scmLibrary = (ScmLibraryMetadata)iterator2.next();
                    if (this.refreshScmWorkspace) {
                        String mappingLibrary = this.getLibraryMapping(mappings, scmLibrary.getProjectHandle());
                        scmLibrary = scmMetadataReader.getLibraryMetadata(scmComponent, scmLibrary.getProjectHandle(), mappingLibrary, monitor);
                    }
                    if (scmLibrary == null || !scmLibrary.hasMappingLibrary()) continue;
                    IBMiLibraryMetadata ibmiLibrary = new IBMiLibraryMetadata(scmLibrary.getMappingLibrary(), this.as400, true);
                    boolean isLibraryExist = ifsMetadataReader.parseLibrary(ibmiLibrary, monitor);
                    LibraryDiffNode libraryDiffNode = this.compareLibraries(scmLibrary, ibmiLibrary);
                    if (!isLibraryExist) {
                        libraryDiffNode.setChangeType(2);
                    }
                    componentDiffNode.addChild(libraryDiffNode);
                }
                this.workspaceDiffNode.addChild(componentDiffNode);
            }
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            return new Status(2, "com.ibm.teamp.filesystem.ide.ui", Messages.bind((String)Messages.ERROR_RUNNING_ACTION_2, (Object[])new String[]{e.getLocalizedMessage()}));
        }
        return Status.OK_STATUS;
    }

    private String getLibraryMapping(List<IProjectToLibraryMap> mappings, IFolderHandle project) {
        for (IProjectToLibraryMap mapping : mappings) {
            if (!mapping.getFolder().sameItemId((IItemHandle)project)) continue;
            return mapping.getLibrary();
        }
        return null;
    }

    private List<IProjectToLibraryMap> getIProjectToLibraryMappings(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws Exception {
        ArrayList<IFolderHandle> projects = new ArrayList<IFolderHandle>();
        ScmComponentMetadata[] components = this.scmWorkspace.getAllScmComponentMetadatas();
        int i = 0;
        while (i < components.length) {
            Iterator iterator = components[i].getLibraryMetadataList().iterator();
            while (iterator.hasNext()) {
                projects.add(((ScmLibraryMetadata)iterator.next()).getProjectHandle());
            }
            ++i;
        }
        ArrayList<IProjectToLibraryMap> mappings = new ArrayList<IProjectToLibraryMap>();
        IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repository.getClientLibrary(IScmIClientLibrary.class);
        List mappingHandles = clientLibrary.getProjectToLibraryMappings(clientLibrary.getWorkspaceI(workspaceHandle, null), projects, null);
        for (IProjectToLibraryMapHandle mapHandle : mappingHandles) {
            IProjectToLibraryMap mapping = (IProjectToLibraryMap)repository.itemManager().fetchCompleteItem((IItemHandle)mapHandle, 1, monitor);
            if (mapping == null) continue;
            mappings.add(mapping);
        }
        return mappings;
    }

    private LibraryDiffNode compareLibraries(ScmLibraryMetadata scmLibrary, IBMiLibraryMetadata ibmiLibrary) {
        LibraryDiffNode result = new LibraryDiffNode(scmLibrary, ibmiLibrary, 0);
        if (scmLibrary == null && ibmiLibrary == null) {
            return result;
        }
        if (scmLibrary == null) {
            result.setChangeType(3);
        } else if (ibmiLibrary == null) {
            result.setChangeType(2);
        } else {
            ObjectDiffNode pfResult;
            ObjectMetadata ibmiObject;
            ArrayList<ObjectMetadata> alreadyCompare = new ArrayList<ObjectMetadata>();
            Iterator iterator = scmLibrary.objectMetadatas();
            while (iterator.hasNext()) {
                ObjectMetadata scmObject = (ObjectMetadata)iterator.next();
                ibmiObject = ibmiLibrary.getObjectMetadata(IBMiProjectResourceNameUtil.unEscapeFileName((String)scmObject.getName()), scmObject.getType(), scmObject.getSubType());
                if (scmObject.isSourceFile()) {
                    pfResult = this.compareSourceFiles((ScmSourceFileMetadata)scmObject, (IBMiSourceFileMetadata)ibmiObject);
                    if (pfResult.getChangeType() != 0 || pfResult.getChildren().length > 0) {
                        result.addChild(pfResult);
                    }
                } else if (scmObject.isSaveFile() && (pfResult = this.compareSaveFiles((ScmSaveFileMetadata)scmObject, (IBMiSaveFileMetadata)ibmiObject)).getChangeType() != 0) {
                    result.addChild(pfResult);
                }
                if (ibmiObject == null) continue;
                alreadyCompare.add(ibmiObject);
            }
            iterator = ibmiLibrary.objectMetadatas();
            while (iterator.hasNext()) {
                ibmiObject = (ObjectMetadata)iterator.next();
                if (alreadyCompare.contains(ibmiObject) || (pfResult = ibmiObject.isSourceFile() ? this.compareSourceFiles(null, (IBMiSourceFileMetadata)ibmiObject) : (ibmiObject.isSaveFile() ? this.compareSaveFiles(null, (IBMiSaveFileMetadata)ibmiObject) : new ObjectDiffNode(null, ibmiObject, 5))).getChangeType() == 0 && pfResult.getChildren().length <= 0) continue;
                result.addChild(pfResult);
            }
        }
        return result;
    }

    private SourceFileDiffNode compareSourceFiles(ScmSourceFileMetadata scmSourceFile, IBMiSourceFileMetadata ibmiSourceFile) {
        SourceFileDiffNode result = new SourceFileDiffNode(scmSourceFile, ibmiSourceFile, 0);
        if (scmSourceFile == null && ibmiSourceFile == null) {
            return result;
        }
        if (scmSourceFile == null) {
            if (ibmiSourceFile.getScmLastModification() == -1L) {
                result.setChangeType(5);
            } else {
                result.setChangeType(3);
            }
            Iterator iterator = ibmiSourceFile.memberMetadatas();
            while (iterator.hasNext()) {
                result.addChild(new MemberDiffNode(null, (IBMiMemberMetadata)iterator.next(), result.getChangeType()));
            }
        } else if (ibmiSourceFile == null) {
            result.setChangeType(2);
            Iterator iterator = scmSourceFile.memberMetadatas();
            while (iterator.hasNext()) {
                result.addChild(new MemberDiffNode((ScmMemberMetadata)iterator.next(), null, result.getChangeType()));
            }
        } else {
            boolean changeInIBMi;
            MemberDiffNode memberResult;
            IBMiMemberMetadata ibmiMember;
            ArrayList<IBMiMemberMetadata> alreadyCompare = new ArrayList<IBMiMemberMetadata>();
            Iterator iterator = scmSourceFile.memberMetadatas();
            while (iterator.hasNext()) {
                ScmMemberMetadata scmMember = (ScmMemberMetadata)iterator.next();
                memberResult = this.compareMembers(scmMember, ibmiMember = (IBMiMemberMetadata)ibmiSourceFile.getMemberMetadata(IBMiProjectResourceNameUtil.unEscapeFileName((String)scmMember.getName())));
                if (memberResult.getChangeType() != 0) {
                    result.addChild(memberResult);
                }
                if (ibmiMember == null) continue;
                alreadyCompare.add(ibmiMember);
            }
            iterator = ibmiSourceFile.memberMetadatas();
            while (iterator.hasNext()) {
                ibmiMember = (IBMiMemberMetadata)iterator.next();
                if (alreadyCompare.contains(ibmiMember) || (memberResult = this.compareMembers(null, ibmiMember)).getChangeType() == 0) continue;
                result.addChild(memberResult);
            }
            boolean fileChangedInScm = result.getAllOutgoingChangeChildren().length > 0;
            boolean attributesChangedInScm = scmSourceFile.getAttributesLastModification() > ibmiSourceFile.getAttributesLastModification();
            String[] changedAttributes = CompareAction.getSourceFileChangedAttributes(scmSourceFile, ibmiSourceFile);
            boolean attributesChangedInIBMi = !attributesChangedInScm && changedAttributes.length > 0;
            boolean fileChangedInIBMi = ibmiSourceFile.getIbmiFileLastModification() > ibmiSourceFile.getIbmiMetadataLastModification() || result.getAllIncomingChangeChildren().length > 0;
            boolean changeInScm = fileChangedInScm || attributesChangedInScm;
            boolean bl = changeInIBMi = fileChangedInIBMi || attributesChangedInIBMi;
            if (changeInScm && changeInIBMi) {
                result.setChangeType(7);
            } else if (changeInScm) {
                result.setChangeType(1);
            } else if (changeInIBMi) {
                result.setChangeType(4);
            }
            result.setChangedAttributes(changedAttributes);
        }
        return result;
    }

    private MemberDiffNode compareMembers(ScmMemberMetadata scmMember, IBMiMemberMetadata ibmiMember) {
        MemberDiffNode result = new MemberDiffNode(scmMember, ibmiMember, 0);
        if (scmMember == null && ibmiMember == null) {
            return result;
        }
        if (scmMember == null) {
            result.setChangeType(ibmiMember.getIbmiMetadataLastModification() == -1L ? 5 : 3);
        } else if (ibmiMember == null) {
            result.setChangeType(2);
        } else {
            boolean changeInIBMi;
            boolean fileChangedInScm = scmMember.getScmLastModification() > ibmiMember.getScmLastModification();
            boolean attributesChangedInScm = scmMember.getAttributesLastModification() > ibmiMember.getAttributesLastModification();
            boolean fileChangedInIBMi = ibmiMember.getIbmiFileLastModification() > ibmiMember.getIbmiMetadataLastModification();
            String[] changedAttributes = CompareAction.getMemberChangedAttributes(scmMember, ibmiMember);
            boolean attributesChangedInIBMi = changedAttributes.length > 0 && !attributesChangedInScm;
            boolean changeInScm = fileChangedInScm || attributesChangedInScm;
            boolean bl = changeInIBMi = fileChangedInIBMi || attributesChangedInIBMi;
            if (changeInScm && changeInIBMi) {
                result.setChangeType(7);
            } else if (changeInScm) {
                result.setChangeType(1);
            } else if (changeInIBMi) {
                result.setChangeType(4);
            }
            result.setChangedAttributes(changedAttributes);
        }
        return result;
    }

    private SaveFileDiffNode compareSaveFiles(ScmSaveFileMetadata scmMember, IBMiSaveFileMetadata ibmiMember) {
        SaveFileDiffNode result = new SaveFileDiffNode(scmMember, ibmiMember, 0);
        if (scmMember == null && ibmiMember == null) {
            return result;
        }
        if (scmMember == null) {
            result.setChangeType(ibmiMember.getIbmiMetadataLastModification() == -1L ? 5 : 3);
        } else if (ibmiMember == null) {
            result.setChangeType(2);
        } else {
            boolean changeInIBMi;
            boolean fileChangedInScm = scmMember.getScmLastModification() > ibmiMember.getScmLastModification();
            boolean attributesChangedInScm = scmMember.getAttributesLastModification() > ibmiMember.getAttributesLastModification();
            boolean fileChangedInIBMi = ibmiMember.getIbmiFileLastModification() > ibmiMember.getIbmiMetadataLastModification();
            String[] changedAttributes = CompareAction.getSaveFileChangedAttributes(scmMember, ibmiMember);
            boolean attributesChangedInIBMi = changedAttributes.length > 0 && !attributesChangedInScm;
            boolean changeInScm = fileChangedInScm || attributesChangedInScm;
            boolean bl = changeInIBMi = fileChangedInIBMi || attributesChangedInIBMi;
            if (changeInScm && changeInIBMi) {
                result.setChangeType(7);
            } else if (changeInScm) {
                result.setChangeType(1);
            } else if (changeInIBMi) {
                result.setChangeType(4);
            }
            result.setChangedAttributes(changedAttributes);
        }
        return result;
    }

    public RootNode getWorkspaceDiffNode() {
        return this.workspaceDiffNode;
    }

    private static String[] getMemberChangedAttributes(ScmMemberMetadata scmMember, IBMiMemberMetadata ibmiMember) {
        return CompareAction.getChangedAttributes(comparingMemberAttributes, (IMetadata)scmMember, (IMetadata)ibmiMember);
    }

    private static String[] getSourceFileChangedAttributes(ScmSourceFileMetadata scmSourceFile, IBMiSourceFileMetadata ibmiSourceFile) {
        return CompareAction.getChangedAttributes(comparingSourceFileAttributes, (IMetadata)scmSourceFile, (IMetadata)ibmiSourceFile);
    }

    private static String[] getSaveFileChangedAttributes(ScmSaveFileMetadata scmSaveFile, IBMiSaveFileMetadata ibmiSaveFile) {
        return CompareAction.getChangedAttributes(comparingSaveFileAttributes, (IMetadata)scmSaveFile, (IMetadata)ibmiSaveFile);
    }

    private static String[] getChangedAttributes(String[] attributes, IMetadata scmMember, IMetadata ibmiMember) {
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < attributes.length) {
            String attr1 = scmMember.getAttribute(attributes[i]);
            String attr2 = ibmiMember.getAttribute(attributes[i]);
            if (attr1 == null) {
                attr1 = "null";
            }
            if (attr2 == null) {
                attr2 = "null";
            }
            if (!attr1.equals(attr2)) {
                results.add(attributes[i]);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    public String getIHostName() {
        if (this.as400 != null) {
            return this.as400.getSystemName();
        }
        return "";
    }

    public String getIHostUserId() {
        if (this.as400 != null) {
            return this.as400.getUserId();
        }
        return "";
    }

    public void setRefreshScmWorkspace(boolean refreshFromScm) {
        this.refreshScmWorkspace = refreshFromScm;
    }

    private void attemptToConnectToHost() {
        this.isConnected = this.connectToAS400FileSystem();
        if (!this.isConnected) {
            this.shellProvider.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SelectHostDialog dialog = new SelectHostDialog(CompareAction.this.shellProvider.getShell());
                    dialog.setHostName(CompareAction.this.as400.getSystemName());
                    dialog.setUserName(CompareAction.this.as400.getUserId());
                    int rc = dialog.open();
                    if (rc == 0) {
                        CompareAction.this.as400 = new AS400(dialog.getHostName(), dialog.getUserName(), dialog.getPassword());
                        IBMiHelperFactory.instance().setAS400(dialog.getHostName(), dialog.getUserName(), dialog.getPassword(), CompareAction.this.as400);
                        CompareAction.this.isConnected = CompareAction.this.connectToAS400FileSystem();
                    }
                }
            });
        }
    }

    private boolean connectToAS400FileSystem() {
        try {
            this.as400.setGuiAvailable(false);
            if (!this.as400.getSystemName().equals("") && !this.as400.getUserId().equals("")) {
                this.as400.connectService(0);
            }
        }
        catch (Exception e) {
            return false;
        }
        return this.as400.isConnected(0);
    }
}

